/*
 * Decompiled with CFR 0.152.
 */
package eval;

import data.instance.Instance;
import data.value.Value;
import eval.EvaluationStats;
import java.util.HashMap;
import java.util.Map;

public class RegressionStats
extends EvaluationStats {
    @Override
    public void computeStats(HashMap<Instance, Value> predictions) {
        Double sumActual = 0.0;
        Double sumPred = 0.0;
        Double sumAbsErr = 0.0;
        Double sumSqrActual = 0.0;
        Double sumSqrPred = 0.0;
        Double sumSqrErr = 0.0;
        Double sumActualPred = 0.0;
        Double numInst = 0.0;
        for (Map.Entry<Instance, Value> ent : predictions.entrySet()) {
            Double d = ent.getKey().getLabel().getNumericValue();
            Double pred = ent.getValue().getNumericValue();
            Double diff = d - pred;
            sumActual = sumActual + d;
            sumPred = sumPred + pred;
            sumAbsErr = sumAbsErr + Math.abs(diff);
            sumSqrActual = sumSqrActual + d * d;
            sumSqrPred = sumSqrPred + pred * pred;
            sumSqrErr = sumSqrErr + diff * diff;
            sumActualPred = sumActualPred + d * pred;
            numInst = numInst + 1.0;
        }
        Double meanActual = sumActual / numInst;
        Double sumAbsMeanActual = 0.0;
        for (Map.Entry entry : predictions.entrySet()) {
            sumAbsMeanActual = sumAbsMeanActual + Math.abs(((Instance)entry.getKey()).getLabel().getNumericValue() - meanActual);
        }
        this.statistics.put("mae", sumAbsErr / numInst);
        this.statistics.put("rmse", Math.sqrt(sumSqrErr / numInst));
        Double d = sumSqrActual - sumActual * sumActual / numInst;
        Double varPred = sumSqrPred - sumPred * sumPred / numInst;
        Double varProduct = sumActualPred - sumActual * sumPred / numInst;
        if (d * varPred <= 0.0) {
            this.statistics.put("pearson", 0.0);
        } else {
            this.statistics.put("pearson", varProduct / Math.sqrt(d * varPred));
        }
        if (sumSqrErr == 0.0) {
            this.statistics.put("rrse", 0.0);
        } else if (d == 0.0) {
            this.statistics.put("rrse", Double.NaN);
        } else {
            this.statistics.put("rrse", Math.sqrt(sumSqrErr / d));
        }
        if (sumAbsErr == 0.0) {
            this.statistics.put("rae", 0.0);
        } else if (sumAbsMeanActual == 0.0) {
            this.statistics.put("rae", Double.NaN);
        } else {
            this.statistics.put("rae", sumAbsErr / sumAbsMeanActual);
        }
        double rrse = (Double)this.statistics.get("rrse");
        this.statistics.put("r2", 1.0 - rrse * rrse);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (Map.Entry ent : this.statistics.entrySet()) {
            res.append(String.valueOf((String)ent.getKey()) + " : " + ent.getValue().toString() + "\n");
        }
        return res.toString();
    }
}

