/*
 * Decompiled with CFR 0.152.
 */
package data.feature;

import data.Type;
import data.catalog.Catalog;
import data.feature.BasicFeature;
import data.feature.SingleValueFeature;
import data.parameter.AffineShift;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashSet;
import org.jdom2.Content;
import org.jdom2.Element;

public class SimpleFeature
extends BasicFeature
implements SingleValueFeature {
    private NumericShiftFunction shift = new AffineShift();

    public SimpleFeature(String n, Type t1, Type t2) {
        super(n, t1, t2);
    }

    @Override
    public Value result(Value in, Catalog cat) {
        Value res = cat.getAttributeValue(this, in);
        if (res.getNumericValue() != null && this.typeOut.getKind() == 1) {
            res = this.shift.apply(res);
        }
        return res;
    }

    @Override
    public SimpleFeature clone() {
        return this;
    }

    @Override
    public Type getTypeOutput() {
        return this.typeOut;
    }

    @Override
    public double complexity() {
        return 1.0;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(SingleValueFeature f) {
        if (f instanceof SimpleFeature) {
            return super.equals((SimpleFeature)f);
        }
        return f == this;
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("attribute");
        el.setAttribute("name", this.name);
        if (this.typeOut.getKind() == 1) {
            Element shiftEl = new Element("shift");
            shiftEl.addContent((Content)this.shift.toXMLElement());
            el.addContent((Content)shiftEl);
        }
        return el;
    }

    @Override
    public double[] range(ArrayList<Value> ids, Catalog cat) {
        if (this.getTypeOutput().getKind() == 1 && !ids.isEmpty()) {
            double[] range = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            boolean modifMin = false;
            boolean modifMax = false;
            for (Value id : ids) {
                Value dval = this.result(id, cat);
                if (dval.getStringValue() == null) continue;
                double val = dval.getNumericValue();
                if (val < range[0]) {
                    range[0] = val;
                    modifMin = true;
                }
                if (!(val > range[1])) continue;
                range[1] = val;
                modifMax = true;
            }
            if (modifMin && modifMax && range[0] != range[1]) {
                return range;
            }
        }
        return null;
    }

    @Override
    public NumericShiftFunction getShift() {
        return this.shift;
    }

    @Override
    public void initShifts(ArrayList<Value> vals, Catalog cat) {
        double[] range = this.range(vals, cat);
        this.shift.setFeature(this);
        this.shift.setParamsOrig(range);
    }

    @Override
    public void deployShifts(ArrayList<Value> vals, Catalog cat) {
        double[] range = this.range(vals, cat);
        this.shift.setParamsDeploy(range);
    }

    @Override
    public HashSet<NumericShiftFunction> getShifts() {
        HashSet<NumericShiftFunction> res = new HashSet<NumericShiftFunction>();
        res.add(this.shift);
        return res;
    }

    public void setShift(NumericShiftFunction sh) {
        this.shift = sh;
    }
}

