/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.value.Value;

public enum Operator {
    LEQ("<="),
    GEQ(">="),
    LT("<"),
    GT(">");

    private String name;

    private Operator(String n2) {
        this.name = n2;
    }

    public String getName() {
        return this.name;
    }

    public static Operator getFromName(String opType) {
        Operator op = GEQ;
        if (opType.equals(">=")) {
            op = GEQ;
        } else if (opType.equals(">")) {
            op = GT;
        } else if (opType.equals("<=")) {
            op = LEQ;
        } else if (opType.equals("<")) {
            op = LT;
        }
        return op;
    }

    public boolean equals(Operator op) {
        return op.getName().equals(this.name);
    }

    public boolean apply(Value d1, Value d2) {
        if (this == LEQ) {
            return d1.compareTo(d2) <= 0;
        }
        if (this == LT) {
            return d1.compareTo(d2) < 0;
        }
        if (this == GEQ) {
            return d1.compareTo(d2) >= 0;
        }
        if (this == GT) {
            return d1.compareTo(d2) > 0;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

