/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.Feature;
import data.feature.SingleValueFeature;
import data.instance.Instance;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import model.inference.ConditionApplication;
import org.jdom2.Content;
import org.jdom2.Element;
import util.GlobalRandom;

public class FilterSet
extends FilterFeature {
    private HashSet<Value> values;

    public FilterSet(SingleValueFeature feat, HashSet<Value> vals) {
        this.feature = feat;
        this.values = vals;
    }

    public FilterSet(Element condEl, Catalog cat) {
        this(Feature.fromXML(condEl.getChild("feature"), cat), new HashSet<Value>(condEl.getChild("rhs").getChild("values").getChildren("value").stream().map(el -> new Value(el.getAttributeValue("val"))).collect(Collectors.toSet())));
    }

    public void setValues(HashSet<Value> val) {
        this.values = val;
    }

    @Override
    public FilterSet cloneCondition() {
        return new FilterSet(this.feature.clone(), new HashSet<Value>(this.values));
    }

    public String toString() {
        return String.valueOf(this.feature.toString()) + " in " + this.values.toString();
    }

    public HashSet<Value> getValues() {
        return this.values;
    }

    public void applyMove(Catalog cat, ArrayList<Value> ids, int moveKind) {
        if (moveKind == 1) {
            this.addValue(cat, ids);
        } else if (moveKind == 2) {
            this.removeValue();
        }
    }

    private void removeValue() {
        int toRemove = GlobalRandom.instance().nextInt(this.values.size());
        ArrayList<Value> arrayValues = new ArrayList<Value>(this.values);
        arrayValues.remove(toRemove);
        this.values.clear();
        this.values.addAll(arrayValues);
    }

    private void addValue(Catalog cat, ArrayList<Value> ids) {
        ArrayList<Value> possibleValues = new ArrayList<Value>(this.feature.getTypeOutput().getValues());
        possibleValues.removeAll(this.values);
        int toAdd = GlobalRandom.instance().nextInt(possibleValues.size());
        this.values.add(possibleValues.get(toAdd));
    }

    public boolean initialize(ArrayList<Value> arrayValues) {
        boolean res = true;
        if (arrayValues.size() < 2) {
            res = false;
        } else {
            int toAdd = GlobalRandom.instance().nextInt(arrayValues.size());
            this.values.add(arrayValues.get(toAdd));
            arrayValues.remove(toAdd);
            int toNotAdd = GlobalRandom.instance().nextInt(arrayValues.size());
            arrayValues.remove(toNotAdd);
            for (Value possVal : arrayValues) {
                boolean chosen = GlobalRandom.instance().nextBoolean();
                if (!chosen) continue;
                this.values.add(possVal);
            }
        }
        return res;
    }

    public void applyMove(Catalog cat, ArrayList<Value> secIds, Value val) {
        if (this.values.contains(val)) {
            this.values.remove(val);
        } else {
            this.values.add(val);
        }
    }

    public boolean initialize(ArrayList<Value> arrayValues, Random rt) {
        boolean res = true;
        if (arrayValues.size() < 2) {
            res = false;
        } else {
            int toAdd = rt.nextInt(arrayValues.size());
            this.values.add(arrayValues.get(toAdd));
            arrayValues.remove(toAdd);
            int toNotAdd = rt.nextInt(arrayValues.size());
            arrayValues.remove(toNotAdd);
            for (Value possVal : arrayValues) {
                boolean chosen = rt.nextBoolean();
                if (!chosen) continue;
                this.values.add(possVal);
            }
        }
        return res;
    }

    @Override
    public Predicate<Value> filter(Catalog cat) {
        return v -> {
            Value res = this.feature.result((Value)v, cat);
            return this.values.contains(res);
        };
    }

    @Override
    public ConditionApplication apply(Instance id, Catalog cat) {
        Value res = this.feature.result(id.getId(), cat);
        if (res.getStringValue() == null) {
            return ConditionApplication.UNAPPLICABLE;
        }
        if (this.values.contains(res)) {
            return ConditionApplication.SUCCESS;
        }
        return ConditionApplication.FAILURE;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("condition");
        el.setAttribute("type", "set");
        Element featEl = new Element("feature");
        featEl.addContent((Content)this.feature.toXMLElement());
        el.addContent((Content)featEl);
        Element rhs = new Element("rhs");
        Element valsEl = new Element("values");
        for (Value v : this.values) {
            Element valEl = new Element("value");
            valEl.setAttribute("val", v.getStringValue());
            valsEl.addContent((Content)valEl);
        }
        rhs.addContent((Content)valsEl);
        el.addContent((Content)rhs);
        return el;
    }
}

