/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.Feature;
import data.feature.SingleValueFeature;
import data.instance.Instance;
import data.value.Value;
import java.util.function.Predicate;
import model.inference.ConditionApplication;
import org.jdom2.Content;
import org.jdom2.Element;

public class FilterNominalFeature
extends FilterFeature {
    private Value value;

    public FilterNominalFeature(SingleValueFeature feat, Value val) {
        this.feature = feat;
        this.value = val;
    }

    public FilterNominalFeature(Element condEl, Catalog cat) {
        this(Feature.fromXML(condEl.getChild("feature"), cat), new Value(condEl.getChild("rhs").getChild("value").getAttributeValue("val")));
    }

    public void setValue(Value val) {
        this.value = val;
    }

    @Override
    public FilterNominalFeature cloneCondition() {
        return new FilterNominalFeature(this.feature.clone(), this.value);
    }

    public String toString() {
        return String.valueOf(this.feature.toString()) + " = " + this.value;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public Predicate<Value> filter(Catalog cat) {
        return v -> {
            Value res = this.feature.result((Value)v, cat);
            return res.equals(this.value);
        };
    }

    @Override
    public ConditionApplication apply(Instance id, Catalog cat) {
        Value res = this.feature.result(id.getId(), cat);
        if (res.getStringValue() == null) {
            return ConditionApplication.UNAPPLICABLE;
        }
        if (res.equals(this.value)) {
            return ConditionApplication.SUCCESS;
        }
        return ConditionApplication.FAILURE;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("condition");
        el.setAttribute("type", "nominal");
        Element featEl = new Element("feature");
        featEl.addContent((Content)this.feature.toXMLElement());
        el.addContent((Content)featEl);
        Element rhs = new Element("rhs");
        Element valEl = new Element("value");
        valEl.setAttribute("val", this.value.getStringValue());
        rhs.addContent((Content)valEl);
        el.addContent((Content)rhs);
        return el;
    }
}

