/*
 * Decompiled with CFR 0.152.
 */
package data.condition;

import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.Feature;
import data.feature.SingleValueFeature;
import data.instance.Instance;
import data.parameter.NumericShiftFunction;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Predicate;
import model.inference.ConditionApplication;
import org.jdom2.Content;
import org.jdom2.Element;
import util.GlobalRandom;

public class FilterInterval
extends FilterFeature {
    protected Value valueLow;
    protected Value valueHigh;
    protected int kind = 2;

    public FilterInterval(SingleValueFeature feat, Value val1, Value val2) {
        this.feature = feat;
        if (val1.compareTo(val2) > 0) {
            this.valueLow = val2;
            this.valueHigh = val1;
        } else {
            this.valueLow = val1;
            this.valueHigh = val2;
        }
    }

    public FilterInterval(SingleValueFeature feat, NumericShiftFunction sh, Value val1, Value val2) {
        super(sh);
        this.feature = feat;
        if (val1.compareTo(val2) > 0) {
            this.valueLow = val2;
            this.valueHigh = val1;
        } else {
            this.valueLow = val1;
            this.valueHigh = val2;
        }
    }

    public FilterInterval(Element condEl, Catalog cat) {
        this(Feature.fromXML(condEl.getChild("feature"), cat), new Value(new Double(condEl.getChild("rhs").getChild("interval").getAttributeValue("val1"))), new Value(new Double(condEl.getChild("rhs").getChild("interval").getAttributeValue("val2"))));
    }

    public void setValueLow(Value val) {
        this.valueLow = val;
    }

    public void setValueHigh(Value val) {
        this.valueHigh = val;
    }

    @Override
    public FilterInterval cloneCondition() {
        return new FilterInterval(this.feature.clone(), this.shift.clone(), this.valueLow, this.valueHigh);
    }

    public String toString() {
        return String.valueOf(this.feature.toString()) + " in [" + this.valueLow.toString() + "; " + this.valueHigh.toString() + "[";
    }

    public Value getValueLow() {
        return this.valueLow;
    }

    public Value getValueHigh() {
        return this.valueHigh;
    }

    private boolean moveRightUpperBound(ArrayList<Value> possibleValues, int depth) {
        boolean res = false;
        if (this.kind != 1) {
            int iFirst = 0;
            int iLast = possibleValues.size() - 1;
            boolean found = false;
            while (iFirst < iLast && !found) {
                int iMiddle = (iFirst + iLast) / 2;
                int comp = possibleValues.get(iMiddle).compareTo(this.valueHigh);
                boolean bl = found = comp == 0;
                if (comp < 0) {
                    iFirst = iMiddle + 1;
                    continue;
                }
                iLast = iMiddle - 1;
            }
            int indexCurrent = (iFirst + iLast) / 2;
            int candidateIndex = Math.min(indexCurrent + depth, possibleValues.size() - 1);
            res = indexCurrent != candidateIndex;
            this.valueHigh = possibleValues.get(candidateIndex);
        }
        return res;
    }

    private boolean moveLeftUpperBound(ArrayList<Value> possibleValues, int depth) {
        boolean res = false;
        if (this.kind != 1) {
            int iFirst = 0;
            int iLast = possibleValues.size() - 1;
            boolean found = false;
            while (iFirst < iLast && !found) {
                int iMiddle = (iFirst + iLast) / 2;
                int comp = possibleValues.get(iMiddle).compareTo(this.valueHigh);
                boolean bl = found = comp == 0;
                if (comp < 0) {
                    iFirst = iMiddle + 1;
                    continue;
                }
                iLast = iMiddle - 1;
            }
            int indexCurrent = (iFirst + iLast) / 2;
            int candidateIndex = Math.max(indexCurrent - depth, 0);
            res = indexCurrent != candidateIndex;
            this.valueHigh = possibleValues.get(candidateIndex);
        }
        return res;
    }

    private boolean moveRightLowerBound(ArrayList<Value> possibleValues, int depth) {
        boolean res = false;
        if (this.kind != 0) {
            int iFirst = 0;
            int iLast = possibleValues.size() - 1;
            boolean found = false;
            while (iFirst < iLast && !found) {
                int iMiddle = (iFirst + iLast) / 2;
                int comp = possibleValues.get(iMiddle).compareTo(this.valueLow);
                boolean bl = found = comp == 0;
                if (comp < 0) {
                    iFirst = iMiddle + 1;
                    continue;
                }
                iLast = iMiddle - 1;
            }
            int indexCurrent = (iFirst + iLast) / 2;
            int candidateIndex = Math.min(indexCurrent + depth, possibleValues.size() - 1);
            res = indexCurrent != candidateIndex;
            this.valueLow = possibleValues.get(candidateIndex);
        }
        return res;
    }

    private boolean moveLeftLowerBound(ArrayList<Value> possibleValues, int depth) {
        boolean res = false;
        if (this.kind != 0) {
            int iFirst = 0;
            int iLast = possibleValues.size() - 1;
            boolean found = false;
            while (iFirst < iLast && !found) {
                int iMiddle = (iFirst + iLast) / 2;
                int comp = possibleValues.get(iMiddle).compareTo(this.valueLow);
                boolean bl = found = comp == 0;
                if (comp < 0) {
                    iFirst = iMiddle + 1;
                    continue;
                }
                iLast = iMiddle - 1;
            }
            int indexCurrent = iLast;
            int candidateIndex = Math.max(indexCurrent - depth, 0);
            res = indexCurrent != candidateIndex;
            this.valueLow = possibleValues.get(candidateIndex);
        }
        return res;
    }

    @Override
    public HashMap<NumericShiftFunction, double[]> getShifts(ArrayList<Value> vals, Catalog cat) {
        HashMap<NumericShiftFunction, double[]> res = new HashMap<NumericShiftFunction, double[]>();
        res.putAll(super.getShifts(vals, cat));
        this.shift.setFeature(this.feature);
        if (!vals.isEmpty()) {
            res.put(this.shift, this.feature.range(vals, cat));
        }
        return res;
    }

    public boolean initialize(ArrayList<Value> arrayValues) {
        boolean res = true;
        if (arrayValues.isEmpty()) {
            res = false;
        } else {
            int caseChosen = GlobalRandom.instance().nextInt(4);
            if (caseChosen == 0) {
                this.kind = 0;
                this.valueLow = new Value(Double.NEGATIVE_INFINITY);
                int n = arrayValues.size();
                int chosen1 = GlobalRandom.instance().nextInt(n);
                this.valueHigh = arrayValues.get(chosen1);
            } else if (caseChosen == 1) {
                this.kind = 1;
                this.valueHigh = new Value(Double.POSITIVE_INFINITY);
                int n = arrayValues.size();
                int chosen1 = GlobalRandom.instance().nextInt(n);
                this.valueLow = arrayValues.get(chosen1);
            } else {
                int chosen2;
                Value v2;
                this.kind = 2;
                arrayValues.add(new Value(Double.POSITIVE_INFINITY));
                arrayValues.add(0, new Value(Double.NEGATIVE_INFINITY));
                int chosen1 = GlobalRandom.instance().nextInt(arrayValues.size());
                Value v1 = arrayValues.get(chosen1);
                arrayValues.remove(chosen1);
                if (v1.getNumericValue().isInfinite() && arrayValues.size() > 1) {
                    arrayValues.remove(new Value(Double.NEGATIVE_INFINITY));
                    arrayValues.remove(new Value(Double.POSITIVE_INFINITY));
                }
                if (v1.compareTo(v2 = arrayValues.get(chosen2 = GlobalRandom.instance().nextInt(arrayValues.size()))) < 0) {
                    this.valueLow = v1;
                    this.valueHigh = v2;
                } else {
                    this.valueHigh = v1;
                    this.valueLow = v2;
                }
            }
        }
        return res;
    }

    public boolean applyMove(ArrayList<Value> possibleValues, int mk, int depth) {
        possibleValues.add(new Value(Double.POSITIVE_INFINITY));
        possibleValues.add(0, new Value(Double.NEGATIVE_INFINITY));
        boolean res = true;
        if (mk == 1) {
            res = this.moveLeftLowerBound(possibleValues, depth);
        } else if (mk == 2) {
            res = this.moveRightLowerBound(possibleValues, depth);
        } else if (mk == 3) {
            res = this.moveLeftUpperBound(possibleValues, depth);
        } else if (mk == 4) {
            res = this.moveRightUpperBound(possibleValues, depth);
        } else if (mk == 5) {
            res = this.moveRightLowerBound(possibleValues, depth) && this.moveRightUpperBound(possibleValues, depth);
        } else if (mk == 6) {
            res = this.moveLeftLowerBound(possibleValues, depth) && this.moveLeftUpperBound(possibleValues, depth);
        } else if (mk == 7) {
            res = this.moveRightLowerBound(possibleValues, depth) && this.moveLeftUpperBound(possibleValues, depth);
        } else if (mk == 8) {
            res = this.moveLeftLowerBound(possibleValues, depth) && this.moveRightUpperBound(possibleValues, depth);
        }
        return res;
    }

    public boolean initialize(ArrayList<Value> arrayValues, Random rt) {
        boolean res = true;
        if (arrayValues.isEmpty()) {
            res = false;
        } else {
            int caseChosen = rt.nextInt(4);
            if (caseChosen == 0) {
                this.kind = 0;
                this.valueLow = new Value(Double.NEGATIVE_INFINITY);
                int n = arrayValues.size();
                int chosen1 = rt.nextInt(n);
                this.valueHigh = arrayValues.get(chosen1);
            } else if (caseChosen == 1) {
                this.kind = 1;
                this.valueHigh = new Value(Double.POSITIVE_INFINITY);
                int n = arrayValues.size();
                int chosen1 = rt.nextInt(n);
                this.valueLow = arrayValues.get(chosen1);
            } else {
                int chosen2;
                Value v2;
                this.kind = 2;
                arrayValues.add(new Value(Double.POSITIVE_INFINITY));
                arrayValues.add(0, new Value(Double.NEGATIVE_INFINITY));
                int chosen1 = rt.nextInt(arrayValues.size());
                Value v1 = arrayValues.get(chosen1);
                arrayValues.remove(chosen1);
                if (v1.getNumericValue().isInfinite() && arrayValues.size() > 1) {
                    arrayValues.remove(new Value(Double.NEGATIVE_INFINITY));
                    arrayValues.remove(new Value(Double.POSITIVE_INFINITY));
                }
                if (v1.compareTo(v2 = arrayValues.get(chosen2 = rt.nextInt(arrayValues.size()))) < 0) {
                    this.valueLow = v1;
                    this.valueHigh = v2;
                } else {
                    this.valueHigh = v1;
                    this.valueLow = v2;
                }
            }
        }
        return res;
    }

    public ArrayList<FilterInterval> localMoves(TreeSet<Value> possibleValues, int depth) {
        ArrayList<FilterInterval> res = new ArrayList<FilterInterval>(4);
        if (this.kind == 2) {
            possibleValues.add(new Value(Double.NEGATIVE_INFINITY));
            possibleValues.add(new Value(Double.POSITIVE_INFINITY));
        }
        ArrayList<Value> arrayValues = new ArrayList<Value>(possibleValues);
        Value closestLL = null;
        Value closestLR = null;
        Value closestUL = null;
        Value closestUR = null;
        if (this.kind != 0) {
            int candidateIndexLL;
            closestLL = possibleValues.ceiling(this.valueLow);
            closestLR = possibleValues.floor(this.valueLow);
            int indexCurrentLL = arrayValues.indexOf(closestLL);
            if (indexCurrentLL != (candidateIndexLL = Math.max(indexCurrentLL - depth, 0))) {
                FilterInterval fiLL = this.cloneCondition();
                fiLL.setValueLow(arrayValues.get(candidateIndexLL));
                res.add(fiLL);
            }
            int indexCurrentLR = arrayValues.indexOf(closestLR);
            int candidateIndexLR = Math.min(indexCurrentLR + depth, arrayValues.size() - 1);
            Value candidateElemLR = arrayValues.get(candidateIndexLR);
            if (indexCurrentLR != candidateIndexLR && candidateElemLR.compareTo(this.valueHigh) < 0) {
                FilterInterval fiLR = this.cloneCondition();
                fiLR.setValueLow(candidateElemLR);
                res.add(fiLR);
            }
        }
        if (this.kind != 1) {
            int candidateIndexUR;
            int indexCurrentUR;
            closestUL = possibleValues.ceiling(this.valueHigh);
            closestUR = possibleValues.floor(this.valueHigh);
            int indexCurrentUL = arrayValues.indexOf(closestUL);
            int candidateIndexUL = Math.max(indexCurrentUL - depth, 0);
            Value candidateElemUL = arrayValues.get(candidateIndexUL);
            if (indexCurrentUL != candidateIndexUL && candidateElemUL.compareTo(this.valueLow) > 0) {
                FilterInterval fiUL = this.cloneCondition();
                fiUL.setValueHigh(candidateElemUL);
                res.add(fiUL);
            }
            if ((indexCurrentUR = arrayValues.indexOf(closestUR)) != (candidateIndexUR = Math.min(indexCurrentUR + depth, arrayValues.size() - 1))) {
                FilterInterval fiUR = this.cloneCondition();
                fiUR.setValueHigh(arrayValues.get(candidateIndexUR));
                res.add(fiUR);
            }
        }
        return res;
    }

    public void applyRandomMove(TreeSet<Value> possibleValues, int move, Random rt) {
        if (this.kind == 1 && move % 2 == 1 || this.kind == 2 && move == 1) {
            ArrayList<Value> possValsArray = new ArrayList<Value>(possibleValues.headSet(this.valueLow, false));
            if (this.kind == 2) {
                possValsArray.add(new Value(Double.NEGATIVE_INFINITY));
            }
            int chosen = rt.nextInt(possValsArray.size());
            this.valueLow = possValsArray.get(chosen);
        } else if (this.kind == 1 && move % 2 == 0 || this.kind == 2 && move == 2) {
            ArrayList<Value> possValsArray = new ArrayList<Value>(possibleValues.subSet(this.valueLow, false, this.valueHigh, false));
            if (!possValsArray.isEmpty()) {
                int chosen = rt.nextInt(possValsArray.size());
                this.valueLow = possValsArray.get(chosen);
            }
        } else if (this.kind == 0 && move % 2 == 1 || this.kind == 2 && move == 3) {
            ArrayList<Value> possValsArray = new ArrayList<Value>(possibleValues.subSet(this.valueLow, false, this.valueHigh, false));
            if (!possValsArray.isEmpty()) {
                int chosen = rt.nextInt(possValsArray.size());
                this.valueHigh = possValsArray.get(chosen);
            }
        } else if (this.kind == 0 && move % 2 == 0 || this.kind == 2 && move == 4) {
            ArrayList<Value> possValsArray = new ArrayList<Value>(possibleValues.tailSet(this.valueHigh, false));
            if (this.kind == 2) {
                possValsArray.add(new Value(Double.POSITIVE_INFINITY));
            }
            int chosen = rt.nextInt(possValsArray.size());
            this.valueHigh = possValsArray.get(chosen);
        }
    }

    @Override
    public Predicate<Value> filter(Catalog cat) {
        return v -> {
            Value res = this.feature.result((Value)v, cat);
            return res.compareTo(this.valueLow) >= 0 && res.compareTo(this.valueHigh) < 0;
        };
    }

    @Override
    public ConditionApplication apply(Instance id, Catalog cat) {
        Value mainRes = this.feature.result(id.getId(), cat);
        if (mainRes.getStringValue() == null) {
            return ConditionApplication.UNAPPLICABLE;
        }
        if (mainRes.compareTo(this.valueLow) >= 0 && mainRes.compareTo(this.valueHigh) < 0) {
            return ConditionApplication.SUCCESS;
        }
        return ConditionApplication.FAILURE;
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("condition");
        el.setAttribute("type", "interval");
        Element featEl = new Element("feature");
        featEl.addContent((Content)this.feature.toXMLElement());
        el.addContent((Content)featEl);
        Element rhs = new Element("rhs");
        Element valEl = new Element("interval");
        valEl.setAttribute("val1", this.valueLow.getStringValue());
        valEl.setAttribute("val2", this.valueHigh.getStringValue());
        rhs.addContent((Content)valEl);
        el.addContent((Content)rhs);
        return el;
    }
}

