/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

public class Quantile
extends AggregateFunction<ArrayList<Value>> {
    private int k;
    private int n;
    TreeSet<Value> values = new TreeSet();

    public Quantile(int k, int n) {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "quantile";
        this.k = k;
        this.n = n;
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        ArrayList<Double> d = new ArrayList<Double>(s.size());
        for (Value valInt : s) {
            d.add(valInt.getNumericValue());
        }
        Collections.sort(d);
        int index = this.k * d.size() % this.n == 0 ? this.k * d.size() / this.n - 1 : this.k * d.size() / this.n;
        return new Value((Double)d.get(index));
    }

    @Override
    public Supplier<ArrayList<Value>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<Value>, Value> accumulator() {
        return (accum, val) -> {
            boolean bl = accum.add(val);
        };
    }

    @Override
    public BinaryOperator<ArrayList<Value>> combiner() {
        return (a, b) -> {
            a.addAll(b);
            return a;
        };
    }

    @Override
    public Function<ArrayList<Value>, Value> finisher() {
        return d -> {
            if (d.isEmpty()) {
                return new Value(null);
            }
            Collections.sort(d);
            int index = this.k * d.size() % this.n == 0 ? this.k * d.size() / this.n - 1 : this.k * d.size() / this.n;
            return new Value(((Value)d.get(index)).getNumericValue());
        };
    }
}

