/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.EmptySetSensitivity;
import data.kind.Nominal;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class Mode
extends AggregateFunction<HashMap<Value, Integer>> {
    public Mode() {
        this.sensitivity = new EmptySetSensitivity();
        this.funcTypeIn = new Nominal();
        this.funcTypeOut = new Nominal();
        this.needsFeature = true;
        this.name = "mode";
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Value instVal : s) {
            String inst = instVal.getStringValue();
            if (!counts.containsKey(inst)) {
                counts.put(inst, 0);
            }
            int currVal = (Integer)counts.get(inst);
            counts.put(inst, currVal + 1);
        }
        ArrayList<Value> candidates = new ArrayList<Value>();
        int cMax = -1;
        for (String val : counts.keySet()) {
            int num = (Integer)counts.get(val);
            if (num < cMax) continue;
            if (num > cMax) {
                cMax = num;
                candidates.clear();
            }
            candidates.add(new Value(val));
        }
        if (candidates.size() == 1) {
            return (Value)candidates.get(0);
        }
        Random r = new Random();
        return (Value)candidates.get(r.nextInt(candidates.size()));
    }

    @Override
    public Supplier<HashMap<Value, Integer>> supplier() {
        return null;
    }

    @Override
    public BiConsumer<HashMap<Value, Integer>, Value> accumulator() {
        return null;
    }

    @Override
    public BinaryOperator<HashMap<Value, Integer>> combiner() {
        return null;
    }

    @Override
    public Function<HashMap<Value, Integer>, Value> finisher() {
        return null;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return null;
    }
}

