/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.Count;
import data.aggregate.Decile1;
import data.aggregate.Decile9;
import data.aggregate.InterquartileRange;
import data.aggregate.Max;
import data.aggregate.Mean;
import data.aggregate.Median;
import data.aggregate.Min;
import data.aggregate.Mode;
import data.aggregate.Proportion;
import data.aggregate.Quartile1;
import data.aggregate.Quartile3;
import data.aggregate.Ratio;
import data.aggregate.StandardDeviation;
import data.aggregate.Sum;
import data.aggregate.selection.PipeSelectionFilters;
import data.aggregate.sensitivity.Sensitivity;
import data.catalog.Catalog;
import data.condition.FilterFeature;
import data.feature.SingleValueFeature;
import data.kind.Kind;
import data.value.Value;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collector;
import org.jdom2.Element;

public abstract class AggregateFunction<T>
implements Collector<Value, T, Value> {
    protected String name;
    protected Sensitivity sensitivity;
    protected Kind funcTypeIn;
    protected Kind funcTypeOut;
    protected boolean needsFeature;
    protected ArrayList<Value> valuesApplied = new ArrayList();
    protected Value resApplied = new Value(0.0);

    public Value apply(ArrayList<Value> s) {
        if (this.sensitivity.canBeApplied(s)) {
            return this.applyFunction(s);
        }
        return this.funcTypeOut.replacementValue();
    }

    public abstract Value applyFunction(ArrayList<Value> var1);

    public Value getResult() {
        if (this.sensitivity.canBeApplied(this.valuesApplied)) {
            return this.resApplied;
        }
        return this.funcTypeOut.replacementValue();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(AggregateFunction<?> af) {
        return af.getName().equals(this.name);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }

    public static AggregateFunction<?> aggregateFunctionByName(String name) {
        AggregateFunction af = null;
        if (name.equals("count")) {
            af = new Count();
        } else if (name.equals("max")) {
            af = new Max();
        } else if (name.equals("min")) {
            af = new Min();
        } else if (name.equals("mean")) {
            af = new Mean();
        } else if (name.equals("sum")) {
            af = new Sum();
        } else if (name.equals("std")) {
            af = new StandardDeviation();
        } else if (name.equals("mode")) {
            af = new Mode();
        } else if (name.equals("median")) {
            af = new Median();
        } else if (name.equals("quartile1")) {
            af = new Quartile1();
        } else if (name.equals("quartile3")) {
            af = new Quartile3();
        } else if (name.equals("decile1")) {
            af = new Decile1();
        } else if (name.equals("decile9")) {
            af = new Decile9();
        } else if (name.equals("interquartile")) {
            af = new InterquartileRange();
        } else if (name.equals("proportion")) {
            af = new Proportion();
        } else if (name.equals("ratio")) {
            af = new Ratio(null, null);
        }
        return af;
    }

    public boolean isSensitive() {
        return this.sensitivity.isSensitive();
    }

    public FilterFeature baseProtection(PipeSelectionFilters objSel) {
        return this.sensitivity.getProtection(objSel);
    }

    public int getKindIn() {
        return this.funcTypeIn.getKind();
    }

    public int getKindOut() {
        return this.funcTypeOut.getKind();
    }

    public boolean isNeedsFeature() {
        return this.needsFeature;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static AggregateFunction<?> fromXML(Element funElem, Catalog cat) {
        AggregateFunction af = null;
        String nameFun = funElem.getAttributeValue("name");
        if (nameFun.equals("count")) {
            af = new Count();
        } else if (nameFun.equals("max")) {
            af = new Max();
        } else if (nameFun.equals("min")) {
            af = new Min();
        } else if (nameFun.equals("mean")) {
            af = new Mean();
        } else if (nameFun.equals("sum")) {
            af = new Sum();
        } else if (nameFun.equals("std")) {
            af = new StandardDeviation();
        } else if (nameFun.equals("mode")) {
            af = new Mode();
        } else if (nameFun.equals("median")) {
            af = new Median();
        } else if (nameFun.equals("quartile1")) {
            af = new Quartile1();
        } else if (nameFun.equals("quartile3")) {
            af = new Quartile3();
        } else if (nameFun.equals("decile1")) {
            af = new Decile1();
        } else if (nameFun.equals("decile9")) {
            af = new Decile9();
        } else if (nameFun.equals("interquartile")) {
            af = new InterquartileRange();
        } else if (nameFun.equals("proportion")) {
            af = new Proportion();
        } else if (nameFun.startsWith("ratio")) {
            String[] split = nameFun.split("_");
            Ratio ra = new Ratio((SingleValueFeature)((Object)cat.getFeatureByName(split[1])), new Value(split[2]));
            af = ra;
        }
        return af;
    }
}

