"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const parameter_group_1 = require("../lib/parameter-group");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-rds-integ');
const vpc = new ec2.Vpc(stack, 'VPC', { maxAzs: 2 });
const params = new parameter_group_1.ClusterParameterGroup(stack, 'Params', {
    family: 'aurora5.6',
    description: 'A nice parameter group',
    parameters: {
        character_set_database: 'utf8mb4'
    }
});
const kmsKey = new kms.Key(stack, 'DbSecurity');
const cluster = new lib_1.DatabaseCluster(stack, 'Database', {
    engine: lib_1.DatabaseClusterEngine.AURORA,
    masterUser: {
        username: 'admin',
        password: cdk.SecretValue.plainText('7959866cacc02c2d243ecfe177464fe6'),
    },
    instanceProps: {
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.SMALL),
        vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC },
        vpc
    },
    parameterGroup: params,
    kmsKey,
});
cluster.connections.allowDefaultPortFromAnyIpv4('Open to the world');
app.synth();
//# sourceMappingURL=data:application/json;base64,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