"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const rds = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-rds-cluster-rotation');
const vpc = new ec2.Vpc(stack, 'VPC');
/// !show
const cluster = new rds.DatabaseCluster(stack, 'Database', {
    engine: rds.DatabaseClusterEngine.AURORA,
    masterUser: {
        username: 'admin'
    },
    instanceProps: {
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.BURSTABLE3, ec2.InstanceSize.SMALL),
        vpc
    }
});
cluster.addRotationSingleUser();
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY2x1c3Rlci1yb3RhdGlvbi5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5jbHVzdGVyLXJvdGF0aW9uLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMsOEJBQThCO0FBRTlCLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsOEJBQThCLENBQUMsQ0FBQztBQUVqRSxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBRXRDLFNBQVM7QUFDVCxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRTtJQUN6RCxNQUFNLEVBQUUsR0FBRyxDQUFDLHFCQUFxQixDQUFDLE1BQU07SUFDeEMsVUFBVSxFQUFFO1FBQ1YsUUFBUSxFQUFFLE9BQU87S0FDbEI7SUFDRCxhQUFhLEVBQUU7UUFDYixZQUFZLEVBQUUsR0FBRyxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUM7UUFDdkYsR0FBRztLQUNKO0NBQ0YsQ0FBQyxDQUFDO0FBRUgsT0FBTyxDQUFDLHFCQUFxQixFQUFFLENBQUM7QUFDaEMsU0FBUztBQUVULEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIHJkcyBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstcmRzLWNsdXN0ZXItcm90YXRpb24nKTtcblxuY29uc3QgdnBjID0gbmV3IGVjMi5WcGMoc3RhY2ssICdWUEMnKTtcblxuLy8vICFzaG93XG5jb25zdCBjbHVzdGVyID0gbmV3IHJkcy5EYXRhYmFzZUNsdXN0ZXIoc3RhY2ssICdEYXRhYmFzZScsIHtcbiAgZW5naW5lOiByZHMuRGF0YWJhc2VDbHVzdGVyRW5naW5lLkFVUk9SQSxcbiAgbWFzdGVyVXNlcjoge1xuICAgIHVzZXJuYW1lOiAnYWRtaW4nXG4gIH0sXG4gIGluc3RhbmNlUHJvcHM6IHtcbiAgICBpbnN0YW5jZVR5cGU6IGVjMi5JbnN0YW5jZVR5cGUub2YoZWMyLkluc3RhbmNlQ2xhc3MuQlVSU1RBQkxFMywgZWMyLkluc3RhbmNlU2l6ZS5TTUFMTCksXG4gICAgdnBjXG4gIH1cbn0pO1xuXG5jbHVzdGVyLmFkZFJvdGF0aW9uU2luZ2xlVXNlcigpO1xuLy8vICFoaWRlXG5cbmFwcC5zeW50aCgpO1xuIl19