import { Construct, IResource, Resource } from '@aws-cdk/core';
/**
 * A parameter group
 */
export interface IParameterGroup extends IResource {
    /**
     * The name of this parameter group
     *
     * @attribute
     */
    readonly parameterGroupName: string;
}
/**
 * A new cluster or instance parameter group
 */
declare abstract class ParameterGroupBase extends Resource implements IParameterGroup {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope: Construct, id: string, parameterGroupName: string): IParameterGroup;
    /**
     * The name of the parameter group
     */
    abstract readonly parameterGroupName: string;
}
/**
 * Properties for a parameter group
 */
export interface ParameterGroupProps {
    /**
     * Database family of this parameter group
     */
    readonly family: string;
    /**
     * Description for this parameter group
     *
     * @default a CDK generated description
     */
    readonly description?: string;
    /**
     * The parameters in this parameter group
     */
    readonly parameters: {
        [key: string]: string;
    };
}
/**
 * A parameter group
 *
 * @resource AWS::RDS::DBParameterGroup
 */
export declare class ParameterGroup extends ParameterGroupBase {
    /**
     * The name of the parameter group
     */
    readonly parameterGroupName: string;
    constructor(scope: Construct, id: string, props: ParameterGroupProps);
}
/**
 * Construction properties for a ClusterParameterGroup
 */
export interface ClusterParameterGroupProps extends ParameterGroupProps {
}
/**
 * A cluster parameter group
 *
 * @resource AWS::RDS::DBClusterParameterGroup
 */
export declare class ClusterParameterGroup extends ParameterGroupBase {
    /**
     * The name of the parameter group
     */
    readonly parameterGroupName: string;
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
export {};
