
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/mcot/pipe:dist

from setuptools import setup

setup(**{
    'author': 'Michiel Cottaar',
    'author_email': 'Michiel.Cottaar@ndcn.ox.ac.uk',
    'classifiers': [
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Operating System :: OS Independent',
    ],
    'description': 'Declerative pipeline definition',
    'license': 'MIT license',
    'long_description': """Build pipelines decleratively built on top of file-tree.

.. code-block:: python

    from mcot.pipe import pipe, In, Out, Ref, Var
    from file_tree import FileTree

    @pipe(logdir='log', minutes=41)
    def func(in_path: In, out_path: Out, ref_path: Ref, placeholder_key: Var):
        pass

    pipe.cli(FileTree.from_string(\"\"\"
    placeholder_key = A, B

    ref_path.txt
    directory-{placeholder_key}
        in_path.txt
        out_path.txt
    \"\"\"))""",
    'name': 'mcot.pipe',
    'python_requires': '>=3.6',
    'url': 'https://git.fmrib.ox.ac.uk/ndcn0236/mcot',
    'version': '0.2.0',
    'package_dir': {
        '': 'src',
    },
    'packages': (
        'mcot',
        'mcot.pipe',
    ),
    'namespace_packages': (
    ),
    'package_data': {
        'mcot.pipe': (
            'README.rst',
            'VERSION',
        ),
    },
    'install_requires': (
        'dask[array]',
        'datalad',
        'file-tree',
        'fslpy',
        'loguru',
        'mcot.utils~=0.1.0',
        'numpy',
        'xarray',
    ),
})
