"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const sqs = require("@aws-cdk/aws-sqs");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
// ---------------------------------
// Define a rule that triggers an SNS topic every 1min.
// Connect the topic with a queue. This means that the queue should have
// a message sent to it every minute.
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-sqs-event-target');
const event = new events.Rule(stack, 'MyRule', {
    schedule: events.Schedule.rate(cdk.Duration.minutes(1)),
});
const queue = new sqs.Queue(stack, 'MyQueue');
event.addTarget(new targets.SqsQueue(queue));
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc3FzLWV2ZW50LXJ1bGUtdGFyZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc3FzLWV2ZW50LXJ1bGUtdGFyZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQThDO0FBQzlDLHdDQUF3QztBQUN4QyxxQ0FBcUM7QUFDckMscUNBQXFDO0FBRXJDLG9DQUFvQztBQUNwQyx1REFBdUQ7QUFDdkQsd0VBQXdFO0FBQ3hFLHFDQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDBCQUEwQixDQUFDLENBQUM7QUFFN0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7SUFDN0MsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0NBQ3hELENBQUMsQ0FBQztBQUVILE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsU0FBUyxDQUFDLENBQUM7QUFDOUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztBQUU3QyxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBldmVudHMgZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cyc7XG5pbXBvcnQgKiBhcyBzcXMgZnJvbSAnQGF3cy1jZGsvYXdzLXNxcyc7XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyB0YXJnZXRzIGZyb20gJy4uLy4uL2xpYic7XG5cbi8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuLy8gRGVmaW5lIGEgcnVsZSB0aGF0IHRyaWdnZXJzIGFuIFNOUyB0b3BpYyBldmVyeSAxbWluLlxuLy8gQ29ubmVjdCB0aGUgdG9waWMgd2l0aCBhIHF1ZXVlLiBUaGlzIG1lYW5zIHRoYXQgdGhlIHF1ZXVlIHNob3VsZCBoYXZlXG4vLyBhIG1lc3NhZ2Ugc2VudCB0byBpdCBldmVyeSBtaW51dGUuXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLXNxcy1ldmVudC10YXJnZXQnKTtcblxuY29uc3QgZXZlbnQgPSBuZXcgZXZlbnRzLlJ1bGUoc3RhY2ssICdNeVJ1bGUnLCB7XG4gIHNjaGVkdWxlOiBldmVudHMuU2NoZWR1bGUucmF0ZShjZGsuRHVyYXRpb24ubWludXRlcygxKSksXG59KTtcblxuY29uc3QgcXVldWUgPSBuZXcgc3FzLlF1ZXVlKHN0YWNrLCAnTXlRdWV1ZScpO1xuZXZlbnQuYWRkVGFyZ2V0KG5ldyB0YXJnZXRzLlNxc1F1ZXVlKHF1ZXVlKSk7XG5cbmFwcC5zeW50aCgpO1xuIl19