"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const batch = require("@aws-cdk/aws-batch");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
const targets = require("../../lib");
test('use aws batch job as an eventrule target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const jobQueue = new batch.JobQueue(stack, 'MyQueue', {
        computeEnvironments: [
            {
                computeEnvironment: new batch.ComputeEnvironment(stack, 'ComputeEnvironment', {
                    managed: false,
                }),
                order: 1,
            },
        ],
    });
    const jobDefinition = new batch.JobDefinition(stack, 'MyJob', {
        container: {
            image: aws_ecs_1.ContainerImage.fromRegistry('test-repo'),
        },
    });
    const rule = new events.Rule(stack, 'Rule', {
        schedule: events.Schedule.expression('rate(1 min)'),
    });
    // WHEN
    rule.addTarget(new targets.BatchJob(jobQueue, jobDefinition));
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::Events::Rule', {
        ScheduleExpression: 'rate(1 min)',
        State: 'ENABLED',
        Targets: [
            {
                Arn: {
                    Ref: 'MyQueueE6CA6235',
                },
                Id: 'Target0',
                RoleArn: {
                    'Fn::GetAtt': [
                        'MyJobEventsRoleCF43C336',
                        'Arn',
                    ],
                },
                BatchParameters: {
                    JobDefinition: { Ref: 'MyJob8719E923' },
                    JobName: 'Rule',
                },
            },
        ],
    }));
    assert_1.expect(stack).to(assert_1.haveResource('AWS::IAM::Policy', {
        PolicyDocument: {
            Statement: [
                {
                    Action: 'batch:SubmitJob',
                    Effect: 'Allow',
                    Resource: [
                        { Ref: 'MyJob8719E923' },
                        { Ref: 'MyQueueE6CA6235' },
                    ],
                },
            ],
            Version: '2012-10-17',
        },
        Roles: [
            { Ref: 'MyJobEventsRoleCF43C336' },
        ],
    }));
});
//# sourceMappingURL=data:application/json;base64,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