"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AfterCreate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class AfterCreate extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, '..', 'lambda'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: ['*'],
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                // we use 'currentVersion' because a new version is created every time the
                // handler changes (either code or configuration). this will have the effect
                // that the trigger will be executed every time the handler is changed.
                HandlerArn: props.handler.currentVersion.functionArn,
            },
        });
        // add a dependency between our resource and the resources we want to invoke
        // after.
        resource.node.addDependency(...(_b = props.resources) !== null && _b !== void 0 ? _b : []);
    }
}
exports.AfterCreate = AfterCreate;
_a = JSII_RTTI_SYMBOL_1;
AfterCreate[_a] = { fqn: "cdk-triggers.AfterCreate", version: "0.0.174" };
//# sourceMappingURL=data:application/json;base64,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