"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
/**
 * Security Groups do not allow for unrestricted SSH traffic - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.securityGroupIngress);
        if (ingressRules != undefined) {
            //For each ingress rule, ensure that it does not allow unrestricted SSH traffic.
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                if ((resolvedRule.cidrIp != undefined &&
                    resolvedRule.cidrIp.includes('/0')) ||
                    (resolvedRule.cidrIpv6 != undefined &&
                        resolvedRule.cidrIpv6.includes('/0'))) {
                    //Is a port range specified?
                    if (resolvedRule.fromPort != undefined &&
                        resolvedRule.toPort != undefined) {
                        if ((resolvedRule.fromPort <= 22 && resolvedRule.toPort >= 22) ||
                            resolvedRule.fromPort == -1 ||
                            resolvedRule.toPort == -1 ||
                            resolvedRule.ipProtocol == '-1') {
                            return false;
                        }
                    }
                    else {
                        if (resolvedRule.fromPort == 22 ||
                            resolvedRule.ipProtocol == '-1') {
                            return false;
                        }
                    }
                }
            }
        }
    }
    else if (node instanceof aws_ec2_1.CfnSecurityGroupIngress) {
        if ((node.cidrIp != undefined && node.cidrIp.includes('/0')) ||
            (node.cidrIpv6 != undefined && node.cidrIpv6.includes('/0'))) {
            //Is a port range specified?
            if (node.fromPort != undefined && node.toPort != undefined) {
                if ((node.fromPort <= 22 && node.toPort >= 22) ||
                    node.fromPort == -1 ||
                    node.toPort == -1 ||
                    node.ipProtocol == '-1') {
                    return false;
                }
            }
            else {
                if (node.fromPort == 22 || node.ipProtocol == '-1') {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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