"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM users, roles, and groups do not use AWS managed policies
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnGroup ||
        node instanceof aws_iam_1.CfnUser ||
        node instanceof aws_iam_1.CfnRole) {
        const managedPolicyArns = monocdk_1.Stack.of(node).resolve(node.managedPolicyArns);
        if (managedPolicyArns != undefined) {
            for (const arn of managedPolicyArns) {
                const resolvedArn = monocdk_1.Stack.of(node).resolve(arn);
                const arnPrefix = JSON.stringify(resolvedArn).split('/', 1)[0];
                if (!(/\d{12}/.test(arnPrefix) || arnPrefix.includes('AWS::AccountId'))) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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