"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const aws_apigatewayv2_1 = require("monocdk/aws-apigatewayv2");
/**
 * APIs implement authorization
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_apigateway_1.CfnMethod || node instanceof aws_apigatewayv2_1.CfnRoute) {
        if (node.authorizationType == undefined ||
            monocdk_1.Stack.of(node).resolve(node.authorizationType) == aws_apigateway_1.AuthorizationType.NONE) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVBJRzQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL25ldHdvcmtfYW5kX2RlbGl2ZXJ5L0FQSUc0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLDJEQUFzRTtBQUN0RSwrREFBb0Q7QUFFcEQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDBCQUFTLElBQUksSUFBSSxZQUFZLDJCQUFRLEVBQUU7UUFDekQsSUFDRSxJQUFJLENBQUMsaUJBQWlCLElBQUksU0FBUztZQUNuQyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxrQ0FBaUIsQ0FBQyxJQUFJLEVBQ3hFO1lBQ0EsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBVkQsNEJBVUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQXV0aG9yaXphdGlvblR5cGUsIENmbk1ldGhvZCB9IGZyb20gJ21vbm9jZGsvYXdzLWFwaWdhdGV3YXknO1xuaW1wb3J0IHsgQ2ZuUm91dGUgfSBmcm9tICdtb25vY2RrL2F3cy1hcGlnYXRld2F5djInO1xuXG4vKipcbiAqIEFQSXMgaW1wbGVtZW50IGF1dGhvcml6YXRpb25cbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5NZXRob2QgfHwgbm9kZSBpbnN0YW5jZW9mIENmblJvdXRlKSB7XG4gICAgaWYgKFxuICAgICAgbm9kZS5hdXRob3JpemF0aW9uVHlwZSA9PSB1bmRlZmluZWQgfHxcbiAgICAgIFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5hdXRob3JpemF0aW9uVHlwZSkgPT0gQXV0aG9yaXphdGlvblR5cGUuTk9ORVxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==