# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 5.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class IpBlockProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'ips': 'list[str]',

        'location': 'str',

        'size': 'int',

        'name': 'str',

        'ip_consumers': 'list[IpConsumer]',
    }

    attribute_map = {

        'ips': 'ips',

        'location': 'location',

        'size': 'size',

        'name': 'name',

        'ip_consumers': 'ipConsumers',
    }

    def __init__(self, ips=None, location=None, size=None, name=None, ip_consumers=None, local_vars_configuration=None):  # noqa: E501
        """IpBlockProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._ips = None
        self._location = None
        self._size = None
        self._name = None
        self._ip_consumers = None
        self.discriminator = None

        if ips is not None:
            self.ips = ips
        self.location = location
        self.size = size
        if name is not None:
            self.name = name
        if ip_consumers is not None:
            self.ip_consumers = ip_consumers


    @property
    def ips(self):
        """Gets the ips of this IpBlockProperties.  # noqa: E501

        A collection of IPs associated with the IP Block  # noqa: E501

        :return: The ips of this IpBlockProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this IpBlockProperties.

        A collection of IPs associated with the IP Block  # noqa: E501

        :param ips: The ips of this IpBlockProperties.  # noqa: E501
        :type ips: list[str]
        """

        self._ips = ips

    @property
    def location(self):
        """Gets the location of this IpBlockProperties.  # noqa: E501

        Location of that IP Block. Property cannot be modified after creation (disallowed in update requests)  # noqa: E501

        :return: The location of this IpBlockProperties.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this IpBlockProperties.

        Location of that IP Block. Property cannot be modified after creation (disallowed in update requests)  # noqa: E501

        :param location: The location of this IpBlockProperties.  # noqa: E501
        :type location: str
        """
        if self.local_vars_configuration.client_side_validation and location is None:  # noqa: E501
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location

    @property
    def size(self):
        """Gets the size of this IpBlockProperties.  # noqa: E501

        The size of the IP block  # noqa: E501

        :return: The size of this IpBlockProperties.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this IpBlockProperties.

        The size of the IP block  # noqa: E501

        :param size: The size of this IpBlockProperties.  # noqa: E501
        :type size: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def name(self):
        """Gets the name of this IpBlockProperties.  # noqa: E501

        A name of that resource  # noqa: E501

        :return: The name of this IpBlockProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IpBlockProperties.

        A name of that resource  # noqa: E501

        :param name: The name of this IpBlockProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def ip_consumers(self):
        """Gets the ip_consumers of this IpBlockProperties.  # noqa: E501

        Read-Only attribute. Lists consumption detail of an individual ip  # noqa: E501

        :return: The ip_consumers of this IpBlockProperties.  # noqa: E501
        :rtype: list[IpConsumer]
        """
        return self._ip_consumers

    @ip_consumers.setter
    def ip_consumers(self, ip_consumers):
        """Sets the ip_consumers of this IpBlockProperties.

        Read-Only attribute. Lists consumption detail of an individual ip  # noqa: E501

        :param ip_consumers: The ip_consumers of this IpBlockProperties.  # noqa: E501
        :type ip_consumers: list[IpConsumer]
        """

        self._ip_consumers = ip_consumers
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpBlockProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IpBlockProperties):
            return True

        return self.to_dict() != other.to_dict()
