# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 5.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class DatacenterProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'description': 'str',

        'location': 'str',

        'version': 'int',

        'features': 'list[str]',

        'sec_auth_protection': 'bool',
    }

    attribute_map = {

        'name': 'name',

        'description': 'description',

        'location': 'location',

        'version': 'version',

        'features': 'features',

        'sec_auth_protection': 'secAuthProtection',
    }

    def __init__(self, name=None, description=None, location=None, version=None, features=None, sec_auth_protection=None, local_vars_configuration=None):  # noqa: E501
        """DatacenterProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._location = None
        self._version = None
        self._features = None
        self._sec_auth_protection = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        self.location = location
        if version is not None:
            self.version = version
        if features is not None:
            self.features = features
        if sec_auth_protection is not None:
            self.sec_auth_protection = sec_auth_protection


    @property
    def name(self):
        """Gets the name of this DatacenterProperties.  # noqa: E501

        A name of that resource  # noqa: E501

        :return: The name of this DatacenterProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatacenterProperties.

        A name of that resource  # noqa: E501

        :param name: The name of this DatacenterProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this DatacenterProperties.  # noqa: E501

        A description for the datacenter, e.g. staging, production  # noqa: E501

        :return: The description of this DatacenterProperties.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DatacenterProperties.

        A description for the datacenter, e.g. staging, production  # noqa: E501

        :param description: The description of this DatacenterProperties.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def location(self):
        """Gets the location of this DatacenterProperties.  # noqa: E501

        The physical location where the datacenter will be created. This will be where all of your servers live. Property cannot be modified after datacenter creation (disallowed in update requests)  # noqa: E501

        :return: The location of this DatacenterProperties.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this DatacenterProperties.

        The physical location where the datacenter will be created. This will be where all of your servers live. Property cannot be modified after datacenter creation (disallowed in update requests)  # noqa: E501

        :param location: The location of this DatacenterProperties.  # noqa: E501
        :type location: str
        """
        if self.local_vars_configuration.client_side_validation and location is None:  # noqa: E501
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location

    @property
    def version(self):
        """Gets the version of this DatacenterProperties.  # noqa: E501

        The version of that Data Center. Gets incremented with every change  # noqa: E501

        :return: The version of this DatacenterProperties.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DatacenterProperties.

        The version of that Data Center. Gets incremented with every change  # noqa: E501

        :param version: The version of this DatacenterProperties.  # noqa: E501
        :type version: int
        """

        self._version = version

    @property
    def features(self):
        """Gets the features of this DatacenterProperties.  # noqa: E501

        List of features supported by the location this data center is part of  # noqa: E501

        :return: The features of this DatacenterProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._features

    @features.setter
    def features(self, features):
        """Sets the features of this DatacenterProperties.

        List of features supported by the location this data center is part of  # noqa: E501

        :param features: The features of this DatacenterProperties.  # noqa: E501
        :type features: list[str]
        """

        self._features = features

    @property
    def sec_auth_protection(self):
        """Gets the sec_auth_protection of this DatacenterProperties.  # noqa: E501

        Boolean value representing if the data center requires extra protection e.g. two factor protection  # noqa: E501

        :return: The sec_auth_protection of this DatacenterProperties.  # noqa: E501
        :rtype: bool
        """
        return self._sec_auth_protection

    @sec_auth_protection.setter
    def sec_auth_protection(self, sec_auth_protection):
        """Sets the sec_auth_protection of this DatacenterProperties.

        Boolean value representing if the data center requires extra protection e.g. two factor protection  # noqa: E501

        :param sec_auth_protection: The sec_auth_protection of this DatacenterProperties.  # noqa: E501
        :type sec_auth_protection: bool
        """

        self._sec_auth_protection = sec_auth_protection
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatacenterProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatacenterProperties):
            return True

        return self.to_dict() != other.to_dict()
