# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ResultsReaderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def results_reader_delete_test_run(self, test_run_id, **kwargs):  # noqa: E501
        """DeleteTestRun  # noqa: E501

        Deletes a specified test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_delete_test_run(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_delete_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_delete_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
            return data

    def results_reader_delete_test_run_with_http_info(self, test_run_id, **kwargs):  # noqa: E501
        """DeleteTestRun  # noqa: E501

        Deletes a specified test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_delete_test_run_with_http_info(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_delete_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `results_reader_delete_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_get_batch_result(self, test_run_id, test_type, **kwargs):  # noqa: E501
        """GetBatchResult  # noqa: E501

        Get batch result with a test run id and a test type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_batch_result(test_run_id, test_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :param str test_type: Type of test, such as \"Subset Accuracy\" or \"Overall Metrics\". (required)
        :return: TestrunresultGetBatchResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_get_batch_result_with_http_info(test_run_id, test_type, **kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_get_batch_result_with_http_info(test_run_id, test_type, **kwargs)  # noqa: E501
            return data

    def results_reader_get_batch_result_with_http_info(self, test_run_id, test_type, **kwargs):  # noqa: E501
        """GetBatchResult  # noqa: E501

        Get batch result with a test run id and a test type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_batch_result_with_http_info(test_run_id, test_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :param str test_type: Type of test, such as \"Subset Accuracy\" or \"Overall Metrics\". (required)
        :return: TestrunresultGetBatchResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'test_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_get_batch_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `results_reader_get_batch_result`")  # noqa: E501
        # verify the required parameter 'test_type' is set
        if ('test_type' not in params or
                params['test_type'] is None):
            raise ValueError("Missing the required parameter `test_type` when calling `results_reader_get_batch_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501
        if 'test_type' in params:
            path_params['testType'] = params['test_type']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}/batch-result/{testType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetBatchResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_get_feature_result(self, test_run_id, feature_id, **kwargs):  # noqa: E501
        """GetFeatureResult  # noqa: E501

        Returns the feature result that matches the specified test run ID  and feature ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_feature_result(test_run_id, feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :param str feature_id: ID of feature. (required)
        :return: TestrunresultGetFeatureResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_get_feature_result_with_http_info(test_run_id, feature_id, **kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_get_feature_result_with_http_info(test_run_id, feature_id, **kwargs)  # noqa: E501
            return data

    def results_reader_get_feature_result_with_http_info(self, test_run_id, feature_id, **kwargs):  # noqa: E501
        """GetFeatureResult  # noqa: E501

        Returns the feature result that matches the specified test run ID  and feature ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_feature_result_with_http_info(test_run_id, feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :param str feature_id: ID of feature. (required)
        :return: TestrunresultGetFeatureResultResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'feature_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_get_feature_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `results_reader_get_feature_result`")  # noqa: E501
        # verify the required parameter 'feature_id' is set
        if ('feature_id' not in params or
                params['feature_id'] is None):
            raise ValueError("Missing the required parameter `feature_id` when calling `results_reader_get_feature_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501
        if 'feature_id' in params:
            path_params['featureId'] = params['feature_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}/feature-result/{featureId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetFeatureResultResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_get_test_run(self, test_run_id, **kwargs):  # noqa: E501
        """GetTestRun  # noqa: E501

        Get the test run result detail with test run id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_test_run(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :return: TestrunresultGetTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_get_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_get_test_run_with_http_info(test_run_id, **kwargs)  # noqa: E501
            return data

    def results_reader_get_test_run_with_http_info(self, test_run_id, **kwargs):  # noqa: E501
        """GetTestRun  # noqa: E501

        Get the test run result detail with test run id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_get_test_run_with_http_info(test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: Existing test run ID. (required)
        :return: TestrunresultGetTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_get_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `results_reader_get_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/{testRunId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultGetTestRunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_batch_results(self, **kwargs):  # noqa: E501
        """ListBatchResults  # noqa: E501

        Returns a paginated list of batch results from a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_batch_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of a test run associated with batch results. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListBatchResults query. Responses from ListBatchResults contain a pageToken when there is a second page of results. Specify no more than one of either this field or the test run ID.
        :param str page_size: Number of objects on each page. Each call of ListBatchResults returns a single page.
        :return: TestrunresultListBatchResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_batch_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_batch_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_batch_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListBatchResults  # noqa: E501

        Returns a paginated list of batch results from a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_batch_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: The ID of a test run associated with batch results. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListBatchResults query. Responses from ListBatchResults contain a pageToken when there is a second page of results. Specify no more than one of either this field or the test run ID.
        :param str page_size: Number of objects on each page. Each call of ListBatchResults returns a single page.
        :return: TestrunresultListBatchResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_batch_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'test_run_id' in params:
            query_params.append(('testRunId', params['test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/batch-results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListBatchResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_feature_results(self, **kwargs):  # noqa: E501
        """ListFeatureResults  # noqa: E501

        List all feature results from a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_feature_results(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: ID of test run associated with feature results. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListFeatureResults query. Responses from ListFeatureResults contain a pageToken when there is a second page of results. Specify no more than one of either this field or the testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListFeatureResults returns a single page.
        :return: TestrunresultListFeatureResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_feature_results_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_feature_results_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_feature_results_with_http_info(self, **kwargs):  # noqa: E501
        """ListFeatureResults  # noqa: E501

        List all feature results from a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_feature_results_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str test_run_id: ID of test run associated with feature results. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListFeatureResults query. Responses from ListFeatureResults contain a pageToken when there is a second page of results. Specify no more than one of either this field or the testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListFeatureResults returns a single page.
        :return: TestrunresultListFeatureResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['test_run_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_feature_results" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'test_run_id' in params:
            query_params.append(('testRunId', params['test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-results', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListFeatureResultsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_summary_tests(self, **kwargs):  # noqa: E501
        """ListSummaryTests  # noqa: E501

        Returns a paginated list of the summary tests of a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_summary_tests(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_test_run_id: ID of the test run associated with summary tests. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListSummaryTests query. Responses from ListSummaryTests contain a pageToken when there is a second page of results. Specify no more than one of either this field or the query.testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListSummaryTests returns a single page.
        :return: TestrunresultListSummaryTestsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_summary_tests_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_summary_tests_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_summary_tests_with_http_info(self, **kwargs):  # noqa: E501
        """ListSummaryTests  # noqa: E501

        Returns a paginated list of the summary tests of a test run.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_summary_tests_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_test_run_id: ID of the test run associated with summary tests. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListSummaryTests query. Responses from ListSummaryTests contain a pageToken when there is a second page of results. Specify no more than one of either this field or the query.testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListSummaryTests returns a single page.
        :return: TestrunresultListSummaryTestsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_test_run_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_summary_tests" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query_test_run_id' in params:
            query_params.append(('query.testRunId', params['query_test_run_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/summary-tests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListSummaryTestsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_test_cases(self, **kwargs):  # noqa: E501
        """ListTestCases  # noqa: E501

        Returns a paginated list of the test cases in a test run. Specify a set  of test types to filter the list by the specified types.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_test_cases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_test_cases_query_test_run_id: ID of test run associated with test cases. Specify no more than one of  either this field or the pageToken field.
        :param list[str] list_test_cases_query_test_types: Optional filter for test types.
        :param list[str] list_test_cases_query_feature_ids: Optional filter for feature ids.
        :param str page_token: Use when retrieving the second page of a ListTestCases query. Responses from ListTestCases contain a pageToken when there is a second page of results. Specify no more than one of either this field or the  listTestCasesQuery.testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListTestCases returns a single page.
        :return: TestrunresultListTestCasesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_test_cases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_test_cases_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_test_cases_with_http_info(self, **kwargs):  # noqa: E501
        """ListTestCases  # noqa: E501

        Returns a paginated list of the test cases in a test run. Specify a set  of test types to filter the list by the specified types.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_test_cases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_test_cases_query_test_run_id: ID of test run associated with test cases. Specify no more than one of  either this field or the pageToken field.
        :param list[str] list_test_cases_query_test_types: Optional filter for test types.
        :param list[str] list_test_cases_query_feature_ids: Optional filter for feature ids.
        :param str page_token: Use when retrieving the second page of a ListTestCases query. Responses from ListTestCases contain a pageToken when there is a second page of results. Specify no more than one of either this field or the  listTestCasesQuery.testRunId field.
        :param str page_size: Number of objects in each page. Each call of ListTestCases returns a single page.
        :return: TestrunresultListTestCasesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_test_cases_query_test_run_id', 'list_test_cases_query_test_types', 'list_test_cases_query_feature_ids', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_test_cases" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'list_test_cases_query_test_run_id' in params:
            query_params.append(('listTestCasesQuery.testRunId', params['list_test_cases_query_test_run_id']))  # noqa: E501
        if 'list_test_cases_query_test_types' in params:
            query_params.append(('listTestCasesQuery.testTypes', params['list_test_cases_query_test_types']))  # noqa: E501
            collection_formats['listTestCasesQuery.testTypes'] = 'multi'  # noqa: E501
        if 'list_test_cases_query_feature_ids' in params:
            query_params.append(('listTestCasesQuery.featureIds', params['list_test_cases_query_feature_ids']))  # noqa: E501
            collection_formats['listTestCasesQuery.featureIds'] = 'multi'  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-cases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListTestCasesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_list_test_runs(self, **kwargs):  # noqa: E501
        """ListTestRuns  # noqa: E501

        List all test runs belonging to a project.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_test_runs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: ID of the project containing the requested test runs. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListTestRuns query. Responses from ListTestRuns contain a pageToken when there is a second page of results. Specify no more than one of either this field or the  project ID.
        :param str page_size: Number of objects on each page. Each call of ListTestRuns returns a single page.
        :return: TestrunresultListTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_list_test_runs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_list_test_runs_with_http_info(**kwargs)  # noqa: E501
            return data

    def results_reader_list_test_runs_with_http_info(self, **kwargs):  # noqa: E501
        """ListTestRuns  # noqa: E501

        List all test runs belonging to a project.  [Python pagination example](#tag/JobReader/operation/JobReader_ListJobs)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_list_test_runs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: ID of the project containing the requested test runs. Specify no more than one of either this field or the pageToken field.
        :param str page_token: Use when retrieving the second page of a ListTestRuns query. Responses from ListTestRuns contain a pageToken when there is a second page of results. Specify no more than one of either this field or the  project ID.
        :param str page_size: Number of objects on each page. Each call of ListTestRuns returns a single page.
        :return: TestrunresultListTestRunsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_list_test_runs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'project_id' in params:
            query_params.append(('projectId', params['project_id']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultListTestRunsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def results_reader_rename_test_run(self, body, test_run_id, **kwargs):  # noqa: E501
        """RenameTestRun  # noqa: E501

        Updates the name of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_rename_test_run(body, test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameTestRunIdBody body: (required)
        :param str test_run_id: ID of target test run. (required)
        :return: TestrunresultRenameTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.results_reader_rename_test_run_with_http_info(body, test_run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.results_reader_rename_test_run_with_http_info(body, test_run_id, **kwargs)  # noqa: E501
            return data

    def results_reader_rename_test_run_with_http_info(self, body, test_run_id, **kwargs):  # noqa: E501
        """RenameTestRun  # noqa: E501

        Updates the name of a test run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.results_reader_rename_test_run_with_http_info(body, test_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RenameTestRunIdBody body: (required)
        :param str test_run_id: ID of target test run. (required)
        :return: TestrunresultRenameTestRunResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'test_run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method results_reader_rename_test_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `results_reader_rename_test_run`")  # noqa: E501
        # verify the required parameter 'test_run_id' is set
        if ('test_run_id' not in params or
                params['test_run_id'] is None):
            raise ValueError("Missing the required parameter `test_run_id` when calling `results_reader_rename_test_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'test_run_id' in params:
            path_params['testRunId'] = params['test_run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/test-runs/rename/{testRunId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TestrunresultRenameTestRunResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
