# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FeatureFlagApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def feature_flag_get_limit_status(self, customer_name, limit, **kwargs):  # noqa: E501
        """GetLimitStatus  # noqa: E501

        Returns the status of a specified limit in this deployment's license.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_limit_status(customer_name, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: Name of the customer to query. (required)
        :param str limit: Specifies which limit to query. (required)
        :return: RimeGetLimitStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_flag_get_limit_status_with_http_info(customer_name, limit, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_flag_get_limit_status_with_http_info(customer_name, limit, **kwargs)  # noqa: E501
            return data

    def feature_flag_get_limit_status_with_http_info(self, customer_name, limit, **kwargs):  # noqa: E501
        """GetLimitStatus  # noqa: E501

        Returns the status of a specified limit in this deployment's license.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_limit_status_with_http_info(customer_name, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: Name of the customer to query. (required)
        :param str limit: Specifies which limit to query. (required)
        :return: RimeGetLimitStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_name', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_flag_get_limit_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_name' is set
        if ('customer_name' not in params or
                params['customer_name'] is None):
            raise ValueError("Missing the required parameter `customer_name` when calling `feature_flag_get_limit_status`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `feature_flag_get_limit_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_name' in params:
            path_params['customerName'] = params['customer_name']  # noqa: E501
        if 'limit' in params:
            path_params['limit'] = params['limit']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-flags/{customerName}/limits/{limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetLimitStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
