# MainFuncLib
This library is created for the second homework of MG 8411 Data Engineering and extends the first homework. This library still hides the API key. The code implements also the Keltner bands.  It keeps track in real time of max, min, mean, VOL, FD (fractal dimension) per 6 minute interval.

It does this by calculating the volatility as max – min. Then 100 Keltner bands get formed in the next interval using the mean and the volatility of the previous interval:

Keltner Channel Upper Band = Mean Value + n*0.025*VOL, n from 1 to 100, where Mean Value and VOL are calculated from the previous period of 6 minutes.

Keltner Channel Lower Band = Mean Value – n*0.025*VOL, n from 1 to 100, where Mean Value and VOL are calculated from the previous period of 6 minutes.

The # crosses with the Keltner bands gets counted during the 6 minute interval and then the fractal dimension is calculated as: # cross/VOL

Extra info: this is based on brownian montion with the Mean Value as the best approximation for the next 6 minutes and the 0.025 is the step size. 

Note that the first 6 minute checkpoint doesn't yield a FD and is set to Null, because there is no previous information yet.

The code also implements a check to see if the provided makes sense and is correct and the comments in the code clarify my implementation of this homework.



### Installation
```
pip install MainFuncLib==0.2.8
```

### Get started
Make sure the latest version of Polygon-api-client is installed. Example of how to use this library in Max's code, delete main() in Max's code and replace with the library:

```Python
# To have HW2 fully extend HW1, I made a new and updated version of the library
# This library can be found at: https://pypi.org/project/MainFuncLib/0.2.8/
# This will also return the extra tables with the parameters for the Keltner Channels and will hide the API key
# as stated in HW1

import os

# Always check if the final db is removed, to prevent already exists errors during initialization
if os.path.lexists("./sqlite/final.db"):
    os.remove("./sqlite/final.db")

from MainFuncLib import mainFunc

# Update to the most recent values
vol_AUD_USD = 0.0168; start_mean_AUD_USD = 0.665
vol_GBP_EUR = 0.0076; start_mean_GBP_EUR = 1.15

time = 36100 # Time for how long you want to run the code

# Example with 2 currency pairs
currency_pairs = [["AUD","USD",0,0, vol_AUD_USD, start_mean_AUD_USD,0,9999],
                  ["GBP","EUR",0,0, vol_GBP_EUR, start_mean_GBP_EUR,0,9999]]

mainFunc(currency_pairs, time)
```