"""Scraper for Supreme Court of Maine
CourtID: me
Court Short Name: Me.
Author: Brian W. Carver
Date created: June 20, 2014

History:
  2014-06-25 (est): Added code for additional date formats.
  2014-07-02: Was receiving InsanityException and tweaked date code to get some
              missing dates.
  2014-12-15: Fixes insanity exception by tweaking the XPaths.
"""

from lxml import html

from juriscraper.OpinionSite import OpinionSite
from juriscraper.lib.string_utils import convert_date_string


class Site(OpinionSite):
    def __init__(self, *args, **kwargs):
        super(Site, self).__init__(*args, **kwargs)
        self.court_id = self.__module__
        self.url = "https://www.courts.maine.gov/courts/sjc/opinions.html"
        self.path_root = '//table[contains(.//th[1], "Opinion")]'

    def _get_cell_path(self, cell_number: int, subpath: str = "") -> str:
        path = '//table[contains(.//th[1], "Opinion")]//td[%d]'
        return "%s/%s" % (path, subpath) if subpath else path

    def _get_download_urls(self):
        path = "%s//td[2]/a[1]/@href" % self.path_root
        return list(self.html.xpath(path))

    def _get_case_names(self):
        case_names = []
        path = "%s//td[2]/a[1]" % self.path_root
        for e in self.html.xpath(path):
            s = html.tostring(e, method="text", encoding="unicode")
            case_names.append(s)
        return case_names

    def _get_case_dates(self):
        dates = []
        path = "%s//td[3]" % self.path_root
        for cell in self.html.xpath(path):
            date_string = cell.text_content().replace("Aguust", "August")
            dates.append(convert_date_string(date_string))
        return dates

    def _get_precedential_statuses(self):
        return ["Published"] * len(self.case_names)

    def _get_neutral_citations(self):
        path = "%s//td[1]//text()" % self.path_root
        return list(self.html.xpath(path))
