#!/bin/python3
# Copyright 2021 by opensource@secinfra.fr
# Initially from Matthew Treinish's https://github.com/mtreinish/pyopnsense
# Improved a bit.

#
# This file is part of pyopnsense2
#
# pyopnsense2 is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# pyopnsense2 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pyopnsense2. If not, see <http://www.gnu.org/licenses/>.

from pyopnsense2 import client
from six.moves import urllib
import json

class core_menu(client.BaseClient):
    """A client for interacting with the OPNSense's coremenu API.
    for more information on used parameters, see : 

    :param str api_key: The API key to use for requests
    :param str api_secret: The API secret to use for requests
    :param str base_url: The base API endpoint for the OPNsense deployment
    """

    def search(self, args={}, params={}):
        """"""
        url = "core/menu/search/"
        data = {}

        data = self._get( url, args)
        return data

    def tree(self, args={}, params={}):
        """"""
        url = "core/menu/tree/"
        data = {}

        data = self._get( url, args)
        return data

class core_system(client.BaseClient):
    """A client for interacting with the OPNSense's coresystem API.
    for more information on used parameters, see : 

    :param str api_key: The API key to use for requests
    :param str api_secret: The API secret to use for requests
    :param str base_url: The base API endpoint for the OPNsense deployment
    """

    def halt(self, args={}, params={}):
        """"""
        url = "core/system/halt/"
        data = {}

        data = self._get( url, args)
        return data

    def reboot(self, args={}, params={}):
        """"""
        url = "core/system/reboot/"
        data = {}

        data = self._get( url, args)
        return data
