# TCRA
**Tropical Cyclone Risk Analysis [TCRA]** 
The documentation of this tool is published here: [TCRA documentation](https://tcra.readthedocs.io)


Overview
--------
**Tropical Cyclone Risk Analysis (TCRA)** is a Python package that allows for the development of scenario-based tropical cyclone risk analysis of buildings and Electrical Power Network (EPN). This tool performs scenario-hazard analysis based on historical or simulated cyclone tracks, fragility-based damage analysis, damage ratio analysis, loss estimation, recovery simulation of damaged structures, and social impact assessments on the community. It also enables decision-makers to make rehabilitation decisions and perform rehabilitation scenario analysis.

Dependency
----------
* warnings
* numpy
* pandas
* matplotlib
* scipy
* folium
* collections
* typing

Version Reslease
-----------------
* v 0.0.1 : July, 2024
The current version is a ongoing research project, which is still a pre-release.

Authors
-----------------
* This tool is developed by [Ram Krishna Mazumder, Ph.D., P.E.](https://rxm562.github.io/), Asset Management Consultant/Structural Engineer, Arcadis U.S. Inc.

Funding Statement
----------------------
* This tool development is partly supported by the [Coalition for Disaster Resilient Infrastructure (CDRI)](https://www.cdri.world/) fellowship 2023-24 Cohort under the Project titled "Community Disaster Resilience Assessment by Integrating Functionality of Buildings and Critical Infrastructure Systems". The development of this tool is not necessarily expressed the view of the CDRI.


Project Team
-----------------
1. Principal Investigator: **Ram Krishna Mazumder**, Asset Management Consultant, Arcadis U.S. Inc.
2. Co-Principal Investigator: **Subhrajit Dutta**, Assistant Professor, Department of Civil Engineering, National Institute of Technology Silchar, Assam, India
3. Co-Principal Investigator: **Sohel Rana**, Research Lecturer, Institute of Earthquake Engineering Research, Chittagong University of Engineering & Technology, Bangladesh.
4. Research Assistant: **Swaranjit Roy**, IEER, Chittagong University of Engineering & Technology, Bangladesh.
5. Research Assistant: **Sahil Chettri**, Department of Civil Engineering, NIT Silchar, Assam, India

Citing TCRA
-----------------
* Mazumder,R.K.(2024). Tropical Cyclone Risk Analysis. https://github.com/rxm562/TCRA


Source Files
-------------------------------
Github: https://github.com/rxm562/TCRA.git
Documentation: https://tcra.readthedocs.io

License
-----------------
The project is licensed under the MIT license. See the LICENSE file
