[![Downloads](https://static.pepy.tech/personalized-badge/generateApiKey?period=total&units=abbreviation&left_color=grey&right_color=yellow&left_text=Total-Downloads)](https://pepy.tech/project/generateApiKey)
[![Supported Versions](https://img.shields.io/pypi/pyversions/generateApiKey.svg)](https://pypi.org/project/YoutubeTags)
![GitHub](https://img.shields.io/github/license/nuhmanpk/generate-api-key)
![PyPI](https://img.shields.io/pypi/v/generateApiKey)
[![Documentation Status](https://readthedocs.org/projects/generateApiKey/badge/?version=latest)](https://generateApiKey.readthedocs.io/en/latest/?badge=latest)
![PyPI - Downloads](https://img.shields.io/pypi/dm/generateApiKey)
[![Downloads](https://static.pepy.tech/personalized-badge/generateApiKey?period=week&units=international_system&left_color=grey&right_color=brightgreen&left_text=Downloads/Week)](https://pepy.tech/project/generateApiKey)
[![Upload to PIP](https://github.com/nuhmanpk/generate-api-key/actions/workflows/pypi-upload.yml/badge.svg?branch=main&event=workflow_dispatch)](https://github.com/nuhmanpk/generate-api-key/actions/workflows/Pypi-uploads.yml)
![PyPI - Format](https://img.shields.io/pypi/format/generateApiKey)
# API Key Generation Package

Timestamp and Numeric Representation: Now, the package incorporates a time-based and date-based hashing mechanism, adding an extra layer of security to your API keys. It captures the current timestamp and numeric representation of the key generation process, creating a unique identifier that's closely tied to the moment it was generated. This feature adds an element of time-based uniqueness to your keys, making them even more secure and less predictable.

This package provides a convenient way to generate API keys using a secret, seed, and an optional include keyword. The generated keys are unique and secure, making them suitable for use in a variety of applications.

The package supports generating API keys using a variety of methods such as UUID v5 and SHA-256 algorithm. The keys are generated using a combination of seed, secret, and include keyword. Additionally, the package allows you to insert the include keyword at a random position in the seed which will make it more difficult to guess.

It is important to keep the secret used to generate the keys secure and not share it with unauthorized parties. Additionally, the package can only be used for legitimate and legal purposes.

Please keep in mind that, even though this package provides a secure way to generate API keys, it is still important to use other security measures such as rate limiting, IP whitelisting, and encryption to protect your API and the data it accesses.

By using this package, you agree to take all necessary precautions to protect the data and resources accessed with the keys from unauthorized access or misuse. It is recommended to consult with a security expert before using this package or handling sensitive data.

# Privacy Policy

This package generates API keys that can be used to access sensitive data or resources. By using this package, you agree to keep the secret used to generate the keys secure and not share it with unauthorized parties. Additionally, the package can only be used for legitimate and legal purposes.

Please be aware that the package may cause a security risk if not used properly. The authors of this package cannot be held responsible for any unauthorized access or misuse of the keys generated by this package.

It is the user's responsibility to ensure the security of the keys and the protection of the data. It is recommended to consult with a security expert before using this package or handling sensitive data.

By using this package, you agree to take all necessary precautions to protect the data and resources accessed with the keys from unauthorized access or misuse.



# Installation
To install your package, you can use the pip package manager by running the following command in your command line:

```python
pip install generateApiKey
```

# Importing the package
Once the package is installed, you can import the package in your code by using the import statement:
```python
from generateApiKey import generateApiKey
```
# Generating an API key
To generate an API key, you can use the generateApiKey() function and pass in the secret, seed, and an optional include keyword. For example:

```python
from generateApiKey import generateApiKey

seed='12'
secret='Topsecrect'
api_key=generateApiKey(secret,seed)
print(api_key)
```


```python
from generateApiKey import generateApiKey
api_key = generateApiKey(secret='Topsecret', seed='12',include='user1')
print(api_key)
```

```python
from generateApiKey import generateApiKey
api_key = generateApiKey(secret='Topsecret', seed='12',include='user1',add_dashes=True)
print(api_key)
```


```python
secret = 'mysecret'
seed = 'randomseed'
include = "TopSecretWord"
api_key = generateApiKey(secret, seed, include)
print(api_key)
```
This will generate an API key based on the provided secret, seed, and include keyword.

## Error handling
It is a good practice to handle errors, you can use the try and except block to handle any exception that may occur during the key generation process.

```python
try:
    secret = 'mysecret'
    seed = 'randomseed'
    include = "Production"
    api_key = generateApiKey(secret, seed, include)
    print(api_key)
except Exception as e:
    print(e)
```

You can use the None return in the package function, to check if the key generation was successful.

```python
api_key = generateApiKey(secret, seed, include)
if api_key is None:
    print("Failed to generate api key")
else:
    print(api_key)
```
# Parameters 

| **Variable** |	**Type** |	**Required** |	**Example Value** |	Description |
|----------|---------|-----------|--------------------|-------------|
| secret |	`String` |	Yes |	"Topsecret" |	The secret key used to generate the API key. It should be kept private and not shared with unauthorized parties. |
| seed |	`String` |	Yes |	"12" |	A value used to seed the generation of the API key. It can be any value, but it should be unique for each key. |
| include |	`String` |	Optional |	"user1" |	An optional value that can be included in the generated API key. It can be used to identify the user or application associated with the key. |
| add_dashes |	`boolean` |	Optional |	True |	A value used to determine wheather to add dashes or not in a key |


By using this package, you are solely liable for any legal issues that may arise from its unauthorized use or misuse, as well as any security risks that may result from not properly securing the secret key used to generate the API keys.

# Fair Use Policy:

This package is provided as is, without any warranties or guarantees of any kind. We are not liable for any damages or losses that may result from its use. We reserve the right to change or discontinue the package at any time without notice.

We encourage you to use the package responsibly, and to report any security issues or bugs you may encounter.

[Nuhman Pk](https://github.com/nuhmanpk)
