# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.3.0  # noqa: E501
    The version of the OpenAPI document: 0.11.2
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class AccountMetadataTransactionBodyDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'target_address': 'str',
        'scoped_metadata_key': 'str',
        'value_size_delta': 'int',
        'value_size': 'int',
        'value': 'str'
    }

    attribute_map = {
        'target_address': 'targetAddress',
        'scoped_metadata_key': 'scopedMetadataKey',
        'value_size_delta': 'valueSizeDelta',
        'value_size': 'valueSize',
        'value': 'value'
    }

    def __init__(self, target_address=None, scoped_metadata_key=None, value_size_delta=None, value_size=None, value=None, local_vars_configuration=None):  # noqa: E501
        """AccountMetadataTransactionBodyDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._target_address = None
        self._scoped_metadata_key = None
        self._value_size_delta = None
        self._value_size = None
        self._value = None
        self.discriminator = None

        self.target_address = target_address
        self.scoped_metadata_key = scoped_metadata_key
        self.value_size_delta = value_size_delta
        self.value_size = value_size
        self.value = value

    @property
    def target_address(self):
        """Gets the target_address of this AccountMetadataTransactionBodyDTO.  # noqa: E501

        Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1.   # noqa: E501

        :return: The target_address of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._target_address

    @target_address.setter
    def target_address(self, target_address):
        """Sets the target_address of this AccountMetadataTransactionBodyDTO.

        Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1.   # noqa: E501

        :param target_address: The target_address of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_address is None:  # noqa: E501
            raise ValueError("Invalid value for `target_address`, must not be `None`")  # noqa: E501

        self._target_address = target_address

    @property
    def scoped_metadata_key(self):
        """Gets the scoped_metadata_key of this AccountMetadataTransactionBodyDTO.  # noqa: E501

        Metadata key scoped to source, target and type expressed.  # noqa: E501

        :return: The scoped_metadata_key of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._scoped_metadata_key

    @scoped_metadata_key.setter
    def scoped_metadata_key(self, scoped_metadata_key):
        """Sets the scoped_metadata_key of this AccountMetadataTransactionBodyDTO.

        Metadata key scoped to source, target and type expressed.  # noqa: E501

        :param scoped_metadata_key: The scoped_metadata_key of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and scoped_metadata_key is None:  # noqa: E501
            raise ValueError("Invalid value for `scoped_metadata_key`, must not be `None`")  # noqa: E501

        self._scoped_metadata_key = scoped_metadata_key

    @property
    def value_size_delta(self):
        """Gets the value_size_delta of this AccountMetadataTransactionBodyDTO.  # noqa: E501

        Change in value size in bytes.  # noqa: E501

        :return: The value_size_delta of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._value_size_delta

    @value_size_delta.setter
    def value_size_delta(self, value_size_delta):
        """Sets the value_size_delta of this AccountMetadataTransactionBodyDTO.

        Change in value size in bytes.  # noqa: E501

        :param value_size_delta: The value_size_delta of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and value_size_delta is None:  # noqa: E501
            raise ValueError("Invalid value for `value_size_delta`, must not be `None`")  # noqa: E501

        self._value_size_delta = value_size_delta

    @property
    def value_size(self):
        """Gets the value_size of this AccountMetadataTransactionBodyDTO.  # noqa: E501

        A number that allows uint 32 values.  # noqa: E501

        :return: The value_size of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :rtype: int
        """
        return self._value_size

    @value_size.setter
    def value_size(self, value_size):
        """Sets the value_size of this AccountMetadataTransactionBodyDTO.

        A number that allows uint 32 values.  # noqa: E501

        :param value_size: The value_size of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and value_size is None:  # noqa: E501
            raise ValueError("Invalid value for `value_size`, must not be `None`")  # noqa: E501

        self._value_size = value_size

    @property
    def value(self):
        """Gets the value of this AccountMetadataTransactionBodyDTO.  # noqa: E501

        Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).  # noqa: E501

        :return: The value of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this AccountMetadataTransactionBodyDTO.

        Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).  # noqa: E501

        :param value: The value of this AccountMetadataTransactionBodyDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountMetadataTransactionBodyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountMetadataTransactionBodyDTO):
            return True

        return self.to_dict() != other.to_dict()
