"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLambdaWithPrivatePypi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
class PythonLambdaWithPrivatePypi extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.indexUrl = props.indexUrl;
        this.trustedHost = props.trustedHost;
        this.codePath = props.codePath;
        this.handler = props.handler ? props.handler : 'index.handler';
        new aws_lambda_1.Function(this, `${id}Lambda`, {
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            handler: this.handler,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, this.codePath), {
                bundling: {
                    image: aws_lambda_1.Runtime.PYTHON_3_9.bundlingImage,
                    command: [
                        'bash',
                        '-c',
                        'pip install ' +
                            `--index-url ${this.indexUrl} ` +
                            `--trusted-host ${this.trustedHost} ` +
                            '-r requirements.txt ' +
                            '-t /asset-output/python ' +
                            '&& cp -au . /asset/output/python',
                    ],
                },
            }),
        });
    }
}
exports.PythonLambdaWithPrivatePypi = PythonLambdaWithPrivatePypi;
_a = JSII_RTTI_SYMBOL_1;
PythonLambdaWithPrivatePypi[_a] = { fqn: "@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi", version: "0.0.97" };
//# sourceMappingURL=data:application/json;base64,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