# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### PythonLambdaWithPrivatePypi <a name="PythonLambdaWithPrivatePypi" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi"></a>

#### Initializers <a name="Initializers" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer"></a>

```typescript
import { PythonLambdaWithPrivatePypi } from '@professionalaf/enterprise-utils'

new PythonLambdaWithPrivatePypi(scope: Construct, id: string, props: PythonLambdaWithPrivatePypiProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.props">props</a></code> | <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps">PythonLambdaWithPrivatePypiProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.Initializer.parameter.props"></a>

- *Type:* <a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps">PythonLambdaWithPrivatePypiProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.isConstruct"></a>

```typescript
import { PythonLambdaWithPrivatePypi } from '@professionalaf/enterprise-utils'

PythonLambdaWithPrivatePypi.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.codePath">codePath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.indexUrl">indexUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.trustedHost">trustedHost</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.handler">handler</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `codePath`<sup>Required</sup> <a name="codePath" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.codePath"></a>

```typescript
public readonly codePath: string;
```

- *Type:* string

---

##### `indexUrl`<sup>Required</sup> <a name="indexUrl" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.indexUrl"></a>

```typescript
public readonly indexUrl: string;
```

- *Type:* string

---

##### `trustedHost`<sup>Required</sup> <a name="trustedHost" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.trustedHost"></a>

```typescript
public readonly trustedHost: string;
```

- *Type:* string

---

##### `handler`<sup>Optional</sup> <a name="handler" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypi.property.handler"></a>

```typescript
public readonly handler: string;
```

- *Type:* string

---


## Structs <a name="Structs" id="Structs"></a>

### PythonLambdaWithPrivatePypiProps <a name="PythonLambdaWithPrivatePypiProps" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps"></a>

#### Initializer <a name="Initializer" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.Initializer"></a>

```typescript
import { PythonLambdaWithPrivatePypiProps } from '@professionalaf/enterprise-utils'

const pythonLambdaWithPrivatePypiProps: PythonLambdaWithPrivatePypiProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.codePath">codePath</a></code> | <code>string</code> | Relative path to function code. |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.indexUrl">indexUrl</a></code> | <code>string</code> | --index-url for private pypi repo. |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.trustedHost">trustedHost</a></code> | <code>string</code> | --trusted-host for private repo. |
| <code><a href="#@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.handler">handler</a></code> | <code>string</code> | Handler location. |

---

##### `codePath`<sup>Required</sup> <a name="codePath" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.codePath"></a>

```typescript
public readonly codePath: string;
```

- *Type:* string

Relative path to function code.

---

##### `indexUrl`<sup>Required</sup> <a name="indexUrl" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.indexUrl"></a>

```typescript
public readonly indexUrl: string;
```

- *Type:* string

-index-url for private pypi repo.

---

##### `trustedHost`<sup>Required</sup> <a name="trustedHost" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.trustedHost"></a>

```typescript
public readonly trustedHost: string;
```

- *Type:* string

-trusted-host for private repo.

---

##### `handler`<sup>Optional</sup> <a name="handler" id="@professionalaf/enterprise-utils.PythonLambdaWithPrivatePypiProps.property.handler"></a>

```typescript
public readonly handler: string;
```

- *Type:* string
- *Default:* 'index.handler'

Handler location.

---



