# OpenPD: Opened Peptide Dynamics package

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![Build Status](https://travis-ci.org/zhenyuwei99/openpd.svg?branch=main)](https://travis-ci.org/zhenyuwei99/openpd)
[![codecov](https://codecov.io/gh/zhenyuwei99/openpd/branch/main/graph/badge.svg?token=2O1CV31X7S)](https://codecov.io/gh/zhenyuwei99/openpd)
[![Documentation Status](https://readthedocs.org/projects/openpd/badge/?version=latest)](https://openpd.net/en/latest/?badge=latest) 
[![PyPi Version](https://img.shields.io/pypi/v/openpd.svg)](https://pypi.org/project/openpd/) 

## Introduction

OpenPD, standing for **Open** **P**eptide **D**ynamics, is a python package, distributed freely under the terms of
GNU Public License Version 3 (GPLv3), for peptide dynamics simulation. It was designed to simulate the folding dynamics of protein efficiently with the assistance of **P**eptide **D**ynamics **F**orce **F**ield (PDFF), which is a solvent considered, high-level coarse-grained force field focusing on the peptide interaction. 

OpenPD is developed and maintained by Zhenyu Wei (zhenyuwei99@gmail.com), from Yunfei Chen's group in Southeast University. As a newly developed program, we always welcome developers to contact us.

The OpenPD distribution includes following files and folders:

|   Name    |             Description             |
| :-------: | :---------------------------------: |
|  README   |              This file              |
|  LICENSE  |             MIT License             |
|   docs    |            Documentation            |
|  openpd   | Source code of openpd python module |
| tutorials |  Folder contains tutorial notebook  |
| setup.py  |     Build script for setuptools     |

## Need help?

To get more information, please check out the project [documentation](https://openpd.net/en/latest).
