# coding: utf-8

"""
    Canopy.Api

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from canopy.openapi.api_client import ApiClient
from canopy.openapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StudyApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def study_delete_study(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_delete_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_delete_study(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_delete_study_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_delete_study_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_delete_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_delete_study_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'undelete'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_delete_study" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_delete_study`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_delete_study`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('undelete') is not None:  # noqa: E501
            query_params.append(('undelete', local_var_params['undelete']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_delete_study_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_delete_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_delete_study_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_delete_study_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_delete_study_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_delete_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_delete_study_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'undelete'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_delete_study_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_delete_study_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_delete_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_delete_study_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('undelete') is not None:  # noqa: E501
            query_params.append(('undelete', local_var_params['undelete']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_all_tenants_study_statistics(self, **kwargs):  # noqa: E501
        """study_get_all_tenants_study_statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_all_tenants_study_statistics(async_req=True)
        >>> result = thread.get()

        :param start_date:
        :type start_date: str
        :param end_date:
        :type end_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAllTenantsStudyStatisticsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_all_tenants_study_statistics_with_http_info(**kwargs)  # noqa: E501

    def study_get_all_tenants_study_statistics_with_http_info(self, **kwargs):  # noqa: E501
        """study_get_all_tenants_study_statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_all_tenants_study_statistics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param start_date:
        :type start_date: str
        :param end_date:
        :type end_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAllTenantsStudyStatisticsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'start_date',
            'end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_all_tenants_study_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('start_date') is not None:  # noqa: E501
            query_params.append(('startDate', local_var_params['start_date']))  # noqa: E501
        if local_var_params.get('end_date') is not None:  # noqa: E501
            query_params.append(('endDate', local_var_params['end_date']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetAllTenantsStudyStatisticsQueryResult",
        }

        return self.api_client.call_api(
            '/studies/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_sim_type(self, sim_type, **kwargs):  # noqa: E501
        """study_get_sim_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_sim_type(sim_type, async_req=True)
        >>> result = thread.get()

        :param sim_type: (required)
        :type sim_type: str
        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SimTypeDefinition
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_sim_type_with_http_info(sim_type, **kwargs)  # noqa: E501

    def study_get_sim_type_with_http_info(self, sim_type, **kwargs):  # noqa: E501
        """study_get_sim_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_sim_type_with_http_info(sim_type, async_req=True)
        >>> result = thread.get()

        :param sim_type: (required)
        :type sim_type: str
        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SimTypeDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'sim_type',
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_sim_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'sim_type' is set
        if self.api_client.client_side_validation and local_var_params.get('sim_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `sim_type` when calling `study_get_sim_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sim_type' in local_var_params:
            path_params['simType'] = local_var_params['sim_type']  # noqa: E501

        query_params = []
        if local_var_params.get('tenant_id') is not None:  # noqa: E501
            query_params.append(('tenantId', local_var_params['tenant_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "SimTypeDefinition",
        }

        return self.api_client.call_api(
            '/studies/types/sims/{simType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_studies(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_studies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_studies(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param filter:
        :type filter: str
        :param include_transient:
        :type include_transient: bool
        :param result_type:
        :type result_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudiesQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_studies_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def study_get_studies_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_studies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_studies_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param filter:
        :type filter: str
        :param include_transient:
        :type include_transient: bool
        :param result_type:
        :type result_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudiesQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'filter',
            'include_transient',
            'result_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_studies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_studies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('filter') is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if local_var_params.get('include_transient') is not None:  # noqa: E501
            query_params.append(('includeTransient', local_var_params['include_transient']))  # noqa: E501
        if local_var_params.get('result_type') is not None:  # noqa: E501
            query_params.append(('resultType', local_var_params['result_type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudiesQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_download(self, tenant_id, study_id, access_signature, expiry, **kwargs):  # noqa: E501
        """study_get_study_download  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download(tenant_id, study_id, access_signature, expiry, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param access_signature: (required)
        :type access_signature: str
        :param expiry: (required)
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param full:
        :type full: bool
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param merged_scalar_results_only:
        :type merged_scalar_results_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_download_with_http_info(tenant_id, study_id, access_signature, expiry, **kwargs)  # noqa: E501

    def study_get_study_download_with_http_info(self, tenant_id, study_id, access_signature, expiry, **kwargs):  # noqa: E501
        """study_get_study_download  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_with_http_info(tenant_id, study_id, access_signature, expiry, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param access_signature: (required)
        :type access_signature: str
        :param expiry: (required)
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param full:
        :type full: bool
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param merged_scalar_results_only:
        :type merged_scalar_results_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'access_signature',
            'expiry',
            'file_name',
            'full',
            'channels_as_csv',
            'merged_scalar_results_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_download`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_download`")  # noqa: E501
        # verify the required parameter 'access_signature' is set
        if self.api_client.client_side_validation and local_var_params.get('access_signature') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `access_signature` when calling `study_get_study_download`")  # noqa: E501
        # verify the required parameter 'expiry' is set
        if self.api_client.client_side_validation and local_var_params.get('expiry') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `expiry` when calling `study_get_study_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('access_signature') is not None:  # noqa: E501
            query_params.append(('accessSignature', local_var_params['access_signature']))  # noqa: E501
        if local_var_params.get('expiry') is not None:  # noqa: E501
            query_params.append(('expiry', local_var_params['expiry']))  # noqa: E501
        if local_var_params.get('file_name') is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if local_var_params.get('full') is not None:  # noqa: E501
            query_params.append(('full', local_var_params['full']))  # noqa: E501
        if local_var_params.get('channels_as_csv') is not None:  # noqa: E501
            query_params.append(('channelsAsCsv', local_var_params['channels_as_csv']))  # noqa: E501
        if local_var_params.get('merged_scalar_results_only') is not None:  # noqa: E501
            query_params.append(('mergedScalarResultsOnly', local_var_params['merged_scalar_results_only']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_download_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param access_signature:
        :type access_signature: str
        :param expiry:
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param full:
        :type full: bool
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param merged_scalar_results_only:
        :type merged_scalar_results_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_download_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_download_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param access_signature:
        :type access_signature: str
        :param expiry:
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param full:
        :type full: bool
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param merged_scalar_results_only:
        :type merged_scalar_results_only: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'access_signature',
            'expiry',
            'file_name',
            'full',
            'channels_as_csv',
            'merged_scalar_results_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_download_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_download_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_download_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_download_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('access_signature') is not None:  # noqa: E501
            query_params.append(('accessSignature', local_var_params['access_signature']))  # noqa: E501
        if local_var_params.get('expiry') is not None:  # noqa: E501
            query_params.append(('expiry', local_var_params['expiry']))  # noqa: E501
        if local_var_params.get('file_name') is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if local_var_params.get('full') is not None:  # noqa: E501
            query_params.append(('full', local_var_params['full']))  # noqa: E501
        if local_var_params.get('channels_as_csv') is not None:  # noqa: E501
            query_params.append(('channelsAsCsv', local_var_params['channels_as_csv']))  # noqa: E501
        if local_var_params.get('merged_scalar_results_only') is not None:  # noqa: E501
            query_params.append(('mergedScalarResultsOnly', local_var_params['merged_scalar_results_only']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_download_url(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_url(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyDownloadUrlQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_download_url_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_download_url_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_url  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_url_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyDownloadUrlQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_download_url" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_download_url`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_download_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyDownloadUrlQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/download-url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_download_url_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_url_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_url_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyDownloadUrlQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_download_url_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_download_url_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_download_url_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_download_url_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyDownloadUrlQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_download_url_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_download_url_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_download_url_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_download_url_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyDownloadUrlQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/download-url', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job(self, tenant_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job(tenant_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_with_http_info(tenant_id, study_id, job_id, **kwargs)  # noqa: E501

    def study_get_study_job_with_http_info(self, tenant_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_with_http_info(tenant_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'job_id',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/jobs/{jobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job_deprecated(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_deprecated(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, **kwargs)  # noqa: E501

    def study_get_study_job_deprecated_with_http_info(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'job_id',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_job_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job_deprecated`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/jobs/{jobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job_download(self, tenant_id, study_id, job_id, access_signature, expiry, **kwargs):  # noqa: E501
        """study_get_study_job_download  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_download(tenant_id, study_id, job_id, access_signature, expiry, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param access_signature: (required)
        :type access_signature: str
        :param expiry: (required)
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param sim_type_channels:
        :type sim_type_channels: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_download_with_http_info(tenant_id, study_id, job_id, access_signature, expiry, **kwargs)  # noqa: E501

    def study_get_study_job_download_with_http_info(self, tenant_id, study_id, job_id, access_signature, expiry, **kwargs):  # noqa: E501
        """study_get_study_job_download  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_download_with_http_info(tenant_id, study_id, job_id, access_signature, expiry, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param access_signature: (required)
        :type access_signature: str
        :param expiry: (required)
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param sim_type_channels:
        :type sim_type_channels: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'job_id',
            'access_signature',
            'expiry',
            'file_name',
            'channels_as_csv',
            'sim_type_channels'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job_download" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job_download`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job_download`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job_download`")  # noqa: E501
        # verify the required parameter 'access_signature' is set
        if self.api_client.client_side_validation and local_var_params.get('access_signature') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `access_signature` when calling `study_get_study_job_download`")  # noqa: E501
        # verify the required parameter 'expiry' is set
        if self.api_client.client_side_validation and local_var_params.get('expiry') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `expiry` when calling `study_get_study_job_download`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if local_var_params.get('access_signature') is not None:  # noqa: E501
            query_params.append(('accessSignature', local_var_params['access_signature']))  # noqa: E501
        if local_var_params.get('expiry') is not None:  # noqa: E501
            query_params.append(('expiry', local_var_params['expiry']))  # noqa: E501
        if local_var_params.get('file_name') is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if local_var_params.get('channels_as_csv') is not None:  # noqa: E501
            query_params.append(('channelsAsCsv', local_var_params['channels_as_csv']))  # noqa: E501
        if local_var_params.get('sim_type_channels') is not None:  # noqa: E501
            query_params.append(('simTypeChannels', local_var_params['sim_type_channels']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/jobs/{jobId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job_download_deprecated(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_download_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_download_deprecated(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param access_signature:
        :type access_signature: str
        :param expiry:
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param sim_type_channels:
        :type sim_type_channels: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_download_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, **kwargs)  # noqa: E501

    def study_get_study_job_download_deprecated_with_http_info(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_download_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_download_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param access_signature:
        :type access_signature: str
        :param expiry:
        :type expiry: str
        :param file_name:
        :type file_name: str
        :param channels_as_csv:
        :type channels_as_csv: bool
        :param sim_type_channels:
        :type sim_type_channels: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'job_id',
            'access_signature',
            'expiry',
            'file_name',
            'channels_as_csv',
            'sim_type_channels'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job_download_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job_download_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_job_download_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job_download_deprecated`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job_download_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if local_var_params.get('access_signature') is not None:  # noqa: E501
            query_params.append(('accessSignature', local_var_params['access_signature']))  # noqa: E501
        if local_var_params.get('expiry') is not None:  # noqa: E501
            query_params.append(('expiry', local_var_params['expiry']))  # noqa: E501
        if local_var_params.get('file_name') is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if local_var_params.get('channels_as_csv') is not None:  # noqa: E501
            query_params.append(('channelsAsCsv', local_var_params['channels_as_csv']))  # noqa: E501
        if local_var_params.get('sim_type_channels') is not None:  # noqa: E501
            query_params.append(('simTypeChannels', local_var_params['sim_type_channels']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/jobs/{jobId}/download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job_metadata(self, tenant_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_metadata(tenant_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobMetadataQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_metadata_with_http_info(tenant_id, study_id, job_id, **kwargs)  # noqa: E501

    def study_get_study_job_metadata_with_http_info(self, tenant_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_metadata_with_http_info(tenant_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobMetadataQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job_metadata`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job_metadata`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobMetadataQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/jobs/{jobId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_job_metadata_deprecated(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_metadata_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_metadata_deprecated(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobMetadataQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_job_metadata_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, **kwargs)  # noqa: E501

    def study_get_study_job_metadata_deprecated_with_http_info(self, tenant_id, user_id, study_id, job_id, **kwargs):  # noqa: E501
        """study_get_study_job_metadata_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_job_metadata_deprecated_with_http_info(tenant_id, user_id, study_id, job_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param job_id: (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobMetadataQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_job_metadata_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_job_metadata_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_job_metadata_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_job_metadata_deprecated`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and local_var_params.get('job_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `study_get_study_job_metadata_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobMetadataQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/jobs/{jobId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_jobs(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_jobs(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param filter:
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_jobs_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_jobs_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_jobs_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param filter:
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_jobs`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_jobs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('filter') is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobsQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_jobs_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_jobs_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_jobs_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param filter:
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyJobsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_jobs_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_jobs_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_jobs_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_jobs_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param filter:
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyJobsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_jobs_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_jobs_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_jobs_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_jobs_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('filter') is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyJobsQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_metadata(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_metadata_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_metadata_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_metadata`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_metadata_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_metadata_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_metadata_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_metadata_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_metadata_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_get_study_metadata_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_metadata_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_metadata_without_user_id_deprecated(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata_without_user_id_deprecated(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_metadata_without_user_id_deprecated_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_metadata_without_user_id_deprecated_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_metadata_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_metadata_without_user_id_deprecated_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_metadata_without_user_id_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_metadata_without_user_id_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_metadata_without_user_id_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/auto/{studyId}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_type(self, study_type, **kwargs):  # noqa: E501
        """study_get_study_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_type(study_type, async_req=True)
        >>> result = thread.get()

        :param study_type: (required)
        :type study_type: str
        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StudyTypeDefinition
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_type_with_http_info(study_type, **kwargs)  # noqa: E501

    def study_get_study_type_with_http_info(self, study_type, **kwargs):  # noqa: E501
        """study_get_study_type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_type_with_http_info(study_type, async_req=True)
        >>> result = thread.get()

        :param study_type: (required)
        :type study_type: str
        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StudyTypeDefinition, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'study_type',
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_type" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'study_type' is set
        if self.api_client.client_side_validation and local_var_params.get('study_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_type` when calling `study_get_study_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'study_type' in local_var_params:
            path_params['studyType'] = local_var_params['study_type']  # noqa: E501

        query_params = []
        if local_var_params.get('tenant_id') is not None:  # noqa: E501
            query_params.append(('tenantId', local_var_params['tenant_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "StudyTypeDefinition",
        }

        return self.api_client.call_api(
            '/studies/types/{studyType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_types(self, **kwargs):  # noqa: E501
        """study_get_study_types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_types(async_req=True)
        >>> result = thread.get()

        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyTypesQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_types_with_http_info(**kwargs)  # noqa: E501

    def study_get_study_types_with_http_info(self, **kwargs):  # noqa: E501
        """study_get_study_types  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param tenant_id:
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyTypesQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_types" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('tenant_id') is not None:  # noqa: E501
            query_params.append(('tenantId', local_var_params['tenant_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyTypesQueryResult",
        }

        return self.api_client.call_api(
            '/studies/types', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_study_without_user_id_deprecated(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_without_user_id_deprecated(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetStudyQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_study_without_user_id_deprecated_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_get_study_without_user_id_deprecated_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_get_study_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_study_without_user_id_deprecated_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetStudyQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_study_without_user_id_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_study_without_user_id_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_get_study_without_user_id_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetStudyQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/auto/{studyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_tenant_access_information(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_access_information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_access_information(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetTenantAccessInformationQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_tenant_access_information_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def study_get_tenant_access_information_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_access_information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_access_information_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetTenantAccessInformationQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_tenant_access_information" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_tenant_access_information`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetTenantAccessInformationQueryResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_tenant_billable_stored_simulation_count(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_billable_stored_simulation_count  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_billable_stored_simulation_count(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetTenantBillableStoredSimulationCountQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_tenant_billable_stored_simulation_count_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def study_get_tenant_billable_stored_simulation_count_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_billable_stored_simulation_count  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_billable_stored_simulation_count_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetTenantBillableStoredSimulationCountQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_tenant_billable_stored_simulation_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_tenant_billable_stored_simulation_count`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetTenantBillableStoredSimulationCountQueryResult",
        }

        return self.api_client.call_api(
            '/studies/statistics/stored/{tenantId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_get_tenant_study_statistics(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_study_statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_study_statistics(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param start_date:
        :type start_date: str
        :param end_date:
        :type end_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetTenantStudyStatisticsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_get_tenant_study_statistics_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def study_get_tenant_study_statistics_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """study_get_tenant_study_statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_get_tenant_study_statistics_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param start_date:
        :type start_date: str
        :param end_date:
        :type end_date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetTenantStudyStatisticsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'start_date',
            'end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_get_tenant_study_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_get_tenant_study_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('start_date') is not None:  # noqa: E501
            query_params.append(('startDate', local_var_params['start_date']))  # noqa: E501
        if local_var_params.get('end_date') is not None:  # noqa: E501
            query_params.append(('endDate', local_var_params['end_date']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetTenantStudyStatisticsQueryResult",
        }

        return self.api_client.call_api(
            '/studies/statistics/{tenantId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_merge_study(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_merge_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_merge_study(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param force_merge_from_baseline:
        :type force_merge_from_baseline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_merge_study_with_http_info(tenant_id, study_id, **kwargs)  # noqa: E501

    def study_merge_study_with_http_info(self, tenant_id, study_id, **kwargs):  # noqa: E501
        """study_merge_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_merge_study_with_http_info(tenant_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param force_merge_from_baseline:
        :type force_merge_from_baseline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'force_merge_from_baseline'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_merge_study" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_merge_study`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_merge_study`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('force_merge_from_baseline') is not None:  # noqa: E501
            query_params.append(('forceMergeFromBaseline', local_var_params['force_merge_from_baseline']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/merge', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_merge_study_deprecated(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_merge_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_merge_study_deprecated(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param force_merge_from_baseline:
        :type force_merge_from_baseline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_merge_study_deprecated_with_http_info(tenant_id, user_id, study_id, **kwargs)  # noqa: E501

    def study_merge_study_deprecated_with_http_info(self, tenant_id, user_id, study_id, **kwargs):  # noqa: E501
        """study_merge_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_merge_study_deprecated_with_http_info(tenant_id, user_id, study_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param force_merge_from_baseline:
        :type force_merge_from_baseline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'force_merge_from_baseline'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_merge_study_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_merge_study_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_merge_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_merge_study_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []
        if local_var_params.get('force_merge_from_baseline') is not None:  # noqa: E501
            query_params.append(('forceMergeFromBaseline', local_var_params['force_merge_from_baseline']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}/merge', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_post_study(self, tenant_id, study_post_study_request, **kwargs):  # noqa: E501
        """study_post_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_post_study(tenant_id, study_post_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_post_study_request: (required)
        :type study_post_study_request: StudyPostStudyRequest
        :param run_inline:
        :type run_inline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostStudyResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_post_study_with_http_info(tenant_id, study_post_study_request, **kwargs)  # noqa: E501

    def study_post_study_with_http_info(self, tenant_id, study_post_study_request, **kwargs):  # noqa: E501
        """study_post_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_post_study_with_http_info(tenant_id, study_post_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_post_study_request: (required)
        :type study_post_study_request: StudyPostStudyRequest
        :param run_inline:
        :type run_inline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostStudyResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_post_study_request',
            'run_inline'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_post_study" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_post_study`")  # noqa: E501
        # verify the required parameter 'study_post_study_request' is set
        if self.api_client.client_side_validation and local_var_params.get('study_post_study_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_post_study_request` when calling `study_post_study`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('run_inline') is not None:  # noqa: E501
            query_params.append(('runInline', local_var_params['run_inline']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'study_post_study_request' in local_var_params:
            body_params = local_var_params['study_post_study_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "PostStudyResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_post_study_deprecated(self, tenant_id, user_id, study_post_study_request, **kwargs):  # noqa: E501
        """study_post_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_post_study_deprecated(tenant_id, user_id, study_post_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_post_study_request: (required)
        :type study_post_study_request: StudyPostStudyRequest
        :param run_inline:
        :type run_inline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostStudyResult
        """
        kwargs['_return_http_data_only'] = True
        return self.study_post_study_deprecated_with_http_info(tenant_id, user_id, study_post_study_request, **kwargs)  # noqa: E501

    def study_post_study_deprecated_with_http_info(self, tenant_id, user_id, study_post_study_request, **kwargs):  # noqa: E501
        """study_post_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_post_study_deprecated_with_http_info(tenant_id, user_id, study_post_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_post_study_request: (required)
        :type study_post_study_request: StudyPostStudyRequest
        :param run_inline:
        :type run_inline: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostStudyResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_post_study_request',
            'run_inline'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_post_study_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_post_study_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_post_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_post_study_request' is set
        if self.api_client.client_side_validation and local_var_params.get('study_post_study_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_post_study_request` when calling `study_post_study_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501

        query_params = []
        if local_var_params.get('run_inline') is not None:  # noqa: E501
            query_params.append(('runInline', local_var_params['run_inline']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'study_post_study_request' in local_var_params:
            body_params = local_var_params['study_post_study_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "PostStudyResult",
        }

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_put_study(self, tenant_id, study_id, study_put_study_request, **kwargs):  # noqa: E501
        """study_put_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study(tenant_id, study_id, study_put_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param study_put_study_request: (required)
        :type study_put_study_request: StudyPutStudyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_put_study_with_http_info(tenant_id, study_id, study_put_study_request, **kwargs)  # noqa: E501

    def study_put_study_with_http_info(self, tenant_id, study_id, study_put_study_request, **kwargs):  # noqa: E501
        """study_put_study  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study_with_http_info(tenant_id, study_id, study_put_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param study_put_study_request: (required)
        :type study_put_study_request: StudyPutStudyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'study_put_study_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_put_study" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_put_study`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_put_study`")  # noqa: E501
        # verify the required parameter 'study_put_study_request' is set
        if self.api_client.client_side_validation and local_var_params.get('study_put_study_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_put_study_request` when calling `study_put_study`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'study_put_study_request' in local_var_params:
            body_params = local_var_params['study_put_study_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_put_study_deprecated(self, tenant_id, user_id, study_id, study_put_study_request, **kwargs):  # noqa: E501
        """study_put_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study_deprecated(tenant_id, user_id, study_id, study_put_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param study_put_study_request: (required)
        :type study_put_study_request: StudyPutStudyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_put_study_deprecated_with_http_info(tenant_id, user_id, study_id, study_put_study_request, **kwargs)  # noqa: E501

    def study_put_study_deprecated_with_http_info(self, tenant_id, user_id, study_id, study_put_study_request, **kwargs):  # noqa: E501
        """study_put_study_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study_deprecated_with_http_info(tenant_id, user_id, study_id, study_put_study_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param study_id: (required)
        :type study_id: str
        :param study_put_study_request: (required)
        :type study_put_study_request: StudyPutStudyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'study_id',
            'study_put_study_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_put_study_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_put_study_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `study_put_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_put_study_deprecated`")  # noqa: E501
        # verify the required parameter 'study_put_study_request' is set
        if self.api_client.client_side_validation and local_var_params.get('study_put_study_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_put_study_request` when calling `study_put_study_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'study_put_study_request' in local_var_params:
            body_params = local_var_params['study_put_study_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{userId}/{studyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def study_put_study_owner(self, tenant_id, study_id, config_put_config_owner_request, **kwargs):  # noqa: E501
        """study_put_study_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study_owner(tenant_id, study_id, config_put_config_owner_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param config_put_config_owner_request: (required)
        :type config_put_config_owner_request: ConfigPutConfigOwnerRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.study_put_study_owner_with_http_info(tenant_id, study_id, config_put_config_owner_request, **kwargs)  # noqa: E501

    def study_put_study_owner_with_http_info(self, tenant_id, study_id, config_put_config_owner_request, **kwargs):  # noqa: E501
        """study_put_study_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.study_put_study_owner_with_http_info(tenant_id, study_id, config_put_config_owner_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param study_id: (required)
        :type study_id: str
        :param config_put_config_owner_request: (required)
        :type config_put_config_owner_request: ConfigPutConfigOwnerRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'study_id',
            'config_put_config_owner_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method study_put_study_owner" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `study_put_study_owner`")  # noqa: E501
        # verify the required parameter 'study_id' is set
        if self.api_client.client_side_validation and local_var_params.get('study_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `study_id` when calling `study_put_study_owner`")  # noqa: E501
        # verify the required parameter 'config_put_config_owner_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_put_config_owner_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_put_config_owner_request` when calling `study_put_study_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'study_id' in local_var_params:
            path_params['studyId'] = local_var_params['study_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_put_config_owner_request' in local_var_params:
            body_params = local_var_params['config_put_config_owner_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/studies/{tenantId}/{studyId}/owner', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
