# coding: utf-8

"""
    Canopy.Api

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from canopy.openapi.api_client import ApiClient
from canopy.openapi.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ConfigApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def config_decrypt(self, body, **kwargs):  # noqa: E501
        """config_decrypt  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_decrypt(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.config_decrypt_with_http_info(body, **kwargs)  # noqa: E501

    def config_decrypt_with_http_info(self, body, **kwargs):  # noqa: E501
        """config_decrypt  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_decrypt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: object
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_decrypt" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/configs/decrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_decrypt_with_metadata(self, config_decrypt_with_metadata_request, **kwargs):  # noqa: E501
        """config_decrypt_with_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_decrypt_with_metadata(config_decrypt_with_metadata_request, async_req=True)
        >>> result = thread.get()

        :param config_decrypt_with_metadata_request: (required)
        :type config_decrypt_with_metadata_request: ConfigDecryptWithMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDecryptedDataQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_decrypt_with_metadata_with_http_info(config_decrypt_with_metadata_request, **kwargs)  # noqa: E501

    def config_decrypt_with_metadata_with_http_info(self, config_decrypt_with_metadata_request, **kwargs):  # noqa: E501
        """config_decrypt_with_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_decrypt_with_metadata_with_http_info(config_decrypt_with_metadata_request, async_req=True)
        >>> result = thread.get()

        :param config_decrypt_with_metadata_request: (required)
        :type config_decrypt_with_metadata_request: ConfigDecryptWithMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDecryptedDataQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'config_decrypt_with_metadata_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_decrypt_with_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_decrypt_with_metadata_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_decrypt_with_metadata_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_decrypt_with_metadata_request` when calling `config_decrypt_with_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_decrypt_with_metadata_request' in local_var_params:
            body_params = local_var_params['config_decrypt_with_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetDecryptedDataQueryResult",
        }

        return self.api_client.call_api(
            '/configs/decryptWithMetadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_delete_config(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_delete_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_delete_config(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.config_delete_config_with_http_info(tenant_id, config_id, **kwargs)  # noqa: E501

    def config_delete_config_with_http_info(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_delete_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_delete_config_with_http_info(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'sub_tree_path',
            'undelete'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_delete_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_delete_config`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_delete_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('undelete') is not None:  # noqa: E501
            query_params.append(('undelete', local_var_params['undelete']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/configs/{tenantId}/{configId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_delete_config_deprecated(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_delete_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_delete_config_deprecated(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.config_delete_config_deprecated_with_http_info(tenant_id, user_id, config_id, **kwargs)  # noqa: E501

    def config_delete_config_deprecated_with_http_info(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_delete_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_delete_config_deprecated_with_http_info(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param undelete:
        :type undelete: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_id',
            'sub_tree_path',
            'undelete'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_delete_config_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_delete_config_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_delete_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_delete_config_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('undelete') is not None:  # noqa: E501
            query_params.append(('undelete', local_var_params['undelete']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}/{configId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_encrypt(self, body, **kwargs):  # noqa: E501
        """config_encrypt  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_encrypt(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: object
        :param description:
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.config_encrypt_with_http_info(body, **kwargs)  # noqa: E501

    def config_encrypt_with_http_info(self, body, **kwargs):  # noqa: E501
        """config_encrypt  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_encrypt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body: (required)
        :type body: object
        :param description:
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'body',
            'description'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_encrypt" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('description') is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "object",
        }

        return self.api_client.call_api(
            '/configs/encrypt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_encrypt_with_metadata(self, config_encrypt_with_metadata_request, **kwargs):  # noqa: E501
        """config_encrypt_with_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_encrypt_with_metadata(config_encrypt_with_metadata_request, async_req=True)
        >>> result = thread.get()

        :param config_encrypt_with_metadata_request: (required)
        :type config_encrypt_with_metadata_request: ConfigEncryptWithMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetEncryptedDataQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_encrypt_with_metadata_with_http_info(config_encrypt_with_metadata_request, **kwargs)  # noqa: E501

    def config_encrypt_with_metadata_with_http_info(self, config_encrypt_with_metadata_request, **kwargs):  # noqa: E501
        """config_encrypt_with_metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_encrypt_with_metadata_with_http_info(config_encrypt_with_metadata_request, async_req=True)
        >>> result = thread.get()

        :param config_encrypt_with_metadata_request: (required)
        :type config_encrypt_with_metadata_request: ConfigEncryptWithMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetEncryptedDataQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'config_encrypt_with_metadata_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_encrypt_with_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_encrypt_with_metadata_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_encrypt_with_metadata_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_encrypt_with_metadata_request` when calling `config_encrypt_with_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_encrypt_with_metadata_request' in local_var_params:
            body_params = local_var_params['config_encrypt_with_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetEncryptedDataQueryResult",
        }

        return self.api_client.call_api(
            '/configs/encryptWithMetadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_with_http_info(tenant_id, config_id, **kwargs)  # noqa: E501

    def config_get_config_with_http_info(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_with_http_info(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'sub_tree_path',
            'sim_version',
            'config_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_get_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501
        if local_var_params.get('config_version') is not None:  # noqa: E501
            query_params.append(('configVersion', local_var_params['config_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{configId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config_deprecated(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_deprecated(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_deprecated_with_http_info(tenant_id, user_id, config_id, **kwargs)  # noqa: E501

    def config_get_config_deprecated_with_http_info(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_deprecated_with_http_info(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_id',
            'sub_tree_path',
            'sim_version',
            'config_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_get_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_get_config_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501
        if local_var_params.get('config_version') is not None:  # noqa: E501
            query_params.append(('configVersion', local_var_params['config_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}/{configId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config_names(self, tenant_id, config_type, **kwargs):  # noqa: E501
        """config_get_config_names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_names(tenant_id, config_type, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_type: (required)
        :type config_type: str
        :param result_type:
        :type result_type: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigNamesQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_names_with_http_info(tenant_id, config_type, **kwargs)  # noqa: E501

    def config_get_config_names_with_http_info(self, tenant_id, config_type, **kwargs):  # noqa: E501
        """config_get_config_names  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_names_with_http_info(tenant_id, config_type, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_type: (required)
        :type config_type: str
        :param result_type:
        :type result_type: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigNamesQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_type',
            'result_type',
            'sub_tree_path',
            'sim_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config_names" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config_names`")  # noqa: E501
        # verify the required parameter 'config_type' is set
        if self.api_client.client_side_validation and local_var_params.get('config_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_type` when calling `config_get_config_names`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('config_type') is not None:  # noqa: E501
            query_params.append(('configType', local_var_params['config_type']))  # noqa: E501
        if local_var_params.get('result_type') is not None:  # noqa: E501
            query_params.append(('resultType', local_var_params['result_type']))  # noqa: E501
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigNamesQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/names', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config_versions(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_versions(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigVersionsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_versions_with_http_info(tenant_id, config_id, **kwargs)  # noqa: E501

    def config_get_config_versions_with_http_info(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_versions_with_http_info(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigVersionsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config_versions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config_versions`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_get_config_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigVersionsQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{configId}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config_versions_deprecated(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_versions_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_versions_deprecated(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigVersionsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_versions_deprecated_with_http_info(tenant_id, user_id, config_id, **kwargs)  # noqa: E501

    def config_get_config_versions_deprecated_with_http_info(self, tenant_id, user_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_versions_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_versions_deprecated_with_http_info(tenant_id, user_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigVersionsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_id',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config_versions_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config_versions_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_get_config_versions_deprecated`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_get_config_versions_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigVersionsQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}/{configId}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_config_without_user_id_deprecated(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_without_user_id_deprecated(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_config_without_user_id_deprecated_with_http_info(tenant_id, config_id, **kwargs)  # noqa: E501

    def config_get_config_without_user_id_deprecated_with_http_info(self, tenant_id, config_id, **kwargs):  # noqa: E501
        """config_get_config_without_user_id_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_config_without_user_id_deprecated_with_http_info(tenant_id, config_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param sim_version:
        :type sim_version: str
        :param config_version:
        :type config_version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'sub_tree_path',
            'sim_version',
            'config_version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_config_without_user_id_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_config_without_user_id_deprecated`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_get_config_without_user_id_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('sim_version') is not None:  # noqa: E501
            query_params.append(('simVersion', local_var_params['sim_version']))  # noqa: E501
        if local_var_params.get('config_version') is not None:  # noqa: E501
            query_params.append(('configVersion', local_var_params['config_version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/auto/{configId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_get_configs(self, tenant_id, config_type, **kwargs):  # noqa: E501
        """config_get_configs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_configs(tenant_id, config_type, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_type: (required)
        :type config_type: str
        :param filter:
        :type filter: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param result_type:
        :type result_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConfigsQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_get_configs_with_http_info(tenant_id, config_type, **kwargs)  # noqa: E501

    def config_get_configs_with_http_info(self, tenant_id, config_type, **kwargs):  # noqa: E501
        """config_get_configs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_get_configs_with_http_info(tenant_id, config_type, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_type: (required)
        :type config_type: str
        :param filter:
        :type filter: str
        :param sub_tree_path:
        :type sub_tree_path: str
        :param result_type:
        :type result_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetConfigsQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_type',
            'filter',
            'sub_tree_path',
            'result_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_get_configs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_get_configs`")  # noqa: E501
        # verify the required parameter 'config_type' is set
        if self.api_client.client_side_validation and local_var_params.get('config_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_type` when calling `config_get_configs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('config_type') is not None:  # noqa: E501
            query_params.append(('configType', local_var_params['config_type']))  # noqa: E501
        if local_var_params.get('filter') is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501
        if local_var_params.get('result_type') is not None:  # noqa: E501
            query_params.append(('resultType', local_var_params['result_type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "GetConfigsQueryResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_post_config(self, tenant_id, config_post_config_request, **kwargs):  # noqa: E501
        """config_post_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_config(tenant_id, config_post_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_post_config_request: (required)
        :type config_post_config_request: ConfigPostConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.config_post_config_with_http_info(tenant_id, config_post_config_request, **kwargs)  # noqa: E501

    def config_post_config_with_http_info(self, tenant_id, config_post_config_request, **kwargs):  # noqa: E501
        """config_post_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_config_with_http_info(tenant_id, config_post_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_post_config_request: (required)
        :type config_post_config_request: ConfigPostConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_post_config_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_post_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_post_config`")  # noqa: E501
        # verify the required parameter 'config_post_config_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_post_config_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_post_config_request` when calling `config_post_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_post_config_request' in local_var_params:
            body_params = local_var_params['config_post_config_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_post_config_deprecated(self, tenant_id, user_id, config_post_config_request, **kwargs):  # noqa: E501
        """config_post_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_config_deprecated(tenant_id, user_id, config_post_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_post_config_request: (required)
        :type config_post_config_request: ConfigPostConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.config_post_config_deprecated_with_http_info(tenant_id, user_id, config_post_config_request, **kwargs)  # noqa: E501

    def config_post_config_deprecated_with_http_info(self, tenant_id, user_id, config_post_config_request, **kwargs):  # noqa: E501
        """config_post_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_config_deprecated_with_http_info(tenant_id, user_id, config_post_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_post_config_request: (required)
        :type config_post_config_request: ConfigPostConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_post_config_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_post_config_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_post_config_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_post_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_post_config_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_post_config_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_post_config_request` when calling `config_post_config_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_post_config_request' in local_var_params:
            body_params = local_var_params['config_post_config_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_post_configs(self, tenant_id, config_post_configs_request, **kwargs):  # noqa: E501
        """config_post_configs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_configs(tenant_id, config_post_configs_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_post_configs_request: (required)
        :type config_post_configs_request: ConfigPostConfigsRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchCreateConfigsResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_post_configs_with_http_info(tenant_id, config_post_configs_request, **kwargs)  # noqa: E501

    def config_post_configs_with_http_info(self, tenant_id, config_post_configs_request, **kwargs):  # noqa: E501
        """config_post_configs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_configs_with_http_info(tenant_id, config_post_configs_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_post_configs_request: (required)
        :type config_post_configs_request: ConfigPostConfigsRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchCreateConfigsResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_post_configs_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_post_configs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_post_configs`")  # noqa: E501
        # verify the required parameter 'config_post_configs_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_post_configs_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_post_configs_request` when calling `config_post_configs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_post_configs_request' in local_var_params:
            body_params = local_var_params['config_post_configs_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "BatchCreateConfigsResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_post_configs_deprecated(self, tenant_id, user_id, config_post_configs_request, **kwargs):  # noqa: E501
        """config_post_configs_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_configs_deprecated(tenant_id, user_id, config_post_configs_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_post_configs_request: (required)
        :type config_post_configs_request: ConfigPostConfigsRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BatchCreateConfigsResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_post_configs_deprecated_with_http_info(tenant_id, user_id, config_post_configs_request, **kwargs)  # noqa: E501

    def config_post_configs_deprecated_with_http_info(self, tenant_id, user_id, config_post_configs_request, **kwargs):  # noqa: E501
        """config_post_configs_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_post_configs_deprecated_with_http_info(tenant_id, user_id, config_post_configs_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_post_configs_request: (required)
        :type config_post_configs_request: ConfigPostConfigsRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BatchCreateConfigsResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_post_configs_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_post_configs_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_post_configs_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_post_configs_deprecated`")  # noqa: E501
        # verify the required parameter 'config_post_configs_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_post_configs_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_post_configs_request` when calling `config_post_configs_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_post_configs_request' in local_var_params:
            body_params = local_var_params['config_post_configs_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "BatchCreateConfigsResult",
        }

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_put_config(self, tenant_id, config_id, config_put_config_request, **kwargs):  # noqa: E501
        """config_put_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config(tenant_id, config_id, config_put_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_request: (required)
        :type config_put_config_request: ConfigPutConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.config_put_config_with_http_info(tenant_id, config_id, config_put_config_request, **kwargs)  # noqa: E501

    def config_put_config_with_http_info(self, tenant_id, config_id, config_put_config_request, **kwargs):  # noqa: E501
        """config_put_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config_with_http_info(tenant_id, config_id, config_put_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_request: (required)
        :type config_put_config_request: ConfigPutConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'config_put_config_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_put_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_put_config`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_put_config`")  # noqa: E501
        # verify the required parameter 'config_put_config_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_put_config_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_put_config_request` when calling `config_put_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_put_config_request' in local_var_params:
            body_params = local_var_params['config_put_config_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/configs/{tenantId}/{configId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_put_config_deprecated(self, tenant_id, user_id, config_id, config_put_config_request, **kwargs):  # noqa: E501
        """config_put_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config_deprecated(tenant_id, user_id, config_id, config_put_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_request: (required)
        :type config_put_config_request: ConfigPutConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.config_put_config_deprecated_with_http_info(tenant_id, user_id, config_id, config_put_config_request, **kwargs)  # noqa: E501

    def config_put_config_deprecated_with_http_info(self, tenant_id, user_id, config_id, config_put_config_request, **kwargs):  # noqa: E501
        """config_put_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config_deprecated_with_http_info(tenant_id, user_id, config_id, config_put_config_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param user_id: (required)
        :type user_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_request: (required)
        :type config_put_config_request: ConfigPutConfigRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'user_id',
            'config_id',
            'config_put_config_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_put_config_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_put_config_deprecated`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and local_var_params.get('user_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `config_put_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_put_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_put_config_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_put_config_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_put_config_request` when calling `config_put_config_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'user_id' in local_var_params:
            path_params['userId'] = local_var_params['user_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_put_config_request' in local_var_params:
            body_params = local_var_params['config_put_config_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/configs/{tenantId}/{userId}/{configId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_put_config_owner(self, tenant_id, config_id, config_put_config_owner_request, **kwargs):  # noqa: E501
        """config_put_config_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config_owner(tenant_id, config_id, config_put_config_owner_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_owner_request: (required)
        :type config_put_config_owner_request: ConfigPutConfigOwnerRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.config_put_config_owner_with_http_info(tenant_id, config_id, config_put_config_owner_request, **kwargs)  # noqa: E501

    def config_put_config_owner_with_http_info(self, tenant_id, config_id, config_put_config_owner_request, **kwargs):  # noqa: E501
        """config_put_config_owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_put_config_owner_with_http_info(tenant_id, config_id, config_put_config_owner_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param config_id: (required)
        :type config_id: str
        :param config_put_config_owner_request: (required)
        :type config_put_config_owner_request: ConfigPutConfigOwnerRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'config_id',
            'config_put_config_owner_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_put_config_owner" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_put_config_owner`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and local_var_params.get('config_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `config_put_config_owner`")  # noqa: E501
        # verify the required parameter 'config_put_config_owner_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_put_config_owner_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_put_config_owner_request` when calling `config_put_config_owner`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_put_config_owner_request' in local_var_params:
            body_params = local_var_params['config_put_config_owner_request']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/configs/{tenantId}/{configId}/owner', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_upgrade_config(self, tenant_id, target_sim_version, config_upgrade_config_deprecated_request, **kwargs):  # noqa: E501
        """config_upgrade_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_upgrade_config(tenant_id, target_sim_version, config_upgrade_config_deprecated_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param target_sim_version: (required)
        :type target_sim_version: str
        :param config_upgrade_config_deprecated_request: (required)
        :type config_upgrade_config_deprecated_request: ConfigUpgradeConfigDeprecatedRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeConfigQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_upgrade_config_with_http_info(tenant_id, target_sim_version, config_upgrade_config_deprecated_request, **kwargs)  # noqa: E501

    def config_upgrade_config_with_http_info(self, tenant_id, target_sim_version, config_upgrade_config_deprecated_request, **kwargs):  # noqa: E501
        """config_upgrade_config  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_upgrade_config_with_http_info(tenant_id, target_sim_version, config_upgrade_config_deprecated_request, async_req=True)
        >>> result = thread.get()

        :param tenant_id: (required)
        :type tenant_id: str
        :param target_sim_version: (required)
        :type target_sim_version: str
        :param config_upgrade_config_deprecated_request: (required)
        :type config_upgrade_config_deprecated_request: ConfigUpgradeConfigDeprecatedRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeConfigQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'target_sim_version',
            'config_upgrade_config_deprecated_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_upgrade_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and local_var_params.get('tenant_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `config_upgrade_config`")  # noqa: E501
        # verify the required parameter 'target_sim_version' is set
        if self.api_client.client_side_validation and local_var_params.get('target_sim_version') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `target_sim_version` when calling `config_upgrade_config`")  # noqa: E501
        # verify the required parameter 'config_upgrade_config_deprecated_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_upgrade_config_deprecated_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_upgrade_config_deprecated_request` when calling `config_upgrade_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'target_sim_version' in local_var_params:
            path_params['targetSimVersion'] = local_var_params['target_sim_version']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_upgrade_config_deprecated_request' in local_var_params:
            body_params = local_var_params['config_upgrade_config_deprecated_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeConfigQueryResult",
        }

        return self.api_client.call_api(
            '/configs/upgrade/{tenantId}/{targetSimVersion}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def config_upgrade_config_deprecated(self, target_sim_version, config_upgrade_config_deprecated_request, **kwargs):  # noqa: E501
        """config_upgrade_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_upgrade_config_deprecated(target_sim_version, config_upgrade_config_deprecated_request, async_req=True)
        >>> result = thread.get()

        :param target_sim_version: (required)
        :type target_sim_version: str
        :param config_upgrade_config_deprecated_request: (required)
        :type config_upgrade_config_deprecated_request: ConfigUpgradeConfigDeprecatedRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeConfigQueryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.config_upgrade_config_deprecated_with_http_info(target_sim_version, config_upgrade_config_deprecated_request, **kwargs)  # noqa: E501

    def config_upgrade_config_deprecated_with_http_info(self, target_sim_version, config_upgrade_config_deprecated_request, **kwargs):  # noqa: E501
        """config_upgrade_config_deprecated  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.config_upgrade_config_deprecated_with_http_info(target_sim_version, config_upgrade_config_deprecated_request, async_req=True)
        >>> result = thread.get()

        :param target_sim_version: (required)
        :type target_sim_version: str
        :param config_upgrade_config_deprecated_request: (required)
        :type config_upgrade_config_deprecated_request: ConfigUpgradeConfigDeprecatedRequest
        :param sub_tree_path:
        :type sub_tree_path: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeConfigQueryResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'target_sim_version',
            'config_upgrade_config_deprecated_request',
            'sub_tree_path'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_upgrade_config_deprecated" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'target_sim_version' is set
        if self.api_client.client_side_validation and local_var_params.get('target_sim_version') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `target_sim_version` when calling `config_upgrade_config_deprecated`")  # noqa: E501
        # verify the required parameter 'config_upgrade_config_deprecated_request' is set
        if self.api_client.client_side_validation and local_var_params.get('config_upgrade_config_deprecated_request') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_upgrade_config_deprecated_request` when calling `config_upgrade_config_deprecated`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'target_sim_version' in local_var_params:
            path_params['targetSimVersion'] = local_var_params['target_sim_version']  # noqa: E501

        query_params = []
        if local_var_params.get('sub_tree_path') is not None:  # noqa: E501
            query_params.append(('subTreePath', local_var_params['sub_tree_path']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_upgrade_config_deprecated_request' in local_var_params:
            body_params = local_var_params['config_upgrade_config_deprecated_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'],
                'POST', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeConfigQueryResult",
        }

        return self.api_client.call_api(
            '/configs/upgrade/{targetSimVersion}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
