# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/sqliteConnection.json
#   timestamp: 2022-04-13T14:46:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SQLiteType(Enum):
    SQLite = 'SQLite'


class SQLiteScheme(Enum):
    sqlite_pysqlite = 'sqlite+pysqlite'


class SQLiteConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SQLiteType] = Field(SQLiteType.SQLite, description='Service Type')
    scheme: Optional[SQLiteScheme] = Field(
        SQLiteScheme.sqlite_pysqlite, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the SQLite. Blank for in-memory database.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect to SQLite. Blank for in-memory database.'
    )
    hostPort: Optional[str] = Field(
        None,
        description='Host and port of the data source. Blank for in-memory database.',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
    )
    databaseMode: Optional[str] = Field(
        ':memory:', description='How to run the SQLite database. :memory: by default.'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
