# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/oracleConnection.json
#   timestamp: 2022-04-13T14:46:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class OracleType(Enum):
    Oracle = 'Oracle'


class OracleScheme(Enum):
    oracle_cx_oracle = 'oracle+cx_oracle'


class OracleConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OracleType] = Field(OracleType.Oracle, description='Service Type')
    scheme: Optional[OracleScheme] = Field(
        OracleScheme.oracle_cx_oracle, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Oracle. This user should have privileges to read all the metadata in Oracle.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Oracle.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the Oracle.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Oracle.',
    )
    oracleServiceName: Optional[str] = Field(
        None,
        description='Oracle Service Name to be passed. Note: either Database or Oracle service name can be sent, not both.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
