# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/clickhouseConnection.json
#   timestamp: 2022-04-13T14:46:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class ClickhouseType(Enum):
    ClickHouse = 'ClickHouse'


class ClickhouseScheme(Enum):
    clickhouse_http = 'clickhouse+http'


class ClickhouseConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ClickhouseType] = Field(
        ClickhouseType.ClickHouse, description='Service Type'
    )
    scheme: Optional[ClickhouseScheme] = Field(
        ClickhouseScheme.clickhouse_http,
        description='SQLAlchemy driver scheme options.',
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Clickhouse. This user should have privileges to read all the metadata in Clickhouse.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect to the Clickhouse.'
    )
    hostPort: Optional[str] = Field(None, description='Host and port of the Clickhouse')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Clickhouse.',
    )
    duration: Optional[int] = Field(
        None, description='Clickhouse SQL connection duration'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
