# coding: utf-8

"""
    DLRN API

    DLRN API client

    OpenAPI spec version: 1.0.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems


class Params(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, max_age=None, success=None, job_id=None,
                 sequential_mode=None, previous_job_id=None, component=None):
        """Params - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'max_age': 'int',
            'success': 'bool',
            'job_id': 'str',
            'sequential_mode': 'bool',
            'previous_job_id': 'str',
            'component': 'str'
        }

        self.attribute_map = {
            'max_age': 'max_age',
            'success': 'success',
            'job_id': 'job_id',
            'sequential_mode': 'sequential_mode',
            'previous_job_id': 'previous_job_id',
            'component': 'component'
        }

        self._max_age = max_age
        self._success = success
        self._job_id = job_id
        self._sequential_mode = sequential_mode
        self._previous_job_id = previous_job_id
        self._component = component

    @property
    def max_age(self):
        """Gets the max_age of this Params.

        Maximum age (in hours) for the repo to be considered.
        Any repo tested or being tested after \"now - max_age\" will be taken
        into account. If set to 0, all repos will be considered.

        :return: The max_age of this Params.
        :rtype: int
        """
        return self._max_age

    @max_age.setter
    def max_age(self, max_age):
        """Sets the max_age of this Params.

        Maximum age (in hours) for the repo to be considered.
        Any repo tested or being tested after \"now - max_age\" will be taken
        into account. If set to 0, all repos will be considered.

        :param max_age: The max_age of this Params.
        :type: int
        """
        if max_age is None:
            raise ValueError("Invalid value for `max_age`, must not be `None`")
        if max_age is not None and max_age < 0:
            raise ValueError("Invalid value for `max_age`, must be a value"
                             " greater than or equal to `0`")

        self._max_age = max_age

    @property
    def success(self):
        """Gets the success of this Params.

        If set to a value, find repos with a successful/unsuccessful vote
        (as specified). If not set, any tested repo will be considered.

        :return: The success of this Params.
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this Params.

        If set to a value, find repos with a successful/unsuccessful vote
        (as specified). If not set, any tested repo will be considered.

        :param success: The success of this Params.
        :type: bool
        """

        self._success = success

    @property
    def job_id(self):
        """Gets the job_id of this Params.

        Name of the CI that sent the vote. If not set, no filter will be set
        on CI.

        :return: The job_id of this Params.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this Params.

        Name of the CI that sent the vote. If not set, no filter will be set
        on CI.

        :param job_id: The job_id of this Params.
        :type: str
        """

        self._job_id = job_id

    @property
    def sequential_mode(self):
        """Gets the sequential_mode of this Params.

        Use the sequential mode algorithm. In this case, return the last tested
        repo within that timeframe for the CI job described by previous_job_id.
        Defaults to false.

        :return: The sequential_mode of this Params.
        :rtype: bool
        """
        return self._sequential_mode

    @sequential_mode.setter
    def sequential_mode(self, sequential_mode):
        """Sets the sequential_mode of this Params.

        Use the sequential mode algorithm. In this case, return the last tested
        repo within that timeframe for the CI job described by previous_job_id.
        Defaults to false.

        :param sequential_mode: The sequential_mode of this Params.
        :type: bool
        """

        self._sequential_mode = sequential_mode

    @property
    def previous_job_id(self):
        """Gets the previous_job_id of this Params.

        If sequential_mode is set to true, look for jobs tested by the CI
        identified by previous_job_id.

        :return: The previous_job_id of this Params.
        :rtype: str
        """
        return self._previous_job_id

    @previous_job_id.setter
    def previous_job_id(self, previous_job_id):
        """Sets the previous_job_id of this Params.

        If sequential_mode is set to true, look for jobs tested by the CI
        identified by previous_job_id.

        :param previous_job_id: The previous_job_id of this Params.
        :type: str
        """

        self._previous_job_id = previous_job_id

    @property
    def component(self):
        """Gets the component of this Params.

        additional notes

        :return: The component of this Params.
        :rtype: str
        """
        return self._component

    @component.setter
    def component(self, component):
        """Sets the component of this Params.

        additional notes

        :param component: The component of this Params.
        :type: str
        """

        self._component = component

    def to_dict(self):
        """Returns the model properties as a dict """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model """
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint` """
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal """
        if not isinstance(other, Params):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal """
        return not self == other
