/**
 * Configure the Docker Machine-based autoscaling feature.
 * @see {@link https://docs.gitlab.com/runner/configuration/advanced-configuration.html#the-runnersmachine-section}
 * @see {@link https://docs.gitlab.com/runner/configuration/autoscale.html#how-concurrent-limit-and-idlecount-generate-the-upper-limit-of-running-machines}
 */
import { MachineOptions } from "./machine-options";
/**
 * @stability stable
 */
export interface MachineConfiguration {
    /**
     * @default 0
     * @stability stable
     */
    readonly idleCount?: number;
    /**
     * @default 300
     * @stability stable
     */
    readonly idleTime?: number;
    /**
     * @default 20
     * @stability stable
     */
    readonly maxBuilds?: number;
    /**
     * @default "amazonec2"
     * @stability stable
     */
    readonly machineDriver?: MachineDriver;
    /**
     * @default "gitlab-runner"
     * @stability stable
     */
    readonly machineName?: string;
    /**
     * @stability stable
     */
    readonly machineOptions?: MachineOptions;
}
export declare type MachineDriver = "amazonec2" | string;
