"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplateRepositoryAssociation = void 0;
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplateRepositoryAssociation extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repository = props.repository;
        const resourceType = 'Custom::ApprovalRuleTemplateRepositoryAssociation';
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, resourceType, {
            codeDirectory: directories_1.approvalRuleTemplateRepositoryAssociationDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['codecommit:AssociateApprovalRuleTemplateWithRepository', 'codecommit:DisassociateApprovalRuleTemplateFromRepository'],
                    Resource: this.repository.repositoryArn,
                },
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType,
            properties: {
                ApprovalRuleTemplateName: props.approvalRuleTemplateName,
                RepositoryName: this.repository.repositoryName,
            },
        });
    }
    onOverridden(id, options) {
        const rule = this.repository.onPullRequestStateChange(id, options);
        rule.addEventPattern({
            detail: {
                event: ['pullRequestApprovalRuleOverridden'],
            },
        });
        return rule;
    }
}
exports.ApprovalRuleTemplateRepositoryAssociation = ApprovalRuleTemplateRepositoryAssociation;
//# sourceMappingURL=data:application/json;base64,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