# Generated by Django 4.1.5 on 2023-01-17 22:22

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('oasis', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='GeographicLocation',
            fields=[
                ('companyid', models.IntegerField(primary_key=True, serialize=False)),
                ('geographiclocationid', models.IntegerField()),
                ('geographiclocationname', models.CharField(blank=True, max_length=100, null=True)),
                ('parent', models.IntegerField(blank=True, null=True)),
                ('locationid', models.IntegerField(blank=True, null=True)),
                ('population', models.IntegerField(blank=True, null=True)),
                ('countryid', models.IntegerField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=1, null=True)),
                ('exempt', models.BooleanField(blank=True, null=True)),
                ('alternatecode', models.IntegerField(blank=True, null=True)),
                ('groupid', models.IntegerField(blank=True, null=True)),
                ('iatacode', models.CharField(blank=True, max_length=3, null=True)),
                ('clientid', models.BigIntegerField(blank=True, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('typeupc', models.CharField(blank=True, max_length=30, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('phonecode', models.CharField(blank=True, max_length=10, null=True)),
                ('latitude', models.CharField(blank=True, max_length=30, null=True)),
                ('longitude', models.CharField(blank=True, max_length=30, null=True)),
            ],
            options={
                'db_table': 'geographiclocation',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='TypeClient',
            fields=[
                ('companyid', models.IntegerField(primary_key=True, serialize=False)),
                ('typeclientid', models.CharField(max_length=1)),
                ('typeclientname', models.CharField(blank=True, max_length=100, null=True)),
                ('taxentity', models.IntegerField(blank=True, null=True)),
                ('typedocumentid', models.CharField(blank=True, max_length=2, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('typeclient', models.CharField(blank=True, max_length=1, null=True)),
                ('typeexternal', models.CharField(blank=True, max_length=10, null=True)),
                ('typeclient1', models.CharField(blank=True, max_length=1, null=True)),
            ],
            options={
                'db_table': 'typeclient',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='DocumentType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type_id', models.CharField(max_length=1, verbose_name='Document type oasis id')),
                ('description', models.CharField(max_length=50, verbose_name='Document type description')),
            ],
        ),
        migrations.CreateModel(
            name='Client',
            fields=[
                ('companyid', models.OneToOneField(db_column='companyid', on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, related_name='clients', serialize=False, to='oasis.geographiclocation')),
                ('clientid', models.BigIntegerField()),
                ('clientname', models.CharField(blank=True, max_length=100, null=True)),
                ('clienttype', models.CharField(blank=True, max_length=1, null=True)),
                ('clientcode', models.CharField(blank=True, max_length=20, null=True)),
                ('national', models.BooleanField(blank=True, null=True)),
                ('representative', models.CharField(blank=True, max_length=100, null=True)),
                ('address', models.CharField(blank=True, max_length=100, null=True)),
                ('phone', models.CharField(blank=True, max_length=30, null=True)),
                ('celphone', models.CharField(blank=True, max_length=30, null=True)),
                ('fax', models.CharField(blank=True, max_length=30, null=True)),
                ('zipcode', models.CharField(blank=True, max_length=20, null=True)),
                ('email', models.CharField(blank=True, max_length=200, null=True)),
                ('geographiclocationid', models.IntegerField(blank=True, db_column='geographiclocationid', null=True)),
                ('checkdigit', models.IntegerField(blank=True, null=True)),
                ('groupid', models.IntegerField(blank=True, null=True)),
                ('vendorid', models.BigIntegerField(blank=True, null=True)),
                ('locationid', models.IntegerField(blank=True, null=True)),
                ('discount', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('conditionpaymentid', models.IntegerField(blank=True, null=True)),
                ('pricetypeid', models.IntegerField(blank=True, null=True)),
                ('tax', models.BooleanField(blank=True, null=True)),
                ('client_class', models.CharField(blank=True, db_column='class', max_length=1, null=True)),
                ('segmentid', models.IntegerField(blank=True, null=True)),
                ('remissioninvoice', models.CharField(blank=True, max_length=1, null=True)),
                ('deliverybill', models.CharField(blank=True, max_length=1, null=True)),
                ('deliverybilldirectionid', models.IntegerField(blank=True, null=True)),
                ('deliverystatement', models.CharField(blank=True, max_length=1, null=True)),
                ('deliverystatementdirectionid', models.IntegerField(blank=True, null=True)),
                ('customer', models.BooleanField(blank=True, null=True)),
                ('taxtypeid', models.IntegerField(blank=True, null=True)),
                ('userid', models.IntegerField(blank=True, null=True)),
                ('alternatecode', models.CharField(blank=True, max_length=15, null=True)),
                ('matrixid', models.BigIntegerField(blank=True, null=True)),
                ('limit', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('lastpurchase', models.DateField(blank=True, null=True)),
                ('specialityid', models.IntegerField(blank=True, null=True)),
                ('programid', models.IntegerField(blank=True, null=True)),
                ('purchasepaymentconditionid', models.IntegerField(blank=True, null=True)),
                ('purchasediscount', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('taxprice', models.CharField(blank=True, max_length=1, null=True)),
                ('supplier', models.BooleanField(blank=True, null=True)),
                ('salescontact', models.CharField(blank=True, max_length=100, null=True)),
                ('paymentcontact', models.CharField(blank=True, max_length=100, null=True)),
                ('purchasecontact', models.CharField(blank=True, max_length=100, null=True)),
                ('entrydate', models.DateField(blank=True, null=True)),
                ('retirementdate', models.DateField(blank=True, null=True)),
                ('paymentformid', models.IntegerField(blank=True, null=True)),
                ('area', models.CharField(blank=True, max_length=1, null=True)),
                ('bankaccount', models.CharField(blank=True, max_length=20, null=True)),
                ('socialinsurance', models.CharField(blank=True, max_length=20, null=True)),
                ('medicalinsurance', models.CharField(blank=True, max_length=20, null=True)),
                ('turnid', models.IntegerField(blank=True, null=True)),
                ('employee', models.BooleanField(blank=True, null=True)),
                ('vendor', models.BooleanField(blank=True, null=True)),
                ('shareholder', models.BooleanField(blank=True, null=True)),
                ('partner', models.BooleanField(blank=True, null=True)),
                ('state', models.CharField(blank=True, max_length=1, null=True)),
                ('industrialactivity', models.IntegerField(blank=True, null=True)),
                ('industrialtax', models.BooleanField(blank=True, null=True)),
                ('retention', models.BooleanField(blank=True, null=True)),
                ('deductibleretention', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('birthdate', models.DateField(blank=True, null=True)),
                ('birthlocationid', models.IntegerField(blank=True, null=True)),
                ('civilstatus', models.CharField(blank=True, max_length=1, null=True)),
                ('education', models.CharField(blank=True, max_length=1, null=True)),
                ('professionid', models.IntegerField(blank=True, null=True)),
                ('currentcompany', models.CharField(blank=True, max_length=40, null=True)),
                ('currentcompanycode', models.CharField(blank=True, max_length=20, null=True)),
                ('ingress', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('entrycompanydate', models.DateField(blank=True, null=True)),
                ('house', models.CharField(blank=True, max_length=1, null=True)),
                ('housevalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('car', models.CharField(blank=True, max_length=1, null=True)),
                ('carvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('spouse', models.CharField(blank=True, max_length=100, null=True)),
                ('spousecode', models.CharField(blank=True, max_length=20, null=True)),
                ('child', models.IntegerField(blank=True, null=True)),
                ('distributortax', models.CharField(blank=True, max_length=1, null=True)),
                ('firstlastname', models.CharField(blank=True, max_length=20, null=True)),
                ('secondlastname', models.CharField(blank=True, max_length=30, null=True)),
                ('firstfirstname', models.CharField(blank=True, max_length=20, null=True)),
                ('secondfirstname', models.CharField(blank=True, max_length=30, null=True)),
                ('sex', models.CharField(blank=True, max_length=1, null=True)),
                ('additionalupc', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('specialrate', models.DecimalField(blank=True, decimal_places=4, max_digits=6, null=True)),
                ('beneficiaryid', models.BigIntegerField(blank=True, null=True)),
                ('bankid', models.IntegerField(blank=True, null=True)),
                ('governmental', models.BooleanField(blank=True, null=True)),
                ('abbreviation', models.CharField(blank=True, max_length=60, null=True)),
                ('bankaccounttype', models.CharField(blank=True, max_length=1, null=True)),
                ('delaytolerance', models.IntegerField(blank=True, null=True)),
                ('partialdispatch', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('partialdispatchproduct', models.BooleanField(blank=True, null=True)),
                ('separation', models.CharField(blank=True, max_length=1, null=True)),
                ('billing', models.CharField(blank=True, max_length=1, null=True)),
                ('currencyid', models.IntegerField(blank=True, null=True)),
                ('languageid', models.IntegerField(blank=True, null=True)),
                ('zoneid', models.IntegerField(blank=True, null=True)),
                ('tagid', models.IntegerField(blank=True, null=True)),
                ('incoterms', models.CharField(blank=True, max_length=3, null=True)),
                ('abc', models.CharField(blank=True, max_length=1, null=True)),
                ('quotacollection', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('quotatype', models.CharField(blank=True, max_length=1, null=True)),
                ('bond', models.CharField(blank=True, max_length=1, null=True)),
                ('quotavalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('qualification', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('collectorid', models.BigIntegerField(blank=True, null=True)),
                ('authorizedid', models.BigIntegerField(blank=True, null=True)),
                ('conditiondirection', models.BooleanField(blank=True, null=True)),
                ('channelid', models.IntegerField(blank=True, null=True)),
                ('supervisorid', models.IntegerField(blank=True, null=True)),
                ('priority', models.IntegerField(blank=True, null=True)),
                ('promptpaymentid', models.IntegerField(blank=True, null=True)),
                ('rotation', models.IntegerField(blank=True, null=True)),
                ('dispatchminimun', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('plan', models.IntegerField(blank=True, null=True)),
                ('creditdata', models.CharField(blank=True, max_length=1, null=True)),
                ('declarant', models.BooleanField(blank=True, null=True)),
                ('replication', models.CharField(blank=True, max_length=30, null=True)),
                ('beneficiary', models.BooleanField(blank=True, null=True)),
                ('contracttype', models.CharField(blank=True, max_length=1, null=True)),
                ('contractdate', models.DateField(blank=True, null=True)),
                ('frequent', models.BooleanField(blank=True, null=True)),
                ('educationaldegree', models.CharField(blank=True, max_length=2, null=True)),
                ('occupation', models.CharField(blank=True, max_length=1, null=True)),
                ('occupied', models.CharField(blank=True, max_length=1, null=True)),
                ('occupiedcode', models.IntegerField(blank=True, null=True)),
                ('lastdate', models.DateField(blank=True, null=True)),
                ('lastproduct', models.IntegerField(blank=True, null=True)),
                ('lastlocation', models.IntegerField(blank=True, null=True)),
                ('healthfee', models.IntegerField(blank=True, null=True)),
                ('affiliate', models.BooleanField(blank=True, null=True)),
                ('neighborhoodid', models.IntegerField(blank=True, null=True)),
                ('oldentity', models.CharField(blank=True, max_length=12, null=True)),
                ('asuranceaffiliationdate', models.DateField(blank=True, null=True)),
                ('disability', models.CharField(blank=True, max_length=1, null=True)),
                ('ethnicgroup', models.CharField(blank=True, max_length=2, null=True)),
                ('totalpoints', models.IntegerField(blank=True, null=True)),
                ('family', models.CharField(blank=True, max_length=1, null=True)),
                ('sisbenfile', models.IntegerField(blank=True, null=True)),
                ('sisbennucleus', models.IntegerField(blank=True, null=True)),
                ('sisbennumber', models.IntegerField(blank=True, null=True)),
                ('sisbendate', models.DateField(blank=True, null=True)),
                ('sisbenlevel', models.IntegerField(blank=True, null=True)),
                ('sisbenpoints', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('affiliatetype', models.CharField(blank=True, max_length=1, null=True)),
                ('matrixclienttype', models.CharField(blank=True, max_length=1, null=True)),
                ('populationgroup', models.CharField(blank=True, max_length=2, null=True)),
                ('affiliatestatus', models.CharField(blank=True, max_length=1, null=True)),
                ('locality', models.CharField(blank=True, max_length=40, null=True)),
                ('zone', models.CharField(blank=True, max_length=1, null=True)),
                ('highcost', models.BooleanField(blank=True, null=True)),
                ('authorizationlevel', models.IntegerField(blank=True, null=True)),
                ('credit', models.BooleanField(blank=True, null=True)),
                ('documentlocationid', models.IntegerField(blank=True, null=True)),
                ('retentionvalue', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('food', models.CharField(blank=True, max_length=2, null=True)),
                ('foodprime', models.CharField(blank=True, max_length=1, null=True)),
                ('foodprimeextra', models.CharField(blank=True, max_length=1, null=True)),
                ('clock', models.BooleanField(blank=True, null=True)),
                ('employeestate', models.CharField(blank=True, max_length=1, null=True)),
                ('positionid', models.IntegerField(blank=True, null=True)),
                ('height', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('weight', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('rh', models.CharField(blank=True, max_length=3, null=True)),
                ('laborlocationid', models.IntegerField(blank=True, null=True)),
                ('time', models.IntegerField(blank=True, null=True)),
                ('paymentlocationid', models.IntegerField(blank=True, null=True)),
                ('expeditiondocumentdate', models.DateField(blank=True, null=True)),
                ('expirationdocumentdate', models.DateField(blank=True, null=True)),
                ('expirationdocument', models.CharField(blank=True, max_length=10, null=True)),
                ('expirationentity', models.CharField(blank=True, max_length=1, null=True)),
                ('duplicateentity', models.CharField(blank=True, max_length=10, null=True)),
                ('motive', models.CharField(blank=True, max_length=3, null=True)),
                ('revised', models.DateField(blank=True, null=True)),
                ('idunumber', models.CharField(blank=True, max_length=15, null=True)),
                ('land', models.CharField(blank=True, max_length=60, null=True)),
                ('farm', models.CharField(blank=True, max_length=60, null=True)),
                ('ciiuid', models.IntegerField(blank=True, null=True)),
                ('replydays', models.IntegerField(blank=True, null=True)),
                ('voucherinitial', models.DateField(blank=True, null=True)),
                ('voucherfinal', models.DateField(blank=True, null=True)),
                ('vouchercomply', models.CharField(blank=True, max_length=1, null=True)),
                ('fiscaldocument', models.CharField(blank=True, max_length=3, null=True)),
                ('image', models.BinaryField(blank=True, null=True)),
                ('individual', models.CharField(blank=True, max_length=1, null=True)),
                ('paymentdays', models.IntegerField(blank=True, null=True)),
                ('birthday', models.DateField(blank=True, null=True)),
                ('marked', models.BooleanField(blank=True, null=True)),
                ('voucher', models.CharField(blank=True, max_length=3, null=True)),
                ('costcenterid', models.IntegerField(blank=True, null=True)),
                ('coffeelimit', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('coffeelimitused', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('signature', models.BinaryField(blank=True, null=True)),
                ('partnerstate', models.CharField(blank=True, max_length=1, null=True)),
                ('updated', models.DateField(blank=True, null=True)),
                ('typedocumentid', models.CharField(blank=True, max_length=2, null=True)),
                ('headid', models.BigIntegerField(blank=True, null=True)),
                ('kinshipid', models.IntegerField(blank=True, null=True)),
                ('grouppopulationid', models.IntegerField(blank=True, null=True)),
                ('condition', models.CharField(blank=True, max_length=1, null=True)),
                ('affiliation', models.DateField(blank=True, null=True)),
                ('consecutive', models.CharField(blank=True, max_length=20, null=True)),
                ('stateaffiliate', models.CharField(blank=True, max_length=2, null=True)),
                ('activationdate', models.DateField(blank=True, null=True)),
                ('suspensiondate', models.DateField(blank=True, null=True)),
                ('report', models.CharField(blank=True, max_length=2, null=True)),
                ('neighborhood', models.CharField(blank=True, max_length=30, null=True)),
                ('datereport', models.DateField(blank=True, null=True)),
                ('translation', models.CharField(blank=True, max_length=2, null=True)),
                ('epsidanterior', models.IntegerField(blank=True, null=True)),
                ('epsidcross', models.IntegerField(blank=True, null=True)),
                ('ingressvalidity', models.CharField(blank=True, max_length=1, null=True)),
                ('registerduria', models.CharField(blank=True, max_length=10, null=True)),
                ('epsidscross', models.IntegerField(blank=True, null=True)),
                ('locationidcross', models.IntegerField(blank=True, null=True)),
                ('resolution', models.CharField(blank=True, max_length=20, null=True)),
                ('core', models.CharField(blank=True, max_length=1, null=True)),
                ('home', models.CharField(blank=True, max_length=2, null=True)),
                ('bdua', models.CharField(blank=True, max_length=2, null=True)),
                ('locationidcross1', models.IntegerField(blank=True, null=True)),
                ('datepoll', models.DateField(blank=True, null=True)),
                ('datechangestate', models.DateField(blank=True, null=True)),
                ('type', models.CharField(blank=True, max_length=1, null=True)),
                ('gloss', models.CharField(blank=True, max_length=10, null=True)),
                ('statecross', models.CharField(blank=True, max_length=2, null=True)),
                ('groupinadequate', models.BooleanField(blank=True, null=True)),
                ('cellular', models.CharField(blank=True, max_length=20, null=True)),
                ('cellular2', models.CharField(blank=True, max_length=20, null=True)),
                ('charingress', models.CharField(blank=True, max_length=1, null=True)),
                ('evolution', models.IntegerField(blank=True, null=True)),
                ('numberbirth', models.IntegerField(blank=True, null=True)),
                ('coverdate', models.DateField(blank=True, null=True)),
                ('validatebdua', models.BooleanField(blank=True, null=True)),
                ('glossbdua', models.CharField(blank=True, max_length=400, null=True)),
                ('statebdua', models.CharField(blank=True, max_length=2, null=True)),
                ('criterionvalidate', models.IntegerField(blank=True, null=True)),
                ('biometria', models.BooleanField(blank=True, null=True)),
                ('groupageid', models.IntegerField(blank=True, null=True)),
                ('upc', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('portability', models.BooleanField(blank=True, null=True)),
                ('regimen', models.CharField(blank=True, max_length=1, null=True)),
                ('levelemployery', models.IntegerField(blank=True, null=True)),
                ('typeemployery', models.IntegerField(blank=True, null=True)),
                ('sisbenmethodology', models.IntegerField(blank=True, null=True)),
                ('alfanet', models.BigIntegerField(blank=True, null=True)),
                ('geographiclocationidactual', models.IntegerField(blank=True, null=True)),
                ('multiaffiliatecross', models.CharField(blank=True, max_length=1, null=True)),
                ('kinshipemployery', models.CharField(blank=True, max_length=2, null=True)),
                ('actuaphone', models.BooleanField(blank=True, null=True)),
                ('actuaaddress', models.BooleanField(blank=True, null=True)),
                ('statetenebit', models.CharField(blank=True, max_length=1, null=True)),
                ('fum', models.DateField(blank=True, null=True)),
                ('pertaintenebit', models.BooleanField(blank=True, null=True)),
                ('numberidinform', models.IntegerField(blank=True, null=True)),
                ('clientidant', models.BigIntegerField(blank=True, null=True)),
                ('upcadditional', models.BooleanField(blank=True, null=True)),
                ('initiationupcadditional', models.DateField(blank=True, null=True)),
                ('employerid', models.BigIntegerField(blank=True, null=True)),
                ('formpaymentid', models.IntegerField(blank=True, null=True)),
                ('scene', models.IntegerField(blank=True, null=True)),
                ('locationaccessid', models.IntegerField(blank=True, null=True)),
                ('compromisetext', models.CharField(blank=True, max_length=4000, null=True)),
                ('dispatchtext', models.CharField(blank=True, max_length=4000, null=True)),
                ('processbiometric', models.IntegerField(blank=True, null=True)),
                ('fingerright', models.IntegerField(blank=True, null=True)),
                ('fingerprintr1', models.BinaryField(blank=True, null=True)),
                ('fingerprintr2', models.BinaryField(blank=True, null=True)),
                ('fingerleft', models.IntegerField(blank=True, null=True)),
                ('fingerprintl1', models.BinaryField(blank=True, null=True)),
                ('fingerprintl2', models.BinaryField(blank=True, null=True)),
                ('imagedocument', models.BinaryField(blank=True, null=True)),
                ('datebiometric', models.DateField(blank=True, null=True)),
                ('typeprocessbiometric', models.IntegerField(blank=True, null=True)),
                ('imagedocument1', models.BinaryField(blank=True, null=True)),
                ('institutional', models.BooleanField(blank=True, null=True)),
                ('levelcontributory', models.IntegerField(blank=True, null=True)),
                ('typecontributory', models.IntegerField(blank=True, null=True)),
                ('typeeducationid', models.IntegerField(blank=True, null=True)),
                ('epsid', models.BigIntegerField(blank=True, null=True)),
                ('eps', models.BooleanField(blank=True, null=True)),
                ('pension', models.BooleanField(blank=True, null=True)),
                ('funeralsecure', models.BooleanField(blank=True, null=True)),
                ('phonecompany', models.CharField(blank=True, max_length=40, null=True)),
                ('egress', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('stratum', models.CharField(blank=True, max_length=1, null=True)),
                ('assets', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('passives', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('patrimony', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('updatedby', models.IntegerField(blank=True, null=True)),
                ('typemediaid', models.IntegerField(blank=True, null=True)),
                ('projectid', models.IntegerField(blank=True, null=True)),
                ('genreid', models.IntegerField(blank=True, null=True)),
                ('automaticpayment', models.BooleanField(blank=True, null=True)),
                ('associateentrydate', models.DateField(blank=True, null=True)),
                ('associateretirementdate', models.DateField(blank=True, null=True)),
                ('cardreference', models.CharField(blank=True, max_length=30, null=True)),
                ('pep', models.BooleanField(blank=True, null=True)),
                ('observation', models.CharField(blank=True, max_length=4000, null=True)),
                ('risk', models.CharField(blank=True, max_length=1, null=True)),
                ('typemedicineid', models.IntegerField(blank=True, null=True)),
                ('commercialregistration', models.CharField(blank=True, max_length=25, null=True)),
                ('contractor', models.BooleanField(blank=True, null=True)),
                ('liquidatorbase', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('salary', models.DecimalField(blank=True, decimal_places=4, max_digits=19, null=True)),
                ('typereference', models.CharField(blank=True, max_length=5, null=True)),
                ('network', models.BooleanField(blank=True, null=True)),
                ('isebill', models.BooleanField(blank=True, null=True)),
                ('lastsale', models.DateField(blank=True, null=True)),
                ('typecontactid', models.IntegerField(blank=True, null=True)),
                ('habeasdata', models.BooleanField(blank=True, null=True)),
                ('coffeefreight', models.CharField(blank=True, max_length=1, null=True)),
                ('ean', models.BigIntegerField(blank=True, null=True)),
                ('typeemployee', models.CharField(blank=True, max_length=3, null=True)),
                ('formliquidationid', models.IntegerField(blank=True, null=True)),
                ('timezone', models.CharField(blank=True, max_length=30, null=True)),
                ('populationgroupmethodology', models.CharField(blank=True, max_length=2, null=True)),
                ('subgroupsisbeniv', models.CharField(blank=True, max_length=3, null=True)),
                ('dispersion', models.CharField(blank=True, max_length=2, null=True)),
                ('solidaritycontribution', models.BooleanField(blank=True, null=True)),
            ],
            options={
                'db_table': 'client',
                'managed': False,
            },
        ),
        migrations.AddConstraint(
            model_name='documenttype',
            constraint=models.UniqueConstraint(fields=('type_id',), name='UNQ_document_type_id'),
        ),
    ]
