# coding: utf-8

"""
 Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 A copy of the License is located at

     http://www.apache.org/licenses/LICENSE-2.0

 or in the "license" file accompanying this file. This file is distributed
 on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied. See the License for the specific language governing
 permissions and limitations under the License.
"""

"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.refinement import Refinement  # noqa: F401,E501


class SearchRefinements(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'browse_node': 'Refinement',
        'other_refinements': 'list[Refinement]',
        'search_index': 'Refinement'
    }

    attribute_map = {
        'browse_node': 'BrowseNode',
        'other_refinements': 'OtherRefinements',
        'search_index': 'SearchIndex'
    }

    def __init__(self, browse_node=None, other_refinements=None, search_index=None):  # noqa: E501
        """SearchRefinements - a model defined in Swagger"""  # noqa: E501

        self._browse_node = None
        self._other_refinements = None
        self._search_index = None
        self.discriminator = None

        if browse_node is not None:
            self.browse_node = browse_node
        if other_refinements is not None:
            self.other_refinements = other_refinements
        if search_index is not None:
            self.search_index = search_index

    @property
    def browse_node(self):
        """Gets the browse_node of this SearchRefinements.  # noqa: E501


        :return: The browse_node of this SearchRefinements.  # noqa: E501
        :rtype: Refinement
        """
        return self._browse_node

    @browse_node.setter
    def browse_node(self, browse_node):
        """Sets the browse_node of this SearchRefinements.


        :param browse_node: The browse_node of this SearchRefinements.  # noqa: E501
        :type: Refinement
        """

        self._browse_node = browse_node

    @property
    def other_refinements(self):
        """Gets the other_refinements of this SearchRefinements.  # noqa: E501


        :return: The other_refinements of this SearchRefinements.  # noqa: E501
        :rtype: list[Refinement]
        """
        return self._other_refinements

    @other_refinements.setter
    def other_refinements(self, other_refinements):
        """Sets the other_refinements of this SearchRefinements.


        :param other_refinements: The other_refinements of this SearchRefinements.  # noqa: E501
        :type: list[Refinement]
        """

        self._other_refinements = other_refinements

    @property
    def search_index(self):
        """Gets the search_index of this SearchRefinements.  # noqa: E501


        :return: The search_index of this SearchRefinements.  # noqa: E501
        :rtype: Refinement
        """
        return self._search_index

    @search_index.setter
    def search_index(self, search_index):
        """Sets the search_index of this SearchRefinements.


        :param search_index: The search_index of this SearchRefinements.  # noqa: E501
        :type: Refinement
        """

        self._search_index = search_index

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SearchRefinements, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchRefinements):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
