# VMware vCloud Python SDK
# Copyright (c) 2014 VMware, Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Dec  4 19:08:22 2014 by generateDS.py version 2.14a.
#
# Command line options:
#   ('-o', 'schema/vcd/v1_5/schemas/vcloud/vAppTemplateType.py')
#
# Command line arguments:
#   schema/vcd/v1_5/schemas/vcloud/vAppTemplate.xsd
#
# Command line:
#   ../bin/generateDS.py -o "schema/vcd/v1_5/schemas/vcloud/vAppTemplateType.py" schema/vcd/v1_5/schemas/vcloud/vAppTemplate.xsd
#
# Current working directory (os.getcwd()):
#   pyvcloud
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_


Validate_simpletypes_ = True


etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class VCloudExtensionType(GeneratedsSuper):
    """0.9 General purpose extension element. Not related to extension
    services. always True if the request should fail when the server
    does not understand the extension. false"""
    subclass = None
    superclass = None
    def __init__(self, required=True, anytypeobjs_=None):
        self.original_tagname_ = None
        self.required = _cast(bool, required)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if VCloudExtensionType.subclass:
            return VCloudExtensionType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensionType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensionType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % (self.required,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'VCloudExtensionType')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class VCloudExtensionType


class VCloudExtensibleType(GeneratedsSuper):
    """0.9 A base abstract type for all complex types that support
    extensions."""
    subclass = None
    superclass = None
    def __init__(self, VCloudExtension=None, extensiontype_=None):
        self.original_tagname_ = None
        if VCloudExtension is None:
            self.VCloudExtension = []
        else:
            self.VCloudExtension = VCloudExtension
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if VCloudExtensibleType.subclass:
            return VCloudExtensibleType.subclass(*args_, **kwargs_)
        else:
            return VCloudExtensibleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VCloudExtension(self): return self.VCloudExtension
    def set_VCloudExtension(self, VCloudExtension): self.VCloudExtension = VCloudExtension
    def add_VCloudExtension(self, value): self.VCloudExtension.append(value)
    def insert_VCloudExtension_at(self, index, value): self.VCloudExtension.insert(index, value)
    def replace_VCloudExtension_at(self, index, value): self.VCloudExtension[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.VCloudExtension
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VCloudExtensibleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VCloudExtensibleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VCloudExtensibleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VCloudExtensibleType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VCloudExtensibleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for VCloudExtension_ in self.VCloudExtension:
            VCloudExtension_.export(outfile, level, namespace_, name_='VCloudExtension', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VCloudExtensibleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('VCloudExtension=[\n')
        level += 1
        for VCloudExtension_ in self.VCloudExtension:
            showIndent(outfile, level)
            outfile.write('model_.VCloudExtensionType(\n')
            VCloudExtension_.exportLiteral(outfile, level, name_='VCloudExtensionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VCloudExtension':
            obj_ = VCloudExtensionType.factory()
            obj_.build(child_)
            self.VCloudExtension.append(obj_)
            obj_.original_tagname_ = 'VCloudExtension'
# end class VCloudExtensibleType


class ErrorType(VCloudExtensibleType):
    """0.9 The standard error message type used in the vCloud REST API.
    none An one line, human-readable message describing the error
    that occurred. truenone The class of the error. Matches the HTTP
    status code. truenone Resource-specific error code. truenone A
    vendor- or implementation-specific error code that can reference
    specific modules or source lines for diagnostic purposes.
    false1.0none The stack trace of the exception. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, vendorSpecificErrorCode=None, stackTrace=None, message=None, minorErrorCode=None, majorErrorCode=None):
        self.original_tagname_ = None
        super(ErrorType, self).__init__(VCloudExtension, )
        self.vendorSpecificErrorCode = _cast(None, vendorSpecificErrorCode)
        self.stackTrace = _cast(None, stackTrace)
        self.message = _cast(None, message)
        self.minorErrorCode = _cast(None, minorErrorCode)
        self.majorErrorCode = _cast(int, majorErrorCode)
    def factory(*args_, **kwargs_):
        if ErrorType.subclass:
            return ErrorType.subclass(*args_, **kwargs_)
        else:
            return ErrorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vendorSpecificErrorCode(self): return self.vendorSpecificErrorCode
    def set_vendorSpecificErrorCode(self, vendorSpecificErrorCode): self.vendorSpecificErrorCode = vendorSpecificErrorCode
    def get_stackTrace(self): return self.stackTrace
    def set_stackTrace(self, stackTrace): self.stackTrace = stackTrace
    def get_message(self): return self.message
    def set_message(self, message): self.message = message
    def get_minorErrorCode(self): return self.minorErrorCode
    def set_minorErrorCode(self, minorErrorCode): self.minorErrorCode = minorErrorCode
    def get_majorErrorCode(self): return self.majorErrorCode
    def set_majorErrorCode(self, majorErrorCode): self.majorErrorCode = majorErrorCode
    def hasContent_(self):
        if (
            super(ErrorType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ErrorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ErrorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ErrorType'):
        super(ErrorType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ErrorType')
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            outfile.write(' vendorSpecificErrorCode=%s' % (self.gds_format_string(quote_attrib(self.vendorSpecificErrorCode).encode(ExternalEncoding), input_name='vendorSpecificErrorCode'), ))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            outfile.write(' stackTrace=%s' % (self.gds_format_string(quote_attrib(self.stackTrace).encode(ExternalEncoding), input_name='stackTrace'), ))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            outfile.write(' message=%s' % (self.gds_format_string(quote_attrib(self.message).encode(ExternalEncoding), input_name='message'), ))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            outfile.write(' minorErrorCode=%s' % (self.gds_format_string(quote_attrib(self.minorErrorCode).encode(ExternalEncoding), input_name='minorErrorCode'), ))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            outfile.write(' majorErrorCode="%s"' % self.gds_format_integer(self.majorErrorCode, input_name='majorErrorCode'))
    def exportChildren(self, outfile, level, namespace_='', name_='ErrorType', fromsubclass_=False, pretty_print=True):
        super(ErrorType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ErrorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.vendorSpecificErrorCode is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            showIndent(outfile, level)
            outfile.write('vendorSpecificErrorCode="%s",\n' % (self.vendorSpecificErrorCode,))
        if self.stackTrace is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            showIndent(outfile, level)
            outfile.write('stackTrace="%s",\n' % (self.stackTrace,))
        if self.message is not None and 'message' not in already_processed:
            already_processed.add('message')
            showIndent(outfile, level)
            outfile.write('message="%s",\n' % (self.message,))
        if self.minorErrorCode is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            showIndent(outfile, level)
            outfile.write('minorErrorCode="%s",\n' % (self.minorErrorCode,))
        if self.majorErrorCode is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            showIndent(outfile, level)
            outfile.write('majorErrorCode=%d,\n' % (self.majorErrorCode,))
        super(ErrorType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ErrorType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vendorSpecificErrorCode', node)
        if value is not None and 'vendorSpecificErrorCode' not in already_processed:
            already_processed.add('vendorSpecificErrorCode')
            self.vendorSpecificErrorCode = value
        value = find_attr_value_('stackTrace', node)
        if value is not None and 'stackTrace' not in already_processed:
            already_processed.add('stackTrace')
            self.stackTrace = value
        value = find_attr_value_('message', node)
        if value is not None and 'message' not in already_processed:
            already_processed.add('message')
            self.message = value
        value = find_attr_value_('minorErrorCode', node)
        if value is not None and 'minorErrorCode' not in already_processed:
            already_processed.add('minorErrorCode')
            self.minorErrorCode = value
        value = find_attr_value_('majorErrorCode', node)
        if value is not None and 'majorErrorCode' not in already_processed:
            already_processed.add('majorErrorCode')
            try:
                self.majorErrorCode = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ErrorType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ErrorType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ErrorType


class ResourceType(VCloudExtensibleType):
    """0.9 The base type for all objects in the vCloud model. Has an
    optional list of links and href and type attributes. always The
    URI of the entity. falsealways The MIME type of the entity.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, Link=None):
        self.original_tagname_ = None
        super(ResourceType, self).__init__(VCloudExtension, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
    def factory(*args_, **kwargs_):
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link_at(self, index, value): self.Link.insert(index, value)
    def replace_Link_at(self, index, value): self.Link[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def hasContent_(self):
        if (
            self.Link or
            super(ResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceType'):
        super(ResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceType', fromsubclass_=False, pretty_print=True):
        super(ResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Link_ in self.Link:
            Link_.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        super(ResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            Link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        super(ResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
            obj_.original_tagname_ = 'Link'
        super(ResourceType, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceType


class IdentifiableResourceType(ResourceType):
    """0.9 The base type for all resource types which contain an id
    attribute. none The entity identifier, expressed in URN format.
    The value of this attribute uniquely identifies the entity,
    persists for the life of the entity, and is never reused.
    falsecreate Optional unique identifier to support idempotent
    semantics for create and delete operations. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, operationKey=None, id=None, extensiontype_=None):
        self.original_tagname_ = None
        super(IdentifiableResourceType, self).__init__(extensiontype_, )
        self.operationKey = _cast(None, operationKey)
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IdentifiableResourceType.subclass:
            return IdentifiableResourceType.subclass(*args_, **kwargs_)
        else:
            return IdentifiableResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_operationKey(self): return self.operationKey
    def set_operationKey(self, operationKey): self.operationKey = operationKey
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(IdentifiableResourceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IdentifiableResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IdentifiableResourceType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IdentifiableResourceType'):
        super(IdentifiableResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IdentifiableResourceType')
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            outfile.write(' operationKey=%s' % (self.gds_format_string(quote_attrib(self.operationKey).encode(ExternalEncoding), input_name='operationKey'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IdentifiableResourceType', fromsubclass_=False, pretty_print=True):
        super(IdentifiableResourceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='IdentifiableResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.operationKey is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            showIndent(outfile, level)
            outfile.write('operationKey="%s",\n' % (self.operationKey,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        super(IdentifiableResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IdentifiableResourceType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('operationKey', node)
        if value is not None and 'operationKey' not in already_processed:
            already_processed.add('operationKey')
            self.operationKey = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IdentifiableResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IdentifiableResourceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IdentifiableResourceType


class ParamsType(VCloudExtensibleType):
    """0.9 A basic type used to specify request parameters. always
    Typically used to name or identify the subject of the request.
    For example, the name of the object being created or modified.
    false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, name=None, Description=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ParamsType, self).__init__(VCloudExtension, extensiontype_, )
        self.name = _cast(None, name)
        self.Description = Description
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ParamsType.subclass:
            return ParamsType.subclass(*args_, **kwargs_)
        else:
            return ParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Description is not None or
            super(ParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ParamsType'):
        super(ParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ParamsType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ParamsType', fromsubclass_=False, pretty_print=True):
        super(ParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='ParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        super(ParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ParamsType


class ReferenceType(VCloudExtensibleType):
    """0.9 A reference to a resource. Contains an href attribute and
    optional name and type attributes. always Contains the URI to
    the entity. truealways The resource identifier, expressed in URN
    format. The value of this attribute uniquely identifies the
    resource, persists for the life of the resource, and is never
    reused. falsealways Contains the type of the the entity.
    falsealways Contains the name of the the entity. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ReferenceType.subclass:
            return ReferenceType.subclass(*args_, **kwargs_)
        else:
            return ReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferenceType'):
        super(ReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferenceType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ReferenceType', fromsubclass_=False, pretty_print=True):
        super(ReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(ReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ReferenceType


class ResourceReferenceType(ReferenceType):
    """0.9 Represents a reference to a resource. Contains an href
    attribute, a resource status attribute, and optional name and
    type attributes. none Status of a resource. false"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, status=None):
        self.original_tagname_ = None
        super(ResourceReferenceType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.status = _cast(int, status)
    def factory(*args_, **kwargs_):
        if ResourceReferenceType.subclass:
            return ResourceReferenceType.subclass(*args_, **kwargs_)
        else:
            return ResourceReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def hasContent_(self):
        if (
            super(ResourceReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceReferenceType'):
        super(ResourceReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceReferenceType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceReferenceType', fromsubclass_=False, pretty_print=True):
        super(ResourceReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(ResourceReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(ResourceReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ResourceReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ResourceReferenceType


class ContainerType(ResourceType):
    """Container for query result sets. none Query name that generated this
    result set. falsenone Page of the result set that this container
    holds. The first page is page number 1. falsenone Page size, as
    a number of records or references. falsenone Total number of
    records or references in the container. false"""
    subclass = None
    superclass = ResourceType
    def __init__(self, total=None, name=None, pageSize=None, page=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ContainerType, self).__init__(extensiontype_, )
        self.total = _cast(int, total)
        self.name = _cast(None, name)
        self.pageSize = _cast(int, pageSize)
        self.page = _cast(int, page)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ContainerType.subclass:
            return ContainerType.subclass(*args_, **kwargs_)
        else:
            return ContainerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_total(self): return self.total
    def set_total(self, total): self.total = total
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_pageSize(self): return self.pageSize
    def set_pageSize(self, pageSize): self.pageSize = pageSize
    def get_page(self): return self.page
    def set_page(self, page): self.page = page
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(ContainerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContainerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContainerType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContainerType'):
        super(ContainerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContainerType')
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            outfile.write(' total="%s"' % self.gds_format_integer(self.total, input_name='total'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            outfile.write(' pageSize="%s"' % self.gds_format_integer(self.pageSize, input_name='pageSize'))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            outfile.write(' page="%s"' % self.gds_format_integer(self.page, input_name='page'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ContainerType', fromsubclass_=False, pretty_print=True):
        super(ContainerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='ContainerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.total is not None and 'total' not in already_processed:
            already_processed.add('total')
            showIndent(outfile, level)
            outfile.write('total=%d,\n' % (self.total,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.pageSize is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            showIndent(outfile, level)
            outfile.write('pageSize=%d,\n' % (self.pageSize,))
        if self.page is not None and 'page' not in already_processed:
            already_processed.add('page')
            showIndent(outfile, level)
            outfile.write('page=%d,\n' % (self.page,))
        super(ContainerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContainerType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('total', node)
        if value is not None and 'total' not in already_processed:
            already_processed.add('total')
            try:
                self.total = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('pageSize', node)
        if value is not None and 'pageSize' not in already_processed:
            already_processed.add('pageSize')
            try:
                self.pageSize = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('page', node)
        if value is not None and 'page' not in already_processed:
            already_processed.add('page')
            try:
                self.page = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ContainerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ContainerType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ContainerType


class CapacityType(VCloudExtensibleType):
    """0.9 Represents the capacity of a given resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, extensiontype_=None):
        self.original_tagname_ = None
        super(CapacityType, self).__init__(VCloudExtension, extensiontype_, )
        self.Units = Units
        self.Allocated = Allocated
        self.Limit = Limit
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CapacityType.subclass:
            return CapacityType.subclass(*args_, **kwargs_)
        else:
            return CapacityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Units(self): return self.Units
    def set_Units(self, Units): self.Units = Units
    def get_Allocated(self): return self.Allocated
    def set_Allocated(self, Allocated): self.Allocated = Allocated
    def get_Limit(self): return self.Limit
    def set_Limit(self, Limit): self.Limit = Limit
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Units is not None or
            self.Allocated is not None or
            self.Limit is not None or
            super(CapacityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityType'):
        super(CapacityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityType')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityType', fromsubclass_=False, pretty_print=True):
        super(CapacityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Units is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUnits>%s</%sUnits>%s' % (namespace_, self.gds_format_string(quote_xml(self.Units).encode(ExternalEncoding), input_name='Units'), namespace_, eol_))
        if self.Allocated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAllocated>%s</%sAllocated>%s' % (namespace_, self.gds_format_integer(self.Allocated, input_name='Allocated'), namespace_, eol_))
        if self.Limit is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLimit>%s</%sLimit>%s' % (namespace_, self.gds_format_integer(self.Limit, input_name='Limit'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Units is not None:
            showIndent(outfile, level)
            outfile.write('Units=%s,\n' % quote_python(self.Units).encode(ExternalEncoding))
        if self.Allocated is not None:
            showIndent(outfile, level)
            outfile.write('Allocated=%d,\n' % self.Allocated)
        if self.Limit is not None:
            showIndent(outfile, level)
            outfile.write('Limit=%d,\n' % self.Limit)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(CapacityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Units':
            Units_ = child_.text
            Units_ = self.gds_validate_string(Units_, node, 'Units')
            self.Units = Units_
        elif nodeName_ == 'Allocated':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Allocated')
            self.Allocated = ival_
        elif nodeName_ == 'Limit':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Limit')
            self.Limit = ival_
        super(CapacityType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityType


class CapacityWithUsageType(CapacityType):
    """0.9 Represents a capacity and usage of a given resource."""
    subclass = None
    superclass = CapacityType
    def __init__(self, VCloudExtension=None, Units=None, Allocated=None, Limit=None, Reserved=None, Used=None, Overhead=None):
        self.original_tagname_ = None
        super(CapacityWithUsageType, self).__init__(VCloudExtension, Units, Allocated, Limit, )
        self.Reserved = Reserved
        self.Used = Used
        self.Overhead = Overhead
    def factory(*args_, **kwargs_):
        if CapacityWithUsageType.subclass:
            return CapacityWithUsageType.subclass(*args_, **kwargs_)
        else:
            return CapacityWithUsageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reserved(self): return self.Reserved
    def set_Reserved(self, Reserved): self.Reserved = Reserved
    def get_Used(self): return self.Used
    def set_Used(self, Used): self.Used = Used
    def get_Overhead(self): return self.Overhead
    def set_Overhead(self, Overhead): self.Overhead = Overhead
    def hasContent_(self):
        if (
            self.Reserved is not None or
            self.Used is not None or
            self.Overhead is not None or
            super(CapacityWithUsageType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CapacityWithUsageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CapacityWithUsageType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CapacityWithUsageType'):
        super(CapacityWithUsageType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CapacityWithUsageType')
    def exportChildren(self, outfile, level, namespace_='', name_='CapacityWithUsageType', fromsubclass_=False, pretty_print=True):
        super(CapacityWithUsageType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Reserved is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReserved>%s</%sReserved>%s' % (namespace_, self.gds_format_integer(self.Reserved, input_name='Reserved'), namespace_, eol_))
        if self.Used is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUsed>%s</%sUsed>%s' % (namespace_, self.gds_format_integer(self.Used, input_name='Used'), namespace_, eol_))
        if self.Overhead is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOverhead>%s</%sOverhead>%s' % (namespace_, self.gds_format_integer(self.Overhead, input_name='Overhead'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='CapacityWithUsageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CapacityWithUsageType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CapacityWithUsageType, self).exportLiteralChildren(outfile, level, name_)
        if self.Reserved is not None:
            showIndent(outfile, level)
            outfile.write('Reserved=%d,\n' % self.Reserved)
        if self.Used is not None:
            showIndent(outfile, level)
            outfile.write('Used=%d,\n' % self.Used)
        if self.Overhead is not None:
            showIndent(outfile, level)
            outfile.write('Overhead=%d,\n' % self.Overhead)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CapacityWithUsageType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reserved':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Reserved')
            self.Reserved = ival_
        elif nodeName_ == 'Used':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Used')
            self.Used = ival_
        elif nodeName_ == 'Overhead':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Overhead')
            self.Overhead = ival_
        super(CapacityWithUsageType, self).buildChildren(child_, node, nodeName_, True)
# end class CapacityWithUsageType


class AccessSettingType(VCloudExtensibleType):
    """0.9 Controls access to the resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Subject=None, AccessLevel=None):
        self.original_tagname_ = None
        super(AccessSettingType, self).__init__(VCloudExtension, )
        self.Subject = Subject
        self.AccessLevel = AccessLevel
    def factory(*args_, **kwargs_):
        if AccessSettingType.subclass:
            return AccessSettingType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Subject(self): return self.Subject
    def set_Subject(self, Subject): self.Subject = Subject
    def get_AccessLevel(self): return self.AccessLevel
    def set_AccessLevel(self, AccessLevel): self.AccessLevel = AccessLevel
    def hasContent_(self):
        if (
            self.Subject is not None or
            self.AccessLevel is not None or
            super(AccessSettingType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingType'):
        super(AccessSettingType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Subject is not None:
            self.Subject.export(outfile, level, namespace_, name_='Subject', pretty_print=pretty_print)
        if self.AccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccessLevel>%s</%sAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.AccessLevel).encode(ExternalEncoding), input_name='AccessLevel'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='AccessSettingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingType, self).exportLiteralChildren(outfile, level, name_)
        if self.Subject is not None:
            showIndent(outfile, level)
            outfile.write('Subject=model_.ReferenceType(\n')
            self.Subject.exportLiteral(outfile, level, name_='Subject')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('AccessLevel=%s,\n' % quote_python(self.AccessLevel).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Subject':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Subject = obj_
            obj_.original_tagname_ = 'Subject'
        elif nodeName_ == 'AccessLevel':
            AccessLevel_ = child_.text
            AccessLevel_ = self.gds_validate_string(AccessLevel_, node, 'AccessLevel')
            self.AccessLevel = AccessLevel_
        super(AccessSettingType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingType


class AccessSettingsType(VCloudExtensibleType):
    """0.9 A list of access settings for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, AccessSetting=None):
        self.original_tagname_ = None
        super(AccessSettingsType, self).__init__(VCloudExtension, )
        if AccessSetting is None:
            self.AccessSetting = []
        else:
            self.AccessSetting = AccessSetting
    def factory(*args_, **kwargs_):
        if AccessSettingsType.subclass:
            return AccessSettingsType.subclass(*args_, **kwargs_)
        else:
            return AccessSettingsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AccessSetting(self): return self.AccessSetting
    def set_AccessSetting(self, AccessSetting): self.AccessSetting = AccessSetting
    def add_AccessSetting(self, value): self.AccessSetting.append(value)
    def insert_AccessSetting_at(self, index, value): self.AccessSetting.insert(index, value)
    def replace_AccessSetting_at(self, index, value): self.AccessSetting[index] = value
    def hasContent_(self):
        if (
            self.AccessSetting or
            super(AccessSettingsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AccessSettingsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AccessSettingsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AccessSettingsType'):
        super(AccessSettingsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AccessSettingsType')
    def exportChildren(self, outfile, level, namespace_='', name_='AccessSettingsType', fromsubclass_=False, pretty_print=True):
        super(AccessSettingsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AccessSetting_ in self.AccessSetting:
            AccessSetting_.export(outfile, level, namespace_, name_='AccessSetting', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AccessSettingsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AccessSettingsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AccessSettingsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('AccessSetting=[\n')
        level += 1
        for AccessSetting_ in self.AccessSetting:
            showIndent(outfile, level)
            outfile.write('model_.AccessSettingType(\n')
            AccessSetting_.exportLiteral(outfile, level, name_='AccessSettingType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AccessSettingsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AccessSetting':
            obj_ = AccessSettingType.factory()
            obj_.build(child_)
            self.AccessSetting.append(obj_)
            obj_.original_tagname_ = 'AccessSetting'
        super(AccessSettingsType, self).buildChildren(child_, node, nodeName_, True)
# end class AccessSettingsType


class ControlAccessParamsType(VCloudExtensibleType):
    """0.9 Specifies access controls for a resource."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, IsSharedToEveryone=None, EveryoneAccessLevel=None, AccessSettings=None):
        self.original_tagname_ = None
        super(ControlAccessParamsType, self).__init__(VCloudExtension, )
        self.IsSharedToEveryone = IsSharedToEveryone
        self.EveryoneAccessLevel = EveryoneAccessLevel
        self.AccessSettings = AccessSettings
    def factory(*args_, **kwargs_):
        if ControlAccessParamsType.subclass:
            return ControlAccessParamsType.subclass(*args_, **kwargs_)
        else:
            return ControlAccessParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_IsSharedToEveryone(self): return self.IsSharedToEveryone
    def set_IsSharedToEveryone(self, IsSharedToEveryone): self.IsSharedToEveryone = IsSharedToEveryone
    def get_EveryoneAccessLevel(self): return self.EveryoneAccessLevel
    def set_EveryoneAccessLevel(self, EveryoneAccessLevel): self.EveryoneAccessLevel = EveryoneAccessLevel
    def get_AccessSettings(self): return self.AccessSettings
    def set_AccessSettings(self, AccessSettings): self.AccessSettings = AccessSettings
    def hasContent_(self):
        if (
            self.IsSharedToEveryone is not None or
            self.EveryoneAccessLevel is not None or
            self.AccessSettings is not None or
            super(ControlAccessParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ControlAccessParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ControlAccessParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ControlAccessParamsType'):
        super(ControlAccessParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ControlAccessParamsType')
    def exportChildren(self, outfile, level, namespace_='', name_='ControlAccessParamsType', fromsubclass_=False, pretty_print=True):
        super(ControlAccessParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsSharedToEveryone>%s</%sIsSharedToEveryone>%s' % (namespace_, self.gds_format_boolean(self.IsSharedToEveryone, input_name='IsSharedToEveryone'), namespace_, eol_))
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEveryoneAccessLevel>%s</%sEveryoneAccessLevel>%s' % (namespace_, self.gds_format_string(quote_xml(self.EveryoneAccessLevel).encode(ExternalEncoding), input_name='EveryoneAccessLevel'), namespace_, eol_))
        if self.AccessSettings is not None:
            self.AccessSettings.export(outfile, level, namespace_, name_='AccessSettings', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ControlAccessParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ControlAccessParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ControlAccessParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.IsSharedToEveryone is not None:
            showIndent(outfile, level)
            outfile.write('IsSharedToEveryone=%s,\n' % self.IsSharedToEveryone)
        if self.EveryoneAccessLevel is not None:
            showIndent(outfile, level)
            outfile.write('EveryoneAccessLevel=%s,\n' % quote_python(self.EveryoneAccessLevel).encode(ExternalEncoding))
        if self.AccessSettings is not None:
            showIndent(outfile, level)
            outfile.write('AccessSettings=model_.AccessSettingsType(\n')
            self.AccessSettings.exportLiteral(outfile, level, name_='AccessSettings')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ControlAccessParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'IsSharedToEveryone':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsSharedToEveryone')
            self.IsSharedToEveryone = ival_
        elif nodeName_ == 'EveryoneAccessLevel':
            EveryoneAccessLevel_ = child_.text
            EveryoneAccessLevel_ = self.gds_validate_string(EveryoneAccessLevel_, node, 'EveryoneAccessLevel')
            self.EveryoneAccessLevel = EveryoneAccessLevel_
        elif nodeName_ == 'AccessSettings':
            obj_ = AccessSettingsType.factory()
            obj_.build(child_)
            self.AccessSettings = obj_
            obj_.original_tagname_ = 'AccessSettings'
        super(ControlAccessParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class ControlAccessParamsType


class OwnerType(ResourceType):
    """1.5 Represents the owner of this entity."""
    subclass = None
    superclass = ResourceType
    def __init__(self, User=None):
        self.original_tagname_ = None
        super(OwnerType, self).__init__()
        self.User = User
    def factory(*args_, **kwargs_):
        if OwnerType.subclass:
            return OwnerType.subclass(*args_, **kwargs_)
        else:
            return OwnerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def hasContent_(self):
        if (
            self.User is not None or
            super(OwnerType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OwnerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OwnerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OwnerType'):
        super(OwnerType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OwnerType')
    def exportChildren(self, outfile, level, namespace_='', name_='OwnerType', fromsubclass_=False, pretty_print=True):
        super(OwnerType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OwnerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(OwnerType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OwnerType, self).exportLiteralChildren(outfile, level, name_)
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(OwnerType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        super(OwnerType, self).buildChildren(child_, node, nodeName_, True)
# end class OwnerType


class ReferencesType(ContainerType):
    """Container for query results returned in references format."""
    subclass = None
    superclass = ContainerType
    def __init__(self, total=None, name=None, pageSize=None, page=None, Reference=None):
        self.original_tagname_ = None
        super(ReferencesType, self).__init__(total, name, pageSize, page, )
        if Reference is None:
            self.Reference = []
        else:
            self.Reference = Reference
    def factory(*args_, **kwargs_):
        if ReferencesType.subclass:
            return ReferencesType.subclass(*args_, **kwargs_)
        else:
            return ReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Reference(self): return self.Reference
    def set_Reference(self, Reference): self.Reference = Reference
    def add_Reference(self, value): self.Reference.append(value)
    def insert_Reference_at(self, index, value): self.Reference.insert(index, value)
    def replace_Reference_at(self, index, value): self.Reference[index] = value
    def hasContent_(self):
        if (
            self.Reference or
            super(ReferencesType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReferencesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReferencesType'):
        super(ReferencesType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReferencesType')
    def exportChildren(self, outfile, level, namespace_='', name_='ReferencesType', fromsubclass_=False, pretty_print=True):
        super(ReferencesType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Reference_ in self.Reference:
            Reference_.export(outfile, level, namespace_, name_='Reference', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReferencesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ReferencesType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReferencesType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Reference=[\n')
        level += 1
        for Reference_ in self.Reference:
            showIndent(outfile, level)
            outfile.write('model_.Reference(\n')
            Reference_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ReferencesType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Reference':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Reference.append(obj_)
            obj_.original_tagname_ = 'Reference'
        super(ReferencesType, self).buildChildren(child_, node, nodeName_, True)
# end class ReferencesType


class QueryListType(ContainerType):
    """Container for the list of typed queries available to the requesting
    user."""
    subclass = None
    superclass = ContainerType
    def __init__(self, total=None, name=None, pageSize=None, page=None):
        self.original_tagname_ = None
        super(QueryListType, self).__init__(total, name, pageSize, page, )
    def factory(*args_, **kwargs_):
        if QueryListType.subclass:
            return QueryListType.subclass(*args_, **kwargs_)
        else:
            return QueryListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(QueryListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryListType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryListType'):
        super(QueryListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='QueryListType')
    def exportChildren(self, outfile, level, namespace_='', name_='QueryListType', fromsubclass_=False, pretty_print=True):
        super(QueryListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='QueryListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(QueryListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(QueryListType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(QueryListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(QueryListType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class QueryListType


class MetadataDomainTagType(GeneratedsSuper):
    """A value of SYSTEM places this MetadataEntry in the SYSTEM domain.
    Omit or leave empty to place this MetadataEntry in the GENERAL
    domain. true One of:<br> PRIVATE<br> READONLY"""
    subclass = None
    superclass = None
    def __init__(self, visibility=None, valueOf_=None):
        self.original_tagname_ = None
        self.visibility = _cast(None, visibility)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if MetadataDomainTagType.subclass:
            return MetadataDomainTagType.subclass(*args_, **kwargs_)
        else:
            return MetadataDomainTagType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_visibility(self): return self.visibility
    def set_visibility(self, visibility): self.visibility = visibility
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDomainTagType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDomainTagType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDomainTagType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDomainTagType'):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            outfile.write(' visibility=%s' % (self.gds_format_string(quote_attrib(self.visibility).encode(ExternalEncoding), input_name='visibility'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDomainTagType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataDomainTagType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.visibility is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            showIndent(outfile, level)
            outfile.write('visibility="%s",\n' % (self.visibility,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('visibility', node)
        if value is not None and 'visibility' not in already_processed:
            already_processed.add('visibility')
            self.visibility = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataDomainTagType


class MetadataEntryType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, Domain=None, Key=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataEntryType, self).__init__()
        self.Domain = Domain
        self.Key = Key
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataEntryType.subclass:
            return MetadataEntryType.subclass(*args_, **kwargs_)
        else:
            return MetadataEntryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Key(self): return self.Key
    def set_Key(self, Key): self.Key = Key
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Key is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataEntryType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataEntryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataEntryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataEntryType'):
        super(MetadataEntryType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataEntryType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataEntryType', fromsubclass_=False, pretty_print=True):
        super(MetadataEntryType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sKey>%s</%sKey>%s' % (namespace_, self.gds_format_string(quote_xml(self.Key).encode(ExternalEncoding), input_name='Key'), namespace_, eol_))
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataEntryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataEntryType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataEntryType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Key is not None:
            showIndent(outfile, level)
            outfile.write('Key=%s,\n' % quote_python(self.Key).encode(ExternalEncoding))
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataEntryType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Key':
            Key_ = child_.text
            Key_ = self.gds_validate_string(Key_, node, 'Key')
            self.Key = Key_
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataEntryType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataEntryType


class MetadataTypedValue(GeneratedsSuper):
    """One of:<br> MetadataStringValue<br> MetadataNumberValue<br>
    MetadataBooleanValue<br> MetadataDateTimeValue"""
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if MetadataTypedValue.subclass:
            return MetadataTypedValue.subclass(*args_, **kwargs_)
        else:
            return MetadataTypedValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataTypedValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataTypedValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataTypedValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataTypedValue'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataTypedValue', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MetadataTypedValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetadataTypedValue


class MetadataStringValue(MetadataTypedValue):
    """UTF-8 character set. Strings longer than 1000 characters cannot be
    searched for in a query."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataStringValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataStringValue.subclass:
            return MetadataStringValue.subclass(*args_, **kwargs_)
        else:
            return MetadataStringValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataStringValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataStringValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataStringValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataStringValue'):
        super(MetadataStringValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataStringValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataStringValue', fromsubclass_=False, pretty_print=True):
        super(MetadataStringValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataStringValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataStringValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataStringValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataStringValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        super(MetadataStringValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataStringValue


class MetadataNumberValue(MetadataTypedValue):
    """A signed 8-byte integer."""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataNumberValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataNumberValue.subclass:
            return MetadataNumberValue.subclass(*args_, **kwargs_)
        else:
            return MetadataNumberValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataNumberValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataNumberValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataNumberValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataNumberValue'):
        super(MetadataNumberValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataNumberValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataNumberValue', fromsubclass_=False, pretty_print=True):
        super(MetadataNumberValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_integer(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataNumberValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataNumberValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataNumberValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%d,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataNumberValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataNumberValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataNumberValue


class MetadataBooleanValue(MetadataTypedValue):
    """One of: 1, 0, true, false"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataBooleanValue, self).__init__()
        self.Value = Value
    def factory(*args_, **kwargs_):
        if MetadataBooleanValue.subclass:
            return MetadataBooleanValue.subclass(*args_, **kwargs_)
        else:
            return MetadataBooleanValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataBooleanValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataBooleanValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataBooleanValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataBooleanValue'):
        super(MetadataBooleanValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataBooleanValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataBooleanValue', fromsubclass_=False, pretty_print=True):
        super(MetadataBooleanValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_boolean(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataBooleanValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataBooleanValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataBooleanValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % self.Value)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataBooleanValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'Value')
            self.Value = ival_
        super(MetadataBooleanValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataBooleanValue


class MetadataDateTimeValue(MetadataTypedValue):
    """UTC format. For example 2012-06-18T12:00:00-05:00"""
    subclass = None
    superclass = MetadataTypedValue
    def __init__(self, Value=None):
        self.original_tagname_ = None
        super(MetadataDateTimeValue, self).__init__()
        if isinstance(Value, basestring):
            initvalue_ = datetime_.datetime.strptime(Value, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Value
        self.Value = initvalue_
    def factory(*args_, **kwargs_):
        if MetadataDateTimeValue.subclass:
            return MetadataDateTimeValue.subclass(*args_, **kwargs_)
        else:
            return MetadataDateTimeValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def hasContent_(self):
        if (
            self.Value is not None or
            super(MetadataDateTimeValue, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataDateTimeValue', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataDateTimeValue'):
        super(MetadataDateTimeValue, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataDateTimeValue')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataDateTimeValue', fromsubclass_=False, pretty_print=True):
        super(MetadataDateTimeValue, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_datetime(self.Value, input_name='Value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='MetadataDateTimeValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataDateTimeValue, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataDateTimeValue, self).exportLiteralChildren(outfile, level, name_)
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.Value, input_name='Value'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataDateTimeValue, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Value':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Value = dval_
        super(MetadataDateTimeValue, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataDateTimeValue


class MetadataType(ResourceType):
    """User-defined metadata associated with with an object."""
    subclass = None
    superclass = ResourceType
    def __init__(self, MetadataEntry=None):
        self.original_tagname_ = None
        super(MetadataType, self).__init__()
        if MetadataEntry is None:
            self.MetadataEntry = []
        else:
            self.MetadataEntry = MetadataEntry
    def factory(*args_, **kwargs_):
        if MetadataType.subclass:
            return MetadataType.subclass(*args_, **kwargs_)
        else:
            return MetadataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_MetadataEntry(self): return self.MetadataEntry
    def set_MetadataEntry(self, MetadataEntry): self.MetadataEntry = MetadataEntry
    def add_MetadataEntry(self, value): self.MetadataEntry.append(value)
    def insert_MetadataEntry_at(self, index, value): self.MetadataEntry.insert(index, value)
    def replace_MetadataEntry_at(self, index, value): self.MetadataEntry[index] = value
    def hasContent_(self):
        if (
            self.MetadataEntry or
            super(MetadataType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataType'):
        super(MetadataType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataType', fromsubclass_=False, pretty_print=True):
        super(MetadataType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MetadataEntry_ in self.MetadataEntry:
            MetadataEntry_.export(outfile, level, namespace_, name_='MetadataEntry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('MetadataEntry=[\n')
        level += 1
        for MetadataEntry_ in self.MetadataEntry:
            showIndent(outfile, level)
            outfile.write('model_.MetadataEntryType(\n')
            MetadataEntry_.exportLiteral(outfile, level, name_='MetadataEntryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'MetadataEntry':
            obj_ = MetadataEntryType.factory()
            obj_.build(child_)
            self.MetadataEntry.append(obj_)
            obj_.original_tagname_ = 'MetadataEntry'
        super(MetadataType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataType


class MetadataValueType(ResourceType):
    subclass = None
    superclass = ResourceType
    def __init__(self, Domain=None, Value=None, TypedValue=None):
        self.original_tagname_ = None
        super(MetadataValueType, self).__init__()
        self.Domain = Domain
        self.Value = Value
        self.TypedValue = TypedValue
    def factory(*args_, **kwargs_):
        if MetadataValueType.subclass:
            return MetadataValueType.subclass(*args_, **kwargs_)
        else:
            return MetadataValueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain(self): return self.Domain
    def set_Domain(self, Domain): self.Domain = Domain
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def get_TypedValue(self): return self.TypedValue
    def set_TypedValue(self, TypedValue): self.TypedValue = TypedValue
    def hasContent_(self):
        if (
            self.Domain is not None or
            self.Value is not None or
            self.TypedValue is not None or
            super(MetadataValueType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetadataValueType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetadataValueType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetadataValueType'):
        super(MetadataValueType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MetadataValueType')
    def exportChildren(self, outfile, level, namespace_='', name_='MetadataValueType', fromsubclass_=False, pretty_print=True):
        super(MetadataValueType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain is not None:
            self.Domain.export(outfile, level, namespace_, name_='Domain', pretty_print=pretty_print)
        if self.Value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.Value).encode(ExternalEncoding), input_name='Value'), namespace_, eol_))
        if self.TypedValue is not None:
            self.TypedValue.export(outfile, level, namespace_, name_='TypedValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MetadataValueType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(MetadataValueType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MetadataValueType, self).exportLiteralChildren(outfile, level, name_)
        if self.Domain is not None:
            showIndent(outfile, level)
            outfile.write('Domain=model_.MetadataDomainTagType(\n')
            self.Domain.exportLiteral(outfile, level, name_='Domain')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Value is not None:
            showIndent(outfile, level)
            outfile.write('Value=%s,\n' % quote_python(self.Value).encode(ExternalEncoding))
        if self.MetadataTypedValue is not None:
            showIndent(outfile, level)
            outfile.write('MetadataTypedValue=model_.MetadataTypedValue(\n')
            self.MetadataTypedValue.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(MetadataValueType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain':
            obj_ = MetadataDomainTagType.factory()
            obj_.build(child_)
            self.Domain = obj_
            obj_.original_tagname_ = 'Domain'
        elif nodeName_ == 'Value':
            Value_ = child_.text
            Value_ = self.gds_validate_string(Value_, node, 'Value')
            self.Value = Value_
        elif nodeName_ == 'TypedValue':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <TypedValue> element')
            self.TypedValue = obj_
            obj_.original_tagname_ = 'TypedValue'
        super(MetadataValueType, self).buildChildren(child_, node, nodeName_, True)
# end class MetadataValueType


class FileUploadParamsType(VCloudExtensibleType):
    """5.1 Parameters for initializing file upload session. create Size in
    bytes of the file which will be uploaded. true"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, fileSize=None):
        self.original_tagname_ = None
        super(FileUploadParamsType, self).__init__(VCloudExtension, )
        self.fileSize = _cast(int, fileSize)
    def factory(*args_, **kwargs_):
        if FileUploadParamsType.subclass:
            return FileUploadParamsType.subclass(*args_, **kwargs_)
        else:
            return FileUploadParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_fileSize(self): return self.fileSize
    def set_fileSize(self, fileSize): self.fileSize = fileSize
    def hasContent_(self):
        if (
            super(FileUploadParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadParamsType'):
        super(FileUploadParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadParamsType')
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            outfile.write(' fileSize="%s"' % self.gds_format_integer(self.fileSize, input_name='fileSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadParamsType', fromsubclass_=False, pretty_print=True):
        super(FileUploadParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fileSize is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            showIndent(outfile, level)
            outfile.write('fileSize=%d,\n' % (self.fileSize,))
        super(FileUploadParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadParamsType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fileSize', node)
        if value is not None and 'fileSize' not in already_processed:
            already_processed.add('fileSize')
            try:
                self.fileSize = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(FileUploadParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FileUploadParamsType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FileUploadParamsType


class FileUploadSocketType(VCloudExtensibleType):
    """5.1 Parameters for initiating file upload. none URL where the file
    must be uploaded. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, uploadLocation=None, Task=None):
        self.original_tagname_ = None
        super(FileUploadSocketType, self).__init__(VCloudExtension, )
        self.uploadLocation = _cast(None, uploadLocation)
        self.Task = Task
    def factory(*args_, **kwargs_):
        if FileUploadSocketType.subclass:
            return FileUploadSocketType.subclass(*args_, **kwargs_)
        else:
            return FileUploadSocketType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def get_uploadLocation(self): return self.uploadLocation
    def set_uploadLocation(self, uploadLocation): self.uploadLocation = uploadLocation
    def hasContent_(self):
        if (
            self.Task is not None or
            super(FileUploadSocketType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileUploadSocketType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileUploadSocketType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileUploadSocketType'):
        super(FileUploadSocketType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileUploadSocketType')
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            outfile.write(' uploadLocation=%s' % (self.gds_format_string(quote_attrib(self.uploadLocation).encode(ExternalEncoding), input_name='uploadLocation'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='FileUploadSocketType', fromsubclass_=False, pretty_print=True):
        super(FileUploadSocketType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Task is not None:
            self.Task.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileUploadSocketType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.uploadLocation is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            showIndent(outfile, level)
            outfile.write('uploadLocation="%s",\n' % (self.uploadLocation,))
        super(FileUploadSocketType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileUploadSocketType, self).exportLiteralChildren(outfile, level, name_)
        if self.Task is not None:
            showIndent(outfile, level)
            outfile.write('Task=model_.TaskType(\n')
            self.Task.exportLiteral(outfile, level, name_='Task')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('uploadLocation', node)
        if value is not None and 'uploadLocation' not in already_processed:
            already_processed.add('uploadLocation')
            self.uploadLocation = value
        super(FileUploadSocketType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task = obj_
            obj_.original_tagname_ = 'Task'
        super(FileUploadSocketType, self).buildChildren(child_, node, nodeName_, True)
# end class FileUploadSocketType


class TaskOperationListType(ResourceType):
    """List of operation names. 1.5"""
    subclass = None
    superclass = ResourceType
    def __init__(self, Operation=None):
        self.original_tagname_ = None
        super(TaskOperationListType, self).__init__()
        if Operation is None:
            self.Operation = []
        else:
            self.Operation = Operation
    def factory(*args_, **kwargs_):
        if TaskOperationListType.subclass:
            return TaskOperationListType.subclass(*args_, **kwargs_)
        else:
            return TaskOperationListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Operation(self): return self.Operation
    def set_Operation(self, Operation): self.Operation = Operation
    def add_Operation(self, value): self.Operation.append(value)
    def insert_Operation_at(self, index, value): self.Operation.insert(index, value)
    def replace_Operation_at(self, index, value): self.Operation[index] = value
    def hasContent_(self):
        if (
            self.Operation or
            super(TaskOperationListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskOperationListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskOperationListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskOperationListType'):
        super(TaskOperationListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskOperationListType')
    def exportChildren(self, outfile, level, namespace_='', name_='TaskOperationListType', fromsubclass_=False, pretty_print=True):
        super(TaskOperationListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Operation_ in self.Operation:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOperation>%s</%sOperation>%s' % (namespace_, self.gds_format_string(quote_xml(Operation_).encode(ExternalEncoding), input_name='Operation'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskOperationListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TaskOperationListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskOperationListType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Operation=[\n')
        level += 1
        for Operation_ in self.Operation:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(Operation_).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TaskOperationListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Operation':
            Operation_ = child_.text
            Operation_ = self.gds_validate_string(Operation_, node, 'Operation')
            self.Operation.append(Operation_)
        super(TaskOperationListType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskOperationListType


class EntityType(IdentifiableResourceType):
    """0.9 Basic entity type in the vCloud object model. Includes a name,
    an optional description, and an optional list of links. always
    The name of the entity. true"""
    subclass = None
    superclass = IdentifiableResourceType
    def __init__(self, operationKey=None, id=None, name=None, Description=None, Tasks=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityType, self).__init__(operationKey, id, extensiontype_, )
        self.name = _cast(None, name)
        self.Description = Description
        self.Tasks = Tasks
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityType.subclass:
            return EntityType.subclass(*args_, **kwargs_)
        else:
            return EntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Tasks(self): return self.Tasks
    def set_Tasks(self, Tasks): self.Tasks = Tasks
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Description is not None or
            self.Tasks is not None or
            super(EntityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityType'):
        super(EntityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityType')
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityType', fromsubclass_=False, pretty_print=True):
        super(EntityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.Description).encode(ExternalEncoding), input_name='Description'), namespace_, eol_))
        if self.Tasks is not None:
            self.Tasks.export(outfile, level, namespace_, name_='Tasks', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=%s,\n' % quote_python(self.Description).encode(ExternalEncoding))
        if self.Tasks is not None:
            showIndent(outfile, level)
            outfile.write('Tasks=model_.TasksInProgressType(\n')
            self.Tasks.exportLiteral(outfile, level, name_='Tasks')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            Description_ = child_.text
            Description_ = self.gds_validate_string(Description_, node, 'Description')
            self.Description = Description_
        elif nodeName_ == 'Tasks':
            obj_ = TasksInProgressType.factory()
            obj_.build(child_)
            self.Tasks = obj_
            obj_.original_tagname_ = 'Tasks'
        super(EntityType, self).buildChildren(child_, node, nodeName_, True)
# end class EntityType


class EntityReferenceType(VCloudExtensibleType):
    """1.5 A reference to a vCloud entity. none The object identifier,
    expressed in URN format. The value of this attribute uniquely
    identifies the object, persists for the life of the object, and
    is never reused. This context-free identifier can apply to any
    object in any system. truealways The type of the the referenced
    object. falsealways The name of the referenced object. false"""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, extensiontype_=None):
        self.original_tagname_ = None
        super(EntityReferenceType, self).__init__(VCloudExtension, extensiontype_, )
        self.type_ = _cast(None, type_)
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if EntityReferenceType.subclass:
            return EntityReferenceType.subclass(*args_, **kwargs_)
        else:
            return EntityReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            super(EntityReferenceType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityReferenceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityReferenceType'):
        super(EntityReferenceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityReferenceType')
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='EntityReferenceType', fromsubclass_=False, pretty_print=True):
        super(EntityReferenceType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityReferenceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(EntityReferenceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityReferenceType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(EntityReferenceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityReferenceType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityReferenceType


class EntityLinkType(EntityReferenceType):
    """1.5 Extends EntityReference type by adding relation attribute.
    always Defines the relationship of the link to the object that
    contains it. A relationship can be the name of an operation on
    the object, a reference to a contained or containing object, or
    a reference to an alternate representation of the object. The
    relationship value implies the HTTP verb to use when you use the
    link's href value as a request URL. true"""
    subclass = None
    superclass = EntityReferenceType
    def __init__(self, VCloudExtension=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(EntityLinkType, self).__init__(VCloudExtension, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if EntityLinkType.subclass:
            return EntityLinkType.subclass(*args_, **kwargs_)
        else:
            return EntityLinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(EntityLinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EntityLinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EntityLinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EntityLinkType'):
        super(EntityLinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EntityLinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='EntityLinkType', fromsubclass_=False, pretty_print=True):
        super(EntityLinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EntityLinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(EntityLinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EntityLinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(EntityLinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EntityLinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EntityLinkType


class TasksInProgressType(VCloudExtensibleType):
    """0.9 A list of queued, running, or recently completed tasks."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Task=None):
        self.original_tagname_ = None
        super(TasksInProgressType, self).__init__(VCloudExtension, )
        if Task is None:
            self.Task = []
        else:
            self.Task = Task
    def factory(*args_, **kwargs_):
        if TasksInProgressType.subclass:
            return TasksInProgressType.subclass(*args_, **kwargs_)
        else:
            return TasksInProgressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Task(self): return self.Task
    def set_Task(self, Task): self.Task = Task
    def add_Task(self, value): self.Task.append(value)
    def insert_Task_at(self, index, value): self.Task.insert(index, value)
    def replace_Task_at(self, index, value): self.Task[index] = value
    def hasContent_(self):
        if (
            self.Task or
            super(TasksInProgressType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TasksInProgressType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TasksInProgressType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TasksInProgressType'):
        super(TasksInProgressType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TasksInProgressType')
    def exportChildren(self, outfile, level, namespace_='', name_='TasksInProgressType', fromsubclass_=False, pretty_print=True):
        super(TasksInProgressType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Task_ in self.Task:
            Task_.export(outfile, level, namespace_, name_='Task', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TasksInProgressType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TasksInProgressType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TasksInProgressType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Task=[\n')
        level += 1
        for Task_ in self.Task:
            showIndent(outfile, level)
            outfile.write('model_.TaskType(\n')
            Task_.exportLiteral(outfile, level, name_='TaskType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TasksInProgressType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Task':
            obj_ = TaskType.factory()
            obj_.build(child_)
            self.Task.append(obj_)
            obj_.original_tagname_ = 'Task'
        super(TasksInProgressType, self).buildChildren(child_, node, nodeName_, True)
# end class TasksInProgressType


class ResourceEntityType(EntityType):
    """0.9 Base type that represents a resource entity such as a vApp
    template or virtual media. none Creation status of the resource
    entity. false"""
    subclass = None
    superclass = EntityType
    def __init__(self, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, Files=None, extensiontype_=None):
        self.original_tagname_ = None
        super(ResourceEntityType, self).__init__(operationKey, id, name, Description, Tasks, extensiontype_, )
        self.status = _cast(int, status)
        self.Files = Files
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ResourceEntityType.subclass:
            return ResourceEntityType.subclass(*args_, **kwargs_)
        else:
            return ResourceEntityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Files(self): return self.Files
    def set_Files(self, Files): self.Files = Files
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Files is not None or
            super(ResourceEntityType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceEntityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceEntityType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceEntityType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceEntityType'):
        super(ResourceEntityType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceEntityType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status="%s"' % self.gds_format_integer(self.status, input_name='status'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceEntityType', fromsubclass_=False, pretty_print=True):
        super(ResourceEntityType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Files is not None:
            self.Files.export(outfile, level, namespace_, name_='Files', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceEntityType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status=%d,\n' % (self.status,))
        super(ResourceEntityType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceEntityType, self).exportLiteralChildren(outfile, level, name_)
        if self.Files is not None:
            showIndent(outfile, level)
            outfile.write('Files=model_.FilesListType(\n')
            self.Files.exportLiteral(outfile, level, name_='Files')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            try:
                self.status = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ResourceEntityType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Files':
            obj_ = FilesListType.factory()
            obj_.build(child_)
            self.Files = obj_
            obj_.original_tagname_ = 'Files'
        super(ResourceEntityType, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceEntityType


class FilesListType(VCloudExtensibleType):
    """0.9 Represents a list of files to be transferred (uploaded or
    downloaded)."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, File=None):
        self.original_tagname_ = None
        super(FilesListType, self).__init__(VCloudExtension, )
        if File is None:
            self.File = []
        else:
            self.File = File
    def factory(*args_, **kwargs_):
        if FilesListType.subclass:
            return FilesListType.subclass(*args_, **kwargs_)
        else:
            return FilesListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def hasContent_(self):
        if (
            self.File or
            super(FilesListType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FilesListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FilesListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FilesListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FilesListType'):
        super(FilesListType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FilesListType')
    def exportChildren(self, outfile, level, namespace_='', name_='FilesListType', fromsubclass_=False, pretty_print=True):
        super(FilesListType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for File_ in self.File:
            File_.export(outfile, level, namespace_, name_='File', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FilesListType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FilesListType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FilesListType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('File=[\n')
        level += 1
        for File_ in self.File:
            showIndent(outfile, level)
            outfile.write('model_.FileType(\n')
            File_.exportLiteral(outfile, level, name_='FileType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(FilesListType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = FileType.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
        super(FilesListType, self).buildChildren(child_, node, nodeName_, True)
# end class FilesListType


class FileType(EntityType):
    """0.9 Represents a file to be transferred (uploaded or downloaded).
    none File size in bytes. falsenone Bytes that have been
    transferred. falsenone The checksum of the file. false"""
    subclass = None
    superclass = EntityType
    def __init__(self, operationKey=None, id=None, name=None, Description=None, Tasks=None, checksum=None, bytesTransferred=None, size=None):
        self.original_tagname_ = None
        super(FileType, self).__init__(operationKey, id, name, Description, Tasks, )
        self.checksum = _cast(None, checksum)
        self.bytesTransferred = _cast(int, bytesTransferred)
        self.size = _cast(int, size)
    def factory(*args_, **kwargs_):
        if FileType.subclass:
            return FileType.subclass(*args_, **kwargs_)
        else:
            return FileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_checksum(self): return self.checksum
    def set_checksum(self, checksum): self.checksum = checksum
    def get_bytesTransferred(self): return self.bytesTransferred
    def set_bytesTransferred(self, bytesTransferred): self.bytesTransferred = bytesTransferred
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def hasContent_(self):
        if (
            super(FileType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='FileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FileType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='FileType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FileType'):
        super(FileType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FileType')
        if self.checksum is not None and 'checksum' not in already_processed:
            already_processed.add('checksum')
            outfile.write(' checksum=%s' % (self.gds_format_string(quote_attrib(self.checksum).encode(ExternalEncoding), input_name='checksum'), ))
        if self.bytesTransferred is not None and 'bytesTransferred' not in already_processed:
            already_processed.add('bytesTransferred')
            outfile.write(' bytesTransferred="%s"' % self.gds_format_integer(self.bytesTransferred, input_name='bytesTransferred'))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
    def exportChildren(self, outfile, level, namespace_='', name_='FileType', fromsubclass_=False, pretty_print=True):
        super(FileType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='FileType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.checksum is not None and 'checksum' not in already_processed:
            already_processed.add('checksum')
            showIndent(outfile, level)
            outfile.write('checksum="%s",\n' % (self.checksum,))
        if self.bytesTransferred is not None and 'bytesTransferred' not in already_processed:
            already_processed.add('bytesTransferred')
            showIndent(outfile, level)
            outfile.write('bytesTransferred=%d,\n' % (self.bytesTransferred,))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % (self.size,))
        super(FileType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FileType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('checksum', node)
        if value is not None and 'checksum' not in already_processed:
            already_processed.add('checksum')
            self.checksum = value
        value = find_attr_value_('bytesTransferred', node)
        if value is not None and 'bytesTransferred' not in already_processed:
            already_processed.add('bytesTransferred')
            try:
                self.bytesTransferred = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(FileType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(FileType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class FileType


class EnvelopeType(GeneratedsSuper):
    """Root OVF descriptor type"""
    subclass = None
    superclass = None
    def __init__(self, lang='en-US', References=None, Section=None, Content=None, Strings=None):
        self.original_tagname_ = None
        self.lang = _cast(None, lang)
        self.References = References
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
        self.Content = Content
        if Strings is None:
            self.Strings = []
        else:
            self.Strings = Strings
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if EnvelopeType.subclass:
            return EnvelopeType.subclass(*args_, **kwargs_)
        else:
            return EnvelopeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_References(self): return self.References
    def set_References(self, References): self.References = References
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section_at(self, index, value): self.Section.insert(index, value)
    def replace_Section_at(self, index, value): self.Section[index] = value
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def get_Strings(self): return self.Strings
    def set_Strings(self, Strings): self.Strings = Strings
    def add_Strings(self, value): self.Strings.append(value)
    def insert_Strings_at(self, index, value): self.Strings.insert(index, value)
    def replace_Strings_at(self, index, value): self.Strings[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.References is not None or
            self.Section or
            self.Content is not None or
            self.Strings
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EnvelopeType', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EnvelopeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EnvelopeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EnvelopeType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' lang=%s' % (self.gds_format_string(quote_attrib(self.lang).encode(ExternalEncoding), input_name='lang'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='EnvelopeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.References is not None:
            self.References.export(outfile, level, namespace_, name_='References', pretty_print=pretty_print)
        for Section_ in self.Section:
            Section_.export(outfile, level, namespace_='ovf:', name_='Section', pretty_print=pretty_print)
        if self.Content is not None:
            self.Content.export(outfile, level, namespace_='ovf:', name_='Content', pretty_print=pretty_print)
        for Strings_ in self.Strings:
            Strings_.export(outfile, level, namespace_, name_='Strings', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EnvelopeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            showIndent(outfile, level)
            outfile.write('lang="%s",\n' % (self.lang,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.References is not None:
            showIndent(outfile, level)
            outfile.write('References=model_.References_Type(\n')
            self.References.exportLiteral(outfile, level, name_='References')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.Section(\n')
            Section_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Content is not None:
            showIndent(outfile, level)
            outfile.write('Content=model_.Content(\n')
            self.Content.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Strings=[\n')
        level += 1
        for Strings_ in self.Strings:
            showIndent(outfile, level)
            outfile.write('model_.Strings_Type(\n')
            Strings_.exportLiteral(outfile, level, name_='Strings_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'References':
            obj_ = References_Type.factory()
            obj_.build(child_)
            self.References = obj_
            obj_.original_tagname_ = 'References'
        elif nodeName_ == 'ShadowVMReferences':
            obj_ = ReferencesType.factory()
            obj_.build(child_)
            self.References = obj_
            obj_.original_tagname_ = 'ShadowVMReferences'
        elif nodeName_ == 'Section':
            class_obj_ = self.get_class_obj_(child_, Section_Type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'Section'
        elif nodeName_ == 'CustomizationSection':
            obj_ = CustomizationSectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'CustomizationSection'
        elif nodeName_ == 'AnnotationSection':
            obj_ = AnnotationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'AnnotationSection'
        elif nodeName_ == 'ProductSection':
            obj_ = ProductSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ProductSection'
        elif nodeName_ == 'NetworkSection':
            obj_ = NetworkSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'NetworkSection'
        elif nodeName_ == 'DiskSection':
            obj_ = DiskSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DiskSection'
        elif nodeName_ == 'OperatingSystemSection':
            obj_ = OperatingSystemSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'OperatingSystemSection'
        elif nodeName_ == 'EulaSection':
            obj_ = EulaSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'EulaSection'
        elif nodeName_ == 'VirtualHardwareSection':
            obj_ = VirtualHardwareSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'VirtualHardwareSection'
        elif nodeName_ == 'ResourceAllocationSection':
            obj_ = ResourceAllocationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ResourceAllocationSection'
        elif nodeName_ == 'InstallSection':
            obj_ = InstallSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'InstallSection'
        elif nodeName_ == 'StartupSection':
            obj_ = StartupSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'StartupSection'
        elif nodeName_ == 'DeploymentOptionSection':
            obj_ = DeploymentOptionSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DeploymentOptionSection'
        elif nodeName_ == 'Content':
            class_obj_ = self.get_class_obj_(child_, Content_Type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Content = obj_
            obj_.original_tagname_ = 'Content'
        elif nodeName_ == 'VirtualSystem':
            obj_ = VirtualSystem_Type.factory()
            obj_.build(child_)
            self.Content = obj_
            obj_.original_tagname_ = 'VirtualSystem'
        elif nodeName_ == 'VirtualSystemCollection':
            obj_ = VirtualSystemCollection_Type.factory()
            obj_.build(child_)
            self.Content = obj_
            obj_.original_tagname_ = 'VirtualSystemCollection'
        elif nodeName_ == 'Strings':
            obj_ = Strings_Type.factory()
            obj_.build(child_)
            self.Strings.append(obj_)
            obj_.original_tagname_ = 'Strings'
# end class EnvelopeType


class References_Type(GeneratedsSuper):
    """Type for list of external resources"""
    subclass = None
    superclass = None
    def __init__(self, File=None, anytypeobjs_=None):
        self.original_tagname_ = None
        if File is None:
            self.File = []
        else:
            self.File = File
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if References_Type.subclass:
            return References_Type.subclass(*args_, **kwargs_)
        else:
            return References_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_File(self): return self.File
    def set_File(self, File): self.File = File
    def add_File(self, value): self.File.append(value)
    def insert_File_at(self, index, value): self.File.insert(index, value)
    def replace_File_at(self, index, value): self.File[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.File or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='References_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='References_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='References_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='References_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='References_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for File_ in self.File:
            File_.export(outfile, level, namespace_, name_='File', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='References_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('File=[\n')
        level += 1
        for File_ in self.File:
            showIndent(outfile, level)
            outfile.write('model_.File_Type(\n')
            File_.exportLiteral(outfile, level, name_='File_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'File':
            obj_ = File_Type.factory()
            obj_.build(child_)
            self.File.append(obj_)
            obj_.original_tagname_ = 'File'
        else:
            obj_ = self.gds_build_any(child_, 'References_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class References_Type


class File_Type(GeneratedsSuper):
    """Type for an external reference to a resourceReference key used in
    other parts of the packageLocation of external resourceSize in
    bytes of the files (if known)Compression type (gzip, bzip2, or
    none if empty or not specified)Chunk size (except for last
    chunk)"""
    subclass = None
    superclass = None
    def __init__(self, compression='', href=None, chunkSize=None, id=None, size=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.compression = _cast(None, compression)
        self.href = _cast(None, href)
        self.chunkSize = _cast(int, chunkSize)
        self.id = _cast(None, id)
        self.size = _cast(int, size)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if File_Type.subclass:
            return File_Type.subclass(*args_, **kwargs_)
        else:
            return File_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_compression(self): return self.compression
    def set_compression(self, compression): self.compression = compression
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_chunkSize(self): return self.chunkSize
    def set_chunkSize(self, chunkSize): self.chunkSize = chunkSize
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_size(self): return self.size
    def set_size(self, size): self.size = size
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='File_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='File_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='File_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='File_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.compression is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            outfile.write(' compression=%s' % (self.gds_format_string(quote_attrib(self.compression).encode(ExternalEncoding), input_name='compression'), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.chunkSize is not None and 'chunkSize' not in already_processed:
            already_processed.add('chunkSize')
            outfile.write(' chunkSize="%s"' % self.gds_format_integer(self.chunkSize, input_name='chunkSize'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
    def exportChildren(self, outfile, level, namespace_='', name_='File_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='File_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.compression is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            showIndent(outfile, level)
            outfile.write('compression="%s",\n' % (self.compression,))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.chunkSize is not None and 'chunkSize' not in already_processed:
            already_processed.add('chunkSize')
            showIndent(outfile, level)
            outfile.write('chunkSize=%d,\n' % (self.chunkSize,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % (self.size,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('compression', node)
        if value is not None and 'compression' not in already_processed:
            already_processed.add('compression')
            self.compression = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('chunkSize', node)
        if value is not None and 'chunkSize' not in already_processed:
            already_processed.add('chunkSize')
            try:
                self.chunkSize = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'File_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class File_Type


class Content_Type(GeneratedsSuper):
    """Base class for content"""
    subclass = None
    superclass = None
    def __init__(self, id=None, Info=None, Name=None, Section=None, extensiontype_=None):
        self.original_tagname_ = None
        self.id = _cast(None, id)
        self.Info = Info
        self.Name = Name
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Content_Type.subclass:
            return Content_Type.subclass(*args_, **kwargs_)
        else:
            return Content_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Info(self): return self.Info
    def set_Info(self, Info): self.Info = Info
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section_at(self, index, value): self.Section.insert(index, value)
    def replace_Section_at(self, index, value): self.Section[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Info is not None or
            self.Name is not None or
            self.Section
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Content_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Content_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Content_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Content_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Content_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Info is not None:
            self.Info.export(outfile, level, namespace_, name_='Info', pretty_print=pretty_print)
        if self.Name is not None:
            self.Name.export(outfile, level, namespace_, name_='Name', pretty_print=pretty_print)
        for Section_ in self.Section:
            Section_.export(outfile, level, namespace_='ovf:', name_='Section', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Content_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Info is not None:
            showIndent(outfile, level)
            outfile.write('Info=model_.Msg_Type(\n')
            self.Info.exportLiteral(outfile, level, name_='Info')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Name is not None:
            showIndent(outfile, level)
            outfile.write('Name=model_.Msg_Type(\n')
            self.Name.exportLiteral(outfile, level, name_='Name')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.Section(\n')
            Section_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Info':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Info = obj_
            obj_.original_tagname_ = 'Info'
        elif nodeName_ == 'Name':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Name = obj_
            obj_.original_tagname_ = 'Name'
        elif nodeName_ == 'Section':
            class_obj_ = self.get_class_obj_(child_, Section_Type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'Section'
        elif nodeName_ == 'CustomizationSection':
            obj_ = CustomizationSectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'CustomizationSection'
        elif nodeName_ == 'AnnotationSection':
            obj_ = AnnotationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'AnnotationSection'
        elif nodeName_ == 'ProductSection':
            obj_ = ProductSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ProductSection'
        elif nodeName_ == 'NetworkSection':
            obj_ = NetworkSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'NetworkSection'
        elif nodeName_ == 'DiskSection':
            obj_ = DiskSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DiskSection'
        elif nodeName_ == 'OperatingSystemSection':
            obj_ = OperatingSystemSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'OperatingSystemSection'
        elif nodeName_ == 'EulaSection':
            obj_ = EulaSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'EulaSection'
        elif nodeName_ == 'VirtualHardwareSection':
            obj_ = VirtualHardwareSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'VirtualHardwareSection'
        elif nodeName_ == 'ResourceAllocationSection':
            obj_ = ResourceAllocationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ResourceAllocationSection'
        elif nodeName_ == 'InstallSection':
            obj_ = InstallSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'InstallSection'
        elif nodeName_ == 'StartupSection':
            obj_ = StartupSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'StartupSection'
        elif nodeName_ == 'DeploymentOptionSection':
            obj_ = DeploymentOptionSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DeploymentOptionSection'
# end class Content_Type


class VirtualSystem_Type(Content_Type):
    """Content describing a virtual system"""
    subclass = None
    superclass = Content_Type
    def __init__(self, id=None, Info=None, Name=None, Section=None):
        self.original_tagname_ = None
        super(VirtualSystem_Type, self).__init__(id, Info, Name, Section, )
    def factory(*args_, **kwargs_):
        if VirtualSystem_Type.subclass:
            return VirtualSystem_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualSystem_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(VirtualSystem_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtualSystem_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualSystem_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VirtualSystem_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtualSystem_Type'):
        super(VirtualSystem_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualSystem_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='VirtualSystem_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualSystem_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VirtualSystem_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VirtualSystem_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VirtualSystem_Type, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VirtualSystem_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VirtualSystem_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VirtualSystem_Type


class VirtualSystemCollection_Type(Content_Type):
    """A collection of Content."""
    subclass = None
    superclass = Content_Type
    def __init__(self, id=None, Info=None, Name=None, Section=None, Content=None):
        self.original_tagname_ = None
        super(VirtualSystemCollection_Type, self).__init__(id, Info, Name, Section, )
        if Content is None:
            self.Content = []
        else:
            self.Content = Content
    def factory(*args_, **kwargs_):
        if VirtualSystemCollection_Type.subclass:
            return VirtualSystemCollection_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualSystemCollection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Content(self): return self.Content
    def set_Content(self, Content): self.Content = Content
    def add_Content(self, value): self.Content.append(value)
    def insert_Content_at(self, index, value): self.Content.insert(index, value)
    def replace_Content_at(self, index, value): self.Content[index] = value
    def hasContent_(self):
        if (
            self.Content or
            super(VirtualSystemCollection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtualSystemCollection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualSystemCollection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VirtualSystemCollection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtualSystemCollection_Type'):
        super(VirtualSystemCollection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualSystemCollection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='VirtualSystemCollection_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualSystemCollection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Content_ in self.Content:
            Content_.export(outfile, level, namespace_='ovf:', name_='Content', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VirtualSystemCollection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VirtualSystemCollection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VirtualSystemCollection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Content=[\n')
        level += 1
        for Content_ in self.Content:
            showIndent(outfile, level)
            outfile.write('model_.Content(\n')
            Content_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VirtualSystemCollection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Content':
            class_obj_ = self.get_class_obj_(child_, Content_Type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Content.append(obj_)
            obj_.original_tagname_ = 'Content'
        elif nodeName_ == 'VirtualSystem':
            obj_ = VirtualSystem_Type.factory()
            obj_.build(child_)
            self.Content.append(obj_)
            obj_.original_tagname_ = 'VirtualSystem'
        elif nodeName_ == 'VirtualSystemCollection':
            obj_ = VirtualSystemCollection_Type.factory()
            obj_.build(child_)
            self.Content.append(obj_)
            obj_.original_tagname_ = 'VirtualSystemCollection'
        super(VirtualSystemCollection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class VirtualSystemCollection_Type


class Strings_Type(GeneratedsSuper):
    """Type for string resource bundleLocale for this string resource
    bundleReference to external resource bundle"""
    subclass = None
    superclass = None
    def __init__(self, lang=None, fileRef=None, Msg=None):
        self.original_tagname_ = None
        self.lang = _cast(None, lang)
        self.fileRef = _cast(None, fileRef)
        if Msg is None:
            self.Msg = []
        else:
            self.Msg = Msg
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if Strings_Type.subclass:
            return Strings_Type.subclass(*args_, **kwargs_)
        else:
            return Strings_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Msg(self): return self.Msg
    def set_Msg(self, Msg): self.Msg = Msg
    def add_Msg(self, value): self.Msg.append(value)
    def insert_Msg_at(self, index, value): self.Msg.insert(index, value)
    def replace_Msg_at(self, index, value): self.Msg[index] = value
    def get_lang(self): return self.lang
    def set_lang(self, lang): self.lang = lang
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Msg
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Strings_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Strings_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Strings_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Strings_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            outfile.write(' lang=%s' % (self.gds_format_string(quote_attrib(self.lang).encode(ExternalEncoding), input_name='lang'), ))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_format_string(quote_attrib(self.fileRef).encode(ExternalEncoding), input_name='fileRef'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Strings_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Msg_ in self.Msg:
            Msg_.export(outfile, level, namespace_, name_='Msg', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Strings_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.lang is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            showIndent(outfile, level)
            outfile.write('lang="%s",\n' % (self.lang,))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            showIndent(outfile, level)
            outfile.write('fileRef="%s",\n' % (self.fileRef,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Msg=[\n')
        level += 1
        for Msg_ in self.Msg:
            showIndent(outfile, level)
            outfile.write('model_.MsgType(\n')
            Msg_.exportLiteral(outfile, level, name_='MsgType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lang', node)
        if value is not None and 'lang' not in already_processed:
            already_processed.add('lang')
            self.lang = value
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Msg':
            obj_ = MsgType.factory()
            obj_.build(child_)
            self.Msg.append(obj_)
            obj_.original_tagname_ = 'Msg'
# end class Strings_Type


class Section_Type(GeneratedsSuper):
    """Base type for Sections, subclassing this is the most common form of
    extensibility. Subtypes define more specific elements."""
    subclass = None
    superclass = None
    def __init__(self, required=None, Info=None, extensiontype_=None):
        self.original_tagname_ = None
        self.required = _cast(bool, required)
        self.Info = Info
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Section_Type.subclass:
            return Section_Type.subclass(*args_, **kwargs_)
        else:
            return Section_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Info(self): return self.Info
    def set_Info(self, Info): self.Info = Info
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.Info is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Section_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Section_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Section_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Section_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Section_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Info is not None:
            self.Info.export(outfile, level, namespace_, name_='Info', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Section_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % (self.required,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Info is not None:
            showIndent(outfile, level)
            outfile.write('Info=model_.Msg_Type(\n')
            self.Info.exportLiteral(outfile, level, name_='Info')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Info':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Info = obj_
            obj_.original_tagname_ = 'Info'
# end class Section_Type


class Msg_Type(GeneratedsSuper):
    """Type for localizable stringDefault string valueIdentifier for lookup
    in string resource bundle for alternate locale"""
    subclass = None
    superclass = None
    def __init__(self, msgid='', valueOf_=None):
        self.original_tagname_ = None
        self.msgid = _cast(None, msgid)
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if Msg_Type.subclass:
            return Msg_Type.subclass(*args_, **kwargs_)
        else:
            return Msg_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_msgid(self): return self.msgid
    def set_msgid(self, msgid): self.msgid = msgid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Msg_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Msg_Type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Msg_Type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Msg_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.msgid is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            outfile.write(' msgid=%s' % (self.gds_format_string(quote_attrib(self.msgid).encode(ExternalEncoding), input_name='msgid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Msg_Type', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Msg_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.msgid is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            showIndent(outfile, level)
            outfile.write('msgid="%s",\n' % (self.msgid,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('msgid', node)
        if value is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            self.msgid = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Msg_Type


class AnnotationSection_Type(Section_Type):
    """User defined annotation"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Annotation=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(AnnotationSection_Type, self).__init__(required, Info, )
        self.Annotation = Annotation
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if AnnotationSection_Type.subclass:
            return AnnotationSection_Type.subclass(*args_, **kwargs_)
        else:
            return AnnotationSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Annotation(self): return self.Annotation
    def set_Annotation(self, Annotation): self.Annotation = Annotation
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Annotation is not None or
            self.anytypeobjs_ or
            super(AnnotationSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AnnotationSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AnnotationSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AnnotationSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AnnotationSection_Type'):
        super(AnnotationSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AnnotationSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='AnnotationSection_Type', fromsubclass_=False, pretty_print=True):
        super(AnnotationSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Annotation is not None:
            self.Annotation.export(outfile, level, namespace_, name_='Annotation', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AnnotationSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AnnotationSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AnnotationSection_Type, self).exportLiteralChildren(outfile, level, name_)
        if self.Annotation is not None:
            showIndent(outfile, level)
            outfile.write('Annotation=model_.Msg_Type(\n')
            self.Annotation.exportLiteral(outfile, level, name_='Annotation')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(AnnotationSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Annotation':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Annotation = obj_
            obj_.original_tagname_ = 'Annotation'
        else:
            obj_ = self.gds_build_any(child_, 'AnnotationSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(AnnotationSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class AnnotationSection_Type


class ProductSection_Type(Section_Type):
    """Product information for a virtual applianceProperties for
    application-level customizationProperty identifier
    prefixProperty identifier suffix"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, instance='', class_='', Product=None, Vendor=None, Version=None, FullVersion=None, ProductUrl=None, VendorUrl=None, AppUrl=None, Icon=None, Category=None, Property=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ProductSection_Type, self).__init__(required, Info, )
        self.instance = _cast(None, instance)
        self.class_ = _cast(None, class_)
        self.Product = Product
        self.Vendor = Vendor
        self.Version = Version
        self.FullVersion = FullVersion
        self.ProductUrl = ProductUrl
        self.VendorUrl = VendorUrl
        self.AppUrl = AppUrl
        if Icon is None:
            self.Icon = []
        else:
            self.Icon = Icon
        if Category is None:
            self.Category = []
        else:
            self.Category = Category
        if Property is None:
            self.Property = []
        else:
            self.Property = Property
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if ProductSection_Type.subclass:
            return ProductSection_Type.subclass(*args_, **kwargs_)
        else:
            return ProductSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Product(self): return self.Product
    def set_Product(self, Product): self.Product = Product
    def get_Vendor(self): return self.Vendor
    def set_Vendor(self, Vendor): self.Vendor = Vendor
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def get_FullVersion(self): return self.FullVersion
    def set_FullVersion(self, FullVersion): self.FullVersion = FullVersion
    def get_ProductUrl(self): return self.ProductUrl
    def set_ProductUrl(self, ProductUrl): self.ProductUrl = ProductUrl
    def get_VendorUrl(self): return self.VendorUrl
    def set_VendorUrl(self, VendorUrl): self.VendorUrl = VendorUrl
    def get_AppUrl(self): return self.AppUrl
    def set_AppUrl(self, AppUrl): self.AppUrl = AppUrl
    def get_Icon(self): return self.Icon
    def set_Icon(self, Icon): self.Icon = Icon
    def add_Icon(self, value): self.Icon.append(value)
    def insert_Icon_at(self, index, value): self.Icon.insert(index, value)
    def replace_Icon_at(self, index, value): self.Icon[index] = value
    def get_Category(self): return self.Category
    def set_Category(self, Category): self.Category = Category
    def add_Category(self, value): self.Category.append(value)
    def insert_Category_at(self, index, value): self.Category.insert(index, value)
    def replace_Category_at(self, index, value): self.Category[index] = value
    def get_Property(self): return self.Property
    def set_Property(self, Property): self.Property = Property
    def add_Property(self, value): self.Property.append(value)
    def insert_Property_at(self, index, value): self.Property.insert(index, value)
    def replace_Property_at(self, index, value): self.Property[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_instance(self): return self.instance
    def set_instance(self, instance): self.instance = instance
    def get_class(self): return self.class_
    def set_class(self, class_): self.class_ = class_
    def hasContent_(self):
        if (
            self.Product is not None or
            self.Vendor is not None or
            self.Version is not None or
            self.FullVersion is not None or
            self.ProductUrl is not None or
            self.VendorUrl is not None or
            self.AppUrl is not None or
            self.Icon or
            self.Category or
            self.Property or
            self.anytypeobjs_ or
            super(ProductSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ProductSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProductSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ProductSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProductSection_Type'):
        super(ProductSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProductSection_Type')
        if self.instance is not None and 'instance' not in already_processed:
            already_processed.add('instance')
            outfile.write(' instance=%s' % (self.gds_format_string(quote_attrib(self.instance).encode(ExternalEncoding), input_name='instance'), ))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (self.gds_format_string(quote_attrib(self.class_).encode(ExternalEncoding), input_name='class'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ProductSection_Type', fromsubclass_=False, pretty_print=True):
        super(ProductSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Product is not None:
            self.Product.export(outfile, level, namespace_, name_='Product', pretty_print=pretty_print)
        if self.Vendor is not None:
            self.Vendor.export(outfile, level, namespace_, name_='Vendor', pretty_print=pretty_print)
        if self.Version is not None:
            self.Version.export(outfile, level, namespace_, name_='Version', pretty_print=pretty_print)
        if self.FullVersion is not None:
            self.FullVersion.export(outfile, level, namespace_, name_='FullVersion', pretty_print=pretty_print)
        if self.ProductUrl is not None:
            self.ProductUrl.export(outfile, level, namespace_, name_='ProductUrl', pretty_print=pretty_print)
        if self.VendorUrl is not None:
            self.VendorUrl.export(outfile, level, namespace_, name_='VendorUrl', pretty_print=pretty_print)
        if self.AppUrl is not None:
            self.AppUrl.export(outfile, level, namespace_, name_='AppUrl', pretty_print=pretty_print)
        for Icon_ in self.Icon:
            Icon_.export(outfile, level, namespace_, name_='Icon', pretty_print=pretty_print)
        for Category_ in self.Category:
            Category_.export(outfile, level, namespace_, name_='Category', pretty_print=pretty_print)
        for Property_ in self.Property:
            Property_.export(outfile, level, namespace_, name_='Property', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ProductSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instance is not None and 'instance' not in already_processed:
            already_processed.add('instance')
            showIndent(outfile, level)
            outfile.write('instance="%s",\n' % (self.instance,))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            showIndent(outfile, level)
            outfile.write('class_="%s",\n' % (self.class_,))
        super(ProductSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProductSection_Type, self).exportLiteralChildren(outfile, level, name_)
        if self.Product is not None:
            showIndent(outfile, level)
            outfile.write('Product=model_.Msg_Type(\n')
            self.Product.exportLiteral(outfile, level, name_='Product')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Vendor is not None:
            showIndent(outfile, level)
            outfile.write('Vendor=model_.Msg_Type(\n')
            self.Vendor.exportLiteral(outfile, level, name_='Vendor')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Version is not None:
            showIndent(outfile, level)
            outfile.write('Version=model_.cimString(\n')
            self.Version.exportLiteral(outfile, level, name_='Version')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.FullVersion is not None:
            showIndent(outfile, level)
            outfile.write('FullVersion=model_.cimString(\n')
            self.FullVersion.exportLiteral(outfile, level, name_='FullVersion')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ProductUrl is not None:
            showIndent(outfile, level)
            outfile.write('ProductUrl=model_.cimString(\n')
            self.ProductUrl.exportLiteral(outfile, level, name_='ProductUrl')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.VendorUrl is not None:
            showIndent(outfile, level)
            outfile.write('VendorUrl=model_.cimString(\n')
            self.VendorUrl.exportLiteral(outfile, level, name_='VendorUrl')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AppUrl is not None:
            showIndent(outfile, level)
            outfile.write('AppUrl=model_.cimString(\n')
            self.AppUrl.exportLiteral(outfile, level, name_='AppUrl')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Icon=[\n')
        level += 1
        for Icon_ in self.Icon:
            showIndent(outfile, level)
            outfile.write('model_.IconType(\n')
            Icon_.exportLiteral(outfile, level, name_='IconType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Category=[\n')
        level += 1
        for Category_ in self.Category:
            showIndent(outfile, level)
            outfile.write('model_.Msg_Type(\n')
            Category_.exportLiteral(outfile, level, name_='Msg_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Property=[\n')
        level += 1
        for Property_ in self.Property:
            showIndent(outfile, level)
            outfile.write('model_.PropertyType(\n')
            Property_.exportLiteral(outfile, level, name_='PropertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instance', node)
        if value is not None and 'instance' not in already_processed:
            already_processed.add('instance')
            self.instance = value
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
        super(ProductSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Product':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Product = obj_
            obj_.original_tagname_ = 'Product'
        elif nodeName_ == 'Vendor':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Vendor = obj_
            obj_.original_tagname_ = 'Vendor'
        elif nodeName_ == 'Version':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Version = obj_
            obj_.original_tagname_ = 'Version'
        elif nodeName_ == 'FullVersion':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.FullVersion = obj_
            obj_.original_tagname_ = 'FullVersion'
        elif nodeName_ == 'ProductUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ProductUrl = obj_
            obj_.original_tagname_ = 'ProductUrl'
        elif nodeName_ == 'VendorUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VendorUrl = obj_
            obj_.original_tagname_ = 'VendorUrl'
        elif nodeName_ == 'AppUrl':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AppUrl = obj_
            obj_.original_tagname_ = 'AppUrl'
        elif nodeName_ == 'Icon':
            obj_ = IconType.factory()
            obj_.build(child_)
            self.Icon.append(obj_)
            obj_.original_tagname_ = 'Icon'
        elif nodeName_ == 'Category':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Category.append(obj_)
            obj_.original_tagname_ = 'Category'
        elif nodeName_ == 'Property':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.Property.append(obj_)
            obj_.original_tagname_ = 'Property'
        else:
            obj_ = self.gds_build_any(child_, 'ProductSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(ProductSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class ProductSection_Type


class PropertyConfigurationValue_Type(GeneratedsSuper):
    """Type for alternative default values for properties when
    DeploymentOptionSection is usedAlternative default property
    valueConfiguration from DeploymentOptionSection in which this
    value is default"""
    subclass = None
    superclass = None
    def __init__(self, configuration=None, value=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.configuration = _cast(None, configuration)
        self.value = _cast(None, value)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if PropertyConfigurationValue_Type.subclass:
            return PropertyConfigurationValue_Type.subclass(*args_, **kwargs_)
        else:
            return PropertyConfigurationValue_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PropertyConfigurationValue_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyConfigurationValue_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PropertyConfigurationValue_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PropertyConfigurationValue_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            outfile.write(' configuration=%s' % (self.gds_format_string(quote_attrib(self.configuration).encode(ExternalEncoding), input_name='configuration'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PropertyConfigurationValue_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PropertyConfigurationValue_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            showIndent(outfile, level)
            outfile.write('configuration="%s",\n' % (self.configuration,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('configuration', node)
        if value is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            self.configuration = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'PropertyConfigurationValue_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class PropertyConfigurationValue_Type


class NetworkSection_Type(Section_Type):
    """Descriptions of logical networks used within the package"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Network=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(NetworkSection_Type, self).__init__(required, Info, )
        if Network is None:
            self.Network = []
        else:
            self.Network = Network
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if NetworkSection_Type.subclass:
            return NetworkSection_Type.subclass(*args_, **kwargs_)
        else:
            return NetworkSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Network(self): return self.Network
    def set_Network(self, Network): self.Network = Network
    def add_Network(self, value): self.Network.append(value)
    def insert_Network_at(self, index, value): self.Network.insert(index, value)
    def replace_Network_at(self, index, value): self.Network[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Network or
            self.anytypeobjs_ or
            super(NetworkSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkSection_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkSection_Type'):
        super(NetworkSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkSection_Type', fromsubclass_=False, pretty_print=True):
        super(NetworkSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Network_ in self.Network:
            Network_.export(outfile, level, namespace_, name_='Network', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Network=[\n')
        level += 1
        for Network_ in self.Network:
            showIndent(outfile, level)
            outfile.write('model_.NetworkType(\n')
            Network_.exportLiteral(outfile, level, name_='NetworkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Network':
            obj_ = NetworkType.factory()
            obj_.build(child_)
            self.Network.append(obj_)
            obj_.original_tagname_ = 'Network'
        else:
            obj_ = self.gds_build_any(child_, 'NetworkSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(NetworkSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class NetworkSection_Type


class DiskSection_Type(Section_Type):
    """Descriptions of virtual disks used within the package"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Disk=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(DiskSection_Type, self).__init__(required, Info, )
        if Disk is None:
            self.Disk = []
        else:
            self.Disk = Disk
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if DiskSection_Type.subclass:
            return DiskSection_Type.subclass(*args_, **kwargs_)
        else:
            return DiskSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Disk(self): return self.Disk
    def set_Disk(self, Disk): self.Disk = Disk
    def add_Disk(self, value): self.Disk.append(value)
    def insert_Disk_at(self, index, value): self.Disk.insert(index, value)
    def replace_Disk_at(self, index, value): self.Disk[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Disk or
            self.anytypeobjs_ or
            super(DiskSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DiskSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DiskSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DiskSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DiskSection_Type'):
        super(DiskSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DiskSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='DiskSection_Type', fromsubclass_=False, pretty_print=True):
        super(DiskSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Disk_ in self.Disk:
            Disk_.export(outfile, level, namespace_, name_='Disk', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DiskSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DiskSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DiskSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Disk=[\n')
        level += 1
        for Disk_ in self.Disk:
            showIndent(outfile, level)
            outfile.write('model_.VirtualDiskDesc_Type(\n')
            Disk_.exportLiteral(outfile, level, name_='VirtualDiskDesc_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DiskSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Disk':
            obj_ = VirtualDiskDesc_Type.factory()
            obj_.build(child_)
            self.Disk.append(obj_)
            obj_.original_tagname_ = 'Disk'
        else:
            obj_ = self.gds_build_any(child_, 'DiskSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(DiskSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class DiskSection_Type


class VirtualDiskDesc_Type(GeneratedsSuper):
    """Type for virtual disk descriptorIdentifier for virtual diskReference
    to virtual disk content. If not specified a blank virtual disk
    is created of size given by capacity attributeVirtual disk
    capacity, can be specified as either an xs:long size or as a
    reference to a property using ${property_name}. Unit of
    allocation for ovf:capacity. If not specified default value is
    bytes. Value shall match a recognized value for the UNITS
    qualifier in DSP0004.Format of virtual disk given as a URI that
    identifies the disk typeEstimated populated size of disk in
    bytesReference to potential parent disk"""
    subclass = None
    superclass = None
    def __init__(self, capacityAllocationUnits='byte', capacity=None, format=None, parentRef=None, fileRef=None, populatedSize=None, diskId=None, anytypeobjs_=None):
        self.original_tagname_ = None
        self.capacityAllocationUnits = _cast(None, capacityAllocationUnits)
        self.capacity = _cast(None, capacity)
        self.format = _cast(None, format)
        self.parentRef = _cast(None, parentRef)
        self.fileRef = _cast(None, fileRef)
        self.populatedSize = _cast(int, populatedSize)
        self.diskId = _cast(None, diskId)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if VirtualDiskDesc_Type.subclass:
            return VirtualDiskDesc_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualDiskDesc_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_capacityAllocationUnits(self): return self.capacityAllocationUnits
    def set_capacityAllocationUnits(self, capacityAllocationUnits): self.capacityAllocationUnits = capacityAllocationUnits
    def get_capacity(self): return self.capacity
    def set_capacity(self, capacity): self.capacity = capacity
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_parentRef(self): return self.parentRef
    def set_parentRef(self, parentRef): self.parentRef = parentRef
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_populatedSize(self): return self.populatedSize
    def set_populatedSize(self, populatedSize): self.populatedSize = populatedSize
    def get_diskId(self): return self.diskId
    def set_diskId(self, diskId): self.diskId = diskId
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtualDiskDesc_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualDiskDesc_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VirtualDiskDesc_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtualDiskDesc_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.capacityAllocationUnits is not None and 'capacityAllocationUnits' not in already_processed:
            already_processed.add('capacityAllocationUnits')
            outfile.write(' capacityAllocationUnits=%s' % (self.gds_format_string(quote_attrib(self.capacityAllocationUnits).encode(ExternalEncoding), input_name='capacityAllocationUnits'), ))
        if self.capacity is not None and 'capacity' not in already_processed:
            already_processed.add('capacity')
            outfile.write(' capacity=%s' % (self.gds_format_string(quote_attrib(self.capacity).encode(ExternalEncoding), input_name='capacity'), ))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            outfile.write(' format=%s' % (self.gds_format_string(quote_attrib(self.format).encode(ExternalEncoding), input_name='format'), ))
        if self.parentRef is not None and 'parentRef' not in already_processed:
            already_processed.add('parentRef')
            outfile.write(' parentRef=%s' % (self.gds_format_string(quote_attrib(self.parentRef).encode(ExternalEncoding), input_name='parentRef'), ))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_format_string(quote_attrib(self.fileRef).encode(ExternalEncoding), input_name='fileRef'), ))
        if self.populatedSize is not None and 'populatedSize' not in already_processed:
            already_processed.add('populatedSize')
            outfile.write(' populatedSize="%s"' % self.gds_format_integer(self.populatedSize, input_name='populatedSize'))
        if self.diskId is not None and 'diskId' not in already_processed:
            already_processed.add('diskId')
            outfile.write(' diskId=%s' % (self.gds_format_string(quote_attrib(self.diskId).encode(ExternalEncoding), input_name='diskId'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VirtualDiskDesc_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VirtualDiskDesc_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.capacityAllocationUnits is not None and 'capacityAllocationUnits' not in already_processed:
            already_processed.add('capacityAllocationUnits')
            showIndent(outfile, level)
            outfile.write('capacityAllocationUnits="%s",\n' % (self.capacityAllocationUnits,))
        if self.capacity is not None and 'capacity' not in already_processed:
            already_processed.add('capacity')
            showIndent(outfile, level)
            outfile.write('capacity="%s",\n' % (self.capacity,))
        if self.format is not None and 'format' not in already_processed:
            already_processed.add('format')
            showIndent(outfile, level)
            outfile.write('format="%s",\n' % (self.format,))
        if self.parentRef is not None and 'parentRef' not in already_processed:
            already_processed.add('parentRef')
            showIndent(outfile, level)
            outfile.write('parentRef="%s",\n' % (self.parentRef,))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            showIndent(outfile, level)
            outfile.write('fileRef="%s",\n' % (self.fileRef,))
        if self.populatedSize is not None and 'populatedSize' not in already_processed:
            already_processed.add('populatedSize')
            showIndent(outfile, level)
            outfile.write('populatedSize=%d,\n' % (self.populatedSize,))
        if self.diskId is not None and 'diskId' not in already_processed:
            already_processed.add('diskId')
            showIndent(outfile, level)
            outfile.write('diskId="%s",\n' % (self.diskId,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('capacityAllocationUnits', node)
        if value is not None and 'capacityAllocationUnits' not in already_processed:
            already_processed.add('capacityAllocationUnits')
            self.capacityAllocationUnits = value
        value = find_attr_value_('capacity', node)
        if value is not None and 'capacity' not in already_processed:
            already_processed.add('capacity')
            self.capacity = value
        value = find_attr_value_('format', node)
        if value is not None and 'format' not in already_processed:
            already_processed.add('format')
            self.format = value
        value = find_attr_value_('parentRef', node)
        if value is not None and 'parentRef' not in already_processed:
            already_processed.add('parentRef')
            self.parentRef = value
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        value = find_attr_value_('populatedSize', node)
        if value is not None and 'populatedSize' not in already_processed:
            already_processed.add('populatedSize')
            try:
                self.populatedSize = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('diskId', node)
        if value is not None and 'diskId' not in already_processed:
            already_processed.add('diskId')
            self.diskId = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'VirtualDiskDesc_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class VirtualDiskDesc_Type


class OperatingSystemSection_Type(Section_Type):
    """Specification of the operating system installed in the
    guestIdentifier defined by the CIM_OperatingSystem.OsType
    enumerationVersion defined by the CIM_OperatingSystem.Version
    field"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, version=None, id=None, Description=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(OperatingSystemSection_Type, self).__init__(required, Info, )
        self.version = _cast(None, version)
        self.id = _cast(int, id)
        self.Description = Description
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if OperatingSystemSection_Type.subclass:
            return OperatingSystemSection_Type.subclass(*args_, **kwargs_)
        else:
            return OperatingSystemSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.Description is not None or
            self.anytypeobjs_ or
            super(OperatingSystemSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OperatingSystemSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OperatingSystemSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OperatingSystemSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OperatingSystemSection_Type'):
        super(OperatingSystemSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OperatingSystemSection_Type')
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_format_string(quote_attrib(self.version).encode(ExternalEncoding), input_name='version'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='OperatingSystemSection_Type', fromsubclass_=False, pretty_print=True):
        super(OperatingSystemSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='OperatingSystemSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version="%s",\n' % (self.version,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
        super(OperatingSystemSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OperatingSystemSection_Type, self).exportLiteralChildren(outfile, level, name_)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Msg_Type(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(OperatingSystemSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        else:
            obj_ = self.gds_build_any(child_, 'OperatingSystemSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(OperatingSystemSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class OperatingSystemSection_Type


class EulaSection_Type(Section_Type):
    """End-User License Agreement"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, License=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(EulaSection_Type, self).__init__(required, Info, )
        self.License = License
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if EulaSection_Type.subclass:
            return EulaSection_Type.subclass(*args_, **kwargs_)
        else:
            return EulaSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_License(self): return self.License
    def set_License(self, License): self.License = License
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.License is not None or
            self.anytypeobjs_ or
            super(EulaSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EulaSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EulaSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='EulaSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EulaSection_Type'):
        super(EulaSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EulaSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='EulaSection_Type', fromsubclass_=False, pretty_print=True):
        super(EulaSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.License is not None:
            self.License.export(outfile, level, namespace_, name_='License', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EulaSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(EulaSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EulaSection_Type, self).exportLiteralChildren(outfile, level, name_)
        if self.License is not None:
            showIndent(outfile, level)
            outfile.write('License=model_.Msg_Type(\n')
            self.License.exportLiteral(outfile, level, name_='License')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(EulaSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'License':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.License = obj_
            obj_.original_tagname_ = 'License'
        else:
            obj_ = self.gds_build_any(child_, 'EulaSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(EulaSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class EulaSection_Type


class VirtualHardwareSection_Type(Section_Type):
    """Specifies virtual hardware requirements for a virtual machineUnique
    identifier of this VirtualHardwareSection (within a
    VirtualSystem)"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, id='', transport=None, System=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(VirtualHardwareSection_Type, self).__init__(required, Info, )
        self.id = _cast(None, id)
        self.transport = _cast(None, transport)
        self.System = System
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if VirtualHardwareSection_Type.subclass:
            return VirtualHardwareSection_Type.subclass(*args_, **kwargs_)
        else:
            return VirtualHardwareSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_System(self): return self.System
    def set_System(self, System): self.System = System
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_transport(self): return self.transport
    def set_transport(self, transport): self.transport = transport
    def hasContent_(self):
        if (
            self.System is not None or
            self.Item or
            self.anytypeobjs_ or
            super(VirtualHardwareSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VirtualHardwareSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualHardwareSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VirtualHardwareSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VirtualHardwareSection_Type'):
        super(VirtualHardwareSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VirtualHardwareSection_Type')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
        if self.transport is not None and 'transport' not in already_processed:
            already_processed.add('transport')
            outfile.write(' transport=%s' % (self.gds_format_string(quote_attrib(self.transport).encode(ExternalEncoding), input_name='transport'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VirtualHardwareSection_Type', fromsubclass_=False, pretty_print=True):
        super(VirtualHardwareSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.System is not None:
            self.System.export(outfile, level, namespace_, name_='System', pretty_print=pretty_print)
        for Item_ in self.Item:
            Item_.export(outfile, level, namespace_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VirtualHardwareSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.transport is not None and 'transport' not in already_processed:
            already_processed.add('transport')
            showIndent(outfile, level)
            outfile.write('transport="%s",\n' % (self.transport,))
        super(VirtualHardwareSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VirtualHardwareSection_Type, self).exportLiteralChildren(outfile, level, name_)
        if self.System is not None:
            showIndent(outfile, level)
            outfile.write('System=model_.VSSD_Type(\n')
            self.System.exportLiteral(outfile, level, name_='System')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Item=[\n')
        level += 1
        for Item_ in self.Item:
            showIndent(outfile, level)
            outfile.write('model_.RASD_Type(\n')
            Item_.exportLiteral(outfile, level, name_='RASD_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('transport', node)
        if value is not None and 'transport' not in already_processed:
            already_processed.add('transport')
            self.transport = value
        super(VirtualHardwareSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'System':
            obj_ = VSSD_Type.factory()
            obj_.build(child_)
            self.System = obj_
            obj_.original_tagname_ = 'System'
        elif nodeName_ == 'Item':
            obj_ = RASD_Type.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'VirtualHardwareSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(VirtualHardwareSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class VirtualHardwareSection_Type


class ResourceAllocationSection_Type(Section_Type):
    """Resource constraints on a VirtualSystemCollection"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(ResourceAllocationSection_Type, self).__init__(required, Info, )
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if ResourceAllocationSection_Type.subclass:
            return ResourceAllocationSection_Type.subclass(*args_, **kwargs_)
        else:
            return ResourceAllocationSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Item or
            self.anytypeobjs_ or
            super(ResourceAllocationSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ResourceAllocationSection_Type', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceAllocationSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ResourceAllocationSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceAllocationSection_Type'):
        super(ResourceAllocationSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceAllocationSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceAllocationSection_Type', fromsubclass_=False, pretty_print=True):
        super(ResourceAllocationSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Item_ in self.Item:
            Item_.export(outfile, level, namespace_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceAllocationSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ResourceAllocationSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceAllocationSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Item=[\n')
        level += 1
        for Item_ in self.Item:
            showIndent(outfile, level)
            outfile.write('model_.RASD_Type(\n')
            Item_.exportLiteral(outfile, level, name_='RASD_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(ResourceAllocationSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Item':
            obj_ = RASD_Type.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'ResourceAllocationSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(ResourceAllocationSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceAllocationSection_Type


class InstallSection_Type(Section_Type):
    """If present indicates that the virtual machine needs to be initially
    booted to install and configure the softwareDelay in seconds to
    wait for power off to complete after initial boot"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, initialBootStopDelay=0, anytypeobjs_=None):
        self.original_tagname_ = None
        super(InstallSection_Type, self).__init__(required, Info, )
        self.initialBootStopDelay = _cast(int, initialBootStopDelay)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if InstallSection_Type.subclass:
            return InstallSection_Type.subclass(*args_, **kwargs_)
        else:
            return InstallSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_initialBootStopDelay(self): return self.initialBootStopDelay
    def set_initialBootStopDelay(self, initialBootStopDelay): self.initialBootStopDelay = initialBootStopDelay
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(InstallSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InstallSection_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InstallSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='InstallSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InstallSection_Type'):
        super(InstallSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InstallSection_Type')
        if self.initialBootStopDelay is not None and 'initialBootStopDelay' not in already_processed:
            already_processed.add('initialBootStopDelay')
            outfile.write(' initialBootStopDelay="%s"' % self.gds_format_integer(self.initialBootStopDelay, input_name='initialBootStopDelay'))
    def exportChildren(self, outfile, level, namespace_='', name_='InstallSection_Type', fromsubclass_=False, pretty_print=True):
        super(InstallSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InstallSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.initialBootStopDelay is not None and 'initialBootStopDelay' not in already_processed:
            already_processed.add('initialBootStopDelay')
            showIndent(outfile, level)
            outfile.write('initialBootStopDelay=%d,\n' % (self.initialBootStopDelay,))
        super(InstallSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(InstallSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('initialBootStopDelay', node)
        if value is not None and 'initialBootStopDelay' not in already_processed:
            already_processed.add('initialBootStopDelay')
            try:
                self.initialBootStopDelay = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(InstallSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'InstallSection_Type')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(InstallSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class InstallSection_Type


class StartupSection_Type(Section_Type):
    """Specifies the order in which entities in a VirtualSystemCollection
    are powered on and shut down"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Item=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(StartupSection_Type, self).__init__(required, Info, )
        if Item is None:
            self.Item = []
        else:
            self.Item = Item
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if StartupSection_Type.subclass:
            return StartupSection_Type.subclass(*args_, **kwargs_)
        else:
            return StartupSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Item(self): return self.Item
    def set_Item(self, Item): self.Item = Item
    def add_Item(self, value): self.Item.append(value)
    def insert_Item_at(self, index, value): self.Item.insert(index, value)
    def replace_Item_at(self, index, value): self.Item[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Item or
            self.anytypeobjs_ or
            super(StartupSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='StartupSection_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StartupSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='StartupSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StartupSection_Type'):
        super(StartupSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StartupSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='StartupSection_Type', fromsubclass_=False, pretty_print=True):
        super(StartupSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Item_ in self.Item:
            Item_.export(outfile, level, namespace_, name_='Item', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='StartupSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StartupSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StartupSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Item=[\n')
        level += 1
        for Item_ in self.Item:
            showIndent(outfile, level)
            outfile.write('model_.ItemType(\n')
            Item_.exportLiteral(outfile, level, name_='ItemType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(StartupSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Item':
            obj_ = ItemType.factory()
            obj_.build(child_)
            self.Item.append(obj_)
            obj_.original_tagname_ = 'Item'
        else:
            obj_ = self.gds_build_any(child_, 'StartupSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(StartupSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class StartupSection_Type


class DeploymentOptionSection_Type(Section_Type):
    """Enumeration of discrete deployment options"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, Configuration=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(DeploymentOptionSection_Type, self).__init__(required, Info, )
        if Configuration is None:
            self.Configuration = []
        else:
            self.Configuration = Configuration
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if DeploymentOptionSection_Type.subclass:
            return DeploymentOptionSection_Type.subclass(*args_, **kwargs_)
        else:
            return DeploymentOptionSection_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def add_Configuration(self, value): self.Configuration.append(value)
    def insert_Configuration_at(self, index, value): self.Configuration.insert(index, value)
    def replace_Configuration_at(self, index, value): self.Configuration[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def hasContent_(self):
        if (
            self.Configuration or
            self.anytypeobjs_ or
            super(DeploymentOptionSection_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DeploymentOptionSection_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DeploymentOptionSection_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DeploymentOptionSection_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DeploymentOptionSection_Type'):
        super(DeploymentOptionSection_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DeploymentOptionSection_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='DeploymentOptionSection_Type', fromsubclass_=False, pretty_print=True):
        super(DeploymentOptionSection_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Configuration_ in self.Configuration:
            Configuration_.export(outfile, level, namespace_, name_='Configuration', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DeploymentOptionSection_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DeploymentOptionSection_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DeploymentOptionSection_Type, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Configuration=[\n')
        level += 1
        for Configuration_ in self.Configuration:
            showIndent(outfile, level)
            outfile.write('model_.ConfigurationType(\n')
            Configuration_.exportLiteral(outfile, level, name_='ConfigurationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DeploymentOptionSection_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration':
            obj_ = ConfigurationType.factory()
            obj_.build(child_)
            self.Configuration.append(obj_)
            obj_.original_tagname_ = 'Configuration'
        else:
            obj_ = self.gds_build_any(child_, 'DeploymentOptionSection_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(DeploymentOptionSection_Type, self).buildChildren(child_, node, nodeName_, True)
# end class DeploymentOptionSection_Type


class cimDateTime(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, CIM_DateTime=None, Interval=None, Date=None, Time=None, Datetime=None):
        self.original_tagname_ = None
        self.CIM_DateTime = CIM_DateTime
        self.Interval = Interval
        if isinstance(Date, basestring):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%d').date()
        else:
            initvalue_ = Date
        self.Date = initvalue_
        if isinstance(Time, basestring):
            initvalue_ = datetime_.datetime.strptime(Time, '%H:%M:%S').time()
        else:
            initvalue_ = Time
        self.Time = initvalue_
        if isinstance(Datetime, basestring):
            initvalue_ = datetime_.datetime.strptime(Datetime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = Datetime
        self.Datetime = initvalue_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimDateTime.subclass:
            return cimDateTime.subclass(*args_, **kwargs_)
        else:
            return cimDateTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CIM_DateTime(self): return self.CIM_DateTime
    def set_CIM_DateTime(self, CIM_DateTime): self.CIM_DateTime = CIM_DateTime
    def get_Interval(self): return self.Interval
    def set_Interval(self, Interval): self.Interval = Interval
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def get_Time(self): return self.Time
    def set_Time(self, Time): self.Time = Time
    def get_Datetime(self): return self.Datetime
    def set_Datetime(self, Datetime): self.Datetime = Datetime
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.CIM_DateTime is not None or
            self.Interval is not None or
            self.Date is not None or
            self.Time is not None or
            self.Datetime is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimDateTime', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimDateTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimDateTime', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimDateTime'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimDateTime', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CIM_DateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCIM_DateTime>%s</%sCIM_DateTime>%s' % (namespace_, self.gds_format_string(quote_xml(self.CIM_DateTime).encode(ExternalEncoding), input_name='CIM_DateTime'), namespace_, eol_))
        if self.Interval is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInterval>%s</%sInterval>%s' % (namespace_, self.gds_format_string(quote_xml(self.Interval).encode(ExternalEncoding), input_name='Interval'), namespace_, eol_))
        if self.Date is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDate>%s</%sDate>%s' % (namespace_, self.gds_format_date(self.Date, input_name='Date'), namespace_, eol_))
        if self.Time is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTime>%s</%sTime>%s' % (namespace_, self.gds_format_time(self.Time, input_name='Time'), namespace_, eol_))
        if self.Datetime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDatetime>%s</%sDatetime>%s' % (namespace_, self.gds_format_datetime(self.Datetime, input_name='Datetime'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='cimDateTime'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.CIM_DateTime is not None:
            showIndent(outfile, level)
            outfile.write('CIM_DateTime=%s,\n' % quote_python(self.CIM_DateTime).encode(ExternalEncoding))
        if self.Interval is not None:
            showIndent(outfile, level)
            outfile.write('Interval=%s,\n' % quote_python(self.Interval).encode(ExternalEncoding))
        if self.Date is not None:
            showIndent(outfile, level)
            outfile.write('Date=model_.GeneratedsSuper.gds_parse_date("%s"),\n' % self.gds_format_date(self.Date, input_name='Date'))
        if self.Time is not None:
            showIndent(outfile, level)
            outfile.write('Time=model_.GeneratedsSuper.gds_parse_time("%s"),\n' % self.gds_format_time(self.Time, input_name='Time'))
        if self.Datetime is not None:
            showIndent(outfile, level)
            outfile.write('Datetime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.Datetime, input_name='Datetime'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CIM_DateTime':
            CIM_DateTime_ = child_.text
            CIM_DateTime_ = self.gds_validate_string(CIM_DateTime_, node, 'CIM_DateTime')
            self.CIM_DateTime = CIM_DateTime_
        elif nodeName_ == 'Interval':
            Interval_ = child_.text
            Interval_ = self.gds_validate_string(Interval_, node, 'Interval')
            self.Interval = Interval_
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.Date = dval_
        elif nodeName_ == 'Time':
            sval_ = child_.text
            dval_ = self.gds_parse_time(sval_)
            self.Time = dval_
        elif nodeName_ == 'Datetime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.Datetime = dval_
# end class cimDateTime


class cimUnsignedByte(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimUnsignedByte.subclass:
            return cimUnsignedByte.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedByte(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimUnsignedByte', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimUnsignedByte')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimUnsignedByte', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimUnsignedByte'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimUnsignedByte', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimUnsignedByte'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedByte


class cimByte(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimByte.subclass:
            return cimByte.subclass(*args_, **kwargs_)
        else:
            return cimByte(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimByte', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimByte')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimByte', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimByte'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimByte', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimByte'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimByte


class cimUnsignedShort(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimUnsignedShort.subclass:
            return cimUnsignedShort.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedShort(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimUnsignedShort', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimUnsignedShort')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimUnsignedShort', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimUnsignedShort'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimUnsignedShort', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimUnsignedShort'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedShort


class cimShort(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimShort.subclass:
            return cimShort.subclass(*args_, **kwargs_)
        else:
            return cimShort(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimShort', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimShort')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimShort', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimShort'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimShort', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimShort'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimShort


class cimUnsignedInt(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if cimUnsignedInt.subclass:
            return cimUnsignedInt.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedInt(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimUnsignedInt', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimUnsignedInt')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimUnsignedInt', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimUnsignedInt'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimUnsignedInt', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimUnsignedInt'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedInt


class cimInt(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimInt.subclass:
            return cimInt.subclass(*args_, **kwargs_)
        else:
            return cimInt(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimInt', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimInt')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimInt', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimInt'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimInt', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimInt'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimInt


class cimUnsignedLong(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimUnsignedLong.subclass:
            return cimUnsignedLong.subclass(*args_, **kwargs_)
        else:
            return cimUnsignedLong(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimUnsignedLong', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimUnsignedLong')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimUnsignedLong', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimUnsignedLong'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimUnsignedLong', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimUnsignedLong'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimUnsignedLong


class cimLong(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if cimLong.subclass:
            return cimLong.subclass(*args_, **kwargs_)
        else:
            return cimLong(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimLong', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimLong')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimLong', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimLong'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimLong', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimLong'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimLong


class cimString(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if cimString.subclass:
            return cimString.subclass(*args_, **kwargs_)
        else:
            return cimString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimString', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimString')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimString', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimString'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimString', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimString'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimString


class cimBoolean(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if cimBoolean.subclass:
            return cimBoolean.subclass(*args_, **kwargs_)
        else:
            return cimBoolean(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimBoolean', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimBoolean')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimBoolean', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimBoolean'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimBoolean', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimBoolean'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimBoolean


class cimFloat(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimFloat.subclass:
            return cimFloat.subclass(*args_, **kwargs_)
        else:
            return cimFloat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimFloat', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimFloat')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimFloat', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimFloat'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimFloat', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimFloat'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimFloat


class cimDouble(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimDouble.subclass:
            return cimDouble.subclass(*args_, **kwargs_)
        else:
            return cimDouble(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimDouble', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimDouble')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimDouble', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimDouble'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimDouble', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimDouble'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimDouble


class cimChar16(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(cimChar16, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimChar16.subclass:
            return cimChar16.subclass(*args_, **kwargs_)
        else:
            return cimChar16(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(cimChar16, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimChar16', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimChar16')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimChar16', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimChar16'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(cimChar16, self).exportAttributes(outfile, level, already_processed, namespace_, name_='cimChar16')
    def exportChildren(self, outfile, level, namespace_='', name_='cimChar16', fromsubclass_=False, pretty_print=True):
        super(cimChar16, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='cimChar16'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(cimChar16, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(cimChar16, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(cimChar16, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimChar16


class cimBase64Binary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimBase64Binary.subclass:
            return cimBase64Binary.subclass(*args_, **kwargs_)
        else:
            return cimBase64Binary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimBase64Binary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimBase64Binary')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimBase64Binary', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimBase64Binary'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimBase64Binary', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimBase64Binary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimBase64Binary


class cimReference(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None):
        self.original_tagname_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimReference.subclass:
            return cimReference.subclass(*args_, **kwargs_)
        else:
            return cimReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimReference', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimReference')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimReference'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='cimReference'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'cimReference')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class cimReference


class cimHexBinary(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if cimHexBinary.subclass:
            return cimHexBinary.subclass(*args_, **kwargs_)
        else:
            return cimHexBinary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimHexBinary', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimHexBinary')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimHexBinary', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimHexBinary'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimHexBinary', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimHexBinary'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimHexBinary


class cimAnySimpleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if cimAnySimpleType.subclass:
            return cimAnySimpleType.subclass(*args_, **kwargs_)
        else:
            return cimAnySimpleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cimAnySimpleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cimAnySimpleType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cimAnySimpleType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cimAnySimpleType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='cimAnySimpleType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='cimAnySimpleType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class cimAnySimpleType


class qualifierString(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, qualifier=None, valueOf_=None, extensiontype_=None):
        self.original_tagname_ = None
        super(qualifierString, self).__init__(valueOf_, extensiontype_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if qualifierString.subclass:
            return qualifierString.subclass(*args_, **kwargs_)
        else:
            return qualifierString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(qualifierString, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='qualifierString', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierString')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='qualifierString', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='qualifierString'):
        super(qualifierString, self).exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierString')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='qualifierString', fromsubclass_=False, pretty_print=True):
        super(qualifierString, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='qualifierString'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            showIndent(outfile, level)
            outfile.write('qualifier=%s,\n' % (self.qualifier,))
        super(qualifierString, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(qualifierString, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(qualifierString, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierString


class qualifierBoolean(cimBoolean):
    subclass = None
    superclass = cimBoolean
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierBoolean, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if qualifierBoolean.subclass:
            return qualifierBoolean.subclass(*args_, **kwargs_)
        else:
            return qualifierBoolean(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(qualifierBoolean, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='qualifierBoolean', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierBoolean')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='qualifierBoolean', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='qualifierBoolean'):
        super(qualifierBoolean, self).exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierBoolean')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespace_='', name_='qualifierBoolean', fromsubclass_=False, pretty_print=True):
        super(qualifierBoolean, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='qualifierBoolean'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            showIndent(outfile, level)
            outfile.write('qualifier=%s,\n' % (self.qualifier,))
        super(qualifierBoolean, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(qualifierBoolean, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierBoolean, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierBoolean


class qualifierUInt32(cimUnsignedInt):
    subclass = None
    superclass = cimUnsignedInt
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierUInt32, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if qualifierUInt32.subclass:
            return qualifierUInt32.subclass(*args_, **kwargs_)
        else:
            return qualifierUInt32(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(qualifierUInt32, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='qualifierUInt32', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierUInt32')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='qualifierUInt32', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='qualifierUInt32'):
        super(qualifierUInt32, self).exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierUInt32')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespace_='', name_='qualifierUInt32', fromsubclass_=False, pretty_print=True):
        super(qualifierUInt32, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='qualifierUInt32'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            showIndent(outfile, level)
            outfile.write('qualifier=%s,\n' % (self.qualifier,))
        super(qualifierUInt32, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(qualifierUInt32, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierUInt32, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierUInt32


class qualifierSInt64(cimLong):
    subclass = None
    superclass = cimLong
    def __init__(self, qualifier=None, valueOf_=None):
        self.original_tagname_ = None
        super(qualifierSInt64, self).__init__(valueOf_, )
        self.qualifier = _cast(bool, qualifier)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if qualifierSInt64.subclass:
            return qualifierSInt64.subclass(*args_, **kwargs_)
        else:
            return qualifierSInt64(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(qualifierSInt64, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='qualifierSInt64', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierSInt64')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='qualifierSInt64', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='qualifierSInt64'):
        super(qualifierSInt64, self).exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierSInt64')
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            outfile.write(' qualifier="%s"' % self.gds_format_boolean(self.qualifier, input_name='qualifier'))
    def exportChildren(self, outfile, level, namespace_='', name_='qualifierSInt64', fromsubclass_=False, pretty_print=True):
        super(qualifierSInt64, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='qualifierSInt64'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.qualifier is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            showIndent(outfile, level)
            outfile.write('qualifier=%s,\n' % (self.qualifier,))
        super(qualifierSInt64, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(qualifierSInt64, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifier', node)
        if value is not None and 'qualifier' not in already_processed:
            already_processed.add('qualifier')
            if value in ('true', '1'):
                self.qualifier = True
            elif value in ('false', '0'):
                self.qualifier = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(qualifierSInt64, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class qualifierSInt64


class qualifierSArray(qualifierString):
    subclass = None
    superclass = qualifierString
    def __init__(self, qualifier=None):
        self.original_tagname_ = None
        super(qualifierSArray, self).__init__(qualifier, )
    def factory(*args_, **kwargs_):
        if qualifierSArray.subclass:
            return qualifierSArray.subclass(*args_, **kwargs_)
        else:
            return qualifierSArray(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(qualifierSArray, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='qualifierSArray', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierSArray')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='qualifierSArray', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='qualifierSArray'):
        super(qualifierSArray, self).exportAttributes(outfile, level, already_processed, namespace_, name_='qualifierSArray')
    def exportChildren(self, outfile, level, namespace_='', name_='qualifierSArray', fromsubclass_=False, pretty_print=True):
        super(qualifierSArray, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='qualifierSArray'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(qualifierSArray, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(qualifierSArray, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(qualifierSArray, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(qualifierSArray, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class qualifierSArray


class AutomaticStartupAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticStartupAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if AutomaticStartupAction.subclass:
            return AutomaticStartupAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticStartupAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(AutomaticStartupAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AutomaticStartupAction', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticStartupAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AutomaticStartupAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AutomaticStartupAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticStartupAction, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticStartupAction')
    def exportChildren(self, outfile, level, namespace_='', name_='AutomaticStartupAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticStartupAction, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='AutomaticStartupAction'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(AutomaticStartupAction, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AutomaticStartupAction, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticStartupAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticStartupAction


class AutomaticShutdownAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticShutdownAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if AutomaticShutdownAction.subclass:
            return AutomaticShutdownAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticShutdownAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(AutomaticShutdownAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AutomaticShutdownAction', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticShutdownAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AutomaticShutdownAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AutomaticShutdownAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticShutdownAction, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticShutdownAction')
    def exportChildren(self, outfile, level, namespace_='', name_='AutomaticShutdownAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticShutdownAction, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='AutomaticShutdownAction'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(AutomaticShutdownAction, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AutomaticShutdownAction, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticShutdownAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticShutdownAction


class AutomaticRecoveryAction(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(AutomaticRecoveryAction, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if AutomaticRecoveryAction.subclass:
            return AutomaticRecoveryAction.subclass(*args_, **kwargs_)
        else:
            return AutomaticRecoveryAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(AutomaticRecoveryAction, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AutomaticRecoveryAction', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticRecoveryAction')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='AutomaticRecoveryAction', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AutomaticRecoveryAction'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(AutomaticRecoveryAction, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AutomaticRecoveryAction')
    def exportChildren(self, outfile, level, namespace_='', name_='AutomaticRecoveryAction', fromsubclass_=False, pretty_print=True):
        super(AutomaticRecoveryAction, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='AutomaticRecoveryAction'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(AutomaticRecoveryAction, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AutomaticRecoveryAction, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(AutomaticRecoveryAction, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AutomaticRecoveryAction


class Caption(cimString):
    subclass = None
    superclass = cimString
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(Caption, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if Caption.subclass:
            return Caption.subclass(*args_, **kwargs_)
        else:
            return Caption(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(Caption, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Caption', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Caption')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='Caption', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Caption'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(Caption, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Caption')
    def exportChildren(self, outfile, level, namespace_='', name_='Caption', fromsubclass_=False, pretty_print=True):
        super(Caption, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Caption'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(Caption, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Caption, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(Caption, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Caption


class CIM_VirtualSystemSettingData_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, AutomaticRecoveryAction=None, AutomaticShutdownAction=None, AutomaticStartupAction=None, AutomaticStartupActionDelay=None, AutomaticStartupActionSequenceNumber=None, Caption=None, ConfigurationDataRoot=None, ConfigurationFile=None, ConfigurationID=None, CreationTime=None, Description=None, ElementName=None, InstanceID=None, LogDataRoot=None, Notes=None, RecoveryFile=None, SnapshotDataRoot=None, SuspendDataRoot=None, SwapFileDataRoot=None, VirtualSystemIdentifier=None, VirtualSystemType=None, anytypeobjs_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.AutomaticRecoveryAction = AutomaticRecoveryAction
        self.validate_AutomaticRecoveryAction(self.AutomaticRecoveryAction)
        self.AutomaticShutdownAction = AutomaticShutdownAction
        self.validate_AutomaticShutdownAction(self.AutomaticShutdownAction)
        self.AutomaticStartupAction = AutomaticStartupAction
        self.validate_AutomaticStartupAction(self.AutomaticStartupAction)
        self.AutomaticStartupActionDelay = AutomaticStartupActionDelay
        self.AutomaticStartupActionSequenceNumber = AutomaticStartupActionSequenceNumber
        self.Caption = Caption
        self.ConfigurationDataRoot = ConfigurationDataRoot
        self.ConfigurationFile = ConfigurationFile
        self.ConfigurationID = ConfigurationID
        self.CreationTime = CreationTime
        self.Description = Description
        self.ElementName = ElementName
        self.InstanceID = InstanceID
        self.LogDataRoot = LogDataRoot
        if Notes is None:
            self.Notes = []
        else:
            self.Notes = Notes
        self.RecoveryFile = RecoveryFile
        self.SnapshotDataRoot = SnapshotDataRoot
        self.SuspendDataRoot = SuspendDataRoot
        self.SwapFileDataRoot = SwapFileDataRoot
        self.VirtualSystemIdentifier = VirtualSystemIdentifier
        self.VirtualSystemType = VirtualSystemType
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CIM_VirtualSystemSettingData_Type.subclass:
            return CIM_VirtualSystemSettingData_Type.subclass(*args_, **kwargs_)
        else:
            return CIM_VirtualSystemSettingData_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_AutomaticRecoveryAction(self): return self.AutomaticRecoveryAction
    def set_AutomaticRecoveryAction(self, AutomaticRecoveryAction): self.AutomaticRecoveryAction = AutomaticRecoveryAction
    def get_AutomaticShutdownAction(self): return self.AutomaticShutdownAction
    def set_AutomaticShutdownAction(self, AutomaticShutdownAction): self.AutomaticShutdownAction = AutomaticShutdownAction
    def get_AutomaticStartupAction(self): return self.AutomaticStartupAction
    def set_AutomaticStartupAction(self, AutomaticStartupAction): self.AutomaticStartupAction = AutomaticStartupAction
    def get_AutomaticStartupActionDelay(self): return self.AutomaticStartupActionDelay
    def set_AutomaticStartupActionDelay(self, AutomaticStartupActionDelay): self.AutomaticStartupActionDelay = AutomaticStartupActionDelay
    def get_AutomaticStartupActionSequenceNumber(self): return self.AutomaticStartupActionSequenceNumber
    def set_AutomaticStartupActionSequenceNumber(self, AutomaticStartupActionSequenceNumber): self.AutomaticStartupActionSequenceNumber = AutomaticStartupActionSequenceNumber
    def get_Caption(self): return self.Caption
    def set_Caption(self, Caption): self.Caption = Caption
    def get_ConfigurationDataRoot(self): return self.ConfigurationDataRoot
    def set_ConfigurationDataRoot(self, ConfigurationDataRoot): self.ConfigurationDataRoot = ConfigurationDataRoot
    def get_ConfigurationFile(self): return self.ConfigurationFile
    def set_ConfigurationFile(self, ConfigurationFile): self.ConfigurationFile = ConfigurationFile
    def get_ConfigurationID(self): return self.ConfigurationID
    def set_ConfigurationID(self, ConfigurationID): self.ConfigurationID = ConfigurationID
    def get_CreationTime(self): return self.CreationTime
    def set_CreationTime(self, CreationTime): self.CreationTime = CreationTime
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ElementName(self): return self.ElementName
    def set_ElementName(self, ElementName): self.ElementName = ElementName
    def get_InstanceID(self): return self.InstanceID
    def set_InstanceID(self, InstanceID): self.InstanceID = InstanceID
    def get_LogDataRoot(self): return self.LogDataRoot
    def set_LogDataRoot(self, LogDataRoot): self.LogDataRoot = LogDataRoot
    def get_Notes(self): return self.Notes
    def set_Notes(self, Notes): self.Notes = Notes
    def add_Notes(self, value): self.Notes.append(value)
    def insert_Notes_at(self, index, value): self.Notes.insert(index, value)
    def replace_Notes_at(self, index, value): self.Notes[index] = value
    def get_RecoveryFile(self): return self.RecoveryFile
    def set_RecoveryFile(self, RecoveryFile): self.RecoveryFile = RecoveryFile
    def get_SnapshotDataRoot(self): return self.SnapshotDataRoot
    def set_SnapshotDataRoot(self, SnapshotDataRoot): self.SnapshotDataRoot = SnapshotDataRoot
    def get_SuspendDataRoot(self): return self.SuspendDataRoot
    def set_SuspendDataRoot(self, SuspendDataRoot): self.SuspendDataRoot = SuspendDataRoot
    def get_SwapFileDataRoot(self): return self.SwapFileDataRoot
    def set_SwapFileDataRoot(self, SwapFileDataRoot): self.SwapFileDataRoot = SwapFileDataRoot
    def get_VirtualSystemIdentifier(self): return self.VirtualSystemIdentifier
    def set_VirtualSystemIdentifier(self, VirtualSystemIdentifier): self.VirtualSystemIdentifier = VirtualSystemIdentifier
    def get_VirtualSystemType(self): return self.VirtualSystemType
    def set_VirtualSystemType(self, VirtualSystemType): self.VirtualSystemType = VirtualSystemType
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_AutomaticRecoveryAction(self, value):
        # Validate type AutomaticRecoveryAction, a restriction on xs:unsignedShort.
        pass
    def validate_AutomaticShutdownAction(self, value):
        # Validate type AutomaticShutdownAction, a restriction on xs:unsignedShort.
        pass
    def validate_AutomaticStartupAction(self, value):
        # Validate type AutomaticStartupAction, a restriction on xs:unsignedShort.
        pass
    def hasContent_(self):
        if (
            self.AutomaticRecoveryAction is not None or
            self.AutomaticShutdownAction is not None or
            self.AutomaticStartupAction is not None or
            self.AutomaticStartupActionDelay is not None or
            self.AutomaticStartupActionSequenceNumber is not None or
            self.Caption is not None or
            self.ConfigurationDataRoot is not None or
            self.ConfigurationFile is not None or
            self.ConfigurationID is not None or
            self.CreationTime is not None or
            self.Description is not None or
            self.ElementName is not None or
            self.InstanceID is not None or
            self.LogDataRoot is not None or
            self.Notes or
            self.RecoveryFile is not None or
            self.SnapshotDataRoot is not None or
            self.SuspendDataRoot is not None or
            self.SwapFileDataRoot is not None or
            self.VirtualSystemIdentifier is not None or
            self.VirtualSystemType is not None or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CIM_VirtualSystemSettingData_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CIM_VirtualSystemSettingData_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CIM_VirtualSystemSettingData_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CIM_VirtualSystemSettingData_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CIM_VirtualSystemSettingData_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AutomaticRecoveryAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAutomaticRecoveryAction>%s</%sAutomaticRecoveryAction>%s' % (namespace_, self.gds_format_integer(self.AutomaticRecoveryAction, input_name='AutomaticRecoveryAction'), namespace_, eol_))
        if self.AutomaticShutdownAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAutomaticShutdownAction>%s</%sAutomaticShutdownAction>%s' % (namespace_, self.gds_format_integer(self.AutomaticShutdownAction, input_name='AutomaticShutdownAction'), namespace_, eol_))
        if self.AutomaticStartupAction is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAutomaticStartupAction>%s</%sAutomaticStartupAction>%s' % (namespace_, self.gds_format_integer(self.AutomaticStartupAction, input_name='AutomaticStartupAction'), namespace_, eol_))
        if self.AutomaticStartupActionDelay is not None:
            self.AutomaticStartupActionDelay.export(outfile, level, namespace_='class:', name_='AutomaticStartupActionDelay', pretty_print=pretty_print)
        if self.AutomaticStartupActionSequenceNumber is not None:
            self.AutomaticStartupActionSequenceNumber.export(outfile, level, namespace_='class:', name_='AutomaticStartupActionSequenceNumber', pretty_print=pretty_print)
        if self.Caption is not None:
            self.Caption.export(outfile, level, namespace_='class:', name_='Caption', pretty_print=pretty_print)
        if self.ConfigurationDataRoot is not None:
            self.ConfigurationDataRoot.export(outfile, level, namespace_='class:', name_='ConfigurationDataRoot', pretty_print=pretty_print)
        if self.ConfigurationFile is not None:
            self.ConfigurationFile.export(outfile, level, namespace_='class:', name_='ConfigurationFile', pretty_print=pretty_print)
        if self.ConfigurationID is not None:
            self.ConfigurationID.export(outfile, level, namespace_='class:', name_='ConfigurationID', pretty_print=pretty_print)
        if self.CreationTime is not None:
            self.CreationTime.export(outfile, level, namespace_='class:', name_='CreationTime', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_='class:', name_='Description', pretty_print=pretty_print)
        if self.ElementName is not None:
            self.ElementName.export(outfile, level, namespace_='class:', name_='ElementName', pretty_print=pretty_print)
        if self.InstanceID is not None:
            self.InstanceID.export(outfile, level, namespace_='class:', name_='InstanceID', pretty_print=pretty_print)
        if self.LogDataRoot is not None:
            self.LogDataRoot.export(outfile, level, namespace_='class:', name_='LogDataRoot', pretty_print=pretty_print)
        for Notes_ in self.Notes:
            Notes_.export(outfile, level, namespace_='class:', name_='Notes', pretty_print=pretty_print)
        if self.RecoveryFile is not None:
            self.RecoveryFile.export(outfile, level, namespace_='class:', name_='RecoveryFile', pretty_print=pretty_print)
        if self.SnapshotDataRoot is not None:
            self.SnapshotDataRoot.export(outfile, level, namespace_='class:', name_='SnapshotDataRoot', pretty_print=pretty_print)
        if self.SuspendDataRoot is not None:
            self.SuspendDataRoot.export(outfile, level, namespace_='class:', name_='SuspendDataRoot', pretty_print=pretty_print)
        if self.SwapFileDataRoot is not None:
            self.SwapFileDataRoot.export(outfile, level, namespace_='class:', name_='SwapFileDataRoot', pretty_print=pretty_print)
        if self.VirtualSystemIdentifier is not None:
            self.VirtualSystemIdentifier.export(outfile, level, namespace_='class:', name_='VirtualSystemIdentifier', pretty_print=pretty_print)
        if self.VirtualSystemType is not None:
            self.VirtualSystemType.export(outfile, level, namespace_='class:', name_='VirtualSystemType', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CIM_VirtualSystemSettingData_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.AutomaticRecoveryAction is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticRecoveryAction=%d,\n' % self.AutomaticRecoveryAction)
        if self.AutomaticShutdownAction is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticShutdownAction=%d,\n' % self.AutomaticShutdownAction)
        if self.AutomaticStartupAction is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticStartupAction=%d,\n' % self.AutomaticStartupAction)
        if self.AutomaticStartupActionDelay is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticStartupActionDelay=model_.AutomaticStartupActionDelay(\n')
            self.AutomaticStartupActionDelay.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AutomaticStartupActionSequenceNumber is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticStartupActionSequenceNumber=model_.AutomaticStartupActionSequenceNumber(\n')
            self.AutomaticStartupActionSequenceNumber.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Caption is not None:
            showIndent(outfile, level)
            outfile.write('Caption=model_.Caption(\n')
            self.Caption.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ConfigurationDataRoot is not None:
            showIndent(outfile, level)
            outfile.write('ConfigurationDataRoot=model_.ConfigurationDataRoot(\n')
            self.ConfigurationDataRoot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ConfigurationFile is not None:
            showIndent(outfile, level)
            outfile.write('ConfigurationFile=model_.ConfigurationFile(\n')
            self.ConfigurationFile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ConfigurationID is not None:
            showIndent(outfile, level)
            outfile.write('ConfigurationID=model_.ConfigurationID(\n')
            self.ConfigurationID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.CreationTime is not None:
            showIndent(outfile, level)
            outfile.write('CreationTime=model_.CreationTime(\n')
            self.CreationTime.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Description(\n')
            self.Description.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ElementName is not None:
            showIndent(outfile, level)
            outfile.write('ElementName=model_.ElementName(\n')
            self.ElementName.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.InstanceID is not None:
            showIndent(outfile, level)
            outfile.write('InstanceID=model_.InstanceID(\n')
            self.InstanceID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.LogDataRoot is not None:
            showIndent(outfile, level)
            outfile.write('LogDataRoot=model_.LogDataRoot(\n')
            self.LogDataRoot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Notes=[\n')
        level += 1
        for Notes_ in self.Notes:
            showIndent(outfile, level)
            outfile.write('model_.Notes(\n')
            Notes_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.RecoveryFile is not None:
            showIndent(outfile, level)
            outfile.write('RecoveryFile=model_.RecoveryFile(\n')
            self.RecoveryFile.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SnapshotDataRoot is not None:
            showIndent(outfile, level)
            outfile.write('SnapshotDataRoot=model_.SnapshotDataRoot(\n')
            self.SnapshotDataRoot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SuspendDataRoot is not None:
            showIndent(outfile, level)
            outfile.write('SuspendDataRoot=model_.SuspendDataRoot(\n')
            self.SuspendDataRoot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.SwapFileDataRoot is not None:
            showIndent(outfile, level)
            outfile.write('SwapFileDataRoot=model_.SwapFileDataRoot(\n')
            self.SwapFileDataRoot.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.VirtualSystemIdentifier is not None:
            showIndent(outfile, level)
            outfile.write('VirtualSystemIdentifier=model_.VirtualSystemIdentifier(\n')
            self.VirtualSystemIdentifier.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.VirtualSystemType is not None:
            showIndent(outfile, level)
            outfile.write('VirtualSystemType=model_.VirtualSystemType(\n')
            self.VirtualSystemType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'AutomaticRecoveryAction':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticRecoveryAction')
            self.AutomaticRecoveryAction = ival_
            self.validate_AutomaticRecoveryAction(self.AutomaticRecoveryAction)    # validate type AutomaticRecoveryAction
        elif nodeName_ == 'AutomaticShutdownAction':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticShutdownAction')
            self.AutomaticShutdownAction = ival_
            self.validate_AutomaticShutdownAction(self.AutomaticShutdownAction)    # validate type AutomaticShutdownAction
        elif nodeName_ == 'AutomaticStartupAction':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'AutomaticStartupAction')
            self.AutomaticStartupAction = ival_
            self.validate_AutomaticStartupAction(self.AutomaticStartupAction)    # validate type AutomaticStartupAction
        elif nodeName_ == 'AutomaticStartupActionDelay':
            obj_ = cimDateTime.factory()
            obj_.build(child_)
            self.AutomaticStartupActionDelay = obj_
            obj_.original_tagname_ = 'AutomaticStartupActionDelay'
        elif nodeName_ == 'AutomaticStartupActionSequenceNumber':
            obj_ = cimUnsignedShort.factory()
            obj_.build(child_)
            self.AutomaticStartupActionSequenceNumber = obj_
            obj_.original_tagname_ = 'AutomaticStartupActionSequenceNumber'
        elif nodeName_ == 'Caption':
            obj_ = Caption.factory()
            obj_.build(child_)
            self.Caption = obj_
            obj_.original_tagname_ = 'Caption'
        elif nodeName_ == 'ConfigurationDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationDataRoot = obj_
            obj_.original_tagname_ = 'ConfigurationDataRoot'
        elif nodeName_ == 'ConfigurationFile':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationFile = obj_
            obj_.original_tagname_ = 'ConfigurationFile'
        elif nodeName_ == 'ConfigurationID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ConfigurationID = obj_
            obj_.original_tagname_ = 'ConfigurationID'
        elif nodeName_ == 'CreationTime':
            obj_ = cimDateTime.factory()
            obj_.build(child_)
            self.CreationTime = obj_
            obj_.original_tagname_ = 'CreationTime'
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'ElementName':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ElementName = obj_
            obj_.original_tagname_ = 'ElementName'
        elif nodeName_ == 'InstanceID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.InstanceID = obj_
            obj_.original_tagname_ = 'InstanceID'
        elif nodeName_ == 'LogDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.LogDataRoot = obj_
            obj_.original_tagname_ = 'LogDataRoot'
        elif nodeName_ == 'Notes':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Notes.append(obj_)
            obj_.original_tagname_ = 'Notes'
        elif nodeName_ == 'RecoveryFile':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.RecoveryFile = obj_
            obj_.original_tagname_ = 'RecoveryFile'
        elif nodeName_ == 'SnapshotDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SnapshotDataRoot = obj_
            obj_.original_tagname_ = 'SnapshotDataRoot'
        elif nodeName_ == 'SuspendDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SuspendDataRoot = obj_
            obj_.original_tagname_ = 'SuspendDataRoot'
        elif nodeName_ == 'SwapFileDataRoot':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.SwapFileDataRoot = obj_
            obj_.original_tagname_ = 'SwapFileDataRoot'
        elif nodeName_ == 'VirtualSystemIdentifier':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualSystemIdentifier = obj_
            obj_.original_tagname_ = 'VirtualSystemIdentifier'
        elif nodeName_ == 'VirtualSystemType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualSystemType = obj_
            obj_.original_tagname_ = 'VirtualSystemType'
        else:
            obj_ = self.gds_build_any(child_, 'CIM_VirtualSystemSettingData_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class CIM_VirtualSystemSettingData_Type


class ConsumerVisibility(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(ConsumerVisibility, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if ConsumerVisibility.subclass:
            return ConsumerVisibility.subclass(*args_, **kwargs_)
        else:
            return ConsumerVisibility(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(ConsumerVisibility, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConsumerVisibility', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConsumerVisibility')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ConsumerVisibility', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConsumerVisibility'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(ConsumerVisibility, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ConsumerVisibility')
    def exportChildren(self, outfile, level, namespace_='', name_='ConsumerVisibility', fromsubclass_=False, pretty_print=True):
        super(ConsumerVisibility, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='ConsumerVisibility'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(ConsumerVisibility, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ConsumerVisibility, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(ConsumerVisibility, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConsumerVisibility


class MappingBehavior(cimAnySimpleType):
    subclass = None
    superclass = cimAnySimpleType
    def __init__(self, valueOf_=None):
        self.original_tagname_ = None
        super(MappingBehavior, self).__init__(valueOf_, )
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if MappingBehavior.subclass:
            return MappingBehavior.subclass(*args_, **kwargs_)
        else:
            return MappingBehavior(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(MappingBehavior, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MappingBehavior', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MappingBehavior')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MappingBehavior', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MappingBehavior'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(MappingBehavior, self).exportAttributes(outfile, level, already_processed, namespace_, name_='MappingBehavior')
    def exportChildren(self, outfile, level, namespace_='', name_='MappingBehavior', fromsubclass_=False, pretty_print=True):
        super(MappingBehavior, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='MappingBehavior'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(MappingBehavior, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(MappingBehavior, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(MappingBehavior, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MappingBehavior


class CIM_ResourceAllocationSettingData_Type(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Address=None, AddressOnParent=None, AllocationUnits=None, AutomaticAllocation=None, AutomaticDeallocation=None, Caption=None, Connection=None, ConsumerVisibility=None, Description=None, ElementName=None, HostResource=None, InstanceID=None, Limit=None, MappingBehavior=None, OtherResourceType=None, Parent=None, PoolID=None, Reservation=None, ResourceSubType=None, ResourceType=None, VirtualQuantity=None, VirtualQuantityUnits=None, Weight=None, anytypeobjs_=None, extensiontype_=None):
        self.original_tagname_ = None
        self.Address = Address
        self.AddressOnParent = AddressOnParent
        self.AllocationUnits = AllocationUnits
        self.AutomaticAllocation = AutomaticAllocation
        self.AutomaticDeallocation = AutomaticDeallocation
        self.Caption = Caption
        if Connection is None:
            self.Connection = []
        else:
            self.Connection = Connection
        self.ConsumerVisibility = ConsumerVisibility
        self.validate_ConsumerVisibility(self.ConsumerVisibility)
        self.Description = Description
        self.ElementName = ElementName
        if HostResource is None:
            self.HostResource = []
        else:
            self.HostResource = HostResource
        self.InstanceID = InstanceID
        self.Limit = Limit
        self.MappingBehavior = MappingBehavior
        self.validate_MappingBehavior(self.MappingBehavior)
        self.OtherResourceType = OtherResourceType
        self.Parent = Parent
        self.PoolID = PoolID
        self.Reservation = Reservation
        self.ResourceSubType = ResourceSubType
        self.ResourceType = ResourceType
        self.validate_ResourceType(self.ResourceType)
        self.VirtualQuantity = VirtualQuantity
        self.VirtualQuantityUnits = VirtualQuantityUnits
        self.Weight = Weight
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
        self.anyAttributes_ = {}
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CIM_ResourceAllocationSettingData_Type.subclass:
            return CIM_ResourceAllocationSettingData_Type.subclass(*args_, **kwargs_)
        else:
            return CIM_ResourceAllocationSettingData_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Address(self): return self.Address
    def set_Address(self, Address): self.Address = Address
    def get_AddressOnParent(self): return self.AddressOnParent
    def set_AddressOnParent(self, AddressOnParent): self.AddressOnParent = AddressOnParent
    def get_AllocationUnits(self): return self.AllocationUnits
    def set_AllocationUnits(self, AllocationUnits): self.AllocationUnits = AllocationUnits
    def get_AutomaticAllocation(self): return self.AutomaticAllocation
    def set_AutomaticAllocation(self, AutomaticAllocation): self.AutomaticAllocation = AutomaticAllocation
    def get_AutomaticDeallocation(self): return self.AutomaticDeallocation
    def set_AutomaticDeallocation(self, AutomaticDeallocation): self.AutomaticDeallocation = AutomaticDeallocation
    def get_Caption(self): return self.Caption
    def set_Caption(self, Caption): self.Caption = Caption
    def get_Connection(self): return self.Connection
    def set_Connection(self, Connection): self.Connection = Connection
    def add_Connection(self, value): self.Connection.append(value)
    def insert_Connection_at(self, index, value): self.Connection.insert(index, value)
    def replace_Connection_at(self, index, value): self.Connection[index] = value
    def get_ConsumerVisibility(self): return self.ConsumerVisibility
    def set_ConsumerVisibility(self, ConsumerVisibility): self.ConsumerVisibility = ConsumerVisibility
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_ElementName(self): return self.ElementName
    def set_ElementName(self, ElementName): self.ElementName = ElementName
    def get_HostResource(self): return self.HostResource
    def set_HostResource(self, HostResource): self.HostResource = HostResource
    def add_HostResource(self, value): self.HostResource.append(value)
    def insert_HostResource_at(self, index, value): self.HostResource.insert(index, value)
    def replace_HostResource_at(self, index, value): self.HostResource[index] = value
    def get_InstanceID(self): return self.InstanceID
    def set_InstanceID(self, InstanceID): self.InstanceID = InstanceID
    def get_Limit(self): return self.Limit
    def set_Limit(self, Limit): self.Limit = Limit
    def get_MappingBehavior(self): return self.MappingBehavior
    def set_MappingBehavior(self, MappingBehavior): self.MappingBehavior = MappingBehavior
    def get_OtherResourceType(self): return self.OtherResourceType
    def set_OtherResourceType(self, OtherResourceType): self.OtherResourceType = OtherResourceType
    def get_Parent(self): return self.Parent
    def set_Parent(self, Parent): self.Parent = Parent
    def get_PoolID(self): return self.PoolID
    def set_PoolID(self, PoolID): self.PoolID = PoolID
    def get_Reservation(self): return self.Reservation
    def set_Reservation(self, Reservation): self.Reservation = Reservation
    def get_ResourceSubType(self): return self.ResourceSubType
    def set_ResourceSubType(self, ResourceSubType): self.ResourceSubType = ResourceSubType
    def get_ResourceType(self): return self.ResourceType
    def set_ResourceType(self, ResourceType): self.ResourceType = ResourceType
    def get_VirtualQuantity(self): return self.VirtualQuantity
    def set_VirtualQuantity(self, VirtualQuantity): self.VirtualQuantity = VirtualQuantity
    def get_VirtualQuantityUnits(self): return self.VirtualQuantityUnits
    def set_VirtualQuantityUnits(self, VirtualQuantityUnits): self.VirtualQuantityUnits = VirtualQuantityUnits
    def get_Weight(self): return self.Weight
    def set_Weight(self, Weight): self.Weight = Weight
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_ConsumerVisibility(self, value):
        # Validate type ConsumerVisibility, a restriction on xs:unsignedShort.
        pass
    def validate_MappingBehavior(self, value):
        # Validate type MappingBehavior, a restriction on xs:unsignedShort.
        pass
    def validate_ResourceType(self, value):
        # Validate type ResourceType, a restriction on xs:unsignedShort.
        pass
    def hasContent_(self):
        if (
            self.Address is not None or
            self.AddressOnParent is not None or
            self.AllocationUnits is not None or
            self.AutomaticAllocation is not None or
            self.AutomaticDeallocation is not None or
            self.Caption is not None or
            self.Connection or
            self.ConsumerVisibility is not None or
            self.Description is not None or
            self.ElementName is not None or
            self.HostResource or
            self.InstanceID is not None or
            self.Limit is not None or
            self.MappingBehavior is not None or
            self.OtherResourceType is not None or
            self.Parent is not None or
            self.PoolID is not None or
            self.Reservation is not None or
            self.ResourceSubType is not None or
            self.ResourceType is not None or
            self.VirtualQuantity is not None or
            self.VirtualQuantityUnits is not None or
            self.Weight is not None or
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CIM_ResourceAllocationSettingData_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CIM_ResourceAllocationSettingData_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CIM_ResourceAllocationSettingData_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CIM_ResourceAllocationSettingData_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CIM_ResourceAllocationSettingData_Type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Address is not None:
            self.Address.export(outfile, level, namespace_='class:', name_='Address', pretty_print=pretty_print)
        if self.AddressOnParent is not None:
            self.AddressOnParent.export(outfile, level, namespace_='class:', name_='AddressOnParent', pretty_print=pretty_print)
        if self.AllocationUnits is not None:
            self.AllocationUnits.export(outfile, level, namespace_='class:', name_='AllocationUnits', pretty_print=pretty_print)
        if self.AutomaticAllocation is not None:
            self.AutomaticAllocation.export(outfile, level, namespace_='class:', name_='AutomaticAllocation', pretty_print=pretty_print)
        if self.AutomaticDeallocation is not None:
            self.AutomaticDeallocation.export(outfile, level, namespace_='class:', name_='AutomaticDeallocation', pretty_print=pretty_print)
        if self.Caption is not None:
            self.Caption.export(outfile, level, namespace_='class:', name_='Caption', pretty_print=pretty_print)
        for Connection_ in self.Connection:
            Connection_.export(outfile, level, namespace_='class:', name_='Connection', pretty_print=pretty_print)
        if self.ConsumerVisibility is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsumerVisibility>%s</%sConsumerVisibility>%s' % (namespace_, self.gds_format_integer(self.ConsumerVisibility, input_name='ConsumerVisibility'), namespace_, eol_))
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_='class:', name_='Description', pretty_print=pretty_print)
        if self.ElementName is not None:
            self.ElementName.export(outfile, level, namespace_='class:', name_='ElementName', pretty_print=pretty_print)
        for HostResource_ in self.HostResource:
            HostResource_.export(outfile, level, namespace_='class:', name_='HostResource', pretty_print=pretty_print)
        if self.InstanceID is not None:
            self.InstanceID.export(outfile, level, namespace_='class:', name_='InstanceID', pretty_print=pretty_print)
        if self.Limit is not None:
            self.Limit.export(outfile, level, namespace_='class:', name_='Limit', pretty_print=pretty_print)
        if self.MappingBehavior is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMappingBehavior>%s</%sMappingBehavior>%s' % (namespace_, self.gds_format_integer(self.MappingBehavior, input_name='MappingBehavior'), namespace_, eol_))
        if self.OtherResourceType is not None:
            self.OtherResourceType.export(outfile, level, namespace_='class:', name_='OtherResourceType', pretty_print=pretty_print)
        if self.Parent is not None:
            self.Parent.export(outfile, level, namespace_='class:', name_='Parent', pretty_print=pretty_print)
        if self.PoolID is not None:
            self.PoolID.export(outfile, level, namespace_='class:', name_='PoolID', pretty_print=pretty_print)
        if self.Reservation is not None:
            self.Reservation.export(outfile, level, namespace_='class:', name_='Reservation', pretty_print=pretty_print)
        if self.ResourceSubType is not None:
            self.ResourceSubType.export(outfile, level, namespace_='class:', name_='ResourceSubType', pretty_print=pretty_print)
        if self.ResourceType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sResourceType>%s</%sResourceType>%s' % (namespace_, self.gds_format_integer(self.ResourceType, input_name='ResourceType'), namespace_, eol_))
        if self.VirtualQuantity is not None:
            self.VirtualQuantity.export(outfile, level, namespace_='class:', name_='VirtualQuantity', pretty_print=pretty_print)
        if self.VirtualQuantityUnits is not None:
            self.VirtualQuantityUnits.export(outfile, level, namespace_='class:', name_='VirtualQuantityUnits', pretty_print=pretty_print)
        if self.Weight is not None:
            self.Weight.export(outfile, level, namespace_='class:', name_='Weight', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CIM_ResourceAllocationSettingData_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Address is not None:
            showIndent(outfile, level)
            outfile.write('Address=model_.Address(\n')
            self.Address.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AddressOnParent is not None:
            showIndent(outfile, level)
            outfile.write('AddressOnParent=model_.AddressOnParent(\n')
            self.AddressOnParent.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AllocationUnits is not None:
            showIndent(outfile, level)
            outfile.write('AllocationUnits=model_.AllocationUnits(\n')
            self.AllocationUnits.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AutomaticAllocation is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticAllocation=model_.AutomaticAllocation(\n')
            self.AutomaticAllocation.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.AutomaticDeallocation is not None:
            showIndent(outfile, level)
            outfile.write('AutomaticDeallocation=model_.AutomaticDeallocation(\n')
            self.AutomaticDeallocation.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Caption is not None:
            showIndent(outfile, level)
            outfile.write('Caption=model_.Caption(\n')
            self.Caption.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Connection=[\n')
        level += 1
        for Connection_ in self.Connection:
            showIndent(outfile, level)
            outfile.write('model_.Connection(\n')
            Connection_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.ConsumerVisibility is not None:
            showIndent(outfile, level)
            outfile.write('ConsumerVisibility=%d,\n' % self.ConsumerVisibility)
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Description(\n')
            self.Description.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ElementName is not None:
            showIndent(outfile, level)
            outfile.write('ElementName=model_.ElementName(\n')
            self.ElementName.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('HostResource=[\n')
        level += 1
        for HostResource_ in self.HostResource:
            showIndent(outfile, level)
            outfile.write('model_.HostResource(\n')
            HostResource_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.InstanceID is not None:
            showIndent(outfile, level)
            outfile.write('InstanceID=model_.InstanceID(\n')
            self.InstanceID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Limit is not None:
            showIndent(outfile, level)
            outfile.write('Limit=model_.Limit(\n')
            self.Limit.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.MappingBehavior is not None:
            showIndent(outfile, level)
            outfile.write('MappingBehavior=%d,\n' % self.MappingBehavior)
        if self.OtherResourceType is not None:
            showIndent(outfile, level)
            outfile.write('OtherResourceType=model_.OtherResourceType(\n')
            self.OtherResourceType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Parent is not None:
            showIndent(outfile, level)
            outfile.write('Parent=model_.Parent(\n')
            self.Parent.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.PoolID is not None:
            showIndent(outfile, level)
            outfile.write('PoolID=model_.PoolID(\n')
            self.PoolID.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Reservation is not None:
            showIndent(outfile, level)
            outfile.write('Reservation=model_.Reservation(\n')
            self.Reservation.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ResourceSubType is not None:
            showIndent(outfile, level)
            outfile.write('ResourceSubType=model_.ResourceSubType(\n')
            self.ResourceSubType.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.ResourceType is not None:
            showIndent(outfile, level)
            outfile.write('ResourceType=%d,\n' % self.ResourceType)
        if self.VirtualQuantity is not None:
            showIndent(outfile, level)
            outfile.write('VirtualQuantity=model_.VirtualQuantity(\n')
            self.VirtualQuantity.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.VirtualQuantityUnits is not None:
            showIndent(outfile, level)
            outfile.write('VirtualQuantityUnits=model_.VirtualQuantityUnits(\n')
            self.VirtualQuantityUnits.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Weight is not None:
            showIndent(outfile, level)
            outfile.write('Weight=model_.Weight(\n')
            self.Weight.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Address':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Address = obj_
            obj_.original_tagname_ = 'Address'
        elif nodeName_ == 'AddressOnParent':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AddressOnParent = obj_
            obj_.original_tagname_ = 'AddressOnParent'
        elif nodeName_ == 'AllocationUnits':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AllocationUnits = obj_
            obj_.original_tagname_ = 'AllocationUnits'
        elif nodeName_ == 'AutomaticAllocation':
            class_obj_ = self.get_class_obj_(child_, cimBoolean)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AutomaticAllocation = obj_
            obj_.original_tagname_ = 'AutomaticAllocation'
        elif nodeName_ == 'AutomaticDeallocation':
            class_obj_ = self.get_class_obj_(child_, cimBoolean)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.AutomaticDeallocation = obj_
            obj_.original_tagname_ = 'AutomaticDeallocation'
        elif nodeName_ == 'Caption':
            obj_ = Caption.factory()
            obj_.build(child_)
            self.Caption = obj_
            obj_.original_tagname_ = 'Caption'
        elif nodeName_ == 'Connection':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Connection.append(obj_)
            obj_.original_tagname_ = 'Connection'
        elif nodeName_ == 'ConsumerVisibility':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ConsumerVisibility')
            self.ConsumerVisibility = ival_
            self.validate_ConsumerVisibility(self.ConsumerVisibility)    # validate type ConsumerVisibility
        elif nodeName_ == 'Description':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'ElementName':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ElementName = obj_
            obj_.original_tagname_ = 'ElementName'
        elif nodeName_ == 'HostResource':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.HostResource.append(obj_)
            obj_.original_tagname_ = 'HostResource'
        elif nodeName_ == 'InstanceID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.InstanceID = obj_
            obj_.original_tagname_ = 'InstanceID'
        elif nodeName_ == 'Limit':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.Limit = obj_
            obj_.original_tagname_ = 'Limit'
        elif nodeName_ == 'MappingBehavior':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'MappingBehavior')
            self.MappingBehavior = ival_
            self.validate_MappingBehavior(self.MappingBehavior)    # validate type MappingBehavior
        elif nodeName_ == 'OtherResourceType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.OtherResourceType = obj_
            obj_.original_tagname_ = 'OtherResourceType'
        elif nodeName_ == 'Parent':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Parent = obj_
            obj_.original_tagname_ = 'Parent'
        elif nodeName_ == 'PoolID':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.PoolID = obj_
            obj_.original_tagname_ = 'PoolID'
        elif nodeName_ == 'Reservation':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.Reservation = obj_
            obj_.original_tagname_ = 'Reservation'
        elif nodeName_ == 'ResourceSubType':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.ResourceSubType = obj_
            obj_.original_tagname_ = 'ResourceSubType'
        elif nodeName_ == 'ResourceType':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'ResourceType')
            self.ResourceType = ival_
            self.validate_ResourceType(self.ResourceType)    # validate type ResourceType
        elif nodeName_ == 'VirtualQuantity':
            obj_ = cimUnsignedLong.factory()
            obj_.build(child_)
            self.VirtualQuantity = obj_
            obj_.original_tagname_ = 'VirtualQuantity'
        elif nodeName_ == 'VirtualQuantityUnits':
            class_obj_ = self.get_class_obj_(child_, cimString)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VirtualQuantityUnits = obj_
            obj_.original_tagname_ = 'VirtualQuantityUnits'
        elif nodeName_ == 'Weight':
            class_obj_ = self.get_class_obj_(child_, cimUnsignedInt)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Weight = obj_
            obj_.original_tagname_ = 'Weight'
        else:
            obj_ = self.gds_build_any(child_, 'CIM_ResourceAllocationSettingData_Type')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
# end class CIM_ResourceAllocationSettingData_Type


class MsgType(GeneratedsSuper):
    """String element valueString element identifier"""
    subclass = None
    superclass = None
    def __init__(self, msgid=None, valueOf_=None):
        self.original_tagname_ = None
        self.msgid = _cast(None, msgid)
        self.valueOf_ = valueOf_
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if MsgType.subclass:
            return MsgType.subclass(*args_, **kwargs_)
        else:
            return MsgType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_msgid(self): return self.msgid
    def set_msgid(self, msgid): self.msgid = msgid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MsgType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MsgType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MsgType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MsgType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.msgid is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            outfile.write(' msgid=%s' % (self.gds_format_string(quote_attrib(self.msgid).encode(ExternalEncoding), input_name='msgid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MsgType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='MsgType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.msgid is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            showIndent(outfile, level)
            outfile.write('msgid="%s",\n' % (self.msgid,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('msgid', node)
        if value is not None and 'msgid' not in already_processed:
            already_processed.add('msgid')
            self.msgid = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MsgType


class IconType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, mimeType=None, width=None, fileRef=None, height=None):
        self.original_tagname_ = None
        self.mimeType = _cast(None, mimeType)
        self.width = _cast(int, width)
        self.fileRef = _cast(None, fileRef)
        self.height = _cast(int, height)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if IconType.subclass:
            return IconType.subclass(*args_, **kwargs_)
        else:
            return IconType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mimeType(self): return self.mimeType
    def set_mimeType(self, mimeType): self.mimeType = mimeType
    def get_width(self): return self.width
    def set_width(self, width): self.width = width
    def get_fileRef(self): return self.fileRef
    def set_fileRef(self, fileRef): self.fileRef = fileRef
    def get_height(self): return self.height
    def set_height(self, height): self.height = height
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IconType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IconType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='IconType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IconType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            outfile.write(' mimeType=%s' % (self.gds_format_string(quote_attrib(self.mimeType).encode(ExternalEncoding), input_name='mimeType'), ))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            outfile.write(' width="%s"' % self.gds_format_integer(self.width, input_name='width'))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            outfile.write(' fileRef=%s' % (self.gds_format_string(quote_attrib(self.fileRef).encode(ExternalEncoding), input_name='fileRef'), ))
        if self.height is not None and 'height' not in already_processed:
            already_processed.add('height')
            outfile.write(' height="%s"' % self.gds_format_integer(self.height, input_name='height'))
    def exportChildren(self, outfile, level, namespace_='', name_='IconType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='IconType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.mimeType is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            showIndent(outfile, level)
            outfile.write('mimeType="%s",\n' % (self.mimeType,))
        if self.width is not None and 'width' not in already_processed:
            already_processed.add('width')
            showIndent(outfile, level)
            outfile.write('width=%d,\n' % (self.width,))
        if self.fileRef is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            showIndent(outfile, level)
            outfile.write('fileRef="%s",\n' % (self.fileRef,))
        if self.height is not None and 'height' not in already_processed:
            already_processed.add('height')
            showIndent(outfile, level)
            outfile.write('height=%d,\n' % (self.height,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('mimeType', node)
        if value is not None and 'mimeType' not in already_processed:
            already_processed.add('mimeType')
            self.mimeType = value
        value = find_attr_value_('width', node)
        if value is not None and 'width' not in already_processed:
            already_processed.add('width')
            try:
                self.width = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('fileRef', node)
        if value is not None and 'fileRef' not in already_processed:
            already_processed.add('fileRef')
            self.fileRef = value
        value = find_attr_value_('height', node)
        if value is not None and 'height' not in already_processed:
            already_processed.add('height')
            try:
                self.height = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class IconType


class PropertyType(GeneratedsSuper):
    """Property identifierProperty typeA comma-separated set of type
    qualifiersDetermines whether the property value is configurable
    during installationDefault value for propertyDetermines whether
    the property value should be obscured during deployment"""
    subclass = None
    superclass = None
    def __init__(self, userConfigurable=False, value='', key=None, password=False, type_=None, qualifiers=None, Label=None, Description=None, Value=None):
        self.original_tagname_ = None
        self.userConfigurable = _cast(bool, userConfigurable)
        self.value = _cast(None, value)
        self.key = _cast(None, key)
        self.password = _cast(bool, password)
        self.type_ = _cast(None, type_)
        self.qualifiers = _cast(None, qualifiers)
        self.Label = Label
        self.Description = Description
        if Value is None:
            self.Value = []
        else:
            self.Value = Value
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if PropertyType.subclass:
            return PropertyType.subclass(*args_, **kwargs_)
        else:
            return PropertyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Label(self): return self.Label
    def set_Label(self, Label): self.Label = Label
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def add_Value(self, value): self.Value.append(value)
    def insert_Value_at(self, index, value): self.Value.insert(index, value)
    def replace_Value_at(self, index, value): self.Value[index] = value
    def get_userConfigurable(self): return self.userConfigurable
    def set_userConfigurable(self, userConfigurable): self.userConfigurable = userConfigurable
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    def get_password(self): return self.password
    def set_password(self, password): self.password = password
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_qualifiers(self): return self.qualifiers
    def set_qualifiers(self, qualifiers): self.qualifiers = qualifiers
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Label is not None or
            self.Description is not None or
            self.Value
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PropertyType', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PropertyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PropertyType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.userConfigurable is not None and 'userConfigurable' not in already_processed:
            already_processed.add('userConfigurable')
            outfile.write(' userConfigurable="%s"' % self.gds_format_boolean(self.userConfigurable, input_name='userConfigurable'))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
        if self.key is not None and 'key' not in already_processed:
            already_processed.add('key')
            outfile.write(' key=%s' % (self.gds_format_string(quote_attrib(self.key).encode(ExternalEncoding), input_name='key'), ))
        if self.password is not None and 'password' not in already_processed:
            already_processed.add('password')
            outfile.write(' password="%s"' % self.gds_format_boolean(self.password, input_name='password'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.qualifiers is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            outfile.write(' qualifiers=%s' % (self.gds_format_string(quote_attrib(self.qualifiers).encode(ExternalEncoding), input_name='qualifiers'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PropertyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Label is not None:
            self.Label.export(outfile, level, namespace_, name_='Label', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description', pretty_print=pretty_print)
        for Value_ in self.Value:
            Value_.export(outfile, level, namespace_, name_='Value', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PropertyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.userConfigurable is not None and 'userConfigurable' not in already_processed:
            already_processed.add('userConfigurable')
            showIndent(outfile, level)
            outfile.write('userConfigurable=%s,\n' % (self.userConfigurable,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
        if self.key is not None and 'key' not in already_processed:
            already_processed.add('key')
            showIndent(outfile, level)
            outfile.write('key="%s",\n' % (self.key,))
        if self.password is not None and 'password' not in already_processed:
            already_processed.add('password')
            showIndent(outfile, level)
            outfile.write('password=%s,\n' % (self.password,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.qualifiers is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            showIndent(outfile, level)
            outfile.write('qualifiers="%s",\n' % (self.qualifiers,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Label is not None:
            showIndent(outfile, level)
            outfile.write('Label=model_.Msg_Type(\n')
            self.Label.exportLiteral(outfile, level, name_='Label')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Msg_Type(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Value=[\n')
        level += 1
        for Value_ in self.Value:
            showIndent(outfile, level)
            outfile.write('model_.PropertyConfigurationValue_Type(\n')
            Value_.exportLiteral(outfile, level, name_='PropertyConfigurationValue_Type')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('userConfigurable', node)
        if value is not None and 'userConfigurable' not in already_processed:
            already_processed.add('userConfigurable')
            if value in ('true', '1'):
                self.userConfigurable = True
            elif value in ('false', '0'):
                self.userConfigurable = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
        value = find_attr_value_('key', node)
        if value is not None and 'key' not in already_processed:
            already_processed.add('key')
            self.key = value
        value = find_attr_value_('password', node)
        if value is not None and 'password' not in already_processed:
            already_processed.add('password')
            if value in ('true', '1'):
                self.password = True
            elif value in ('false', '0'):
                self.password = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('qualifiers', node)
        if value is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            self.qualifiers = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Label':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Label = obj_
            obj_.original_tagname_ = 'Label'
        elif nodeName_ == 'Description':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
        elif nodeName_ == 'Value':
            obj_ = PropertyConfigurationValue_Type.factory()
            obj_.build(child_)
            self.Value.append(obj_)
            obj_.original_tagname_ = 'Value'
# end class PropertyType


class NetworkType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, Description=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.Description = Description
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if NetworkType.subclass:
            return NetworkType.subclass(*args_, **kwargs_)
        else:
            return NetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NetworkType', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NetworkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Msg_Type(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
# end class NetworkType


class ItemType(GeneratedsSuper):
    """Unique identifier of the content (within a VirtualSystemCollection)
    Startup order. Entities are started up starting with lower-
    numbers first, starting from 0. Items with same order identifier
    may be started up concurrently or in any order. The order is
    reversed for shutdown.Delay in seconds to wait for power on to
    completeResumes power-on sequence if guest software reports
    okDelay in seconds to wait for power off to completeStart action
    to use, valid values are: 'powerOn', 'none' Stop action to use,
    valid values are: ''powerOff' , 'guestShutdown', 'none'"""
    subclass = None
    superclass = None
    def __init__(self, stopDelay=0, order=None, startAction='powerOn', startDelay=0, waitingForGuest=False, stopAction='powerOff', id=None):
        self.original_tagname_ = None
        self.stopDelay = _cast(int, stopDelay)
        self.order = _cast(int, order)
        self.startAction = _cast(None, startAction)
        self.startDelay = _cast(int, startDelay)
        self.waitingForGuest = _cast(bool, waitingForGuest)
        self.stopAction = _cast(None, stopAction)
        self.id = _cast(None, id)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if ItemType.subclass:
            return ItemType.subclass(*args_, **kwargs_)
        else:
            return ItemType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_stopDelay(self): return self.stopDelay
    def set_stopDelay(self, stopDelay): self.stopDelay = stopDelay
    def get_order(self): return self.order
    def set_order(self, order): self.order = order
    def get_startAction(self): return self.startAction
    def set_startAction(self, startAction): self.startAction = startAction
    def get_startDelay(self): return self.startDelay
    def set_startDelay(self, startDelay): self.startDelay = startDelay
    def get_waitingForGuest(self): return self.waitingForGuest
    def set_waitingForGuest(self, waitingForGuest): self.waitingForGuest = waitingForGuest
    def get_stopAction(self): return self.stopAction
    def set_stopAction(self, stopAction): self.stopAction = stopAction
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ItemType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ItemType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ItemType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ItemType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.stopDelay is not None and 'stopDelay' not in already_processed:
            already_processed.add('stopDelay')
            outfile.write(' stopDelay="%s"' % self.gds_format_integer(self.stopDelay, input_name='stopDelay'))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(' order="%s"' % self.gds_format_integer(self.order, input_name='order'))
        if self.startAction is not None and 'startAction' not in already_processed:
            already_processed.add('startAction')
            outfile.write(' startAction=%s' % (self.gds_format_string(quote_attrib(self.startAction).encode(ExternalEncoding), input_name='startAction'), ))
        if self.startDelay is not None and 'startDelay' not in already_processed:
            already_processed.add('startDelay')
            outfile.write(' startDelay="%s"' % self.gds_format_integer(self.startDelay, input_name='startDelay'))
        if self.waitingForGuest is not None and 'waitingForGuest' not in already_processed:
            already_processed.add('waitingForGuest')
            outfile.write(' waitingForGuest="%s"' % self.gds_format_boolean(self.waitingForGuest, input_name='waitingForGuest'))
        if self.stopAction is not None and 'stopAction' not in already_processed:
            already_processed.add('stopAction')
            outfile.write(' stopAction=%s' % (self.gds_format_string(quote_attrib(self.stopAction).encode(ExternalEncoding), input_name='stopAction'), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ItemType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ItemType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.stopDelay is not None and 'stopDelay' not in already_processed:
            already_processed.add('stopDelay')
            showIndent(outfile, level)
            outfile.write('stopDelay=%d,\n' % (self.stopDelay,))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            showIndent(outfile, level)
            outfile.write('order=%d,\n' % (self.order,))
        if self.startAction is not None and 'startAction' not in already_processed:
            already_processed.add('startAction')
            showIndent(outfile, level)
            outfile.write('startAction="%s",\n' % (self.startAction,))
        if self.startDelay is not None and 'startDelay' not in already_processed:
            already_processed.add('startDelay')
            showIndent(outfile, level)
            outfile.write('startDelay=%d,\n' % (self.startDelay,))
        if self.waitingForGuest is not None and 'waitingForGuest' not in already_processed:
            already_processed.add('waitingForGuest')
            showIndent(outfile, level)
            outfile.write('waitingForGuest=%s,\n' % (self.waitingForGuest,))
        if self.stopAction is not None and 'stopAction' not in already_processed:
            already_processed.add('stopAction')
            showIndent(outfile, level)
            outfile.write('stopAction="%s",\n' % (self.stopAction,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('stopDelay', node)
        if value is not None and 'stopDelay' not in already_processed:
            already_processed.add('stopDelay')
            try:
                self.stopDelay = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            try:
                self.order = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('startAction', node)
        if value is not None and 'startAction' not in already_processed:
            already_processed.add('startAction')
            self.startAction = value
        value = find_attr_value_('startDelay', node)
        if value is not None and 'startDelay' not in already_processed:
            already_processed.add('startDelay')
            try:
                self.startDelay = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('waitingForGuest', node)
        if value is not None and 'waitingForGuest' not in already_processed:
            already_processed.add('waitingForGuest')
            if value in ('true', '1'):
                self.waitingForGuest = True
            elif value in ('false', '0'):
                self.waitingForGuest = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('stopAction', node)
        if value is not None and 'stopAction' not in already_processed:
            already_processed.add('stopAction')
            self.stopAction = value
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ItemType


class ConfigurationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, default=False, id=None, Label=None, Description=None):
        self.original_tagname_ = None
        self.default = _cast(bool, default)
        self.id = _cast(None, id)
        self.Label = Label
        self.Description = Description
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if ConfigurationType.subclass:
            return ConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Label(self): return self.Label
    def set_Label(self, Label): self.Label = Label
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            self.Label is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConfigurationType', namespacedef_=' xmlns:ovf="http://schemas.dmtf.org/ovf/envelope/1" ', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ConfigurationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigurationType'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Label is not None:
            self.Label.export(outfile, level, namespace_, name_='Label', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, namespace_, name_='Description', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ConfigurationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            showIndent(outfile, level)
            outfile.write('default=%s,\n' % (self.default,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Label is not None:
            showIndent(outfile, level)
            outfile.write('Label=model_.Msg_Type(\n')
            self.Label.exportLiteral(outfile, level, name_='Label')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Description is not None:
            showIndent(outfile, level)
            outfile.write('Description=model_.Msg_Type(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Label':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Label = obj_
            obj_.original_tagname_ = 'Label'
        elif nodeName_ == 'Description':
            obj_ = Msg_Type.factory()
            obj_.build(child_)
            self.Description = obj_
            obj_.original_tagname_ = 'Description'
# end class ConfigurationType


class RASD_Type(CIM_ResourceAllocationSettingData_Type):
    """Wrapper for CIM_ResourceAllocationSettingData_TypeDetermines whether
    import should fail if entry is not understoodConfiguration from
    DeploymentOptionSection this entry is valid forStates that this
    entry is a range marker"""
    subclass = None
    superclass = CIM_ResourceAllocationSettingData_Type
    def __init__(self, Address=None, AddressOnParent=None, AllocationUnits=None, AutomaticAllocation=None, AutomaticDeallocation=None, Caption=None, Connection=None, ConsumerVisibility=None, Description=None, ElementName=None, HostResource=None, InstanceID=None, Limit=None, MappingBehavior=None, OtherResourceType=None, Parent=None, PoolID=None, Reservation=None, ResourceSubType=None, ResourceType=None, VirtualQuantity=None, VirtualQuantityUnits=None, Weight=None, anytypeobjs_=None, required=True, bound=None, configuration=None):
        self.original_tagname_ = None
        super(RASD_Type, self).__init__(Address, AddressOnParent, AllocationUnits, AutomaticAllocation, AutomaticDeallocation, Caption, Connection, ConsumerVisibility, Description, ElementName, HostResource, InstanceID, Limit, MappingBehavior, OtherResourceType, Parent, PoolID, Reservation, ResourceSubType, ResourceType, VirtualQuantity, VirtualQuantityUnits, Weight, anytypeobjs_, )
        self.required = _cast(bool, required)
        self.bound = _cast(None, bound)
        self.configuration = _cast(None, configuration)
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if RASD_Type.subclass:
            return RASD_Type.subclass(*args_, **kwargs_)
        else:
            return RASD_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_required(self): return self.required
    def set_required(self, required): self.required = required
    def get_bound(self): return self.bound
    def set_bound(self, bound): self.bound = bound
    def get_configuration(self): return self.configuration
    def set_configuration(self, configuration): self.configuration = configuration
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            super(RASD_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RASD_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RASD_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='RASD_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RASD_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(RASD_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RASD_Type')
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required="%s"' % self.gds_format_boolean(self.required, input_name='required'))
        if self.bound is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            outfile.write(' bound=%s' % (self.gds_format_string(quote_attrib(self.bound).encode(ExternalEncoding), input_name='bound'), ))
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            outfile.write(' configuration=%s' % (self.gds_format_string(quote_attrib(self.configuration).encode(ExternalEncoding), input_name='configuration'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RASD_Type', fromsubclass_=False, pretty_print=True):
        super(RASD_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='RASD_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            showIndent(outfile, level)
            outfile.write('required=%s,\n' % (self.required,))
        if self.bound is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            showIndent(outfile, level)
            outfile.write('bound="%s",\n' % (self.bound,))
        if self.configuration is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            showIndent(outfile, level)
            outfile.write('configuration="%s",\n' % (self.configuration,))
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(RASD_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RASD_Type, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            if value in ('true', '1'):
                self.required = True
            elif value in ('false', '0'):
                self.required = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('bound', node)
        if value is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            self.bound = value
        value = find_attr_value_('configuration', node)
        if value is not None and 'configuration' not in already_processed:
            already_processed.add('configuration')
            self.configuration = value
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(RASD_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RASD_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RASD_Type


class VSSD_Type(CIM_VirtualSystemSettingData_Type):
    """Wrapper for CIM_VirtualSystemSettingData_Type"""
    subclass = None
    superclass = CIM_VirtualSystemSettingData_Type
    def __init__(self, AutomaticRecoveryAction=None, AutomaticShutdownAction=None, AutomaticStartupAction=None, AutomaticStartupActionDelay=None, AutomaticStartupActionSequenceNumber=None, Caption=None, ConfigurationDataRoot=None, ConfigurationFile=None, ConfigurationID=None, CreationTime=None, Description=None, ElementName=None, InstanceID=None, LogDataRoot=None, Notes=None, RecoveryFile=None, SnapshotDataRoot=None, SuspendDataRoot=None, SwapFileDataRoot=None, VirtualSystemIdentifier=None, VirtualSystemType=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(VSSD_Type, self).__init__(AutomaticRecoveryAction, AutomaticShutdownAction, AutomaticStartupAction, AutomaticStartupActionDelay, AutomaticStartupActionSequenceNumber, Caption, ConfigurationDataRoot, ConfigurationFile, ConfigurationID, CreationTime, Description, ElementName, InstanceID, LogDataRoot, Notes, RecoveryFile, SnapshotDataRoot, SuspendDataRoot, SwapFileDataRoot, VirtualSystemIdentifier, VirtualSystemType, anytypeobjs_, )
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if VSSD_Type.subclass:
            return VSSD_Type.subclass(*args_, **kwargs_)
        else:
            return VSSD_Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def hasContent_(self):
        if (
            super(VSSD_Type, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VSSD_Type', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VSSD_Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VSSD_Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VSSD_Type'):
        unique_counter = 0
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.add(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                mo = re_.match(Namespace_extract_pat_, name)
                if mo is not None:
                    namespace, name = mo.group(1, 2)
                    if name not in already_processed:
                        already_processed.add(name)
                        if namespace == 'http://www.w3.org/XML/1998/namespace':
                            outfile.write(' %s=%s' % (
                                name, quote_attrib(value), ))
                        else:
                            unique_counter += 1
                            outfile.write(' xmlns:yyy%d="%s"' % (
                                unique_counter, namespace, ))
                            outfile.write(' yyy%d:%s=%s' % (
                                unique_counter, name, quote_attrib(value), ))
                else:
                    if name not in already_processed:
                        already_processed.add(name)
                        outfile.write(' %s=%s' % (
                            name, quote_attrib(value), ))
        super(VSSD_Type, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VSSD_Type')
    def exportChildren(self, outfile, level, namespace_='', name_='VSSD_Type', fromsubclass_=False, pretty_print=True):
        super(VSSD_Type, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VSSD_Type'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s="%s",\n' % (name, value,))
        super(VSSD_Type, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VSSD_Type, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
        super(VSSD_Type, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VSSD_Type, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VSSD_Type


class TaskType(EntityType):
    """0.9 Represents an asynchronous operation in vCloud Director. none
    The execution status of the task. One of:<br> <b>queued</b> (The
    task has been queued for execution)<br> <b>preRunning</b> (The
    task is awaiting preprocessing or administrative action.)<br>
    <b>running</b> (The task is running.)<br> <b>success</b> (The
    task completed with a status of success.)<br> <b>error</b> (The
    task encountered an error while running.)<br> <b>canceled</b>
    (The task was canceled by the owner or an administrator.)<br>
    <b>aborted</b> (The task was aborted by an administrative
    action.) truealways A message describing the operation that is
    tracked by this task. falsenone The short name of the operation
    that is tracked by this task. false5.1createtrue Identifier of
    the service that created the task. It must not start with
    com.vmware.vcloud and the length must be between 1 and 128
    symbols. none The date and time the system started executing the
    task. May not be present if the task has not been executed yet.
    falsenone The date and time that processing of the task was
    completed. May not be present if the task is still being
    executed. falsenone The date and time at which the task resource
    will be destroyed and no longer available for retrieval. May not
    be present if the task has not been executed or is still being
    executed. false5.1nonefalse Whether user has requested this
    processing to be canceled."""
    subclass = None
    superclass = EntityType
    def __init__(self, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, operationName=None, expiryTime=None, cancelRequested=None, startTime=None, operation=None, endTime=None, serviceNamespace=None, Owner=None, Error=None, User=None, Organization=None, Progress=None, Params=None, Details=None):
        self.original_tagname_ = None
        super(TaskType, self).__init__(operationKey, id, name, Description, Tasks, )
        self.status = _cast(None, status)
        self.operationName = _cast(None, operationName)
        if isinstance(expiryTime, basestring):
            initvalue_ = datetime_.datetime.strptime(expiryTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = expiryTime
        self.expiryTime = initvalue_
        self.cancelRequested = _cast(bool, cancelRequested)
        if isinstance(startTime, basestring):
            initvalue_ = datetime_.datetime.strptime(startTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = startTime
        self.startTime = initvalue_
        self.operation = _cast(None, operation)
        if isinstance(endTime, basestring):
            initvalue_ = datetime_.datetime.strptime(endTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endTime
        self.endTime = initvalue_
        self.serviceNamespace = _cast(None, serviceNamespace)
        self.Owner = Owner
        self.Error = Error
        self.User = User
        self.Organization = Organization
        self.Progress = Progress
        self.Params = Params
        self.Details = Details
    def factory(*args_, **kwargs_):
        if TaskType.subclass:
            return TaskType.subclass(*args_, **kwargs_)
        else:
            return TaskType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_Error(self): return self.Error
    def set_Error(self, Error): self.Error = Error
    def get_User(self): return self.User
    def set_User(self, User): self.User = User
    def get_Organization(self): return self.Organization
    def set_Organization(self, Organization): self.Organization = Organization
    def get_Progress(self): return self.Progress
    def set_Progress(self, Progress): self.Progress = Progress
    def get_Params(self): return self.Params
    def set_Params(self, Params): self.Params = Params
    def get_Details(self): return self.Details
    def set_Details(self, Details): self.Details = Details
    def get_status(self): return self.status
    def set_status(self, status): self.status = status
    def get_operationName(self): return self.operationName
    def set_operationName(self, operationName): self.operationName = operationName
    def get_expiryTime(self): return self.expiryTime
    def set_expiryTime(self, expiryTime): self.expiryTime = expiryTime
    def get_cancelRequested(self): return self.cancelRequested
    def set_cancelRequested(self, cancelRequested): self.cancelRequested = cancelRequested
    def get_startTime(self): return self.startTime
    def set_startTime(self, startTime): self.startTime = startTime
    def get_operation(self): return self.operation
    def set_operation(self, operation): self.operation = operation
    def get_endTime(self): return self.endTime
    def set_endTime(self, endTime): self.endTime = endTime
    def get_serviceNamespace(self): return self.serviceNamespace
    def set_serviceNamespace(self, serviceNamespace): self.serviceNamespace = serviceNamespace
    def hasContent_(self):
        if (
            self.Owner is not None or
            self.Error is not None or
            self.User is not None or
            self.Organization is not None or
            self.Progress is not None or
            self.Params is not None or
            self.Details is not None or
            super(TaskType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TaskType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TaskType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaskType'):
        super(TaskType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaskType')
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            outfile.write(' status=%s' % (self.gds_format_string(quote_attrib(self.status).encode(ExternalEncoding), input_name='status'), ))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            outfile.write(' operationName=%s' % (self.gds_format_string(quote_attrib(self.operationName).encode(ExternalEncoding), input_name='operationName'), ))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            outfile.write(' expiryTime="%s"' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            outfile.write(' cancelRequested="%s"' % self.gds_format_boolean(self.cancelRequested, input_name='cancelRequested'))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            outfile.write(' startTime="%s"' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            outfile.write(' operation=%s' % (self.gds_format_string(quote_attrib(self.operation).encode(ExternalEncoding), input_name='operation'), ))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            outfile.write(' endTime="%s"' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            outfile.write(' serviceNamespace=%s' % (self.gds_format_string(quote_attrib(self.serviceNamespace).encode(ExternalEncoding), input_name='serviceNamespace'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaskType', fromsubclass_=False, pretty_print=True):
        super(TaskType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Owner is not None:
            self.Owner.export(outfile, level, namespace_, name_='Owner', pretty_print=pretty_print)
        if self.Error is not None:
            self.Error.export(outfile, level, namespace_, name_='Error', pretty_print=pretty_print)
        if self.User is not None:
            self.User.export(outfile, level, namespace_, name_='User', pretty_print=pretty_print)
        if self.Organization is not None:
            self.Organization.export(outfile, level, namespace_, name_='Organization', pretty_print=pretty_print)
        if self.Progress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProgress>%s</%sProgress>%s' % (namespace_, self.gds_format_integer(self.Progress, input_name='Progress'), namespace_, eol_))
        if self.Params is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParams>%s</%sParams>%s' % (namespace_, self.gds_format_string(quote_xml(self.Params).encode(ExternalEncoding), input_name='Params'), namespace_, eol_))
        if self.Details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDetails>%s</%sDetails>%s' % (namespace_, self.gds_format_string(quote_xml(self.Details).encode(ExternalEncoding), input_name='Details'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='TaskType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.status is not None and 'status' not in already_processed:
            already_processed.add('status')
            showIndent(outfile, level)
            outfile.write('status="%s",\n' % (self.status,))
        if self.operationName is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            showIndent(outfile, level)
            outfile.write('operationName="%s",\n' % (self.operationName,))
        if self.expiryTime is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            showIndent(outfile, level)
            outfile.write('expiryTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.expiryTime, input_name='expiryTime'))
        if self.cancelRequested is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            showIndent(outfile, level)
            outfile.write('cancelRequested=%s,\n' % (self.cancelRequested,))
        if self.startTime is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            showIndent(outfile, level)
            outfile.write('startTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.startTime, input_name='startTime'))
        if self.operation is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            showIndent(outfile, level)
            outfile.write('operation="%s",\n' % (self.operation,))
        if self.endTime is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            showIndent(outfile, level)
            outfile.write('endTime=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.endTime, input_name='endTime'))
        if self.serviceNamespace is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            showIndent(outfile, level)
            outfile.write('serviceNamespace="%s",\n' % (self.serviceNamespace,))
        super(TaskType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaskType, self).exportLiteralChildren(outfile, level, name_)
        if self.Owner is not None:
            showIndent(outfile, level)
            outfile.write('Owner=model_.ReferenceType(\n')
            self.Owner.exportLiteral(outfile, level, name_='Owner')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Error is not None:
            showIndent(outfile, level)
            outfile.write('Error=model_.ErrorType(\n')
            self.Error.exportLiteral(outfile, level, name_='Error')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.User is not None:
            showIndent(outfile, level)
            outfile.write('User=model_.ReferenceType(\n')
            self.User.exportLiteral(outfile, level, name_='User')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Organization is not None:
            showIndent(outfile, level)
            outfile.write('Organization=model_.ReferenceType(\n')
            self.Organization.exportLiteral(outfile, level, name_='Organization')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Progress is not None:
            showIndent(outfile, level)
            outfile.write('Progress=%d,\n' % self.Progress)
        if self.Params is not None:
            showIndent(outfile, level)
            outfile.write('Params=%s,\n' % quote_python(self.Params).encode(ExternalEncoding))
        if self.Details is not None:
            showIndent(outfile, level)
            outfile.write('Details=%s,\n' % quote_python(self.Details).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('status', node)
        if value is not None and 'status' not in already_processed:
            already_processed.add('status')
            self.status = value
        value = find_attr_value_('operationName', node)
        if value is not None and 'operationName' not in already_processed:
            already_processed.add('operationName')
            self.operationName = value
        value = find_attr_value_('expiryTime', node)
        if value is not None and 'expiryTime' not in already_processed:
            already_processed.add('expiryTime')
            try:
                self.expiryTime = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (expiryTime): %s' % exp)
        value = find_attr_value_('cancelRequested', node)
        if value is not None and 'cancelRequested' not in already_processed:
            already_processed.add('cancelRequested')
            if value in ('true', '1'):
                self.cancelRequested = True
            elif value in ('false', '0'):
                self.cancelRequested = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('startTime', node)
        if value is not None and 'startTime' not in already_processed:
            already_processed.add('startTime')
            try:
                self.startTime = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (startTime): %s' % exp)
        value = find_attr_value_('operation', node)
        if value is not None and 'operation' not in already_processed:
            already_processed.add('operation')
            self.operation = value
        value = find_attr_value_('endTime', node)
        if value is not None and 'endTime' not in already_processed:
            already_processed.add('endTime')
            try:
                self.endTime = self.gds_parse_datetime(value)
            except ValueError, exp:
                raise ValueError('Bad date-time attribute (endTime): %s' % exp)
        value = find_attr_value_('serviceNamespace', node)
        if value is not None and 'serviceNamespace' not in already_processed:
            already_processed.add('serviceNamespace')
            self.serviceNamespace = value
        super(TaskType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Owner':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'Error':
            obj_ = ErrorType.factory()
            obj_.build(child_)
            self.Error = obj_
            obj_.original_tagname_ = 'Error'
        elif nodeName_ == 'User':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.User = obj_
            obj_.original_tagname_ = 'User'
        elif nodeName_ == 'Organization':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Organization = obj_
            obj_.original_tagname_ = 'Organization'
        elif nodeName_ == 'Progress':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError), exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'Progress')
            self.Progress = ival_
        elif nodeName_ == 'Params':
            Params_ = child_.text
            Params_ = self.gds_validate_string(Params_, node, 'Params')
            self.Params = Params_
        elif nodeName_ == 'Details':
            Details_ = child_.text
            Details_ = self.gds_validate_string(Details_, node, 'Details')
            self.Details = Details_
        super(TaskType, self).buildChildren(child_, node, nodeName_, True)
# end class TaskType


class LinkType(ReferenceType):
    """0.9 Extends reference type by adding relation attribute. Defines a
    hyper-link with a relationship, hyper-link reference, and an
    optional MIME type. always Defines the relationship of the link
    to the object that contains it. A relationship can be the name
    of an operation on the object, a reference to a contained or
    containing object, or a reference to an alternate representation
    of the object. The relationship value implies the HTTP verb to
    use when you use the link's href as a request URL. See the
    vCloud API Programming Guide for a list of links and link
    relations. true"""
    subclass = None
    superclass = ReferenceType
    def __init__(self, VCloudExtension=None, href=None, type_=None, id=None, name=None, rel=None):
        self.original_tagname_ = None
        super(LinkType, self).__init__(VCloudExtension, href, type_, id, name, )
        self.rel = _cast(None, rel)
    def factory(*args_, **kwargs_):
        if LinkType.subclass:
            return LinkType.subclass(*args_, **kwargs_)
        else:
            return LinkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def hasContent_(self):
        if (
            super(LinkType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LinkType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LinkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LinkType'):
        super(LinkType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LinkType')
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            outfile.write(' rel=%s' % (self.gds_format_string(quote_attrib(self.rel).encode(ExternalEncoding), input_name='rel'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LinkType', fromsubclass_=False, pretty_print=True):
        super(LinkType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='LinkType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            showIndent(outfile, level)
            outfile.write('rel="%s",\n' % (self.rel,))
        super(LinkType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LinkType, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.add('rel')
            self.rel = value
        super(LinkType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LinkType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LinkType


class CustomizationSectionType(Section_Type):
    """1.0 Represents a vApp template customization settings. always5.1
    True if this template is a gold master. falsenone Link to the
    section. falsenone MIME type of the section. false"""
    subclass = None
    superclass = Section_Type
    def __init__(self, required=None, Info=None, href=None, type_=None, goldMaster=False, CustomizeOnInstantiate=None, Link=None, anytypeobjs_=None):
        self.original_tagname_ = None
        super(CustomizationSectionType, self).__init__(required, Info, )
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.goldMaster = _cast(bool, goldMaster)
        self.CustomizeOnInstantiate = CustomizeOnInstantiate
        if Link is None:
            self.Link = []
        else:
            self.Link = Link
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CustomizationSectionType.subclass:
            return CustomizationSectionType.subclass(*args_, **kwargs_)
        else:
            return CustomizationSectionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_CustomizeOnInstantiate(self): return self.CustomizeOnInstantiate
    def set_CustomizeOnInstantiate(self, CustomizeOnInstantiate): self.CustomizeOnInstantiate = CustomizeOnInstantiate
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def add_Link(self, value): self.Link.append(value)
    def insert_Link_at(self, index, value): self.Link.insert(index, value)
    def replace_Link_at(self, index, value): self.Link[index] = value
    def get_anytypeobjs_(self): return self.anytypeobjs_
    def set_anytypeobjs_(self, anytypeobjs_): self.anytypeobjs_ = anytypeobjs_
    def add_anytypeobjs_(self, value): self.anytypeobjs_.append(value)
    def insert_anytypeobjs_(self, index, value): self._anytypeobjs_[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_goldMaster(self): return self.goldMaster
    def set_goldMaster(self, goldMaster): self.goldMaster = goldMaster
    def hasContent_(self):
        if (
            self.CustomizeOnInstantiate is not None or
            self.Link or
            self.anytypeobjs_ or
            super(CustomizationSectionType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CustomizationSectionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CustomizationSectionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CustomizationSectionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CustomizationSectionType'):
        super(CustomizationSectionType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CustomizationSectionType')
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.goldMaster is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            outfile.write(' goldMaster="%s"' % self.gds_format_boolean(self.goldMaster, input_name='goldMaster'))
    def exportChildren(self, outfile, level, namespace_='', name_='CustomizationSectionType', fromsubclass_=False, pretty_print=True):
        super(CustomizationSectionType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CustomizeOnInstantiate is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomizeOnInstantiate>%s</%sCustomizeOnInstantiate>%s' % (namespace_, self.gds_format_boolean(self.CustomizeOnInstantiate, input_name='CustomizeOnInstantiate'), namespace_, eol_))
        for Link_ in self.Link:
            Link_.export(outfile, level, namespace_, name_='Link', pretty_print=pretty_print)
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CustomizationSectionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_="%s",\n' % (self.type_,))
        if self.goldMaster is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            showIndent(outfile, level)
            outfile.write('goldMaster=%s,\n' % (self.goldMaster,))
        super(CustomizationSectionType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CustomizationSectionType, self).exportLiteralChildren(outfile, level, name_)
        if self.CustomizeOnInstantiate is not None:
            showIndent(outfile, level)
            outfile.write('CustomizeOnInstantiate=%s,\n' % self.CustomizeOnInstantiate)
        showIndent(outfile, level)
        outfile.write('Link=[\n')
        level += 1
        for Link_ in self.Link:
            showIndent(outfile, level)
            outfile.write('model_.LinkType(\n')
            Link_.exportLiteral(outfile, level, name_='LinkType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('goldMaster', node)
        if value is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            if value in ('true', '1'):
                self.goldMaster = True
            elif value in ('false', '0'):
                self.goldMaster = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(CustomizationSectionType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'CustomizeOnInstantiate':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'CustomizeOnInstantiate')
            self.CustomizeOnInstantiate = ival_
        elif nodeName_ == 'Link':
            obj_ = LinkType.factory()
            obj_.build(child_)
            self.Link.append(obj_)
            obj_.original_tagname_ = 'Link'
        else:
            obj_ = self.gds_build_any(child_, 'CustomizationSectionType')
            if obj_ is not None:
                self.add_anytypeobjs_(obj_)
        super(CustomizationSectionType, self).buildChildren(child_, node, nodeName_, True)
# end class CustomizationSectionType


class CloneVAppTemplateParamsType(ParamsType):
    """0.9 Parameters for a cloneVappTemplate request."""
    subclass = None
    superclass = ParamsType
    def __init__(self, VCloudExtension=None, name=None, Description=None, Source=None, IsSourceDelete=None, VdcStorageProfile=None):
        self.original_tagname_ = None
        super(CloneVAppTemplateParamsType, self).__init__(VCloudExtension, name, Description, )
        self.Source = Source
        self.IsSourceDelete = IsSourceDelete
        self.VdcStorageProfile = VdcStorageProfile
    def factory(*args_, **kwargs_):
        if CloneVAppTemplateParamsType.subclass:
            return CloneVAppTemplateParamsType.subclass(*args_, **kwargs_)
        else:
            return CloneVAppTemplateParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Source(self): return self.Source
    def set_Source(self, Source): self.Source = Source
    def get_IsSourceDelete(self): return self.IsSourceDelete
    def set_IsSourceDelete(self, IsSourceDelete): self.IsSourceDelete = IsSourceDelete
    def get_VdcStorageProfile(self): return self.VdcStorageProfile
    def set_VdcStorageProfile(self, VdcStorageProfile): self.VdcStorageProfile = VdcStorageProfile
    def hasContent_(self):
        if (
            self.Source is not None or
            self.IsSourceDelete is not None or
            self.VdcStorageProfile is not None or
            super(CloneVAppTemplateParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CloneVAppTemplateParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CloneVAppTemplateParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CloneVAppTemplateParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CloneVAppTemplateParamsType'):
        super(CloneVAppTemplateParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CloneVAppTemplateParamsType')
    def exportChildren(self, outfile, level, namespace_='', name_='CloneVAppTemplateParamsType', fromsubclass_=False, pretty_print=True):
        super(CloneVAppTemplateParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Source is not None:
            self.Source.export(outfile, level, namespace_, name_='Source', pretty_print=pretty_print)
        if self.IsSourceDelete is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsSourceDelete>%s</%sIsSourceDelete>%s' % (namespace_, self.gds_format_boolean(self.IsSourceDelete, input_name='IsSourceDelete'), namespace_, eol_))
        if self.VdcStorageProfile is not None:
            self.VdcStorageProfile.export(outfile, level, namespace_, name_='VdcStorageProfile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CloneVAppTemplateParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(CloneVAppTemplateParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CloneVAppTemplateParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.Source is not None:
            showIndent(outfile, level)
            outfile.write('Source=model_.ReferenceType(\n')
            self.Source.exportLiteral(outfile, level, name_='Source')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.IsSourceDelete is not None:
            showIndent(outfile, level)
            outfile.write('IsSourceDelete=%s,\n' % self.IsSourceDelete)
        if self.VdcStorageProfile is not None:
            showIndent(outfile, level)
            outfile.write('VdcStorageProfile=model_.ReferenceType(\n')
            self.VdcStorageProfile.exportLiteral(outfile, level, name_='VdcStorageProfile')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(CloneVAppTemplateParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Source':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Source = obj_
            obj_.original_tagname_ = 'Source'
        elif nodeName_ == 'IsSourceDelete':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'IsSourceDelete')
            self.IsSourceDelete = ival_
        elif nodeName_ == 'VdcStorageProfile':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VdcStorageProfile = obj_
            obj_.original_tagname_ = 'VdcStorageProfile'
        super(CloneVAppTemplateParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class CloneVAppTemplateParamsType


class UploadVAppTemplateParamsType(ParamsType):
    """0.9 Parameters for an uploadVappTemplate request. always Reserved.
    Unimplemented. falsealways True if an OVF manifest is included
    in the upload. Default value is false. falsealways5.5 Source URL
    of the OVF package. false"""
    subclass = None
    superclass = ParamsType
    def __init__(self, VCloudExtension=None, name=None, Description=None, manifestRequired=None, transferFormat=None, sourceHref=None, VdcStorageProfile=None):
        self.original_tagname_ = None
        super(UploadVAppTemplateParamsType, self).__init__(VCloudExtension, name, Description, )
        self.manifestRequired = _cast(bool, manifestRequired)
        self.transferFormat = _cast(None, transferFormat)
        self.sourceHref = _cast(None, sourceHref)
        self.VdcStorageProfile = VdcStorageProfile
    def factory(*args_, **kwargs_):
        if UploadVAppTemplateParamsType.subclass:
            return UploadVAppTemplateParamsType.subclass(*args_, **kwargs_)
        else:
            return UploadVAppTemplateParamsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_VdcStorageProfile(self): return self.VdcStorageProfile
    def set_VdcStorageProfile(self, VdcStorageProfile): self.VdcStorageProfile = VdcStorageProfile
    def get_manifestRequired(self): return self.manifestRequired
    def set_manifestRequired(self, manifestRequired): self.manifestRequired = manifestRequired
    def get_transferFormat(self): return self.transferFormat
    def set_transferFormat(self, transferFormat): self.transferFormat = transferFormat
    def get_sourceHref(self): return self.sourceHref
    def set_sourceHref(self, sourceHref): self.sourceHref = sourceHref
    def hasContent_(self):
        if (
            self.VdcStorageProfile is not None or
            super(UploadVAppTemplateParamsType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='UploadVAppTemplateParamsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UploadVAppTemplateParamsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='UploadVAppTemplateParamsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='UploadVAppTemplateParamsType'):
        super(UploadVAppTemplateParamsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='UploadVAppTemplateParamsType')
        if self.manifestRequired is not None and 'manifestRequired' not in already_processed:
            already_processed.add('manifestRequired')
            outfile.write(' manifestRequired="%s"' % self.gds_format_boolean(self.manifestRequired, input_name='manifestRequired'))
        if self.transferFormat is not None and 'transferFormat' not in already_processed:
            already_processed.add('transferFormat')
            outfile.write(' transferFormat=%s' % (self.gds_format_string(quote_attrib(self.transferFormat).encode(ExternalEncoding), input_name='transferFormat'), ))
        if self.sourceHref is not None and 'sourceHref' not in already_processed:
            already_processed.add('sourceHref')
            outfile.write(' sourceHref=%s' % (self.gds_format_string(quote_attrib(self.sourceHref).encode(ExternalEncoding), input_name='sourceHref'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='UploadVAppTemplateParamsType', fromsubclass_=False, pretty_print=True):
        super(UploadVAppTemplateParamsType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.VdcStorageProfile is not None:
            self.VdcStorageProfile.export(outfile, level, namespace_, name_='VdcStorageProfile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='UploadVAppTemplateParamsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.manifestRequired is not None and 'manifestRequired' not in already_processed:
            already_processed.add('manifestRequired')
            showIndent(outfile, level)
            outfile.write('manifestRequired=%s,\n' % (self.manifestRequired,))
        if self.transferFormat is not None and 'transferFormat' not in already_processed:
            already_processed.add('transferFormat')
            showIndent(outfile, level)
            outfile.write('transferFormat="%s",\n' % (self.transferFormat,))
        if self.sourceHref is not None and 'sourceHref' not in already_processed:
            already_processed.add('sourceHref')
            showIndent(outfile, level)
            outfile.write('sourceHref="%s",\n' % (self.sourceHref,))
        super(UploadVAppTemplateParamsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(UploadVAppTemplateParamsType, self).exportLiteralChildren(outfile, level, name_)
        if self.VdcStorageProfile is not None:
            showIndent(outfile, level)
            outfile.write('VdcStorageProfile=model_.ReferenceType(\n')
            self.VdcStorageProfile.exportLiteral(outfile, level, name_='VdcStorageProfile')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('manifestRequired', node)
        if value is not None and 'manifestRequired' not in already_processed:
            already_processed.add('manifestRequired')
            if value in ('true', '1'):
                self.manifestRequired = True
            elif value in ('false', '0'):
                self.manifestRequired = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('transferFormat', node)
        if value is not None and 'transferFormat' not in already_processed:
            already_processed.add('transferFormat')
            self.transferFormat = value
        value = find_attr_value_('sourceHref', node)
        if value is not None and 'sourceHref' not in already_processed:
            already_processed.add('sourceHref')
            self.sourceHref = value
        super(UploadVAppTemplateParamsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'VdcStorageProfile':
            class_obj_ = self.get_class_obj_(child_, ReferenceType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.VdcStorageProfile = obj_
            obj_.original_tagname_ = 'VdcStorageProfile'
        super(UploadVAppTemplateParamsType, self).buildChildren(child_, node, nodeName_, True)
# end class UploadVAppTemplateParamsType


class VAppTemplateChildrenType(VCloudExtensibleType):
    """0.9 Container for virtual machines included in this vApp template."""
    subclass = None
    superclass = VCloudExtensibleType
    def __init__(self, VCloudExtension=None, Vm=None):
        self.original_tagname_ = None
        super(VAppTemplateChildrenType, self).__init__(VCloudExtension, )
        if Vm is None:
            self.Vm = []
        else:
            self.Vm = Vm
    def factory(*args_, **kwargs_):
        if VAppTemplateChildrenType.subclass:
            return VAppTemplateChildrenType.subclass(*args_, **kwargs_)
        else:
            return VAppTemplateChildrenType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Vm(self): return self.Vm
    def set_Vm(self, Vm): self.Vm = Vm
    def add_Vm(self, value): self.Vm.append(value)
    def insert_Vm_at(self, index, value): self.Vm.insert(index, value)
    def replace_Vm_at(self, index, value): self.Vm[index] = value
    def hasContent_(self):
        if (
            self.Vm or
            super(VAppTemplateChildrenType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VAppTemplateChildrenType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VAppTemplateChildrenType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VAppTemplateChildrenType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VAppTemplateChildrenType'):
        super(VAppTemplateChildrenType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VAppTemplateChildrenType')
    def exportChildren(self, outfile, level, namespace_='', name_='VAppTemplateChildrenType', fromsubclass_=False, pretty_print=True):
        super(VAppTemplateChildrenType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Vm_ in self.Vm:
            Vm_.export(outfile, level, namespace_, name_='Vm', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VAppTemplateChildrenType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(VAppTemplateChildrenType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VAppTemplateChildrenType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Vm=[\n')
        level += 1
        for Vm_ in self.Vm:
            showIndent(outfile, level)
            outfile.write('model_.VAppTemplateType(\n')
            Vm_.exportLiteral(outfile, level, name_='VAppTemplateType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(VAppTemplateChildrenType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Vm':
            obj_ = VAppTemplateType.factory()
            obj_.build(child_)
            self.Vm.append(obj_)
            obj_.original_tagname_ = 'Vm'
        super(VAppTemplateChildrenType, self).buildChildren(child_, node, nodeName_, True)
# end class VAppTemplateChildrenType


class VAppTemplateType(ResourceEntityType):
    """0.9 Represents a vApp template. none True if the OVF descriptor for
    this template has been uploaded. falsealways1.5 True if this
    template is a gold master. false"""
    subclass = None
    superclass = ResourceEntityType
    def __init__(self, operationKey=None, id=None, name=None, Description=None, Tasks=None, status=None, Files=None, ovfDescriptorUploaded=None, goldMaster=False, Owner=None, Children=None, Section=None, VAppScopedLocalId=None, DefaultStorageProfile=None, DateCreated=None):
        self.original_tagname_ = None
        super(VAppTemplateType, self).__init__(operationKey, id, name, Description, Tasks, status, Files, )
        self.ovfDescriptorUploaded = _cast(bool, ovfDescriptorUploaded)
        self.goldMaster = _cast(bool, goldMaster)
        self.Owner = Owner
        self.Children = Children
        if Section is None:
            self.Section = []
        else:
            self.Section = Section
        self.VAppScopedLocalId = VAppScopedLocalId
        self.DefaultStorageProfile = DefaultStorageProfile
        if isinstance(DateCreated, basestring):
            initvalue_ = datetime_.datetime.strptime(DateCreated, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = DateCreated
        self.DateCreated = initvalue_
    def factory(*args_, **kwargs_):
        if VAppTemplateType.subclass:
            return VAppTemplateType.subclass(*args_, **kwargs_)
        else:
            return VAppTemplateType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Owner(self): return self.Owner
    def set_Owner(self, Owner): self.Owner = Owner
    def get_Children(self): return self.Children
    def set_Children(self, Children): self.Children = Children
    def get_Section(self): return self.Section
    def set_Section(self, Section): self.Section = Section
    def add_Section(self, value): self.Section.append(value)
    def insert_Section_at(self, index, value): self.Section.insert(index, value)
    def replace_Section_at(self, index, value): self.Section[index] = value
    def get_VAppScopedLocalId(self): return self.VAppScopedLocalId
    def set_VAppScopedLocalId(self, VAppScopedLocalId): self.VAppScopedLocalId = VAppScopedLocalId
    def get_DefaultStorageProfile(self): return self.DefaultStorageProfile
    def set_DefaultStorageProfile(self, DefaultStorageProfile): self.DefaultStorageProfile = DefaultStorageProfile
    def get_DateCreated(self): return self.DateCreated
    def set_DateCreated(self, DateCreated): self.DateCreated = DateCreated
    def get_ovfDescriptorUploaded(self): return self.ovfDescriptorUploaded
    def set_ovfDescriptorUploaded(self, ovfDescriptorUploaded): self.ovfDescriptorUploaded = ovfDescriptorUploaded
    def get_goldMaster(self): return self.goldMaster
    def set_goldMaster(self, goldMaster): self.goldMaster = goldMaster
    def hasContent_(self):
        if (
            self.Owner is not None or
            self.Children is not None or
            self.Section or
            self.VAppScopedLocalId is not None or
            self.DefaultStorageProfile is not None or
            self.DateCreated is not None or
            super(VAppTemplateType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VAppTemplateType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VAppTemplateType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VAppTemplateType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VAppTemplateType'):
        super(VAppTemplateType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VAppTemplateType')
        if self.ovfDescriptorUploaded is not None and 'ovfDescriptorUploaded' not in already_processed:
            already_processed.add('ovfDescriptorUploaded')
            outfile.write(' ovfDescriptorUploaded="%s"' % self.gds_format_boolean(self.ovfDescriptorUploaded, input_name='ovfDescriptorUploaded'))
        if self.goldMaster is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            outfile.write(' goldMaster="%s"' % self.gds_format_boolean(self.goldMaster, input_name='goldMaster'))
    def exportChildren(self, outfile, level, namespace_='', name_='VAppTemplateType', fromsubclass_=False, pretty_print=True):
        super(VAppTemplateType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Owner is not None:
            self.Owner.export(outfile, level, namespace_, name_='Owner', pretty_print=pretty_print)
        if self.Children is not None:
            self.Children.export(outfile, level, namespace_, name_='Children', pretty_print=pretty_print)
        for Section_ in self.Section:
            Section_.export(outfile, level, namespace_='ovf:', name_='Section', pretty_print=pretty_print)
        if self.VAppScopedLocalId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVAppScopedLocalId>%s</%sVAppScopedLocalId>%s' % (namespace_, self.gds_format_string(quote_xml(self.VAppScopedLocalId).encode(ExternalEncoding), input_name='VAppScopedLocalId'), namespace_, eol_))
        if self.DefaultStorageProfile is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDefaultStorageProfile>%s</%sDefaultStorageProfile>%s' % (namespace_, self.gds_format_string(quote_xml(self.DefaultStorageProfile).encode(ExternalEncoding), input_name='DefaultStorageProfile'), namespace_, eol_))
        if self.DateCreated is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDateCreated>%s</%sDateCreated>%s' % (namespace_, self.gds_format_datetime(self.DateCreated, input_name='DateCreated'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='VAppTemplateType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ovfDescriptorUploaded is not None and 'ovfDescriptorUploaded' not in already_processed:
            already_processed.add('ovfDescriptorUploaded')
            showIndent(outfile, level)
            outfile.write('ovfDescriptorUploaded=%s,\n' % (self.ovfDescriptorUploaded,))
        if self.goldMaster is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            showIndent(outfile, level)
            outfile.write('goldMaster=%s,\n' % (self.goldMaster,))
        super(VAppTemplateType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VAppTemplateType, self).exportLiteralChildren(outfile, level, name_)
        if self.Owner is not None:
            showIndent(outfile, level)
            outfile.write('Owner=model_.OwnerType(\n')
            self.Owner.exportLiteral(outfile, level, name_='Owner')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Children is not None:
            showIndent(outfile, level)
            outfile.write('Children=model_.VAppTemplateChildrenType(\n')
            self.Children.exportLiteral(outfile, level, name_='Children')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Section=[\n')
        level += 1
        for Section_ in self.Section:
            showIndent(outfile, level)
            outfile.write('model_.Section(\n')
            Section_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.VAppScopedLocalId is not None:
            showIndent(outfile, level)
            outfile.write('VAppScopedLocalId=%s,\n' % quote_python(self.VAppScopedLocalId).encode(ExternalEncoding))
        if self.DefaultStorageProfile is not None:
            showIndent(outfile, level)
            outfile.write('DefaultStorageProfile=%s,\n' % quote_python(self.DefaultStorageProfile).encode(ExternalEncoding))
        if self.DateCreated is not None:
            showIndent(outfile, level)
            outfile.write('DateCreated=model_.GeneratedsSuper.gds_parse_datetime("%s"),\n' % self.gds_format_datetime(self.DateCreated, input_name='DateCreated'))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ovfDescriptorUploaded', node)
        if value is not None and 'ovfDescriptorUploaded' not in already_processed:
            already_processed.add('ovfDescriptorUploaded')
            if value in ('true', '1'):
                self.ovfDescriptorUploaded = True
            elif value in ('false', '0'):
                self.ovfDescriptorUploaded = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('goldMaster', node)
        if value is not None and 'goldMaster' not in already_processed:
            already_processed.add('goldMaster')
            if value in ('true', '1'):
                self.goldMaster = True
            elif value in ('false', '0'):
                self.goldMaster = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(VAppTemplateType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Owner':
            obj_ = OwnerType.factory()
            obj_.build(child_)
            self.Owner = obj_
            obj_.original_tagname_ = 'Owner'
        elif nodeName_ == 'Children':
            obj_ = VAppTemplateChildrenType.factory()
            obj_.build(child_)
            self.Children = obj_
            obj_.original_tagname_ = 'Children'
        elif nodeName_ == 'Section':
            class_obj_ = self.get_class_obj_(child_, Section_Type)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'Section'
        elif nodeName_ == 'CustomizationSection':
            obj_ = CustomizationSectionType.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'CustomizationSection'
        elif nodeName_ == 'AnnotationSection':
            obj_ = AnnotationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'AnnotationSection'
        elif nodeName_ == 'ProductSection':
            obj_ = ProductSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ProductSection'
        elif nodeName_ == 'NetworkSection':
            obj_ = NetworkSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'NetworkSection'
        elif nodeName_ == 'DiskSection':
            obj_ = DiskSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DiskSection'
        elif nodeName_ == 'OperatingSystemSection':
            obj_ = OperatingSystemSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'OperatingSystemSection'
        elif nodeName_ == 'EulaSection':
            obj_ = EulaSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'EulaSection'
        elif nodeName_ == 'VirtualHardwareSection':
            obj_ = VirtualHardwareSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'VirtualHardwareSection'
        elif nodeName_ == 'ResourceAllocationSection':
            obj_ = ResourceAllocationSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'ResourceAllocationSection'
        elif nodeName_ == 'InstallSection':
            obj_ = InstallSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'InstallSection'
        elif nodeName_ == 'StartupSection':
            obj_ = StartupSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'StartupSection'
        elif nodeName_ == 'DeploymentOptionSection':
            obj_ = DeploymentOptionSection_Type.factory()
            obj_.build(child_)
            self.Section.append(obj_)
            obj_.original_tagname_ = 'DeploymentOptionSection'
        elif nodeName_ == 'VAppScopedLocalId':
            VAppScopedLocalId_ = child_.text
            VAppScopedLocalId_ = self.gds_validate_string(VAppScopedLocalId_, node, 'VAppScopedLocalId')
            self.VAppScopedLocalId = VAppScopedLocalId_
        elif nodeName_ == 'DefaultStorageProfile':
            DefaultStorageProfile_ = child_.text
            DefaultStorageProfile_ = self.gds_validate_string(DefaultStorageProfile_, node, 'DefaultStorageProfile')
            self.DefaultStorageProfile = DefaultStorageProfile_
        elif nodeName_ == 'DateCreated':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.DateCreated = dval_
        super(VAppTemplateType, self).buildChildren(child_, node, nodeName_, True)
# end class VAppTemplateType


GDSClassesMapping = {
    'VdcStorageProfile': ReferenceType,
    'ControlAccessParams': ControlAccessParamsType,
    'Envelope': EnvelopeType,
    'CreationTime': cimDateTime,
    'StartupSection': StartupSection_Type,
    'HostResource': cimString,
    'UploadVAppTemplateParams': UploadVAppTemplateParamsType,
    'NetworkSection': NetworkSection_Type,
    'Metadata': MetadataType,
    'Files': FilesListType,
    'VendorUrl': cimString,
    'Parent': cimString,
    'DiskSection': DiskSection_Type,
    'LogDataRoot': cimString,
    'AutomaticStartupActionDelay': cimDateTime,
    'Annotation': Msg_Type,
    'Icon': IconType,
    'Task': TaskType,
    'ConfigurationDataRoot': cimString,
    'Notes': cimString,
    'Address': cimString,
    'Value': PropertyConfigurationValue_Type,
    'OtherResourceType': cimString,
    'Limit': cimUnsignedLong,
    'OperatingSystemSection': OperatingSystemSection_Type,
    'Organization': ReferenceType,
    'Reference': ReferenceType,
    'File': File_Type,
    'ResourceSubType': cimString,
    'Entity': EntityType,
    'VirtualHardwareSection': VirtualHardwareSection_Type,
    'Disk': VirtualDiskDesc_Type,
    'Subject': ReferenceType,
    'SnapshotDataRoot': cimString,
    'Network': NetworkType,
    'Section': Section_Type,
    'System': VSSD_Type,
    'Label': Msg_Type,
    'Source': ReferenceType,
    'Version': cimString,
    'Name': Msg_Type,
    'ProductSection': ProductSection_Type,
    'MetadataValue': MetadataValueType,
    'Vendor': Msg_Type,
    'AutomaticDeallocation': cimBoolean,
    'ConfigurationFile': cimString,
    'Link': LinkType,
    'Configuration': ConfigurationType,
    'VCloudExtension': VCloudExtensionType,
    'Info': Msg_Type,
    'ConfigurationID': cimString,
    'AddressOnParent': cimString,
    'Property': PropertyType,
    'Strings': Strings_Type,
    'Domain': MetadataDomainTagType,
    'Tasks': TasksInProgressType,
    'CustomizationSection': CustomizationSectionType,
    'Weight': cimUnsignedInt,
    'AccessSetting': AccessSettingType,
    'DeploymentOptionSection': DeploymentOptionSection_Type,
    'SuspendDataRoot': cimString,
    'AnnotationSection': AnnotationSection_Type,
    'VirtualSystemType': cimString,
    'Owner': ReferenceType,
    'ResourceEntity': ResourceEntityType,
    'ShadowVMReferences': ReferencesType,
    'Category': Msg_Type,
    'VAppTemplate': VAppTemplateType,
    'AutomaticStartupActionSequenceNumber': cimUnsignedShort,
    'AutomaticAllocation': cimBoolean,
    'Msg': MsgType,
    'ElementName': cimString,
    'FullVersion': cimString,
    'QueryList': QueryListType,
    'SwapFileDataRoot': cimString,
    'VirtualQuantity': cimUnsignedLong,
    'User': ReferenceType,
    'AccessSettings': AccessSettingsType,
    'AllocationUnits': cimString,
    'Connection': cimString,
    'Error': ErrorType,
    'CIM_VirtualSystemSettingData': CIM_VirtualSystemSettingData_Type,
    'MetadataEntry': MetadataEntryType,
    'References': References_Type,
    'Children': VAppTemplateChildrenType,
    'AppUrl': cimString,
    'InstanceID': cimString,
    'CloneVAppTemplateParams': CloneVAppTemplateParamsType,
    'Content': Content_Type,
    'VirtualSystemCollection': VirtualSystemCollection_Type,
    'Product': Msg_Type,
    'Description': Msg_Type,
    'InstallSection': InstallSection_Type,
    'ProductUrl': cimString,
    'PoolID': cimString,
    'Reservation': cimUnsignedLong,
    'VirtualQuantityUnits': cimString,
    'EulaSection': EulaSection_Type,
    'CIM_ResourceAllocationSettingData': CIM_ResourceAllocationSettingData_Type,
    'TypedValue': MetadataTypedValue,
    'License': Msg_Type,
    'Item': ItemType,
    'VirtualSystem': VirtualSystem_Type,
    'Vm': VAppTemplateType,
    'ResourceAllocationSection': ResourceAllocationSection_Type,
    'VirtualSystemIdentifier': cimString,
    'RecoveryFile': cimString,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'VAppTemplateType'
        rootClass = VAppTemplateType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'VAppTemplateType'
        rootClass = VAppTemplateType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'VAppTemplateType'
        rootClass = VAppTemplateType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'VAppTemplateType'
        rootClass = VAppTemplateType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from vAppTemplateType import *\n\n')
        sys.stdout.write('import vAppTemplateType as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AccessSettingType",
    "AccessSettingsType",
    "AnnotationSection_Type",
    "AutomaticRecoveryAction",
    "AutomaticShutdownAction",
    "AutomaticStartupAction",
    "CIM_ResourceAllocationSettingData_Type",
    "CIM_VirtualSystemSettingData_Type",
    "CapacityType",
    "CapacityWithUsageType",
    "Caption",
    "CloneVAppTemplateParamsType",
    "ConfigurationType",
    "ConsumerVisibility",
    "ContainerType",
    "Content_Type",
    "ControlAccessParamsType",
    "CustomizationSectionType",
    "DeploymentOptionSection_Type",
    "DiskSection_Type",
    "EntityLinkType",
    "EntityReferenceType",
    "EntityType",
    "EnvelopeType",
    "ErrorType",
    "EulaSection_Type",
    "FileType",
    "FileUploadParamsType",
    "FileUploadSocketType",
    "File_Type",
    "FilesListType",
    "IconType",
    "IdentifiableResourceType",
    "InstallSection_Type",
    "ItemType",
    "LinkType",
    "MappingBehavior",
    "MetadataBooleanValue",
    "MetadataDateTimeValue",
    "MetadataDomainTagType",
    "MetadataEntryType",
    "MetadataNumberValue",
    "MetadataStringValue",
    "MetadataType",
    "MetadataTypedValue",
    "MetadataValueType",
    "MsgType",
    "Msg_Type",
    "NetworkSection_Type",
    "NetworkType",
    "OperatingSystemSection_Type",
    "OwnerType",
    "ParamsType",
    "ProductSection_Type",
    "PropertyConfigurationValue_Type",
    "PropertyType",
    "QueryListType",
    "RASD_Type",
    "ReferenceType",
    "ReferencesType",
    "References_Type",
    "ResourceAllocationSection_Type",
    "ResourceEntityType",
    "ResourceReferenceType",
    "ResourceType",
    "Section_Type",
    "StartupSection_Type",
    "Strings_Type",
    "TaskOperationListType",
    "TaskType",
    "TasksInProgressType",
    "UploadVAppTemplateParamsType",
    "VAppTemplateChildrenType",
    "VAppTemplateType",
    "VCloudExtensibleType",
    "VCloudExtensionType",
    "VSSD_Type",
    "VirtualDiskDesc_Type",
    "VirtualHardwareSection_Type",
    "VirtualSystemCollection_Type",
    "VirtualSystem_Type",
    "cimAnySimpleType",
    "cimBase64Binary",
    "cimBoolean",
    "cimByte",
    "cimChar16",
    "cimDateTime",
    "cimDouble",
    "cimFloat",
    "cimHexBinary",
    "cimInt",
    "cimLong",
    "cimReference",
    "cimShort",
    "cimString",
    "cimUnsignedByte",
    "cimUnsignedInt",
    "cimUnsignedLong",
    "cimUnsignedShort",
    "qualifierBoolean",
    "qualifierSArray",
    "qualifierSInt64",
    "qualifierString",
    "qualifierUInt32"
]
