# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = [
    "base_folder",
    "simulations_observing_efficiency",
    "get_telescope",
    "parse_channels",
    "s4",
]

# Cell

import os

base_folder = os.environ.get(
    "S4REFSIMTOOL_INPUT", "/global/cscratch1/sd/keskital/s4sim/reference_tool/out/"
)

# Cell

simulations_observing_efficiency = dict(
    pole=dict(SAT=46.29 / 100, LAT=37.23 / 100), chile=dict()
)

# Cell


def get_telescope(channel):
    """Identify if a channel is in SAT or LAT

    Parameters
    ----------
    channel : str
        channel tag, e.g. MFH1

    Returns
    -------
    telescope : str
        'SAT' or 'LAT'
    """
    return channel[-2] + "AT"


# Cell

import h5py

s4 = h5py.File("cmbs4_tophat.h5", "r")


def parse_channels(channels):
    if channels in ["SAT", "LAT"]:
        channels = [ch for ch in s4.keys() if s4[ch].attrs["telescope"] == channels]
    elif channels in ["all", None]:
        channels = list(s4.keys())
    elif isinstance(channels, str):
        channels = channels.split(",")
    return channels
