# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-08-06 02:37
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_conversation', '0006_auto_20200617_1309'),
    ]

    operations = [
        migrations.CreateModel(
            name='Poll',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='(DEPRECIATED) set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('title', models.CharField(max_length=250, verbose_name='Title')),
                ('image', models.URLField(blank=True, null=True, verbose_name="Illustration de l'évènement")),
                ('hostingOrganisation', models.CharField(max_length=250, verbose_name='Name of the hosting organisation')),
                ('startDate', models.DateField(blank=True, null=True, verbose_name='Date de début')),
                ('endDate', models.DateField(verbose_name='Date de fin')),
                ('shortDescription', models.CharField(max_length=250, verbose_name='Short description')),
                ('longDescription', models.TextField(verbose_name='Long description')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='createdVotes', to=settings.AUTH_USER_MODEL)),
                ('debate', models.ManyToManyField(blank=True, related_name='debates', to='djangoldp_conversation.Conversation')),
            ],
        ),
        migrations.CreateModel(
            name='PollOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='(DEPRECIATED) set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(max_length=250, verbose_name='Options available for a vote')),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='(DEPRECIATED) set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(max_length=250, verbose_name='Name')),
            ],
        ),
        migrations.CreateModel(
            name='Vote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='(DEPRECIATED) set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('chosenOption', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='userVote', to='djangoldp_polls.PollOption')),
                ('relatedPoll', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='votes', to='djangoldp_polls.Poll')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='poll',
            name='pollOptions',
            field=models.ManyToManyField(blank=True, related_name='relatedPollOptions', to='djangoldp_polls.PollOption'),
        ),
        migrations.AddField(
            model_name='poll',
            name='tags',
            field=models.ManyToManyField(blank=True, related_name='tags', to='djangoldp_polls.Tag'),
        ),
    ]
