# Contributing

I love to work together with people so if you have an excellent idea for a feature, improvements or maybe you found
a bug. Please, don't hesitate in adding an issue, so we can discuss and find a good solution together.

If you never participated in any open-source project before it is even better! I can help you through the process. The
important thing is to get more people involved in the Python community. So, don't be shy!

## Getting started

The best way to get started is to look at the issues section and see if the bug or feature you are planning to work with
isn't already in development.

When the features and bug are not reported in the issues section, you can start by adding the issue.

### Reporting a bug

To report a bug is simple, add a few things:

- Description of the bug
- Error messages and tracebacks
- Steps to reproduce
- Python version
- System version

### Feature proposal

If you had a great idea for a feature, I would be thrilled to hear. You can add to the feature description
the following information:

- Description of the feature
- Some use cases
- Some examples of how the feature could work

When adding a proposal for a new feature try being as detailed as possible.

### Documentation

The project could always need more detailed and complete documentation. Contributions with docstrings and
improving the current documentation on README are very welcome.

## Start coding

If you get an issue to work on, then you can:

- Fork the project
- Create a new branch
- Hack away!
- Submit the pull request when you are ready


## Before you submit a pull request

- Make sure to add unit tests (if applicable)
- Make sure all tests are passing
- Run a code formatter. This project uses black, you can run the command: `black -l79 -N -S ./dataclass_csv`
- Add docstrings for new functions and classes.



Happy Hacking!!!
