# flake8: noqa: W291
# pylint: disable=too-many-lines,trailing-whitespace

"""
AbstractAnnofabApiのヘッダ部分

Note:
    このファイルはopenapi-generatorで自動生成される。詳細は generate/README.mdを参照
"""

import abc
import warnings  # pylint: disable=unused-import
from typing import Any, Dict, List, Optional, Tuple, Union  # pylint: disable=unused-import

import requests

import annofabapi  # pylint: disable=unused-import


class AbstractAnnofabApi(abc.ABC):
    """
    AnnofabApiクラスの抽象クラス
    """

    @abc.abstractmethod
    def _request_wrapper(
        self,
        http_method: str,
        url_path: str,
        query_params: Optional[Dict[str, Any]] = None,
        header_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
    ) -> Tuple[Any, requests.Response]:
        pass

    #########################################
    # Public Method : AfAccountApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def change_password(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """パスワード変更
        https://annofab.com/docs/api/#operation/changePassword


        authorizations: Everyone


        パスワードの変更を試みます。  パスワードの要件を満たさない場合、エラーメッセージが返ります。

        Args:
            request_body (Any): Request Body
                change_password_request (ChangePasswordRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/change-password"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def confirm_reset_email(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """メールアドレスstep2（確定）
        https://annofab.com/docs/api/#operation/confirmResetEmail


        authorizations: EveryoneRequestBody


        [受け取った確認コード](#operation/initiateResetEmail)を使い、メールアドレスを変更します。

        Args:
            request_body (Any): Request Body
                confirm_reset_email_request (ConfirmResetEmailRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/confirm-reset-email"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def confirm_reset_password(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """パスワードリセットstep2（新しいパスワードに変更）
        https://annofab.com/docs/api/#operation/confirmResetPassword


        authorizations: EveryoneRequestBody


        新しいパスワードに変更します。 本人確認のため、[パスワードリセットを要求](#operation/initiateResetPassword)で受信したメールに記載された検証コードを使用します。  パスワードリセットプロセスの最終ステップです。

        Args:
            request_body (Any): Request Body
                confirm_reset_password_request (ConfirmResetPasswordRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/confirm-reset-password"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def confirm_signup(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """サインアップstep2（本登録）
        https://annofab.com/docs/api/#operation/confirmSignup


        authorizations: EveryoneRequestBody


        アカウントのサインアップの最後のステップとして、アカウントを本登録します。

        Args:
            request_body (Any): Request Body
                confirm_sign_up_request (ConfirmSignUpRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/confirm-sign-up"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def confirm_verify_email(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """メールアドレス検証step2（確定）
        https://annofab.com/docs/api/#operation/confirmVerifyEmail


        authorizations: Everyone


        [受け取った確認コード](#operation/initiateVerifyEmail)を使い、メールアドレスが有効であることを確認します。

        Args:
            request_body (Any): Request Body
                confirm_verify_email_request (ConfirmVerifyEmailRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/confirm-verify-email"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_password_reset(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """パスワードリセットstep1（開始）
        https://annofab.com/docs/api/#operation/initiatePasswordReset


        authorizations: EveryoneRequestBody


        パスワードリセットに必要な確認コードをメールで送付します。 後続の[新しいパスワードに変更](#operation/confirmResetPassword)を実行することで、新しいパスワードに変更できます。

        Args:
            request_body (Any): Request Body
                password_reset_request (PasswordResetRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/request-password-reset"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_reset_email(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """メールアドレスリセットstep1（開始）
        https://annofab.com/docs/api/#operation/initiateResetEmail


        authorizations: Everyone


        メールアドレス変更プロセスを開始します。  本人からの要求かどうかを検証するための確認コードがメールで送付されます。

        Args:
            request_body (Any): Request Body
                reset_email_request (ResetEmailRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/reset-email"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_signup(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """サインアップstep1（仮登録）
        https://annofab.com/docs/api/#operation/initiateSignup




        アカウントのサインアップの最初のステップとして、アカウントを仮登録します。  AnnoFab に未登録のメールアドレスであれば、新規アカウントが仮登録状態で作成され、本登録フローのためのメールが送信されます。 このメールには仮パスワードなどが記載されています。  指定したメールアドレスを使うユーザーが仮登録であれば、本登録フローのメールが再送信されます。 指定したメールアドレスを使うユーザーが本登録であれば、不正なリクエストとしてエラーを返します（本登録が仮登録に戻ることはありません）。

        Args:
            request_body (Any): Request Body
                sign_up_request (SignUpRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/sign-up"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_verify_email(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """メールアドレス検証step1（開始）
        https://annofab.com/docs/api/#operation/initiateVerifyEmail


        authorizations: Everyone


        メールアドレスが有効かどうかの確認プロセスを開始します。  本人からの要求かどうかを検証するための確認コードがメールで送付されます。

        Args:
            request_body (Any): Request Body
                verify_email_request (VerifyEmailRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/verify-email"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfAnnotationApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_annotations(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション一括更新
        https://annofab.com/docs/api/#operation/batchUpdateAnnotations


        authorizations: ProjectAccepter


        複数のアノテーションを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の更新や削除ができます。  **現時点で、このAPIは複数のアノテーションを修正するためのもので、新しいアノテーションを作成することはできません**。 新しいアノテーションを更新や削除の対象に指定した場合、無視されます。  既に作成済みのアノテーションのうち、リクエストボディの配列に含まれないアノテーションは更新されません。  更新対象のアノテーションのうち、属性配列に含まれない属性は更新されません。  更新対象のアノテーションのラベルを変更する場合、異なるアノテーション種別のラベルに変更することはできません。 また、変更後のラベルに含まれない属性は削除されます。  画像全体のアノテーションは、他のラベルに変更することはできません。  塗りつぶしv2アノテーションは、1ラベル1アノテーションの制約のため、他の塗りつぶしv2ラベルに変更することはできません。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。  受入が完了しているタスクのアノテーション更新を含む場合、オーナー以上の権限が必要になります。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_annotation_request_item (List[BatchAnnotationRequestItem]):  (required)

        Returns:
            Tuple[List[SingleAnnotation], requests.Response]


        """
        url_path = f"/projects/{project_id}/annotations"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation(
        self, project_id: str, task_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク-入力データのSimpleアノテーション一括取得
        https://annofab.com/docs/api/#operation/getAnnotation


        authorizations: AllProjectMember


        指定したタスク - 入力データにつけられたアノテーションを一括で取得します。 Simple版のアノテーションJSONは、機械学習の一般的な利用で扱いやすい構造になっています。  なお、プロジェクト全体のアノテーションを一括で取得したい場合には、 [getAnnotationArchive](#operation/getAnnotationArchive) APIを使用することもできます。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[SimpleAnnotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation/simple"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_archive(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """SimpleアノテーションZIP取得
        https://annofab.com/docs/api/#operation/getAnnotationArchive


        authorizations: ProjectDataUser


        プロジェクト内のアノテーション（Simple版）がまとめられたZIPを取得するための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。 アノテーションZIPを更新中の場合は409エラーになります。  SimpleアノテーションZIPのデータ構造については、 [Simple Annotation ZIP](#section/Simple-Annotation-ZIP) を参照ください。  なお、特定のタスクのSimpleアノテーションを取得したい場合には、 [getAnnotation](#operation/getAnnotation) APIを使用することもできます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/archive/simple"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_list(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション一括取得
        https://annofab.com/docs/api/#operation/getAnnotationList


        authorizations: AllProjectMember


        指定したタスク-入力データにつけられたアノテーションを一括で取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数
                aggregate_by_task_and_input (bool):  trueを指定した場合に「タスクIDと入力IDの組」ごとに検索結果を集計するようにする。
                no_aggregate_label_and_input (bool):  trueを指定した場合、ラベルIDによるアノテーション検索数の集約結果、および属性IDによるアノテーション検索数の集約結果を取得しなくなります。  集約計算は時間がかかる処理であるため、アノテーション件数が多い場合はアノテーション検索が遅くなる場合がありますが、 このパラメーターをtrueに指定することで集約計算をおこなわなくなるため、アノテーション検索が速くなる可能性があります。
                query (str):  絞り込み条件([AnnotationQuery](#section/AnnotationQuery))をJSON形式で表した文字列。
                sort (str):  ソート順の指定。 使用可能キーはtask_id, input_data_id, detail.annotation_id, detail.account_id, detail.label_id, detail.data_holding_type, detail.created_datetime, detail.updated_datetimeのいずれかです。降順指定時は先頭に-(ハイフン)を付与します。 複数指定時は,(カンマ)区切りで列挙します。複数キーを列挙した場合は、先頭から優先順位を割り振られます。

        Returns:
            Tuple[AnnotationList, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotations"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_archive_full_with_pro_id(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """FullアノテーションZIP取得
        https://annofab.com/docs/api/#operation/getArchiveFullWithProId


        authorizations: ProjectDataUser


        プロジェクト内のアノテーション（Full版）がまとめられたZIPを取得するための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。 アノテーションZIPを更新中の場合は409エラーになります。  FullアノテーションZIPのデータ構造については、 [Full Annotation ZIP](#section/Full-Annotation-ZIP) を参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/archive/full"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_editor_annotation(
        self, project_id: str, task_id: str, input_data_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク/入力データのアノテーション一括取得
        https://annofab.com/docs/api/#operation/getEditorAnnotation


        authorizations: AllProjectMember


        [putAnnotation](#operation/putAnnotation)が要求する構造のアノテーションを取得します。 このAPIは、[putAnnotation](#operation/putAnnotation)をより利用しやすくする目的で提供しています。 機械学習などで利用する成果物としてのアノテーションを取得するには、以下をご利用いただけます。  * [getAnnotation](#operation/getAnnotation): 特定のタスク - 入力データのアノテーション取得 * [getAnnotationArchive](#operation/getAnnotationArchive): プロジェクト全体のアノテーション（ZIP）

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            query_params (Dict[str, Any]): Query Parameters
                task_history_id (str):  過去のフェーズのアノテーションを取得する場合、タスク履歴IDを指定します。未指定時は最新のアノテーションを取得します。  過去のアノテーションデータは最後に保存してから30日前のデータまで取得できます。 30日より前のデータを取得しようとした場合はアノテーションデータは空リストとなります。

        Returns:
            Tuple[Annotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_annotation_archive_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """アノテーションZIP更新開始
        https://annofab.com/docs/api/#operation/postAnnotationArchiveUpdate


        authorizations: ProjectDataUser


        プロジェクト内のアノテーションZIP（Simple版とFull版の両方）の更新を開始します。 ZIPの更新は、データ量に応じて数分〜数十分かかります。  アノテーションZIPは毎日AM 03:00 JSTごろに自動更新されますが、本APIを用いると、自動更新を待たずに更新を要求できます。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-annotation`）。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[PostAnnotationArchiveUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/archive/update"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_annotation(
        self, project_id: str, task_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク-入力データのアノテーション更新
        https://annofab.com/docs/api/#operation/putAnnotation


        authorizations: AllProjectMember


        「過去に誰にも割り当てられていないタスクに含まれる入力データ」に限り、プロジェクトオーナーであればアノテーションを更新できます。 この挙動は、[AnnoFab外部で作成されたアノテーションをインポート](/docs/tutorial/tutorial-ex-importing-annotation.html) する目的にも利用できます。  １度でも誰かに割り当てられたタスクは、タスクの現在の担当者であればアノテーションを更新できます。 タスクの現在の担当者でない場合、エラーになります。 この制限は、アノテーション作業中の予期せぬ同時編集を防ぐためです。  `is_protected`（保護） を `true` にすることで、アノテーションをアノテーションエディタ上での削除から保護できます。 属性の変更もさせたくない場合は、アノテーション仕様で特定の属性を読取専用にすることで保護できます。保護は、  * 外部からインポートしたアノテーション * 別プロジェクトからコピーしたアノテーション  などを誤って削除したくないときに便利です。 `is_protected`は、プロジェクトオーナーのみ変更可能です。  なお、本APIでは `is_protected` によらず、更新や削除が可能です。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            request_body (Any): Request Body
                annotation (Annotation):  (required)

        Returns:
            Tuple[Annotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfAnnotationSpecsApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_annotation_specs(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション仕様取得
        https://annofab.com/docs/api/#operation/getAnnotationSpecs


        authorizations: AllProjectMember


        指定したプロジェクトのアノテーション仕様を取得します。  パラメータを指定することで、過去に保存された履歴を取得することもできます。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                history_id (str):  過去のアノテーション仕様を取得する場合、[アノテーション仕様履歴取得](#operation/getAnnotationSpecsHistories)APIで取得した `history_id` の値を指定します。 未指定時は最新のアノテーション仕様を取得します。
                v (str):  取得するアノテーション仕様のフォーマットバージョンを指定します。

        Returns:
            Tuple[AnnotationSpecs, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_specs_histories(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """アノテーション仕様履歴一括取得
        https://annofab.com/docs/api/#operation/getAnnotationSpecsHistories


        authorizations: AllProjectMember


        指定されたプロジェクトのアノテーション仕様のすべての履歴を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[AnnotationSpecsHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs-histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_annotation_specs(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション仕様更新
        https://annofab.com/docs/api/#operation/putAnnotationSpecs


        authorizations: ProjectOwner


        アノテーション仕様を更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                annotation_specs_request (AnnotationSpecsRequest):  (required)

        Returns:
            Tuple[AnnotationSpecsV2, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfCommentApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_comments(
        self, project_id: str, task_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """コメント一括更新
        https://annofab.com/docs/api/#operation/batchUpdateComments


        authorizations: AllProjectMember


        コメントを一括更新します。 タスクの現在の担当者でない場合、またはタスクの状態が「作業中」でない場合は409エラーになります。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新（作成含む）」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の更新や削除ができます。  既に作成済みのコメントのうち、リクエストボディの配列に含まれないものは更新されません。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。  **このAPIでは検査コメントのデータは更新できません（今後対応予定）。**

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            request_body (Any): Request Body
                batch_comment_request_item (List[BatchCommentRequestItem]):  (required)

        Returns:
            Tuple[List[Comment], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/comments"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_comments(
        self, project_id: str, task_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """コメント一括取得
        https://annofab.com/docs/api/#operation/getComments


        authorizations: AllProjectMember


        指定されたタスクで、指定された入力データにつけられたコメントをすべて取得します。  **このAPIでは検査コメントのデータは取得できません（今後対応予定）。**

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[List[Comment], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/comments"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInputApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_inputs(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データ一括更新
        https://annofab.com/docs/api/#operation/batchUpdateInputs


        authorizations: ProjectOwner


        入力データを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、現在「削除」の1通りのみがあります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の削除ができます。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_input_data_request_item (List[BatchInputDataRequestItem]):  (required)

        Returns:
            Tuple[List[InputData], requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def create_temp_path(
        self, project_id: str, header_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """一時データ保存先取得
        https://annofab.com/docs/api/#operation/createTempPath


        authorizations: AllProjectMember


        「複数の入力データを圧縮したZIPファイル」や「4MBを超える画像」などをAnnoFabに一時的に保存するための、URLと登録用データパスを発行します。  このAPIと他のAPIを以下に示すように使うことで、ZIPファイルなどをAFにアップロードできます。   1. 本APIを実行して、URLを取得する。   * `curl -X POST -H 'Content-Type: {CONTENT_TYPE_HERE}' 'https://annofab.com/api/v1/projects/{project_id}/create-temp-path'` 2. 1で取得したURLに、一時保存したいファイルをPUTする。   * `curl -X PUT -H 'Content-Type: {CONTENT_TYPE_HERE}' --data-binary @/hoge.zip 'https://{発行されたURL}'` 3. 1で取得した登録用データパスを [入力データ登録API](#operation/putInputData)のリクエストボディ `input_data_path` に指定する。   * `curl -X PUT -H 'Content-Type: text/json' -d '{\"input_data_name\":\"{表示名}\", \"input_data_path\":\"{登録用データパス}\" }' 'https://annofab.com/api/v1/projects/{project_id}/inputs/{input_data_id}'`  ここで、1と2で `CONTENT_TYPE_HERE` は必ず一致しなければいけません。 ZIPファイルの場合は `application/zip` 、画像ファイルの場合は `image/png` など、適切な Content-Type を指定します。  登録するファイルはどのような内容であれ、アップロードから24時間経過すると削除されます。 したがって、ZIP圧縮した入力データを登録する場合は、URL発行から24時間以内に完了してください。

        Args:
            project_id (str):  プロジェクトID (required)
            header_params (Dict[str, Any]): Header Parameters
                content_type (str):  アップロードしたいファイルの Content-Type を指定します。

        Returns:
            Tuple[DataPath, requests.Response]


        """
        url_path = f"/projects/{project_id}/create-temp-path"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "header_params": header_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_input_data(self, project_id: str, input_data_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データ削除
        https://annofab.com/docs/api/#operation/deleteInputData


        authorizations: ProjectOwner


        入力データを削除します。  入力データの実体ファイルが AnnoFab のストレージに存在するものであれば、実体ファイルも削除されます。 お客様の管理するプライベートストレージに存在するものであれば、実体ファイルは削除されません。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data(self, project_id: str, input_data_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データ取得
        https://annofab.com/docs/api/#operation/getInputData


        authorizations: AllProjectMember


        指定された入力データを取得します。  この API の返す入力データは入力データ名などの項目を含む JSON であり、実体のファイル（画像や動画など）ではありません。 実体ファイルにアクセスする方法は非公開です（詳細を希望される場合はお問い合わせください）。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_list(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データ一括取得
        https://annofab.com/docs/api/#operation/getInputDataList


        authorizations: AllProjectMember


        指定されたプロジェクトの入力データを検索します。  パフォーマンスのため、結果はページング形式で返ります。全件取得したい場合は、レスポンスを見て、ページ移動してください。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                input_data_id (str):  入力データIDでの部分一致検索で使用。1文字以上あれば使用します。最大文字列長300文字。大文字小文字は区別しません。
                input_data_name (str):  入力データ名での部分一致検索で使用。1文字以上あれば使用します。最大文字列長300文字。大文字小文字は区別しません。
                input_data_path (str):  入力データパスでの部分一致検索で使用。1文字以上あれば使用します。最大文字列長300文字。
                task_id (str):  入力データが紐づくタスクIDの部分一致検索で使用。1文字以上あれば使用します。最大文字列長300文字。大文字小文字は区別しません。条件に合致した先頭100件のタスクに使われている入力データを検索します。
                _from (str):  更新日時での範囲検索で使用（ISO 8601 拡張形式）
                to (str):  更新日時での範囲検索で使用（ISO 8601 拡張形式）
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数

        Returns:
            Tuple[InputDataList, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_input_data(
        self, project_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データ更新
        https://annofab.com/docs/api/#operation/putInputData


        authorizations: ProjectOwner


        入力データ（画像プロジェクトなら画像、動画プロジェクトなら動画や時系列データ）を登録します。  ファイルの登録には、[アップロード用一時データ保存先作成API](#operation/createTempPath) を組み合わせて使用します。  ## ZIPでまとめてアップロード  画像プロジェクトの場合、複数の画像ファイルをZIPでまとめてアップロードできます。ZIPは最大5GB、UTF-8エンコーディングのみ対応しています。<br> アノテーション作業生産性を高めるため、画像は「長辺4096px以内」かつ「4MB以内」になるよう縮小されます。<br> 作成されるアノテーションは、元の解像度でつけた場合相当に自動で復元されます。  動画プロジェクトの場合、複数の動画ファイルをZIPでまとめてアップロードできます。ZIPは最大5GB、UTF-8エンコーディングのみ対応しています。<br> また、複数のストリーミング形式の動画をアップロードすることもできます。<br> この場合はZIP形式必須で、同一のZIPファイル内にm3u8ファイルとtsファイルを両方含めてください。<br> なお、このm3u8ファイルに記述された相対パスでtsファイルが参照可能である必要があります。  ZIPファイルを登録するとバックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-inputs`）。  ### ディレクトリ例 ```   hoge.zip/     hoge.ts     fuga/       foo.m3u8(hoge.ts, fuga/foo1.ts, fuga/foo2.tsを参照)       foo1.ts       foo2.ts     piyo1/       piyo2/         bar.ts       bar.m3u8(hoge.ts, piyo1/piyo2/bar.tsを参照) ```  ## 注意事項  * `input_data_path` のスキーマが `https` の場合、 `input_data_name` もしくは `input_data_path` の末尾にファイルの拡張子を含むようにしてください     * `input_data_name`  の値が優先されます * `input_data_path` のスキーマが `s3` かつ入力データがtsファイルの場合、 `input_data_name` もしくは `input_data_path` の末尾にファイルの拡張子を含むようにしてください     * `input_data_name`  の値が優先されます * ZIPでまとめてアップロード時、ZIPファイル内の次の名前のファイルは入力データとして登録されません     * `Thumbs.db`     * `__MACOSX`     * `.DS_Store`     * 上記以外の、ファイル名先頭が `.`（ドット）で始まるファイル * ZIPでまとめてアップロード時、ZIPファイル内の `.`（ドット）から始まるフォルダ以下のファイルは入力データとして登録されません

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                input_data_request (InputDataRequest):  (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInspectionApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_inspections(
        self, project_id: str, task_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント一括更新
        https://annofab.com/docs/api/#operation/batchUpdateInspections


        authorizations: AllProjectMember


        検査コメントを一括更新します。 タスクの現在の担当者でない場合、またはタスクの状態が「作業中」でない場合は409エラーになります。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新（作成含む）」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の更新や削除ができます。  既に作成済みの検査コメントのうち、リクエストボディの配列に含まれないものは更新されません。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            request_body (Any): Request Body
                batch_inspection_request_item (List[BatchInspectionRequestItem]):  (required)

        Returns:
            Tuple[List[Inspection], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/inspections"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspections(
        self, project_id: str, task_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント一括取得
        https://annofab.com/docs/api/#operation/getInspections


        authorizations: AllProjectMember


        指定されたタスクで、指定された入力データにつけられた検査コメントをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[List[Inspection], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/inspections"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInstructionApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_instruction_image(self, project_id: str, image_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像削除
        https://annofab.com/docs/api/#operation/deleteInstructionImage


        authorizations: ProjectAccepter, ProjectOwner


        プロジェクトの作業ガイドの画像を削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            image_id (str):  作業ガイド画像ID (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images/{image_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの取得
        https://annofab.com/docs/api/#operation/getInstruction


        authorizations: AllProjectMember


        指定された版の作業ガイドのHTMLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                history_id (str):  取得する版の履歴ID (required)

        Returns:
            Tuple[Instruction, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_history(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの編集履歴の取得
        https://annofab.com/docs/api/#operation/getInstructionHistory


        authorizations: AllProjectMember


        プロジェクトの作業ガイドの編集履歴を取得します。 取得される編集履歴は日付の新しい順にソートされます。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                limit (int):  取得する編集履歴の件数

        Returns:
            Tuple[List[InstructionHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-history"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_image_url_for_put(
        self, project_id: str, image_id: str, header_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像登録・更新用URL取得
        https://annofab.com/docs/api/#operation/getInstructionImageUrlForPut


        authorizations: ProjectAccepter, ProjectOwner


        プロジェクトの作業ガイドの画像を登録するためのput先URLを取得します。  リクエストヘッダには、登録する画像に応じた適切な Content-Type を指定してください。   作業ガイド画像の登録/更新方法は以下の通りです。 1. `getInstructionImageUrlForPut` APIを実行して、ファイルアップロード用のURLを取得する。   * `curl -X GET -H 'Content-Type: {CONTENT_TYPE_HERE}' 'https://annofab.com/api/v1/projects/{project_id}/instruction-images/{image_id}/put-url'` 2. 手順1で取得したファイルアップロード用のURLに対して、登録/更新する作業ガイド画像ファイル(`hoge.jpg`)をPUTする。   * `curl -X PUT -H 'Content-Type: {CONTENT_TYPE_HERE}' --data-binary @/hoge.jpg '{ファイルアップロード用のURL}'`  手順1と2で `CONTENT_TYPE_HERE` は必ず一致しなければいけません。

        Args:
            project_id (str):  プロジェクトID (required)
            image_id (str):  作業ガイド画像ID (required)
            header_params (Dict[str, Any]): Header Parameters
                content_type (str):  登録する画像ファイルの Content-Type を指定します。

        Returns:
            Tuple[InstructionImagePath, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images/{image_id}/put-url"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "header_params": header_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_images(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像一覧の取得
        https://annofab.com/docs/api/#operation/getInstructionImages


        authorizations: AllProjectMember


        プロジェクトの作業ガイドの画像一覧を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[InstructionImage], requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_instruction(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの更新
        https://annofab.com/docs/api/#operation/putInstruction


        authorizations: ProjectAccepter, ProjectOwner


        作業ガイドのHTMLを更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                instruction (Instruction):  (required)

        Returns:
            Tuple[InstructionHistory, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfJobApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_project_job(
        self, project_id: str, job_type: str, job_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """バックグラウンドジョブ情報削除
        https://annofab.com/docs/api/#operation/deleteProjectJob


        authorizations: ProjectOwner


        バックグラウンドジョブ情報を削除します。  なお、バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            project_id (str):  プロジェクトID (required)
            job_type (ProjectJobType):  ジョブの種別。[詳細はこちら](#section/ProjectJobType)。 (required)
            job_id (str):  ジョブID (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/jobs/{job_type}/{job_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_job(
        self, organization_name: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織のバックグラウンドジョブ情報取得
        https://annofab.com/docs/api/#operation/getOrganizationJob


        authorizations: AllOrganizationMember


        組織のバックグラウンドジョブの情報を取得します。 取得されるジョブ情報は、作成日付の新しい順にソートされています。  バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            organization_name (str):  組織名 (required)
            query_params (Dict[str, Any]): Query Parameters
                type (str):  取得するジョブの種別。[詳細はこちら](#section/OrganizationJobType)。
                page (int):  検索結果のうち、取得したいページの番号(1始まり)  現在は未実装のパラメータです。(今後対応予定)
                limit (int):  1ページあたりの取得するデータ件数。 未指定時は1件のみ取得。
                exclusive_start_created_datetime (str):  取得するデータの直前の作成日時（ISO 8601 拡張形式）

        Returns:
            Tuple[OrganizationJobInfoContainer, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/jobs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_job(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトのバックグラウンドジョブ情報取得
        https://annofab.com/docs/api/#operation/getProjectJob


        authorizations: AllProjectMember


        プロジェクトのバックグラウンドジョブの情報を取得します。 取得されるジョブ情報は、作成日付の新しい順にソートされています。  バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                type (ProjectJobType):  取得するジョブの種別。[詳細はこちら](#section/ProjectJobType)。
                page (int):  検索結果のうち、取得したいページの番号(1始まり)  現在は未実装のパラメータです。(今後対応予定)
                limit (int):  1ページあたりの取得するデータ件数。 未指定時は1件のみ取得。
                exclusive_start_created_datetime (str):  取得するデータの直前の作成日時（ISO 8601 拡張形式）

        Returns:
            Tuple[ProjectJobInfoContainer, requests.Response]


        """
        url_path = f"/projects/{project_id}/jobs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfMyApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def confirm_my_account_delete(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """アカウント削除step2（確定）
        https://annofab.com/docs/api/#operation/confirmMyAccountDelete


        authorizations: EveryoneRequestBody


        [受け取った確認コード](#operation/initiateMyAccountDelete)を使い、アカウントを削除します。

        Args:
            request_body (Any): Request Body
                confirm_account_delete_request (ConfirmAccountDeleteRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/my/account/delete-request/confirm"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_account(self, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のアカウント取得
        https://annofab.com/docs/api/#operation/getMyAccount


        authorizations: Everyone


        API リクエストユーザーのアカウント情報を取得します。

        Args:

        Returns:
            Tuple[MyAccount, requests.Response]


        """
        url_path = f"/my/account"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_member_in_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のプロジェクトメンバー取得
        https://annofab.com/docs/api/#operation/getMyMemberInProject


        authorizations: AllProjectMember


        備考: システム管理者が自身が所属しないプロジェクトに対して実行した場合、オーナーであるというダミーのプロジェクトメンバー情報が取得できます。ダミーには更新日は含まれません。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/my/projects/{project_id}/member"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_organizations(
        self, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """所属組織一括取得
        https://annofab.com/docs/api/#operation/getMyOrganizations


        authorizations: AllOrganizationMember


        API リクエストユーザーが所属するすべての組織における、自身がどのようなメンバー設定で所属しているかをまとめて取得します。

        Args:
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号  現在は未実装のパラメータです。(今後対応予定)
                limit (int):  1ページあたりの取得するデータ件数  現在は未実装のパラメータです。(今後対応予定)

        Returns:
            Tuple[MyOrganizationList, requests.Response]


        """
        url_path = f"/my/organizations"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_project_members(self, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のプロジェクトメンバー情報一括取得
        https://annofab.com/docs/api/#operation/getMyProjectMembers


        authorizations: Everyone


        API リクエストユーザーが所属するすべてのプロジェクトにおける、自身がどのようなメンバー設定で所属しているかをまとめて取得します。

        Args:

        Returns:
            Tuple[List[ProjectMember], requests.Response]


        """
        url_path = f"/my/project-members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_projects(self, query_params: Optional[Dict[str, Any]] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """所属プロジェクト一括取得
        https://annofab.com/docs/api/#operation/getMyProjects


        authorizations: Everyone


        自身が所属するプロジェクトを一括で取得します。

        Args:
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号
                limit (int):  1ページあたりの取得するデータ件数
                organization_id (str):  指定した組織に属するプロジェクトに絞り込む。未指定時は全プロジェクト。
                title (str):  プロジェクトタイトルでの部分一致検索。1文字以上あれば使用します。利便性のため、大文字小文字は区別しません。
                status (ProjectStatus):  指定した状態のプロジェクトで絞り込む。未指定時は全プロジェクト。
                input_data_type (InputDataType):  指定した入力データ種別でプロジェクトを絞り込む。未指定時は全プロジェクト
                sort_by (str):  `date` を指定することでプロジェクトの最新のタスク更新時間の順にソートして出力する。 未指定時はプロジェクト名でソートする。

        Returns:
            Tuple[ProjectContainer, requests.Response]


        """
        url_path = f"/my/projects"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_my_account_delete(self, **kwargs) -> Tuple[Any, requests.Response]:
        """アカウント削除step1（確認）
        https://annofab.com/docs/api/#operation/initiateMyAccountDelete


        authorizations: Everyone


        アカウント削除プロセスを開始します。  本人からの要求かどうかを検証するための確認コードがメールで送付されます。

        Args:

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/my/account/delete-request"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_my_account(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のアカウント情報更新
        https://annofab.com/docs/api/#operation/putMyAccount


        authorizations: Everyone


        API リクエストユーザーのアカウント情報を更新します。

        Args:
            request_body (Any): Request Body
                put_my_account_request (PutMyAccountRequest):  (required)

        Returns:
            Tuple[MyAccount, requests.Response]


        """
        url_path = f"/my/account"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def update_organization(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """組織名変更
        https://annofab.com/docs/api/#operation/updateOrganization


        authorizations: OrganizationOwner


        同じ name の組織が既に存在する場合は失敗(400)します。

        Args:
            request_body (Any): Request Body
                put_organization_name_request (PutOrganizationNameRequest):  (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/my/organizations"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def create_new_organization(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """組織新規作成
        https://annofab.com/docs/api/#operation/createNewOrganization


        authorizations: Everyone


        同じ name の組織が既に存在する場合は失敗（400）します。

        Args:
            request_body (Any): Request Body
                organization_registration_request (OrganizationRegistrationRequest):  (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_organization(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織削除
        https://annofab.com/docs/api/#operation/deleteOrganization


        authorizations: OrganizationOwner


        組織を完全に削除します。  組織のプロジェクトが1件も存在しない場合のみ削除できます。 組織を削除したい場合は全てのプロジェクトを削除してください。 また、削除された組織は元に戻せませんのでご注意ください。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_name}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織情報取得
        https://annofab.com/docs/api/#operation/getOrganization


        authorizations: AllOrganizationMember


        指定組織の組織IDなどの情報を取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_name}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_activity(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織活動サマリー取得
        https://annofab.com/docs/api/#operation/getOrganizationActivity


        authorizations: AllOrganizationMember


        組織全体でどれだけ AnnoFab ストレージを使用しているかなどの活動の要約を取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationActivity, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/activity"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_projects_of_organization(
        self, organization_name: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織配下プロジェクト一括取得
        https://annofab.com/docs/api/#operation/getProjectsOfOrganization


        authorizations: AllOrganizationMember


        指定した組織のプロジェクトを一括で取得します。

        Args:
            organization_name (str):  組織名 (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号
                limit (int):  1ページあたりの取得するデータ件数
                account_id (str):  指定したアカウントIDをメンバーに持つプロジェクトで絞り込む。
                except_account_id (str):  指定したアカウントIDをメンバーに持たないプロジェクトで絞り込む。
                title (str):  プロジェクトタイトルでの部分一致検索。1文字以上あれば使用します。利便性のため、大文字小文字は区別しません。
                status (ProjectStatus):  指定した状態のプロジェクトで絞り込む。未指定時は全プロジェクト。
                plugin_id (str):  指定したプラグインIDを使用しているプロジェクトで絞り込む。未指定時は指定なし。
                input_data_type (InputDataType):  指定した入力データ種別でプロジェクトを絞り込む。未指定時は全プロジェクト。
                sort_by (str):  `date` を指定することでプロジェクトの最新のタスク更新時間の順にソートして出力する。 未指定時はプロジェクト名でソートする。

        Returns:
            Tuple[ProjectList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/projects"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationInputApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_organization_input_data(
        self, organization_name: str, input_data_set_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセットの入力データ削除
        https://annofab.com/docs/api/#operation/deleteOrganizationInputData


        authorizations: OrganizationAdministrator, ProjectOwner


        指定した組織の[入力データセット](#tag/af-organization-input)内で指定した入力データ情報を削除します。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs/{input_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_set(
        self, organization_name: str, input_data_set_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット情報取得
        https://annofab.com/docs/api/#operation/getInputDataSet


        authorizations: AllOrganizationMember


        指定した組織の[入力データセット](#tag/af-organization-input)の情報を取得します。 組織オーナーまたは組織管理者でない場合は自身が所属するプロジェクトの入力データセットのみが取得できます。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)

        Returns:
            Tuple[InputDataSet, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_set_list(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データセット一括取得
        https://annofab.com/docs/api/#operation/getInputDataSetList


        authorizations: OrganizationAdministrator, OrganizationOwner


        指定した組織の[入力データセット](#tag/af-organization-input)を一括で取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[InputDataSetList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_input_data(
        self, organization_name: str, input_data_set_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセットの入力データ取得
        https://annofab.com/docs/api/#operation/getOrganizationInputData


        authorizations: AllOrganizationMember


        指定した組織の[入力データセット](#tag/af-organization-input)内で指定した入力データ情報を取得します。 組織オーナーまたは組織管理者でない場合は自身が所属するプロジェクトの入力データセット内の入力データのみが取得できます。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs/{input_data_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_input_data_list(
        self, organization_name: str, input_data_set_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット内の入力データ一括取得
        https://annofab.com/docs/api/#operation/getOrganizationInputDataList


        authorizations: AllOrganizationMember


        指定された入力データセットの入力データを検索します。 組織オーナーまたは組織管理者でない場合は自身が所属するプロジェクトの入力データセット内の入力データのみが取得できます。  パフォーマンスのため、結果はページング形式で返ります。全件取得したい場合は、レスポンスを見て、ページ移動してください。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            query_params (Dict[str, Any]): Query Parameters
                input_data_id (str):  入力データIDでの部分一致検索で使用。1文字以上あれば使用します。
                input_data_name (str):  入力データ名での部分一致検索で使用。1文字以上あれば使用します。
                input_data_path (str):  入力データパスでの部分一致検索で使用。1文字以上あれば使用します。
                task_id (str):  入力データが紐づくタスクIDの部分一致検索で使用。1文字以上あれば使用します。条件に合致した先頭100件のタスクに使われている入力データを検索します。
                _from (str):  更新日時での範囲検索で使用（ISO 8601 拡張形式）
                to (str):  更新日時での範囲検索で使用（ISO 8601 拡張形式）
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数

        Returns:
            Tuple[InputDataList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_input_data_set(
        self, organization_name: str, input_data_set_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット新規作成/更新
        https://annofab.com/docs/api/#operation/putInputDataSet


        authorizations: OrganizationAdministrator, OrganizationOwner


        指定した組織の[入力データセット](#tag/af-organization-input)の情報を新規登録/更新します。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            request_body (Any): Request Body
                put_input_data_set_request (PutInputDataSetRequest):

        Returns:
            Tuple[InputDataSet, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationMemberApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def accept_organization_invitation(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織への招待受諾
        https://annofab.com/docs/api/#operation/acceptOrganizationInvitation


        authorizations: EveryoneRequestBody


        組織への招待を受諾し、組織へのメンバー登録を完了します。  [組織招待API](#operation/postInviteOrganizationMember)で送信されたメールに記載されているトークンが必要です。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザ名 (required)
            request_body (Any): Request Body
                accept_organization_invitation_request (AcceptOrganizationInvitationRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/invitation/accept"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_organization_member(
        self, organization_name: str, user_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバー削除
        https://annofab.com/docs/api/#operation/deleteOrganizationMember


        authorizations: OrganizationAdministrator


        指定したメンバーを指定した組織から削除します。  組織の管理者が実行する場合、組織のオーナーは削除できません。(権限エラーになります)

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザID (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_member(self, organization_name: str, user_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織メンバー取得
        https://annofab.com/docs/api/#operation/getOrganizationMember


        authorizations: AllOrganizationMember


        指定したユーザーが指定した組織にどのようなロールで参加しているかを取得します。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザID (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_members(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織メンバー一括取得
        https://annofab.com/docs/api/#operation/getOrganizationMembers


        authorizations: AllOrganizationMember


        脱退したメンバーは含まれません。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationMemberList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def invite_organization_member(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織への招待送信
        https://annofab.com/docs/api/#operation/inviteOrganizationMember


        authorizations: OrganizationAdministrator


        指定したユーザーに、組織への招待（メール）を送信します。  組織の管理者が実行する場合、リクエストボディ内の `role` には `contributor` を指定してください。(それ以外の値を指定した場合エラーとなります)

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザ名 (required)
            request_body (Any): Request Body
                invite_organization_member_request (InviteOrganizationMemberRequest):  (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/invitation"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def update_organization_member_role(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバーのロール更新
        https://annofab.com/docs/api/#operation/updateOrganizationMemberRole


        authorizations: OrganizationOwner


        指定された組織メンバーのロールのみを変更します。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザID (required)
            request_body (Any): Request Body
                put_organization_member_role_request (PutOrganizationMemberRoleRequest):  (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/role"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationPluginApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_organization_plugin(
        self, organization_name: str, plugin_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグイン削除
        https://annofab.com/docs/api/#operation/deleteOrganizationPlugin


        authorizations: OrganizationAdministrator, OrganizationOwner


        **この API は AnnoFab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**  指定した組織のプラグインを削除します。

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_plugin(
        self, organization_name: str, plugin_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグイン取得
        https://annofab.com/docs/api/#operation/getOrganizationPlugin


        authorizations: AllOrganizationMember


        **この API は AnnoFab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**  指定した組織のプラグインを取得します。

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_plugins(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プラグイン一括取得
        https://annofab.com/docs/api/#operation/getOrganizationPlugins


        authorizations: AllOrganizationMember


        **この API は AnnoFab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**  指定した組織のプラグインを一括で取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationPluginList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_organization_plugin(
        self, organization_name: str, plugin_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグイン更新
        https://annofab.com/docs/api/#operation/putOrganizationPlugin


        authorizations: OrganizationAdministrator, OrganizationOwner


        **この API は AnnoFab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**  指定した組織のプラグインを更新します。

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)
            request_body (Any): Request Body
                put_organization_plugin_request (PutOrganizationPluginRequest):  (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト削除
        https://annofab.com/docs/api/#operation/deleteProject


        authorizations: ProjectOwner


        プロジェクトを完全に削除します。 アノテーション仕様、タスク、入力データ、アノテーションなど、プロジェクト配下のリソースがすべて削除されます。  削除されたプロジェクトは元に戻せません。 完了したプロジェクトは削除せず、プロジェクト状態を「停止中」に変更するのをおすすめします。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`delete-project`）。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[DeleteProjectResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_of_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトの所属組織取得
        https://annofab.com/docs/api/#operation/getOrganizationOfProject


        authorizations: AllProjectMember


        指定されたプロジェクトがひもづく組織を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/projects/{project_id}/organization"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト取得
        https://annofab.com/docs/api/#operation/getProject


        authorizations: AllProjectMember


        プロジェクトを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Project, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_inputs_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトの入力データ情報全件URLの取得
        https://annofab.com/docs/api/#operation/getProjectInputsUrl


        authorizations: ProjectDataUser


        入力データ情報全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  ### 入力データ情報全件ファイル 入力データ情報全件ファイルには、プロジェクトの入力データ情報がJSON形式（[InputData](#section/InputData)の配列）で記録されています。 ただし`InputData`中の`url`は常に`null`です。 このファイルは毎日AM 02:00 JSTに更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_inspections_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトの検査コメント全件URLの取得
        https://annofab.com/docs/api/#operation/getProjectInspectionsUrl


        authorizations: ProjectDataUser


        検査コメント全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  ### 検査コメント全件ファイル 検査コメント全件ファイルには、プロジェクトの検査コメント情報がJSON形式（[Inspection](#section/Inspection)の配列）で記録されています。 このファイルは毎日AM 02:00 JSTに更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/inspections"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_task_histories_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク履歴全件URLの取得
        https://annofab.com/docs/api/#operation/getProjectTaskHistoriesUrl


        authorizations: ProjectDataUser


        タスク履歴全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  ### タスク履歴全件ファイル タスク履歴イベント全件ファイルには、プロジェクトのタスク履歴情報がJSON形式（キーがタスクID、値が[TaskHistory](#section/TaskHistory)の配列となるマップ）で記録されています。 このファイルは毎日AM 02:00 JSTに更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/task_histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_task_history_events_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク履歴イベント全件URLの取得
        https://annofab.com/docs/api/#operation/getProjectTaskHistoryEventsUrl

        .. deprecated:: X

        authorizations: ProjectDataUser


        タスク履歴イベント全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  ### タスク履歴イベント全件ファイル タスク履歴イベント全件ファイルには、プロジェクトのタスク履歴イベント情報がJSON形式（[TaskHistoryEvent](#section/TaskHistoryEvent)の配列）で記録されています。 このファイルは毎日AM 02:00 JSTに更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_project_task_history_events_url() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/rawdata/task_history_events"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_tasks_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク全件URLの取得
        https://annofab.com/docs/api/#operation/getProjectTasksUrl


        authorizations: ProjectDataUser


        タスク全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  ### タスク全件ファイル タスク全件ファイルには、プロジェクトのタスク情報がJSON形式（[Task](#section/Task)の配列）で記録されています。 このファイルは毎日AM 02:00 JSTに更新されます。 また、[postProjectTasksUpdate](#operation/postProjectTasksUpdate) APIを利用することで、手動でタスク全件ファイルを更新することも可能です。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/tasks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_project_copy(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト複製
        https://annofab.com/docs/api/#operation/initiateProjectCopy


        authorizations: OrganizationAdministrator, ProjectOwner


        指定したプロジェクトのデータを引き継いだ新しいプロジェクトを作成します。 新しいプロジェクトに引き継がれるデータは次の通りです。  * プロジェクト設定 * プロジェクトメンバー * アノテーション仕様  また、オプションを指定することで新しいプロジェクトに次のデータを引き継ぐことも可能です。  |引き継ぎ対象|同時に引き継ぐ必要があるデータ| |:--|:--| |入力データ|| |タスク|入力データ| |アノテーション|入力データ、タスク| |補助情報|入力データ| |作業ガイド|| |Webhook||  このAPIを利用するには、プロジェクトを登録する組織の[OrganizationAdministrator](#section/Authentication/OrganizationAdministrator) かつ コピー元プロジェクトの [ProjectOwner](#section/Authentication/ProjectOwner) である必要があります。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`copy-project`）。

        Args:
            project_id (str):  コピー元となるプロジェクトID (required)
            request_body (Any): Request Body
                project_copy_request (ProjectCopyRequest):  (required)

        Returns:
            Tuple[ProjectCopyResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/copy"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_project_inputs_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトの入力データ情報全件ファイル更新開始
        https://annofab.com/docs/api/#operation/postProjectInputsUpdate


        authorizations: ProjectDataUser


        プロジェクト内の入力データ情報全件ファイルの更新を開始します。 ファイルの更新時間は、データ量に応じて数分～数十分程度かかります。 本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-inputs-list`）。  入力データ情報全件ファイルは毎日AM 02:00 JSTに自動更新されます。 本APIを用いると、自動更新を待たずに更新を要求できます。 ただし、入力データ情報全件ファイル以外は更新されません。  入力データ情報全件ファイルについては、[getProjectInputsUrl](#operation/getProjectInputsUrl) APIを参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectInputsUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/inputs"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_project_tasks_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク全件ファイル更新開始
        https://annofab.com/docs/api/#operation/postProjectTasksUpdate


        authorizations: ProjectDataUser


        プロジェクト内のタスク全件ファイルの更新を開始します。 ファイルの更新時間は、データ量に応じて数分～数十分程度かかります。 本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-tasks-list`）。  タスク全件ファイルは毎日AM 02:00 JSTに自動更新されます。 本APIを用いると、自動更新を待たずに更新を要求できます。 ただし、タスク全件ファイル以外は更新されません。  タスク全件ファイルについては、[getProjectTasksUrl](#operation/getProjectTasksUrl) APIを参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[PostProjectTasksUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_project(
        self,
        project_id: str,
        query_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
        **kwargs,
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト作成/更新
        https://annofab.com/docs/api/#operation/putProject


        authorizations: OrganizationAdministrator, ProjectOwner


        プロジェクトを新規作成または更新します。  ### 新規作成する場合 ユーザーは、作成するプロジェクトをひもづける組織の [OrganizationAdministrator](#section/Authentication/OrganizationAdministrator) である必要があります。  ### 更新する場合 ユーザーは、更新するプロジェクトの [ProjectOwner](#section/Authentication/ProjectOwner) である必要があります。 また所属組織を変更する場合は、新しくひもづける組織の [OrganizationAdministrator](#section/Authentication/OrganizationAdministrator) である必要があります。  なお、プロジェクト状態を「停止中」にした場合、アノテーションZIPやタスク進捗状況などの集計情報は自動更新されなくなります。 所属組織が変更された場合バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`move-project`）。

        Args:
            project_id (str):  プロジェクトID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            query_params (Dict[str, Any]): Query Parameters
                v (str):  APIの戻り型のバージョンを指定します。 値と戻り型の対応は以下です。 - \"1\"：Project - \"2\"：PutProjectResponse
            request_body (Any): Request Body
                put_project_request (PutProjectRequest):

        Returns:
            Tuple[Project, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectMemberApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_project_member(self, project_id: str, user_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー取得
        https://annofab.com/docs/api/#operation/getProjectMember


        authorizations: AllProjectMember


        プロジェクトの特定のメンバーを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            user_id (str):  アカウントのユーザID. RESTクライアントユーザが指定しやすいように、Cognitoのaccount_idではなくuser_idとしている。 (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/projects/{project_id}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_members(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー一括取得
        https://annofab.com/docs/api/#operation/getProjectMembers


        authorizations: AllProjectMember


        備考: 組織に加入していないメンバーも取得できることがあります（[プロジェクト更新](#operation/putProject)でプロジェクトの組織移動をおこなった場合）。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                include_inactive_member (str):  脱退したプロジェクトメンバーも取得する時に、キーのみ指定します（値は無視されます）。

        Returns:
            Tuple[ProjectMemberList, requests.Response]


        """
        url_path = f"/projects/{project_id}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_project_member(
        self, project_id: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー追加/更新
        https://annofab.com/docs/api/#operation/putProjectMember


        authorizations: ProjectOwner


        プロジェクトにメンバーを新規に追加、または存在するメンバーの設定を変更します。  メンバーとなるユーザーは、作成するプロジェクトをひもづける組織に加入している必要があります。

        Args:
            project_id (str):  プロジェクトID (required)
            user_id (str):  アカウントのユーザID. RESTクライアントユーザが指定しやすいように、Cognitoのaccount_idではなくuser_idとしている。 (required)
            request_body (Any): Request Body
                project_member_request (ProjectMemberRequest):  (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/projects/{project_id}/members/{user_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfStatisticsApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_account_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ユーザー別タスク集計取得
        https://annofab.com/docs/api/#operation/getAccountDailyStatistics


        authorizations: AllProjectMember


        指定した期間の [ユーザー別タスク集計データ](#section/ArrayOfProjectAccountStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectAccountStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/accounts/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_account_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """ユーザー別タスク集計ファイルへのURL取得
        https://annofab.com/docs/api/#operation/getAccountStatistics

        .. deprecated:: X

        authorizations: AllProjectMember


        [ユーザー別タスク集計データ](#section/ArrayOfProjectAccountStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_account_statistics() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/statistics/accounts"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspection_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント集計取得
        https://annofab.com/docs/api/#operation/getInspectionDailyStatistics


        authorizations: AllProjectMember


        指定した期間の [検査コメント集計データ](#section/ArrayOfInspectionStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[InspectionStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/inspections/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspection_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """検査コメント集計ファイルへのURL取得
        https://annofab.com/docs/api/#operation/getInspectionStatistics

        .. deprecated:: X

        authorizations: AllProjectMember


        [検査コメント集計データ](#section/ArrayOfInspectionStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_inspection_statistics() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/statistics/inspections"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_label_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """ラベル別アノテーション数集計取得
        https://annofab.com/docs/api/#operation/getLabelStatistics


        authorizations: AllProjectMember


        [ラベル別アノテーション数集計データ](#section/ArrayOfLabelStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/labels"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_markers(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """統計グラフマーカー一括取得
        https://annofab.com/docs/api/#operation/getMarkers


        authorizations: AllProjectMember


        指定されたプロジェクトの統計グラフマーカーをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Markers, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/markers"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_phase_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """フェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getPhaseDailyStatistics


        authorizations: AllProjectMember


        指定した期間の [フェーズ別タスク集計データ](#section/ArrayOfTaskPhaseStatistics) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[TaskPhaseStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/task-phases/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_statistics_available_dates(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト統計記録期間取得
        https://annofab.com/docs/api/#operation/getStatisticsAvailableDates


        authorizations: AllProjectMember


        プロジェクトの統計情報が記録されている日付期間を取得します。  日付期間とは、from（日付）からto（日付）までの連続する日付を指します。fromとtoの日付は期間に含みます。  プロジェクトが一度も停止されていない場合、プロジェクト作成日から昨日までの日付期間が一つだけ返ります。  プロジェクトを停止した場合、プロジェクトの作成日から停止した日までの日付期間が一つだけ返ります。  プロジェクトを再開した場合、統計情報が記録されない（プロジェクトの停止）期間を除いた日付期間が複数返ります。以降、プロジェクトの停止と再開を繰り返すたびに結果の日付期間が増えていきます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[DateRange], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/dates"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク集計取得
        https://annofab.com/docs/api/#operation/getTaskDailyStatistics


        authorizations: AllProjectMember


        指定した期間の [タスク集計データ](#section/ArrayOfProjectTaskStatisticsHistory) を取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectTaskStatisticsHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/tasks/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_phase_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """フェーズ別タスク集計ファイルへのURL取得
        https://annofab.com/docs/api/#operation/getTaskPhaseStatistics

        .. deprecated:: X

        authorizations: AllProjectMember


        [フェーズ別タスク集計データ](#section/ArrayOfTaskPhaseStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_task_phase_statistics() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/statistics/task-phases"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク集計ファイルへのURL取得
        https://annofab.com/docs/api/#operation/getTaskStatistics

        .. deprecated:: X

        authorizations: AllProjectMember


        [タスク集計データ](#section/ArrayOfProjectTaskStatisticsHistory) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_task_statistics() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/statistics/tasks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト単位のフェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatistics


        authorizations: AllProjectMember


        指定したプロジェクトのタスク作業時間集計データを指定した期間分取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByProject, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics_by_account(
        self, project_id: str, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー単位のフェーズ別タスク集計取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatisticsByAccount


        authorizations: AllProjectMember


        指定したプロジェクトメンバーのタスク作業時間集計データを指定した期間分取得できるAPI。取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                _from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByAccount, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes-by-account/{account_id}/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク作業時間集計ファイルへのURL取得
        https://annofab.com/docs/api/#operation/getWorktimeStatistics

        .. deprecated:: X

        authorizations: AllProjectMember


        [タスク作業時間集計データ](#section/ArrayOfWorktimeStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_worktime_statistics() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/statistics/worktimes"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_markers(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """統計グラフマーカー更新
        https://annofab.com/docs/api/#operation/putMarkers


        authorizations: ProjectOwner


        指定されたプロジェクトの統計グラフマーカーを更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                put_markers_request (PutMarkersRequest):  (required)

        Returns:
            Tuple[Markers, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/markers"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfSupplementaryApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_supplementary_data(
        self, project_id: str, input_data_id: str, supplementary_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """補助情報削除
        https://annofab.com/docs/api/#operation/deleteSupplementaryData


        authorizations: ProjectOwner


        指定された補助情報を、実体ファイルとともに削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)
            supplementary_data_id (str):  補助情報ID（プロジェクトIDとの2つ組で一意となる値） (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data/{supplementary_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_supplementary_data_list(
        self, project_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """補助情報一括取得
        https://annofab.com/docs/api/#operation/getSupplementaryDataList


        authorizations: AllProjectMember


        指定された入力データにつけられた補助情報をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[List[SupplementaryData], requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_supplementary_data(
        self,
        project_id: str,
        input_data_id: str,
        supplementary_data_id: str,
        request_body: Optional[Any] = None,
        **kwargs,
    ) -> Tuple[Any, requests.Response]:
        """補助情報作成/更新
        https://annofab.com/docs/api/#operation/putSupplementaryData


        authorizations: ProjectOwner


        指定された入力データに補助情報を新規作成または更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)
            supplementary_data_id (str):  補助情報ID（プロジェクトIDとの2つ組で一意となる値） (required)
            request_body (Any): Request Body
                supplementary_data_request (SupplementaryDataRequest):  (required)

        Returns:
            Tuple[SupplementaryData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data/{supplementary_data_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfTaskApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def assign_tasks(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク割当
        https://annofab.com/docs/api/#operation/assignTasks


        authorizations: AllProjectMember


        メンバーもしくは自身にタスクを割当します。  個々のタスクの情報を取得する場合は、[タスク取得](#operation/getTask)を使います。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                task_assign_request (TaskAssignRequest):  (required)

        Returns:
            Tuple[List[Task], requests.Response]


        """
        url_path = f"/projects/{project_id}/assign-tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def batch_update_tasks(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク一括更新
        https://annofab.com/docs/api/#operation/batchUpdateTasks


        authorizations: ProjectOwner


        タスクを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、現在「削除」の1通りのみがあります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の削除ができます。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_task_request_item (List[BatchTaskRequestItem]):  (required)

        Returns:
            Tuple[List[Task], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_task(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク削除
        https://annofab.com/docs/api/#operation/deleteTask


        authorizations: ProjectOwner


        不要になったタスクや、間違って投入したタスクを削除します。教師データなどは削除せず残すので、あとから復元することも可能です。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク取得
        https://annofab.com/docs/api/#operation/getTask


        authorizations: AllProjectMember


        個々のタスクの情報を取得します。  タスクを割り当てる場合は、[タスク割当](#operation/startTask)を使います。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_histories(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク履歴一括取得
        https://annofab.com/docs/api/#operation/getTaskHistories


        authorizations: AllProjectMember


        指定されたタスクの作業履歴をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[List[TaskHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_tasks(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク検索
        https://annofab.com/docs/api/#operation/getTasks


        authorizations: AllProjectMember


        プロジェクトに含まれる複数のタスクをまとめて取得します。  検索条件を指定することで、特定のユーザが担当するタスクなどを絞り込むことができます。  パフォーマンスのため、結果はページング形式で返ります。全件取得したい場合は、レスポンスを見て、ページ移動してください。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数
                task_id (str):  タスクIDでの部分一致検索で使用。最大文字列長300文字。1文字以上あれば使用します。利便性のため、大文字小文字は区別しません
                input_data_ids (str):  指定された入力データIDを使用しているタスクを絞り込みます。カンマ区切りで複数の入力データIDを指定可能です。1文字以上あれば使用します。利便性のため、大文字小文字は区別しません
                phase (TaskPhase):  絞り込み条件となるフェーズ名。未指定時は全フェーズ
                phase_stage (int):  絞り込み条件となるステージ。未指定時は全ステージ
                status (TaskStatus):  絞り込み条件となる状態名。未指定時は全ステータス。
                account_id (str):  絞り込み条件となる作業中のアカウントID。未指定時は全アカウント
                no_user (str):  未割り当てのタスクを絞り込む時に、キーのみ指定します（値は無視されます）。
                previous_account_id (str):  そのタスクをこれまでに担当したことのあるユーザー（現在の担当者含む）のアカウントID。未指定時は全ユーザ
                previous_phase (TaskPhase):  そのタスクがこれまでに遷移したことのあるフェーズ名（現在のフェーズ含む）。未指定時は全フェーズ
                previous_phase_stage (int):  そのタスクがこれまでに遷移したことのあるステージ（現在のステージ含む）。未指定時は全ステージ
                rejected_only (str):  差し戻されたタスクだけを絞り込む時に、キーのみ指定します（値は無視されます）。
                auto_accepted_only (str):  「抜取検査の対象外となり、自動受入されたタスク」だけを絞り込む時に、キーのみ指定します（値は無視されます）。
                metadata (str):  メタデータからタスクを検索できます。<br> 例えば、 `priority` (数値) や `assignable` (真偽値) といったメタデータを個々のタスクに登録していたとします。 その場合、次のように検索できます。  ``` // priorityが5のタスクを検索 https://annofab.com/~/tasks?metadata=priority:5  // priorityが5以外のタスクを検索 https://annofab.com/~/tasks?metadata=-priority:5  // priorityが1より大きいタスクを検索 https://annofab.com/~/tasks?metadata=priority:>1  // priorityが1以上のタスクを検索 https://annofab.com/~/tasks?metadata=priority:>=1  // priorityが100未満のタスクを検索 https://annofab.com/~/tasks?metadata=priority:<100  // priorityが100以下のタスクを検索 https://annofab.com/~/tasks?metadata=priority:<=100  // priorityが1~100のタスクを検索 (複数の検索条件は半角スペースで区切ります) https://annofab.com/~/tasks?metadata=priority:>=1 priority:<=100  // priorityが1以上、且つ、assignableがtrueのタスクを検索 https://annofab.com/~/tasks?metadata=priority:>=1 assignable:true ```  次の検索構文は <span style=\"color: red\">deprecated</span> です。  ``` // priorityが5のタスクを検索 https://annofab.com/~/tasks?metadata.priority=5  // priorityが1以上のタスクを検索 https://annofab.com/~/tasks?metadata.priority>=1  // priorityが100以下のタスクを検索 https://annofab.com/~/tasks?metadata.priority<=100  // priorityが1~100のタスクを検索 https://annofab.com/~/tasks?metadata.priority>=1&metadata.priority<=100  // 教師付けフェーズ、且つ、priorityが5のタスクを検索 https://annofab.com/~/tasks?phase=annotation&metadata.priority=5 ```  (注意) これらの例は、説明の都合上「URLエンコード」を施していません。<br> 実際には、URLエンコードを施してください。
                sort (str):  ソート順の指定。  * 使用可能キーはtask_id、updated_datetime、number_of_rejections、phase、phase_stage、status、account_id, metadataのいずれかです。 * metadata指定時は、`metadata.{メタデータ名}` の形式で指定します。 * 降順指定時は先頭に-(ハイフン)を付与します。 * 複数指定時は,(カンマ)区切りで列挙します。複数キーを列挙した場合は、先頭から優先順位を割り振られます。
                annotation (str):  アノテーションの絞り込み条件をJSON形式([AnnotationQuery](#section/AnnotationQuery))で指定したもの。指定した条件に合致するアノテーションを持つタスクを絞り込む際に指定する。

        Returns:
            Tuple[TaskList, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_tasks_generation(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク一括作成
        https://annofab.com/docs/api/#operation/initiateTasksGeneration


        authorizations: ProjectOwner


        典型的なタスク作成ルールにもとづいた、一括作成を行うAPIです。  タスク作成ルールは、リクエストペイロードの `task_generate_rule` フィールドで指定できます。<br> `ByCount` を指定した場合、1つのタスクに割りあてる入力データの個数を指定してタスクを生成します。この作成ルールは、画像を同じ枚数均等にタスクに割り振りたい場合に便利です。<br> `ByDirectory` を指定した場合、入力データ名をファイルパスに見立て、ディレクトリ単位でタスクを生成します。この作成ルールは、動画などから切り出した画像をディレクトリ別に格納し、、その動画（ディレクトリ）の単位でタスクを作りたい場合に便利です。 `ByInputDataCsv` を指定した場合、入力データを各タスクに割り振ったCSVへのS3パスを指定してタスクを生成できます。この作成ルールは特定のデータの組み合わせを持ったタスクを作成したい場合に便利です。<br>  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-tasks`）。  #### ByDirectory: ディレクトリ単位でのタスク一括生成の使い方 例えば、次のような `input_data_name_` の入力データが登録されているとします。  * a.zip/dir1/image1.png * a.zip/dir1/image2.png * a.zip/dir1/subdir/image3.png * a.zip/dir1/subdir/image4.png * a.zip/dir1/subdir/image5.png * b.zip/dir2/subdir1/image6.png * b.zip/dir2/subdir1/image7.png * b.zip/dir2/subdir1/image8.png * b.zip/dir2/subdir2/image9.png * b.zip/dir2/subdir2/image10.png  ここで、`input_data_name_prefix`フィールド に `a.zip` を指定すると、次の2タスクが生成されます。  1. タスク: `{task_id_prefix}_a.zip_dir1`   * a.zip/dir1/image1.png   * a.zip/dir1/image2.png 2. タスク: `{task_id_prefix}_a.zip_dir1_subdir`   * a.zip/dir1/subdir/image3.png   * a.zip/dir1/subdir/image4.png   * a.zip/dir1/subdir/image5.png  次に、`input_data_name_prefix` に `b.zip/dir2` を指定すると、次の2タスクが生成されます。  1. タスク: `{task_id_prefix}_b.zip_dir2_subdir1`   * b.zip/dir2/subdir1/image6.png   * b.zip/dir2/subdir1/image7.png   * b.zip/dir2/subdir1/image8.png 2. タスク: `{task_id_prefix}_b.zip_dir2_subdir2`   * b.zip/dir2/subdir2/image9.png   * b.zip/dir2/subdir2/image10.png  `input_data_name_prefix` が未指定の時は、全ディレクトリごとにタスクが作成されます。つまり次のように4つのタスクが生成されます。  1. タスク: `{task_id_prefix}_a.zip_dir1`   * a.zip/dir1/image1.png   * a.zip/dir1/image2.png 2. タスク: `{task_id_prefix}_a.zip_dir1_subdir`   * a.zip/dir1/subdir/image3.png   * a.zip/dir1/subdir/image4.png   * a.zip/dir1/subdir/image5.png 3. タスク: `{task_id_prefix}_b.zip_dir2_subdir1`   * b.zip/dir2/subdir1/image6.png   * b.zip/dir2/subdir1/image7.png   * b.zip/dir2/subdir1/image8.png 4. タスク: `{task_id_prefix}_b.zip_dir2_subdir2`   * b.zip/dir2/subdir2/image9.png   * b.zip/dir2/subdir2/image10.png  画像プロジェクトの場合、タスクに割り当てられる「ディレクトリ内の入力データ」の順序は、名前の昇順となります。<br> 動画プロジェクトの場合、タスクに割り当てられる「ディレクトリ内の入力データ」の順序は、動画の入力データが先頭に来るようにソートされたうえで、名前の昇順となります。  **注意:** `ByDirectory`では、入力データ名がファイルパス形式になっていない入力データはタスクの作成対象になりません。 例えば、`foo/bar.png` はタスクの作成対象になりますが、ディレクトリを含まない`bar.png` や、最後がディレクトリになっている`foo/bar.png/` は対象になりません。  **注意:** 動画プロジェクトの場合、ディレクトリに含まれる動画の入力データは一つに制限してください。 これが守られない場合、作成されたタスクで動画を再生できない場合があります。  #### ByInputDataCsv: CSVによるタスク一括生成の使い方 以下のように「タスクID,入力データ名,入力データID」を1行毎に指定したCSVを作成します。  ``` task_1,a001.jpg,ca0cb2f9-fec5-49b4-98df-dc34490f9785 task_1,a002.jpg,5ac1987e-ca7c-42a0-9c19-b5b23a41836b task_1,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee task_2,b001.jpg,4f2ae4d0-7a38-4f9a-be6f-170ba76aba73 task_2,b002.jpg,45ac5852-f20c-4938-9ee9-cc0274401df7 task_2,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee task_3,c001.jpg,3260c7a0-4820-424d-a26e-db7e91dbc139 task_3,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee ``` CSVのエンコーディングは UTF-8(BOM付き)、UTF-8(BOMなし)、UTF-16(BOM付きLE) のいずれかのみ対応しています。  **注意:** 動画プロジェクトの場合、一つのタスクに含まれる動画の入力データは一つに制限し、動画の入力データの位置は先頭にしてください。 これが守られない場合、作成されたタスクで動画を再生できない場合があります。  [createTempPath](#operation/createTempPath) APIを使ってアップロード用のURLとS3パスを取得してCSVをアップロードした上で`csv_data_path` フィールドに取得したS3パスを記述します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                task_generate_request (TaskGenerateRequest):  (required)

        Returns:
            Tuple[TaskGenerateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/generate-tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def operate_task(
        self, project_id: str, task_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク状態変更
        https://annofab.com/docs/api/#operation/operateTask


        authorizations: AllProjectMember


        タスクの状態、もしくはタスクの担当者を変更することができます。  #### ユースケースごとの使い方  * タスクを作業中(working)にしたい場合   * 制約     * 現在タスクを担当しているユーザーのみ、この操作を行うことができます。     * 現在の状態が未着手(not_started)、休憩中(break)、保留(on_hold)のいずれかであるタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"working\", account_id: \"自身(現在のタスク担当者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクを休憩中にしたい場合   * 制約     * 現在タスクを担当しているユーザーのみ、この操作を行うことができます。     * 現在の状態が作業中(working)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"break\", account_id: \"自身(現在のタスク担当者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクを保留(on_hold)にしたい場合   * 制約     * 現在タスクを担当しているユーザーのみ、この操作を行うことができます。     * 現在の状態が作業中(working)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"on_hold\", account_id: \"自身(現在のタスク担当者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクを提出(complete)したい場合   * 制約     * 現在タスクを担当しているユーザーのみ、この操作を行うことができます。     * 現在の状態が作業中(working)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"complete\", account_id: \"自身(現在のタスク担当者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクの提出を取消し(cancelled)したい場合   * 制約     * タスクを提出したユーザーのみ、この操作を行うことができます。     * タスク提出後に検査/受入(抜取含む)等の作業が一切行われていない場合のみ、この操作を行うことができます。     * 現在の状態が未着手(not_started)のタスクに対してのみ、この操作を行うことができます。     * 現在のフェーズが検査(inspection)、もしくは受入(acceptance)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"cancelled\", account_id: \"自身(タスク提出者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクを差戻し(rejected)したい場合   * 制約     * 現在タスクを担当しているユーザーのみ、この操作を行うことができます。     * 現在の状態が作業中(working)のタスクに対してのみ、この操作を行うことができます。     * 現在のフェーズが検査(inspection)、もしくは受入(acceptance)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"rejected\", account_id: \"自身(現在のタスク担当者)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}```   * タスクを強制差戻し(force rejected)したい場合     * 強制差戻しについて       * タスクの状態・フェーズを無視して、フェーズを教師付け(annotation)に、状態を未作業(not started)に変更します。       * タスクの担当者としては、直前の教師付け(annotation)フェーズの担当者を割り当てます。       * この差戻しは差戻しとして扱われず、抜取検査・抜取受入のスキップ判定に影響を及ぼしません。     * 制約       * プロジェクトオーナー(owner)のみ、この操作を行うことができます。       * 現在のタスクの状態、フェーズを問わず、この操作を行うことができます。     * リクエストボディのJSONサンプル       * ```{ status: \"rejected\", account_id: \"自身(プロジェクトオーナー)のアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\", force: true }``` * タスクの受入完了を取り消したい場合   * 制約     * プロジェクトオーナー(owner)のみ、この操作を行うことができます。     * 現在の状態が完了(completed)のタスクに対してのみ、この操作を行うことができます。     * 現在のフェーズが受入(acceptance)のタスクに対してのみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"not_started\", account_id: \"再度受入を担当させたいアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクの担当者を変更したい場合   * 制約     * プロジェクトオーナー(owner)、もしくは受入担当者(accepter)のみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"not_started\", account_id: \"現在のフェーズを担当できるアカウントID\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}``` * タスクの担当者を未割当てにしたい場合   * 制約     * プロジェクトオーナー(owner)、もしくは受入担当者(accepter)のみ、この操作を行うことができます。   * リクエストボディのJSONサンプル     * ```{ status: \"not_started\", last_updated_datetime: \"2018-08-14T19:01:51.775+09:00\"}```

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            request_body (Any): Request Body
                task_operation (TaskOperation):  (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/operate"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def patch_tasks_metadata(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスクメタデータの一括更新
        https://annofab.com/docs/api/#operation/patchTasksMetadata


        authorizations: ProjectDataUser


        複数の既存タスクのメタデータを一括更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                body (__DictStrKeyAnyValue__):  タスクIDとメタデータのkey-valueペア(Dictionary)を指定してください。<br> メタデータは、メタデータ名と値のkey-valueペア(Dictionary)です。  keyに指定できる文字種は次の通りです。  * 半角英数字 * `_` (アンダースコア) * `-` (ハイフン)  valueに指定できる値は次の通りです。  * 文字列 * 数値 * 真偽値  ``` (例)  {   \"task_1\": { \"metadata_1\": \"str\", \"metadata_2\": 100 },   \"task_2\": { \"metadata_3\": true } } ```  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/metadata"
        http_method = "PATCH"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_task(
        self, project_id: str, task_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク作成/更新
        https://annofab.com/docs/api/#operation/putTask


        authorizations: ProjectOwner


        1つのタスクを作成または更新します。 複数のタスクを一括生成する場合は、効率のよい[一括作成API](#operation/initiateTasksGeneration)を検討してください。  このAPIで変更できるのは、タスクの入力データ（`input_data_list`）のみです。タスクに割り当てた画像や動画などの入力データを差し替えることができます。  タスクの担当者やステータスを変更するには、[タスク割当](#operation/startTask)や[タスクの状態遷移](#operation/operateTask)を使用します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                task_request (TaskRequest):  (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfWebhookApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_webhook(self, project_id: str, webhook_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト Webhook 削除
        https://annofab.com/docs/api/#operation/deleteWebhook


        authorizations: ProjectOwner


        指定された Webhook を削除

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID (required)

        Returns:
            Tuple[Webhook, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_webhooks(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト Webhook 一括取得
        https://annofab.com/docs/api/#operation/getWebhooks


        authorizations: ProjectOwner


        指定されたプロジェクトの Webhook をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[Webhook], requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_webhook(
        self, project_id: str, webhook_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト Webhook 作成/更新
        https://annofab.com/docs/api/#operation/putWebhook


        authorizations: ProjectOwner


        プロジェクトのWebhookを新規作成/更新します。  Webhook で送信される body には、event_type によって以下のプレースホルダーを使用できます。  * task-completed   * {{PROJECT_ID}} :  プロジェクトID   * {{TASK_ID}} : タスクID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00   * {{LAST_ACCOUNT}} : 最終作業者     * 形式 : アカウントID  * annotation-archive-updated   * {{PROJECT_ID}} :  プロジェクトID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00  * input-data-zip-registered   * {{PROJECT_ID}} :  プロジェクトID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00   * {{ZIP_NAME}} : ZIPファイル名     * 例 : input_data.zip  * project-copy-completed   * {{PROJECT_ID}} :  プロジェクトID   * {{DEST_PROJECT_ID}} :  コピー先プロジェクトID   * {{DEST_PROJECT_TITLE}} : コピー先プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00  Webhookが起動されると、ジョブ種別が`invoke-hook`のバックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます。

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                webhook (Webhook):  (required)

        Returns:
            Tuple[Webhook, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def test_webhook(
        self, project_id: str, webhook_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト Webhook テスト実行
        https://annofab.com/docs/api/#operation/testWebhook


        authorizations: ProjectOwner


        得録された登録された URL にテスト用の Webhook を実際に送信します。  送信される Webhook の body に含まれるプレースホルダーは、本 API リクエストで指定されたダミーのプレースホルダーで置き換えられます。

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID (required)
            request_body (Any): Request Body
                webhook_test_request (WebhookTestRequest):  (required)

        Returns:
            Tuple[WebhookTestResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}/test"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        return self._request_wrapper(http_method, url_path, **keyword_params)
