/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager {
    private HashMap<String, Connection> _connections = new HashMap();
    private static ConnectionManager _instance = null;
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class.getName());

    public static ConnectionManager getInstance() {
        if (_instance == null) {
            _instance = new ConnectionManager();
        }
        return _instance;
    }

    private ConnectionManager() {
    }

    public Connection getConnection(LinkedHashMap<String, Object> connectionParams, boolean forceNewConnection) throws IOException {
        String key = ConnectionManager.generateKey(connectionParams);
        if (this._connections.containsKey(key) && !forceNewConnection) {
            LOGGER.info("Connection already existing for key: " + key + " . Using it...");
            return this._connections.get(key);
        }
        if (forceNewConnection) {
            LOGGER.info("Forcing the creation of a new connection");
        } else {
            LOGGER.info("Connection not existing. Creating new connection");
        }
        Connection jmxConnection = new Connection(connectionParams);
        this._connections.put(key, jmxConnection);
        return jmxConnection;
    }

    private static String generateKey(LinkedHashMap<String, Object> connectionParams) {
        return connectionParams.get("host") + ":" + connectionParams.get("port") + ":" + connectionParams.get("user");
    }
}

