# cavoke-openapi-client
API for cavoke interaction between main server and clients

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cavoke_openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cavoke_openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import cavoke_openapi_client
from pprint import pprint
from cavoke_openapi_client.api import default_api
from cavoke_openapi_client.model.error import Error
from cavoke_openapi_client.model.game_info import GameInfo
from cavoke_openapi_client.model.game_move import GameMove
from cavoke_openapi_client.model.game_state import GameState
from cavoke_openapi_client.model.game_statistics import GameStatistics
from cavoke_openapi_client.model.room_info import RoomInfo
from cavoke_openapi_client.model.session_info import SessionInfo
from cavoke_openapi_client.model.user import User
from cavoke_openapi_client.model.user_game_statistics import UserGameStatistics
from cavoke_openapi_client.model.user_statistics import UserStatistics
from cavoke_openapi_client.model.validation_result import ValidationResult
# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = cavoke_openapi_client.Configuration(
    host = "http://localhost:8080"
)



# Enter a context with an instance of the API client
with cavoke_openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    session_id = "session_id_example" # str | UUID of a game session (room to game pair)
    new_role = 0 # int | New role to join

    try:
        # Change user's role in session
        api_instance.change_role(session_id, new_role)
    except cavoke_openapi_client.ApiException as e:
        print("Exception when calling DefaultApi->change_role: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**change_role**](docs/DefaultApi.md#change_role) | **POST** /sessions/{session_id}/change_role | Change user&#39;s role in session
*DefaultApi* | [**config_game**](docs/DefaultApi.md#config_game) | **GET** /games/{game_id}/get_config | Get GameInfo of specific game
*DefaultApi* | [**create_session**](docs/DefaultApi.md#create_session) | **POST** /sessions/create | Create a session (room to game pair) from requested cavoke game
*DefaultApi* | [**download_client**](docs/DefaultApi.md#download_client) | **GET** /games/{game_id}/get_client | Download QML client zip of a game
*DefaultApi* | [**game_statistics**](docs/DefaultApi.md#game_statistics) | **GET** /statistics/game/{game_id} | Game statistics
*DefaultApi* | [**get_update**](docs/DefaultApi.md#get_update) | **GET** /play/{session_id}/get_state | Get state for user from QML game
*DefaultApi* | [**health**](docs/DefaultApi.md#health) | **GET** /health | Simple health check
*DefaultApi* | [**join_session**](docs/DefaultApi.md#join_session) | **POST** /sessions/{session_id}/join | Join a session
*DefaultApi* | [**leave_session**](docs/DefaultApi.md#leave_session) | **POST** /sessions/{session_id}/leave | Leave the session
*DefaultApi* | [**list_games**](docs/DefaultApi.md#list_games) | **GET** /games/list | List available games to play
*DefaultApi* | [**profile_change_name_post**](docs/DefaultApi.md#profile_change_name_post) | **POST** /profile/change_name | Changes name for the current user
*DefaultApi* | [**profile_get_me_get**](docs/DefaultApi.md#profile_get_me_get) | **GET** /profile/get_me | Gets information about current user
*DefaultApi* | [**room_create**](docs/DefaultApi.md#room_create) | **POST** /rooms/create | Creates a new room
*DefaultApi* | [**room_info**](docs/DefaultApi.md#room_info) | **GET** /rooms/{room_id}/get_info | Room information
*DefaultApi* | [**room_info_by_code**](docs/DefaultApi.md#room_info_by_code) | **GET** /rooms/get_info_by_invite_code | Room information by invite code
*DefaultApi* | [**room_join**](docs/DefaultApi.md#room_join) | **POST** /rooms/join | Join the room by invite code
*DefaultApi* | [**room_leave**](docs/DefaultApi.md#room_leave) | **POST** /rooms/{room_id}/leave | Leave the room
*DefaultApi* | [**room_new_session**](docs/DefaultApi.md#room_new_session) | **POST** /rooms/{room_id}/create_session | Create a new session inside the room
*DefaultApi* | [**send_move**](docs/DefaultApi.md#send_move) | **POST** /play/{session_id}/send_move | Send a move from QML game
*DefaultApi* | [**session_info**](docs/DefaultApi.md#session_info) | **GET** /sessions/{session_id}/get_info | Session information
*DefaultApi* | [**start_session**](docs/DefaultApi.md#start_session) | **POST** /sessions/{session_id}/start | Start the game
*DefaultApi* | [**submit_game**](docs/DefaultApi.md#submit_game) | **POST** /submit_game | Send a game for review to the cavokedev
*DefaultApi* | [**user_auth_statistics**](docs/DefaultApi.md#user_auth_statistics) | **GET** /profile/my_user_statistics | User statistics for currently logged in user (via auth)
*DefaultApi* | [**user_game_auth_statistics**](docs/DefaultApi.md#user_game_auth_statistics) | **GET** /profile/my_user_game_statistics/{game_id} | UserGame statistics for currently logged in user (via auth)
*DefaultApi* | [**user_game_statistics**](docs/DefaultApi.md#user_game_statistics) | **GET** /statistics/user/{user_id}/game/{game_id} | UserGame statistics
*DefaultApi* | [**user_statistics**](docs/DefaultApi.md#user_statistics) | **GET** /statistics/user/{user_id} | User statistics
*DefaultApi* | [**users_get_user_get**](docs/DefaultApi.md#users_get_user_get) | **GET** /users/get_user | Gets information about given user by user_id
*DefaultApi* | [**validate_session**](docs/DefaultApi.md#validate_session) | **POST** /sessions/{session_id}/validate | Check if the host can launch the game with current config


## Documentation For Models

 - [Error](docs/Error.md)
 - [GameInfo](docs/GameInfo.md)
 - [GameMove](docs/GameMove.md)
 - [GameState](docs/GameState.md)
 - [GameStatistics](docs/GameStatistics.md)
 - [InviteCode](docs/InviteCode.md)
 - [OccupiedPositions](docs/OccupiedPositions.md)
 - [Player](docs/Player.md)
 - [RoomInfo](docs/RoomInfo.md)
 - [SessionCreationRequest](docs/SessionCreationRequest.md)
 - [SessionInfo](docs/SessionInfo.md)
 - [User](docs/User.md)
 - [UserGameStatistics](docs/UserGameStatistics.md)
 - [UserStatistics](docs/UserStatistics.md)
 - [ValidationResult](docs/ValidationResult.md)


## Documentation For Authorization


## cavoke_oauth_auth0

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://cavoke.eu.auth0.com/authorize
- **Scopes**: 
 - **identity**: identify as current user
 - **sessions**: perform operations with sessions
 - **profile**: read/write information about current user
 - **users**: read public information about other users


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in cavoke_openapi_client.apis and cavoke_openapi_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from cavoke_openapi_client.api.default_api import DefaultApi`
- `from cavoke_openapi_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import cavoke_openapi_client
from cavoke_openapi_client.apis import *
from cavoke_openapi_client.models import *
```

