"""
    Keycloak Admin REST API

    This is a REST API reference for the Keycloak Admin  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from keycloak_api.api_client import ApiClient, Endpoint as _Endpoint
from keycloak_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from keycloak_api.model.credential_representation import CredentialRepresentation
from keycloak_api.model.federated_identity_representation import FederatedIdentityRepresentation
from keycloak_api.model.user_representation import UserRepresentation


class UsersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.realm_users_count_get_endpoint = _Endpoint(
            settings={
                'response_type': (int,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/count',
                'operation_id': 'realm_users_count_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'email',
                    'email_verified',
                    'first_name',
                    'last_name',
                    'search',
                    'username',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'email':
                        (str,),
                    'email_verified':
                        (bool,),
                    'first_name':
                        (str,),
                    'last_name':
                        (str,),
                    'search':
                        (str,),
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'email': 'email',
                    'email_verified': 'emailVerified',
                    'first_name': 'firstName',
                    'last_name': 'lastName',
                    'search': 'search',
                    'username': 'username',
                },
                'location_map': {
                    'realm': 'path',
                    'email': 'query',
                    'email_verified': 'query',
                    'first_name': 'query',
                    'last_name': 'query',
                    'search': 'query',
                    'username': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users',
                'operation_id': 'realm_users_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'brief_representation',
                    'email',
                    'email_verified',
                    'enabled',
                    'exact',
                    'first',
                    'first_name',
                    'idp_alias',
                    'idp_user_id',
                    'last_name',
                    'max',
                    'q',
                    'search',
                    'username',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'brief_representation':
                        (bool,),
                    'email':
                        (str,),
                    'email_verified':
                        (bool,),
                    'enabled':
                        (bool,),
                    'exact':
                        (bool,),
                    'first':
                        (int,),
                    'first_name':
                        (str,),
                    'idp_alias':
                        (str,),
                    'idp_user_id':
                        (str,),
                    'last_name':
                        (str,),
                    'max':
                        (int,),
                    'q':
                        (str,),
                    'search':
                        (str,),
                    'username':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'brief_representation': 'briefRepresentation',
                    'email': 'email',
                    'email_verified': 'emailVerified',
                    'enabled': 'enabled',
                    'exact': 'exact',
                    'first': 'first',
                    'first_name': 'firstName',
                    'idp_alias': 'idpAlias',
                    'idp_user_id': 'idpUserId',
                    'last_name': 'lastName',
                    'max': 'max',
                    'q': 'q',
                    'search': 'search',
                    'username': 'username',
                },
                'location_map': {
                    'realm': 'path',
                    'brief_representation': 'query',
                    'email': 'query',
                    'email_verified': 'query',
                    'enabled': 'query',
                    'exact': 'query',
                    'first': 'query',
                    'first_name': 'query',
                    'idp_alias': 'query',
                    'idp_user_id': 'query',
                    'last_name': 'query',
                    'max': 'query',
                    'q': 'query',
                    'search': 'query',
                    'username': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_configured_user_storage_credential_types_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/configured-user-storage-credential-types',
                'operation_id': 'realm_users_id_configured_user_storage_credential_types_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_consents_client_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/consents/{client}',
                'operation_id': 'realm_users_id_consents_client_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'client',
                ],
                'required': [
                    'realm',
                    'id',
                    'client',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'client':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'client': 'client',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'client': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_consents_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/consents',
                'operation_id': 'realm_users_id_consents_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_credentials_credential_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/credentials/{credentialId}',
                'operation_id': 'realm_users_id_credentials_credential_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'credential_id',
                ],
                'required': [
                    'realm',
                    'id',
                    'credential_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'credential_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'credential_id': 'credentialId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'credential_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/credentials/{credentialId}/moveAfter/{newPreviousCredentialId}',
                'operation_id': 'realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'credential_id',
                    'new_previous_credential_id',
                ],
                'required': [
                    'realm',
                    'id',
                    'credential_id',
                    'new_previous_credential_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'credential_id':
                        (str,),
                    'new_previous_credential_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'credential_id': 'credentialId',
                    'new_previous_credential_id': 'newPreviousCredentialId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'credential_id': 'path',
                    'new_previous_credential_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_credentials_credential_id_move_to_first_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/credentials/{credentialId}/moveToFirst',
                'operation_id': 'realm_users_id_credentials_credential_id_move_to_first_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'credential_id',
                ],
                'required': [
                    'realm',
                    'id',
                    'credential_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'credential_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'credential_id': 'credentialId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'credential_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_credentials_credential_id_user_label_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/credentials/{credentialId}/userLabel',
                'operation_id': 'realm_users_id_credentials_credential_id_user_label_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'credential_id',
                    'body',
                ],
                'required': [
                    'realm',
                    'id',
                    'credential_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'credential_id':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'credential_id': 'credentialId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'credential_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'text/plain'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_credentials_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/credentials',
                'operation_id': 'realm_users_id_credentials_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}',
                'operation_id': 'realm_users_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_disable_credential_types_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/disable-credential-types',
                'operation_id': 'realm_users_id_disable_credential_types_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'request_body',
                ],
                'required': [
                    'realm',
                    'id',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'request_body':
                        ([str],),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_execute_actions_email_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/execute-actions-email',
                'operation_id': 'realm_users_id_execute_actions_email_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'request_body',
                    'client_id',
                    'lifespan',
                    'redirect_uri',
                ],
                'required': [
                    'realm',
                    'id',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'request_body':
                        ([str],),
                    'client_id':
                        (str,),
                    'lifespan':
                        (int,),
                    'redirect_uri':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'client_id': 'client_id',
                    'lifespan': 'lifespan',
                    'redirect_uri': 'redirect_uri',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'request_body': 'body',
                    'client_id': 'query',
                    'lifespan': 'query',
                    'redirect_uri': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_federated_identity_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/federated-identity',
                'operation_id': 'realm_users_id_federated_identity_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_federated_identity_provider_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/federated-identity/{provider}',
                'operation_id': 'realm_users_id_federated_identity_provider_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'provider',
                ],
                'required': [
                    'realm',
                    'id',
                    'provider',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'provider':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'provider': 'provider',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'provider': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_federated_identity_provider_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/federated-identity/{provider}',
                'operation_id': 'realm_users_id_federated_identity_provider_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'provider',
                    'federated_identity_representation',
                ],
                'required': [
                    'realm',
                    'id',
                    'provider',
                    'federated_identity_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'provider':
                        (str,),
                    'federated_identity_representation':
                        (FederatedIdentityRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'provider': 'provider',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'provider': 'path',
                    'federated_identity_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (UserRepresentation,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}',
                'operation_id': 'realm_users_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_groups_count_get_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/groups/count',
                'operation_id': 'realm_users_id_groups_count_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'search',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'search':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'search': 'search',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'search': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_groups_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/groups',
                'operation_id': 'realm_users_id_groups_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'brief_representation',
                    'first',
                    'max',
                    'search',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'brief_representation':
                        (bool,),
                    'first':
                        (int,),
                    'max':
                        (int,),
                    'search':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'brief_representation': 'briefRepresentation',
                    'first': 'first',
                    'max': 'max',
                    'search': 'search',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'brief_representation': 'query',
                    'first': 'query',
                    'max': 'query',
                    'search': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_groups_group_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/groups/{groupId}',
                'operation_id': 'realm_users_id_groups_group_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'group_id',
                ],
                'required': [
                    'realm',
                    'id',
                    'group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'group_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_groups_group_id_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/groups/{groupId}',
                'operation_id': 'realm_users_id_groups_group_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'group_id',
                ],
                'required': [
                    'realm',
                    'id',
                    'group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'group_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'group_id': 'groupId',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_impersonation_post_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/impersonation',
                'operation_id': 'realm_users_id_impersonation_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_logout_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/logout',
                'operation_id': 'realm_users_id_logout_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_offline_sessions_client_uuid_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/offline-sessions/{clientUuid}',
                'operation_id': 'realm_users_id_offline_sessions_client_uuid_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'client_uuid',
                ],
                'required': [
                    'realm',
                    'id',
                    'client_uuid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'client_uuid':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'client_uuid': 'clientUuid',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'client_uuid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}',
                'operation_id': 'realm_users_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'user_representation',
                ],
                'required': [
                    'realm',
                    'id',
                    'user_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'user_representation':
                        (UserRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'user_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_reset_password_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/reset-password',
                'operation_id': 'realm_users_id_reset_password_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'credential_representation',
                ],
                'required': [
                    'realm',
                    'id',
                    'credential_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'credential_representation':
                        (CredentialRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'credential_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_id_send_verify_email_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/send-verify-email',
                'operation_id': 'realm_users_id_send_verify_email_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'client_id',
                    'redirect_uri',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'client_id':
                        (str,),
                    'redirect_uri':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                    'client_id': 'client_id',
                    'redirect_uri': 'redirect_uri',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'client_id': 'query',
                    'redirect_uri': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_id_sessions_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/{id}/sessions',
                'operation_id': 'realm_users_id_sessions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users',
                'operation_id': 'realm_users_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'user_representation',
                ],
                'required': [
                    'realm',
                    'user_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'user_representation':
                        (UserRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                    'user_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_users_profile_get_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/profile',
                'operation_id': 'realm_users_profile_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_users_profile_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/users/profile',
                'operation_id': 'realm_users_profile_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'body',
                ],
                'required': [
                    'realm',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'body':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def realm_users_count_get(
        self,
        realm,
        **kwargs
    ):
        """Returns the number of users that match the given criteria.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_count_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            email (str): email filter. [optional]
            email_verified (bool): [optional]
            first_name (str): first name filter. [optional]
            last_name (str): last name filter. [optional]
            search (str): arbitrary search string for all the fields below. [optional]
            username (str): username filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            int
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_users_count_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_get(
        self,
        realm,
        **kwargs
    ):
        """Get users   Returns a stream of users, filtered according to query parameters.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            brief_representation (bool): Boolean which defines whether brief representations are returned (default: false). [optional]
            email (str): A String contained in email, or the complete email, if param \"exact\" is true. [optional]
            email_verified (bool): whether the email has been verified. [optional]
            enabled (bool): Boolean representing if user is enabled or not. [optional]
            exact (bool): Boolean which defines whether the params \"last\", \"first\", \"email\" and \"username\" must match exactly. [optional]
            first (int): Pagination offset. [optional]
            first_name (str): A String contained in firstName, or the complete firstName, if param \"exact\" is true. [optional]
            idp_alias (str): The alias of an Identity Provider linked to the user. [optional]
            idp_user_id (str): The userId at an Identity Provider linked to the user. [optional]
            last_name (str): A String contained in lastName, or the complete lastName, if param \"exact\" is true. [optional]
            max (int): Maximum results size (defaults to 100). [optional]
            q (str): A query to search for custom attributes, in the format 'key1:value2 key2:value2'. [optional]
            search (str): A String contained in username, first or last name, or email. [optional]
            username (str): A String contained in username, or the complete username, if param \"exact\" is true. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_users_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_configured_user_storage_credential_types_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Return credential types, which are provided by the user storage where user is stored.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_configured_user_storage_credential_types_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_configured_user_storage_credential_types_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_consents_client_delete(
        self,
        realm,
        id,
        client,
        **kwargs
    ):
        """Revoke consent and offline tokens for particular client from user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_consents_client_delete(realm, id, client, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            client (str): Client id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['client'] = \
            client
        return self.realm_users_id_consents_client_delete_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_consents_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get consents granted by the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_consents_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_consents_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_credentials_credential_id_delete(
        self,
        realm,
        id,
        credential_id,
        **kwargs
    ):
        """Remove a credential for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_credentials_credential_id_delete(realm, id, credential_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            credential_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['credential_id'] = \
            credential_id
        return self.realm_users_id_credentials_credential_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post(
        self,
        realm,
        id,
        credential_id,
        new_previous_credential_id,
        **kwargs
    ):
        """Move a credential to a position behind another credential  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post(realm, id, credential_id, new_previous_credential_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            credential_id (str): The credential to move
            new_previous_credential_id (str): The credential that will be the previous element in the list. If set to null, the moved credential will be the first element in the list.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['credential_id'] = \
            credential_id
        kwargs['new_previous_credential_id'] = \
            new_previous_credential_id
        return self.realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_credentials_credential_id_move_to_first_post(
        self,
        realm,
        id,
        credential_id,
        **kwargs
    ):
        """Move a credential to a first position in the credentials list of the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_credentials_credential_id_move_to_first_post(realm, id, credential_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            credential_id (str): The credential to move

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['credential_id'] = \
            credential_id
        return self.realm_users_id_credentials_credential_id_move_to_first_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_credentials_credential_id_user_label_put(
        self,
        realm,
        id,
        credential_id,
        body,
        **kwargs
    ):
        """Update a credential label for a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_credentials_credential_id_user_label_put(realm, id, credential_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            credential_id (str):
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['credential_id'] = \
            credential_id
        kwargs['body'] = \
            body
        return self.realm_users_id_credentials_credential_id_user_label_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_credentials_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """realm_users_id_credentials_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_credentials_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_credentials_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_delete(
        self,
        realm,
        id,
        **kwargs
    ):
        """Delete the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_delete(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_disable_credential_types_put(
        self,
        realm,
        id,
        request_body,
        **kwargs
    ):
        """Disable all credentials for a user of a specific type  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_disable_credential_types_put(realm, id, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            request_body ([str]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['request_body'] = \
            request_body
        return self.realm_users_id_disable_credential_types_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_execute_actions_email_put(
        self,
        realm,
        id,
        request_body,
        **kwargs
    ):
        """Send a update account email to the user   An email contains a link the user can click to perform a set of required actions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_execute_actions_email_put(realm, id, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            request_body ([str]): required actions the user needs to complete

        Keyword Args:
            client_id (str): Client id. [optional]
            lifespan (int): Number of seconds after which the generated token expires. [optional]
            redirect_uri (str): Redirect uri. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['request_body'] = \
            request_body
        return self.realm_users_id_execute_actions_email_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_federated_identity_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get social logins associated with the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_federated_identity_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_federated_identity_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_federated_identity_provider_delete(
        self,
        realm,
        id,
        provider,
        **kwargs
    ):
        """Remove a social login provider from user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_federated_identity_provider_delete(realm, id, provider, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            provider (str): Social login provider id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['provider'] = \
            provider
        return self.realm_users_id_federated_identity_provider_delete_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_federated_identity_provider_post(
        self,
        realm,
        id,
        provider,
        federated_identity_representation,
        **kwargs
    ):
        """Add a social login provider to the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_federated_identity_provider_post(realm, id, provider, federated_identity_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            provider (str): Social login provider id
            federated_identity_representation (FederatedIdentityRepresentation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['provider'] = \
            provider
        kwargs['federated_identity_representation'] = \
            federated_identity_representation
        return self.realm_users_id_federated_identity_provider_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get representation of the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UserRepresentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_groups_count_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """realm_users_id_groups_count_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_groups_count_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            search (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_groups_count_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_groups_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """realm_users_id_groups_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_groups_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            brief_representation (bool): [optional]
            first (int): [optional]
            max (int): [optional]
            search (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_groups_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_groups_group_id_delete(
        self,
        realm,
        id,
        group_id,
        **kwargs
    ):
        """realm_users_id_groups_group_id_delete  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_groups_group_id_delete(realm, id, group_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            group_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['group_id'] = \
            group_id
        return self.realm_users_id_groups_group_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_groups_group_id_put(
        self,
        realm,
        id,
        group_id,
        **kwargs
    ):
        """realm_users_id_groups_group_id_put  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_groups_group_id_put(realm, id, group_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            group_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['group_id'] = \
            group_id
        return self.realm_users_id_groups_group_id_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_impersonation_post(
        self,
        realm,
        id,
        **kwargs
    ):
        """Impersonate the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_impersonation_post(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_impersonation_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_logout_post(
        self,
        realm,
        id,
        **kwargs
    ):
        """Remove all user sessions associated with the user   Also send notification to all clients that have an admin URL to invalidate the sessions for the particular user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_logout_post(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_logout_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_offline_sessions_client_uuid_get(
        self,
        realm,
        id,
        client_uuid,
        **kwargs
    ):
        """Get offline sessions associated with the user and client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_offline_sessions_client_uuid_get(realm, id, client_uuid, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            client_uuid (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['client_uuid'] = \
            client_uuid
        return self.realm_users_id_offline_sessions_client_uuid_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_put(
        self,
        realm,
        id,
        user_representation,
        **kwargs
    ):
        """Update the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_put(realm, id, user_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            user_representation (UserRepresentation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['user_representation'] = \
            user_representation
        return self.realm_users_id_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_reset_password_put(
        self,
        realm,
        id,
        credential_representation,
        **kwargs
    ):
        """Set up a new password for the user.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_reset_password_put(realm, id, credential_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id
            credential_representation (CredentialRepresentation): The representation must contain a rawPassword with the plain-text password

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['credential_representation'] = \
            credential_representation
        return self.realm_users_id_reset_password_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_send_verify_email_put(
        self,
        realm,
        id,
        **kwargs
    ):
        """Send an email-verification email to the user   An email contains a link the user can click to verify their email address.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_send_verify_email_put(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            client_id (str): Client id. [optional]
            redirect_uri (str): Redirect uri. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_send_verify_email_put_endpoint.call_with_http_info(**kwargs)

    def realm_users_id_sessions_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get sessions associated with the user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_id_sessions_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): User id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_users_id_sessions_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_post(
        self,
        realm,
        user_representation,
        **kwargs
    ):
        """Create a new user   Username must be unique.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_post(realm, user_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            user_representation (UserRepresentation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['user_representation'] = \
            user_representation
        return self.realm_users_post_endpoint.call_with_http_info(**kwargs)

    def realm_users_profile_get(
        self,
        realm,
        **kwargs
    ):
        """realm_users_profile_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_profile_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_users_profile_get_endpoint.call_with_http_info(**kwargs)

    def realm_users_profile_put(
        self,
        realm,
        body,
        **kwargs
    ):
        """realm_users_profile_put  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_users_profile_put(realm, body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            body (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['body'] = \
            body
        return self.realm_users_profile_put_endpoint.call_with_http_info(**kwargs)

